/*
 * Decompiled with CFR 0.152.
 */
package com.lowagie.text.pdf;

import com.lowagie.text.DocumentException;
import com.lowagie.text.pdf.CJKFont;
import com.lowagie.text.pdf.EnumerateTTC;
import com.lowagie.text.pdf.GlyphList;
import com.lowagie.text.pdf.PdfEncodings;
import com.lowagie.text.pdf.PdfIndirectReference;
import com.lowagie.text.pdf.PdfName;
import com.lowagie.text.pdf.PdfNumber;
import com.lowagie.text.pdf.PdfStream;
import com.lowagie.text.pdf.PdfWriter;
import com.lowagie.text.pdf.TrueTypeFont;
import com.lowagie.text.pdf.TrueTypeFontUnicode;
import com.lowagie.text.pdf.Type1Font;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Method;
import java.util.HashMap;

public abstract class BaseFont {
    public static final String COURIER = "Courier";
    public static final String COURIER_BOLD = "Courier-Bold";
    public static final String COURIER_OBLIQUE = "Courier-Oblique";
    public static final String COURIER_BOLDOBLIQUE = "Courier-BoldOblique";
    public static final String HELVETICA = "Helvetica";
    public static final String HELVETICA_BOLD = "Helvetica-Bold";
    public static final String HELVETICA_OBLIQUE = "Helvetica-Oblique";
    public static final String HELVETICA_BOLDOBLIQUE = "Helvetica-BoldOblique";
    public static final String SYMBOL = "Symbol";
    public static final String TIMES_ROMAN = "Times-Roman";
    public static final String TIMES_BOLD = "Times-Bold";
    public static final String TIMES_ITALIC = "Times-Italic";
    public static final String TIMES_BOLDITALIC = "Times-BoldItalic";
    public static final String ZAPFDINGBATS = "ZapfDingbats";
    public static final int ASCENT = 1;
    public static final int CAPHEIGHT = 2;
    public static final int DESCENT = 3;
    public static final int ITALICANGLE = 4;
    public static final int BBOXLLX = 5;
    public static final int BBOXLLY = 6;
    public static final int BBOXURX = 7;
    public static final int BBOXURY = 8;
    public static final int AWT_ASCENT = 9;
    public static final int AWT_DESCENT = 10;
    public static final int AWT_LEADING = 11;
    public static final int AWT_MAXADVANCE = 12;
    public static final int FONT_TYPE_T1 = 0;
    public static final int FONT_TYPE_TT = 1;
    public static final int FONT_TYPE_CJK = 2;
    public static final int FONT_TYPE_TTUNI = 3;
    public static final int FONT_TYPE_DOCUMENT = 4;
    public static final String IDENTITY_H = "Identity-H";
    public static final String IDENTITY_V = "Identity-V";
    public static final String CP1250 = "Cp1250";
    public static final String CP1252 = "Cp1252";
    public static final String CP1257 = "Cp1257";
    public static final String WINANSI = "Cp1252";
    public static final String MACROMAN = "MacRoman";
    public static final boolean EMBEDDED = true;
    public static final boolean NOT_EMBEDDED = false;
    public static final boolean CACHED = true;
    public static final boolean NOT_CACHED = false;
    public static final String RESOURCE_PATH = "com/lowagie/text/pdf/fonts/";
    public static final char CID_NEWLINE = Short.MAX_VALUE;
    int fontType;
    public static final String notdef = ".notdef";
    protected int[] widths = new int[256];
    protected String[] differences = new String[256];
    protected char[] unicodeDifferences = new char[256];
    protected String encoding;
    protected boolean embedded;
    protected boolean fontSpecific = true;
    protected static HashMap fontCache = new HashMap();
    protected static final HashMap BuiltinFonts14 = new HashMap();
    protected boolean forceWidthsOutput = false;
    protected boolean directTextToByte = false;
    protected boolean subset = true;
    protected boolean fastWinansi = false;
    static /* synthetic */ Class class$java$lang$Thread;
    static /* synthetic */ Class class$com$lowagie$text$pdf$BaseFont;

    protected BaseFont() {
    }

    public static BaseFont createFont(String string, String string2, boolean bl) throws DocumentException, IOException {
        return BaseFont.createFont(string, string2, bl, true, null, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static BaseFont createFont(String string, String string2, boolean bl, boolean bl2, byte[] byArray, byte[] byArray2) throws DocumentException, IOException {
        HashMap hashMap;
        boolean bl3;
        String string3 = BaseFont.getBaseName(string);
        string2 = BaseFont.normalizeEncoding(string2);
        boolean bl4 = BuiltinFonts14.containsKey(string);
        boolean bl5 = bl3 = bl4 ? false : CJKFont.isCJKFont(string3, string2);
        if (bl4 || bl3) {
            bl = false;
        } else if (string2.equals(IDENTITY_H) || string2.equals(IDENTITY_V)) {
            bl = true;
        }
        BaseFont baseFont = null;
        BaseFont baseFont2 = null;
        String string4 = string + "\n" + string2 + "\n" + bl;
        if (bl2) {
            hashMap = fontCache;
            synchronized (hashMap) {
                baseFont = (BaseFont)fontCache.get(string4);
            }
            if (baseFont != null) {
                return baseFont;
            }
        }
        if (bl4 || string.toLowerCase().endsWith(".afm")) {
            baseFont2 = new Type1Font(string, string2, bl, byArray, byArray2);
            baseFont2.fastWinansi = string2.equals("Cp1252");
        } else if (string3.toLowerCase().endsWith(".ttf") || string3.toLowerCase().endsWith(".otf") || string3.toLowerCase().indexOf(".ttc,") > 0) {
            if (string2.equals(IDENTITY_H) || string2.equals(IDENTITY_V)) {
                baseFont2 = new TrueTypeFontUnicode(string, string2, bl, byArray);
            } else {
                baseFont2 = new TrueTypeFont(string, string2, bl, byArray);
                baseFont2.fastWinansi = string2.equals("Cp1252");
            }
        } else if (bl3) {
            baseFont2 = new CJKFont(string, string2, bl);
        } else {
            throw new DocumentException("Font '" + string + "' with '" + string2 + "' is not recognized.");
        }
        if (bl2) {
            hashMap = fontCache;
            synchronized (hashMap) {
                baseFont = (BaseFont)fontCache.get(string4);
                if (baseFont != null) {
                    return baseFont;
                }
                fontCache.put(string4, baseFont2);
            }
        }
        return baseFont2;
    }

    protected static String getBaseName(String string) {
        if (string.endsWith(",Bold")) {
            return string.substring(0, string.length() - 5);
        }
        if (string.endsWith(",Italic")) {
            return string.substring(0, string.length() - 7);
        }
        if (string.endsWith(",BoldItalic")) {
            return string.substring(0, string.length() - 11);
        }
        return string;
    }

    protected static String normalizeEncoding(String string) {
        if (string.equals("winansi") || string.equals("")) {
            return "Cp1252";
        }
        if (string.equals("macroman")) {
            return MACROMAN;
        }
        return string;
    }

    protected void createEncoding() {
        if (this.fontSpecific) {
            for (int i = 0; i < 256; ++i) {
                this.widths[i] = this.getRawWidth(i, null);
            }
        } else {
            byte[] byArray = new byte[1];
            for (int i = 0; i < 256; ++i) {
                byArray[0] = (byte)i;
                String string = PdfEncodings.convertToString(byArray, this.encoding);
                int n = string.length() > 0 ? (int)string.charAt(0) : 63;
                String string2 = GlyphList.unicodeToName(n);
                if (string2 == null) {
                    string2 = notdef;
                }
                this.differences[i] = string2;
                this.unicodeDifferences[i] = n;
                this.widths[i] = this.getRawWidth(n, string2);
            }
        }
    }

    abstract int getRawWidth(int var1, String var2);

    public abstract int getKerning(char var1, char var2);

    public int getWidth(char c) {
        if (this.fastWinansi) {
            if (c < '\u0080' || c >= '\u00a0' && c <= '\u00ff') {
                return this.widths[c];
            }
            return this.widths[PdfEncodings.winansi.get(c)];
        }
        return this.getWidth(new String(new char[]{c}));
    }

    public int getWidth(String string) {
        int n = 0;
        if (this.fastWinansi) {
            int n2 = string.length();
            for (int i = 0; i < n2; ++i) {
                char c = string.charAt(i);
                if (c < '\u0080' || c >= '\u00a0' && c <= '\u00ff') {
                    n += this.widths[c];
                    continue;
                }
                n += this.widths[PdfEncodings.winansi.get(c)];
            }
            return n;
        }
        byte[] byArray = this.convertToBytes(string);
        for (int i = 0; i < byArray.length; ++i) {
            n += this.widths[0xFF & byArray[i]];
        }
        return n;
    }

    public float getWidthPointKerned(String string, float f) {
        float f2 = (float)this.getWidth(string) * 0.001f * f;
        if (!this.hasKernPairs()) {
            return f2;
        }
        int n = string.length() - 1;
        int n2 = 0;
        char[] cArray = string.toCharArray();
        for (int i = 0; i < n; ++i) {
            n2 += this.getKerning(cArray[i], cArray[i + 1]);
        }
        return f2 + (float)n2 * 0.001f * f;
    }

    public float getWidthPoint(String string, float f) {
        return (float)this.getWidth(string) * 0.001f * f;
    }

    public float getWidthPoint(char c, float f) {
        return (float)this.getWidth(c) * 0.001f * f;
    }

    byte[] convertToBytes(String string) {
        if (this.directTextToByte) {
            return PdfEncodings.convertToBytes(string, null);
        }
        return PdfEncodings.convertToBytes(string, this.encoding);
    }

    abstract void writeFont(PdfWriter var1, PdfIndirectReference var2, Object[] var3) throws DocumentException, IOException;

    public String getEncoding() {
        return this.encoding;
    }

    public abstract float getFontDescriptor(int var1, float var2);

    public int getFontType() {
        return this.fontType;
    }

    public boolean isEmbedded() {
        return this.embedded;
    }

    public boolean isFontSpecific() {
        return this.fontSpecific;
    }

    public static String createSubsetPrefix() {
        String string = "";
        for (int i = 0; i < 6; ++i) {
            string = string + (char)(Math.random() * 26.0 + 65.0);
        }
        return string + "+";
    }

    char getUnicodeDifferences(int n) {
        return this.unicodeDifferences[n];
    }

    public abstract String getPostscriptFontName();

    public abstract String[][] getFullFontName();

    public static String[][] getFullFontName(String string, String string2, byte[] byArray) throws DocumentException, IOException {
        String string3 = BaseFont.getBaseName(string);
        BaseFont baseFont = null;
        baseFont = string3.toLowerCase().endsWith(".ttf") || string3.toLowerCase().endsWith(".otf") || string3.toLowerCase().indexOf(".ttc,") > 0 ? new TrueTypeFont(string, "Cp1252", false, byArray, true) : BaseFont.createFont(string, string2, false, false, byArray, null);
        return ((BaseFont)baseFont).getFullFontName();
    }

    public static Object[] getAllFontNames(String string, String string2, byte[] byArray) throws DocumentException, IOException {
        String string3 = BaseFont.getBaseName(string);
        BaseFont baseFont = null;
        baseFont = string3.toLowerCase().endsWith(".ttf") || string3.toLowerCase().endsWith(".otf") || string3.toLowerCase().indexOf(".ttc,") > 0 ? new TrueTypeFont(string, "Cp1252", false, byArray, true) : BaseFont.createFont(string, string2, false, false, byArray, null);
        return new Object[]{baseFont.getPostscriptFontName(), baseFont.getFamilyFontName(), baseFont.getFullFontName()};
    }

    public abstract String[][] getFamilyFontName();

    public String[] getCodePagesSupported() {
        return new String[0];
    }

    public static String[] enumerateTTCNames(String string) throws DocumentException, IOException {
        return new EnumerateTTC(string).getNames();
    }

    public static String[] enumerateTTCNames(byte[] byArray) throws DocumentException, IOException {
        return new EnumerateTTC(byArray).getNames();
    }

    public int[] getWidths() {
        return this.widths;
    }

    public String[] getDifferences() {
        return this.differences;
    }

    public char[] getUnicodeDifferences() {
        return this.unicodeDifferences;
    }

    public boolean isForceWidthsOutput() {
        return this.forceWidthsOutput;
    }

    public void setForceWidthsOutput(boolean bl) {
        this.forceWidthsOutput = bl;
    }

    public boolean isDirectTextToByte() {
        return this.directTextToByte;
    }

    public void setDirectTextToByte(boolean bl) {
        this.directTextToByte = bl;
    }

    public boolean isSubset() {
        return this.subset;
    }

    public void setSubset(boolean bl) {
        this.subset = bl;
    }

    public static InputStream getResourceStream(String string) {
        return BaseFont.getResourceStream(string, null);
    }

    public static InputStream getResourceStream(String string, ClassLoader classLoader) {
        if (string.startsWith("/")) {
            string = string.substring(1);
        }
        InputStream inputStream = null;
        if (classLoader != null && (inputStream = classLoader.getResourceAsStream(string)) != null) {
            return inputStream;
        }
        try {
            ClassLoader classLoader2;
            Method method = (class$java$lang$Thread == null ? (class$java$lang$Thread = BaseFont.class$("java.lang.Thread")) : class$java$lang$Thread).getMethod("getContextClassLoader", new Class[0]);
            if (method != null && (classLoader2 = (ClassLoader)method.invoke((Object)Thread.currentThread(), new Object[0])) != null) {
                inputStream = classLoader2.getResourceAsStream(string);
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        if (inputStream == null) {
            inputStream = (class$com$lowagie$text$pdf$BaseFont == null ? (class$com$lowagie$text$pdf$BaseFont = BaseFont.class$("com.lowagie.text.pdf.BaseFont")) : class$com$lowagie$text$pdf$BaseFont).getResourceAsStream("/" + string);
        }
        if (inputStream == null) {
            inputStream = ClassLoader.getSystemResourceAsStream(string);
        }
        return inputStream;
    }

    public char getUnicodeEquivalent(char c) {
        return c;
    }

    public char getCidCode(char c) {
        return c;
    }

    public abstract boolean hasKernPairs();

    public boolean charExists(char c) {
        byte[] byArray = this.convertToBytes(new String(new char[]{c}));
        return byArray.length > 0;
    }

    public boolean setCharAdvance(char c, int n) {
        byte[] byArray = this.convertToBytes(new String(new char[]{c}));
        if (byArray.length == 0) {
            return false;
        }
        this.widths[0xFF & byArray[0]] = n;
        return true;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    static {
        BuiltinFonts14.put(COURIER, PdfName.COURIER);
        BuiltinFonts14.put(COURIER_BOLD, PdfName.COURIER_BOLD);
        BuiltinFonts14.put(COURIER_BOLDOBLIQUE, PdfName.COURIER_BOLDOBLIQUE);
        BuiltinFonts14.put(COURIER_OBLIQUE, PdfName.COURIER_OBLIQUE);
        BuiltinFonts14.put(HELVETICA, PdfName.HELVETICA);
        BuiltinFonts14.put(HELVETICA_BOLD, PdfName.HELVETICA_BOLD);
        BuiltinFonts14.put(HELVETICA_BOLDOBLIQUE, PdfName.HELVETICA_BOLDOBLIQUE);
        BuiltinFonts14.put(HELVETICA_OBLIQUE, PdfName.HELVETICA_OBLIQUE);
        BuiltinFonts14.put(SYMBOL, PdfName.SYMBOL);
        BuiltinFonts14.put(TIMES_ROMAN, PdfName.TIMES_ROMAN);
        BuiltinFonts14.put(TIMES_BOLD, PdfName.TIMES_BOLD);
        BuiltinFonts14.put(TIMES_BOLDITALIC, PdfName.TIMES_BOLDITALIC);
        BuiltinFonts14.put(TIMES_ITALIC, PdfName.TIMES_ITALIC);
        BuiltinFonts14.put(ZAPFDINGBATS, PdfName.ZAPFDINGBATS);
    }

    class StreamFont
    extends PdfStream {
        public StreamFont(byte[] byArray, int[] nArray) throws DocumentException {
            try {
                this.bytes = byArray;
                this.put(PdfName.LENGTH, new PdfNumber(this.bytes.length));
                for (int i = 0; i < nArray.length; ++i) {
                    this.put(new PdfName("Length" + (i + 1)), new PdfNumber(nArray[i]));
                }
                this.flateCompress();
            }
            catch (Exception exception) {
                throw new DocumentException(exception);
            }
        }

        public StreamFont(byte[] byArray, String string) throws DocumentException {
            try {
                this.bytes = byArray;
                this.put(PdfName.LENGTH, new PdfNumber(this.bytes.length));
                if (string != null) {
                    this.put(PdfName.SUBTYPE, new PdfName(string));
                }
                this.flateCompress();
            }
            catch (Exception exception) {
                throw new DocumentException(exception);
            }
        }
    }
}

