/*
 * ElementPropertiesDialog.java
 *
 * iReport  --  Visual designer for generating JasperReports Documents
 *  Copyright (C) 2002-2003  Giulio Toffoli gt@businesslogic.it
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 *  Giulio Toffoli
 *  Via T.Aspetti, 233
 *  35100 Padova ITALY
 *  gt@businesslogic.it
 *
 *
 * How this window work.
 * This form has an attribute that rappresents the JReportForm active.
 * If the jrf is null, this frame hides.
 * When something changes, the program can call "updateSelection". This
 * class retrive from jrf the selected elements and update all
 * interface.
 *
 * Created on 28 aprile 2003, 23.53
 */

package it.businesslogic.ireport.gui;

import it.businesslogic.ireport.util.*;
import it.businesslogic.ireport.gui.event.*;
import it.businesslogic.ireport.chart.*;
import java.util.*;
import java.awt.*;
import javax.swing.table.*;
import it.businesslogic.ireport.*;
import it.businesslogic.ireport.gui.box.*;
/**
 *
 * @author <a href="mailto:gt78@users.sourceforge.net">Giulio Toffoli</a>
 * @author <a href="mailto:phenderson@users.sourceforge.net">Peter Henderson</a>
 */
public class ElementPropertiesDialog extends javax.swing.JDialog {
    
    public static final int GRAPHICS_TAB = 1;
    public static final int RECTANGLE_TAB = 2;
    public static final int LINE_TAB = 3;
    public static final int IMAGE_TAB = 4;
    public static final int FONT_TAB = 5;
    public static final int STATITEXT_TAB = 6;
    public static final int TEXTFIELD_TAB = 7;
    public static final int HYPERLINK_TAB = 8;
    public static final int SUBREPORT1_TAB = 9;
    public static final int SUBREPORT2_TAB = 10;
    public static final int CHART_TAB = 11;
    public static final int COMMON_TAB = 12;
    public static final int BARCODE_TAB = 13;
    
    
    private JReportFrame jrf = null;
    private String lastSelectedPaneName = "Common";
    private javax.swing.JPanel lastSelectedPanel = null;
    private BoxPanel boxPanel = null;
    
    /** Creates new form ElementPropertiesDialog */
    public ElementPropertiesDialog(java.awt.Frame parent, boolean modal) {
        super(parent, modal);
        initComponents();
        
        //System.out.println(">>> 1");
        
        jTabbedPane.removeAll();
        this.setSize(370, 380);
        
        // Position types...
        jComboBoxPositionType.addItem("FixRelativeToTop");
        jComboBoxPositionType.addItem("Float");
        jComboBoxPositionType.addItem("FixRelativeToBottom");
        
        // Pens...
        jComboBoxPen.addItem("None");
        jComboBoxPen.addItem("Thin");
        jComboBoxPen.addItem("1Point");
        jComboBoxPen.addItem("2Point");
        jComboBoxPen.addItem("4Point");
        jComboBoxPen.addItem("Dotted");
        
        // StretchTypes...
        jComboBoxStretchType.addItem("NoStretch");
        jComboBoxStretchType.addItem("RelativeToTallestObject");
        jComboBoxStretchType.addItem("RelativeToBandHeight");
        
        // Fill...
        jComboBoxFill.addItem("Solid");
        
        // Line...
        jComboBoxLineDirection.addItem("TopDown");
        jComboBoxLineDirection.addItem("BottomUp");
        
        // Rotate
        jComboBoxRotation.addItem("None");
        jComboBoxRotation.addItem("Left");
        jComboBoxRotation.addItem("Right");
        
        
        // Scale Image...
        jComboBoxScale.addItem("Clip");
        jComboBoxScale.addItem("FillFrame");
        jComboBoxScale.addItem("RetainShape");
        
        // Image Evaluation Time...
        jComboBoxEvaluationTime.addItem("Now");
        jComboBoxEvaluationTime.addItem("Report");
        jComboBoxEvaluationTime.addItem("Page");
        jComboBoxEvaluationTime.addItem("Column");
        jComboBoxEvaluationTime.addItem("Group");
        
        // Image Evaluation Time chart...
        jComboBoxEvaluationTime1.addItem("Now");
        jComboBoxEvaluationTime1.addItem("Report");
        jComboBoxEvaluationTime1.addItem("Page");
        jComboBoxEvaluationTime1.addItem("Column");
        jComboBoxEvaluationTime1.addItem("Group");
        
        // Image Expression Classes...
        jComboBoxImageExpressionClass.addItem("java.lang.String");
        jComboBoxImageExpressionClass.addItem("java.io.File");
        jComboBoxImageExpressionClass.addItem("java.net.URL");
        jComboBoxImageExpressionClass.addItem("java.io.InputStream");
        jComboBoxImageExpressionClass.addItem("java.awt.Image");
        jComboBoxImageExpressionClass.addItem("net.sf.jasperreports.engine.JRRenderable");
        
        // Image Vertical Alignments...
        jComboBoxVerticalAlignment.addItem("Top");
        jComboBoxVerticalAlignment.addItem("Middle");
        jComboBoxVerticalAlignment.addItem("Bottom");
        
        // Image Horizontal Alignments...
        jComboBoxHorizontalAlignment.addItem("Left");
        jComboBoxHorizontalAlignment.addItem("Center");
        jComboBoxHorizontalAlignment.addItem("Right");
        
        // Image Horizontal Alignments...
        jComboBoxPDFFontName.addItem("Helvetica");
        jComboBoxPDFFontName.addItem("Helvetica-Bold");
        jComboBoxPDFFontName.addItem("Helvetica-BoldOblique");
        jComboBoxPDFFontName.addItem("Helvetica-Oblique");
        jComboBoxPDFFontName.addItem("Courier");
        jComboBoxPDFFontName.addItem("Courier-Bold");
        jComboBoxPDFFontName.addItem("Courier-BoldOblique");
        jComboBoxPDFFontName.addItem("Courier-Oblique");
        jComboBoxPDFFontName.addItem("Symbol");
        jComboBoxPDFFontName.addItem("Times-Roman");
        jComboBoxPDFFontName.addItem("Times-Bold");
        jComboBoxPDFFontName.addItem("Times-BoldItalic");
        jComboBoxPDFFontName.addItem("Times-Italic");
        jComboBoxPDFFontName.addItem("ZapfDingbats");
        jComboBoxPDFFontName.addItem("STSong-Light");
        jComboBoxPDFFontName.addItem("MHei-Medium");
        jComboBoxPDFFontName.addItem("MSung-Light");
        jComboBoxPDFFontName.addItem("HeiseiKakuGo-W5");
        jComboBoxPDFFontName.addItem("HeiseiMin-W3");
        jComboBoxPDFFontName.addItem("HYGoThic-Medium");
        jComboBoxPDFFontName.addItem("HYSMyeongJo-Medium");
        jComboBoxPDFFontName.addItem("External TTF font...");
        
        // Text Vertical Alignments...
        jComboBoxVAlign.addItem("Top");
        jComboBoxVAlign.addItem("Middle");
        jComboBoxVAlign.addItem("Bottom");
        
        // Image Horizontal Alignments...
        jComboBoxHAlign.addItem("Left");
        jComboBoxHAlign.addItem("Center");
        jComboBoxHAlign.addItem("Right");
        jComboBoxHAlign.addItem("Justified");
        
        jNumberComboBoxSize.addEntry("3",3);
        jNumberComboBoxSize.addEntry("5",5);
        jNumberComboBoxSize.addEntry("8",8);
        jNumberComboBoxSize.addEntry("10",10);
        jNumberComboBoxSize.addEntry("12",12);
        jNumberComboBoxSize.addEntry("14",14);
        jNumberComboBoxSize.addEntry("18",18);
        jNumberComboBoxSize.addEntry("24",24);
        jNumberComboBoxSize.addEntry("36",36);
        jNumberComboBoxSize.addEntry("48",48);
        
        jComboBoxLineSpacing.addItem("Single");
        jComboBoxLineSpacing.addItem("1_1_2");
        jComboBoxLineSpacing.addItem("Double");
        
        jComboBoxPdfEncoding.addItem(new PdfEncoding("Cp1250","CP1250 (Central European)"));
        jComboBoxPdfEncoding.addItem(new PdfEncoding("Cp1251","CP1251 (Cyrillic)"));
        jComboBoxPdfEncoding.addItem(new PdfEncoding("Cp1252","CP1252 (Western European ANSI aka WinAnsi)"));
        jComboBoxPdfEncoding.addItem(new PdfEncoding("Cp1253","CP1253 (Greek)"));
        jComboBoxPdfEncoding.addItem(new PdfEncoding("Cp1254","CP1254 (Turkish)"));
        jComboBoxPdfEncoding.addItem(new PdfEncoding("Cp1255","CP1255 (Hebrew)"));
        jComboBoxPdfEncoding.addItem(new PdfEncoding("Cp1256","CP1256 (Arabic)"));
        jComboBoxPdfEncoding.addItem(new PdfEncoding("Cp1257","CP1257 (Baltic)"));
        jComboBoxPdfEncoding.addItem(new PdfEncoding("Cp1258","CP1258 (Vietnamese)"));
        jComboBoxPdfEncoding.addItem(new PdfEncoding("UniGB-UCS2-H","UniGB-UCS2-H (Chinese Simplified)"));
        jComboBoxPdfEncoding.addItem(new PdfEncoding("UniGB-UCS2-V","UniGB-UCS2-V (Chinese Simplified)"));
        jComboBoxPdfEncoding.addItem(new PdfEncoding("UniCNS-UCS2-H","UniCNS-UCS2-H (Chinese traditional)"));
        jComboBoxPdfEncoding.addItem(new PdfEncoding("UniCNS-UCS2-V","UniCNS-UCS2-V (Chinese traditional)"));
        jComboBoxPdfEncoding.addItem(new PdfEncoding("UniJIS-UCS2-H","UniJIS-UCS2-H (Japanese)"));
        jComboBoxPdfEncoding.addItem(new PdfEncoding("UniJIS-UCS2-V","UniJIS-UCS2-V (Japanese)"));
        jComboBoxPdfEncoding.addItem(new PdfEncoding("UniJIS-UCS2-HW-H","UniJIS-UCS2-HW-H (Japanese)"));
        jComboBoxPdfEncoding.addItem(new PdfEncoding("UniJIS-UCS2-HW-V","UniJIS-UCS2-HW-V (Japanese)"));
        jComboBoxPdfEncoding.addItem(new PdfEncoding("UniKS-UCS2-H","UniKS-UCS2-H (Korean)"));
        jComboBoxPdfEncoding.addItem(new PdfEncoding("UniKS-UCS2-V","UniKS-UCS2-V (Korean)"));
        jComboBoxPdfEncoding.addItem(new PdfEncoding("Identity-H","Identity-H (Unicode with horizontal writing)"));
        jComboBoxPdfEncoding.addItem(new PdfEncoding("Identity-V","Identity-V (Unicode with vertical writing)"));
        
        jComboBoxPattern.addItem(new PdfEncoding("#,##0.00"," #,##0.00 (example 1,234.56)"));
        
        jComboBoxTextFieldExpressionClass.addItem("java.lang.Boolean");
        jComboBoxTextFieldExpressionClass.addItem("java.lang.Byte");
        jComboBoxTextFieldExpressionClass.addItem("java.util.Date");
        jComboBoxTextFieldExpressionClass.addItem("java.sql.Timestamp");
        jComboBoxTextFieldExpressionClass.addItem("java.sql.Time");
        jComboBoxTextFieldExpressionClass.addItem("java.lang.Double");
        jComboBoxTextFieldExpressionClass.addItem("java.lang.Float");
        jComboBoxTextFieldExpressionClass.addItem("java.lang.Integer");
        jComboBoxTextFieldExpressionClass.addItem("java.lang.Long");
        jComboBoxTextFieldExpressionClass.addItem("java.lang.Short");
        jComboBoxTextFieldExpressionClass.addItem("java.math.BigDecimal");
        jComboBoxTextFieldExpressionClass.addItem("java.lang.String");
        
        // Text field Evaluation Time...
        jComboBoxTextFieldEvaluationTime.addItem("Now");
        jComboBoxTextFieldEvaluationTime.addItem("Report");
        jComboBoxTextFieldEvaluationTime.addItem("Page");
        jComboBoxTextFieldEvaluationTime.addItem("Column");
        jComboBoxTextFieldEvaluationTime.addItem("Group");
        
        jComboBoxSubreportConnectionType.addItem("Don't use connection or datasource");
        jComboBoxSubreportConnectionType.addItem("Use connection expression");
        jComboBoxSubreportConnectionType.addItem("Use datasource expression");
        
        
        jComboBoxSubreportExpressionClass.addItem("java.lang.String");
        jComboBoxSubreportExpressionClass.addItem("java.io.File");
        jComboBoxSubreportExpressionClass.addItem("java.net.URL");
        jComboBoxSubreportExpressionClass.addItem("java.io.InputStream");
        jComboBoxSubreportExpressionClass.addItem("net.sf.jasperreports.engine.JasperReport");
        
        jComboBoxLinkType.addItem("None");
        jComboBoxLinkType.addItem("Reference");
        jComboBoxLinkType.addItem("LocalAnchor");
        jComboBoxLinkType.addItem("LocalPage");
        jComboBoxLinkType.addItem("RemoteAnchor");
        jComboBoxLinkType.addItem("RemotePage");
        
        // Barcode Evaluation Time...
        jComboBoxEvaluationTimeBarcode.addItem("Now");
        jComboBoxEvaluationTimeBarcode.addItem("Report");
        jComboBoxEvaluationTimeBarcode.addItem("Page");
        jComboBoxEvaluationTimeBarcode.addItem("Column");
        jComboBoxEvaluationTimeBarcode.addItem("Group");
        
        // Barcode Evaluation Time...
        jComboBoxLinkTarget.addItem("Self");
        jComboBoxLinkTarget.addItem("Blank");
        
        // Load Fonts...
        String[] fontFamilies = java.awt.GraphicsEnvironment.getLocalGraphicsEnvironment().getAvailableFontFamilyNames();
        for (int i=0; i<fontFamilies.length; ++i) {
            jComboBoxFontName.addItem(fontFamilies[i]);
        }
        
        this.jRTextExpressionAreaPrintWhenExpression.getDocument().addDocumentListener( new javax.swing.event.DocumentListener() {
            public void changedUpdate(javax.swing.event.DocumentEvent evt) {
                jRTextExpressionAreaPrintWhenExpressionTextChanged();
            }
            public void insertUpdate(javax.swing.event.DocumentEvent evt) {
                jRTextExpressionAreaPrintWhenExpressionTextChanged();
            }
            public void removeUpdate(javax.swing.event.DocumentEvent evt) {
                jRTextExpressionAreaPrintWhenExpressionTextChanged();
            }
        });
        
        
        
        this.jTextAreaText.getDocument().addDocumentListener( new javax.swing.event.DocumentListener() {
            public void changedUpdate(javax.swing.event.DocumentEvent evt) {
                jTextAreaTextChanged();
            }
            public void insertUpdate(javax.swing.event.DocumentEvent evt) {
                jTextAreaTextChanged();
            }
            public void removeUpdate(javax.swing.event.DocumentEvent evt) {
                jTextAreaTextChanged();
            }
        });
        
        this.jRTextExpressionAreaTextFieldExpression.getDocument().addDocumentListener( new javax.swing.event.DocumentListener() {
            public void changedUpdate(javax.swing.event.DocumentEvent evt) {
                jRTextExpressionAreaTextFieldExpressionTextChanged();
            }
            public void insertUpdate(javax.swing.event.DocumentEvent evt) {
                jRTextExpressionAreaTextFieldExpressionTextChanged();
            }
            public void removeUpdate(javax.swing.event.DocumentEvent evt) {
                jRTextExpressionAreaTextFieldExpressionTextChanged();
            }
        });
        
        this.jRTextExpressionAreaImageExpression.getDocument().addDocumentListener( new javax.swing.event.DocumentListener() {
            public void changedUpdate(javax.swing.event.DocumentEvent evt) {
                jRTextExpressionAreaImageExpressionTextChanged();
            }
            public void insertUpdate(javax.swing.event.DocumentEvent evt) {
                jRTextExpressionAreaImageExpressionTextChanged();
            }
            public void removeUpdate(javax.swing.event.DocumentEvent evt) {
                jRTextExpressionAreaImageExpressionTextChanged();
            }
        });
        
        this.jRTextExpressionAreaSubreportExpression.getDocument().addDocumentListener( new javax.swing.event.DocumentListener() {
            public void changedUpdate(javax.swing.event.DocumentEvent evt) {
                jRTextExpressionAreaSubreportExpressionTextChanged();
            }
            public void insertUpdate(javax.swing.event.DocumentEvent evt) {
                jRTextExpressionAreaSubreportExpressionTextChanged();
            }
            public void removeUpdate(javax.swing.event.DocumentEvent evt) {
                jRTextExpressionAreaSubreportExpressionTextChanged();
            }
        });
        
        this.jRTextExpressionAreaTextConnectionExpression.getDocument().addDocumentListener( new javax.swing.event.DocumentListener() {
            public void changedUpdate(javax.swing.event.DocumentEvent evt) {
                jRTextExpressionAreaTextConnectionExpressionTextChanged();
            }
            public void insertUpdate(javax.swing.event.DocumentEvent evt) {
                jRTextExpressionAreaTextConnectionExpressionTextChanged();
            }
            public void removeUpdate(javax.swing.event.DocumentEvent evt) {
                jRTextExpressionAreaTextConnectionExpressionTextChanged();
            }
        });
        
        this.jRTextExpressionAreaSubreportMapExpression.getDocument().addDocumentListener( new javax.swing.event.DocumentListener() {
            public void changedUpdate(javax.swing.event.DocumentEvent evt) {
                jRTextExpressionAreaSubreportMapExpressionTextChanged();
            }
            public void insertUpdate(javax.swing.event.DocumentEvent evt) {
                jRTextExpressionAreaSubreportMapExpressionTextChanged();
            }
            public void removeUpdate(javax.swing.event.DocumentEvent evt) {
                jRTextExpressionAreaSubreportMapExpressionTextChanged();
            }
        });
        
        
        javax.swing.DefaultListSelectionModel dlsm =  (javax.swing.DefaultListSelectionModel)this.jTableSubreportParameters.getSelectionModel();
        dlsm.addListSelectionListener(new javax.swing.event.ListSelectionListener() {
            public void valueChanged(javax.swing.event.ListSelectionEvent e)  {
                jTableSubreportParametersListSelectionValueChanged(e);
            }
        });
        
        
        this.jRTextExpressionAreaAnchorName.getDocument().addDocumentListener( new javax.swing.event.DocumentListener() {
            public void changedUpdate(javax.swing.event.DocumentEvent evt) {
                jRTextExpressionAreaAnchorNameTextChanged();
            }
            public void insertUpdate(javax.swing.event.DocumentEvent evt) {
                jRTextExpressionAreaAnchorNameTextChanged();
            }
            public void removeUpdate(javax.swing.event.DocumentEvent evt) {
                jRTextExpressionAreaAnchorNameTextChanged();
            }
        });
        
        this.jRTextExpressionAreaAnchor.getDocument().addDocumentListener( new javax.swing.event.DocumentListener() {
            public void changedUpdate(javax.swing.event.DocumentEvent evt) {
                jRTextExpressionAreaAnchorTextChanged();
            }
            public void insertUpdate(javax.swing.event.DocumentEvent evt) {
                jRTextExpressionAreaAnchorTextChanged();
            }
            public void removeUpdate(javax.swing.event.DocumentEvent evt) {
                jRTextExpressionAreaAnchorTextChanged();
            }
        });
        
        this.jRTextExpressionAreaPage.getDocument().addDocumentListener( new javax.swing.event.DocumentListener() {
            public void changedUpdate(javax.swing.event.DocumentEvent evt) {
                jRTextExpressionAreaPageTextChanged();
            }
            public void insertUpdate(javax.swing.event.DocumentEvent evt) {
                jRTextExpressionAreaPageTextChanged();
            }
            public void removeUpdate(javax.swing.event.DocumentEvent evt) {
                jRTextExpressionAreaPageTextChanged();
            }
        });
        
        this.jRTextExpressionAreaReference.getDocument().addDocumentListener( new javax.swing.event.DocumentListener() {
            public void changedUpdate(javax.swing.event.DocumentEvent evt) {
                jRTextExpressionAreaReferenceTextChanged();
            }
            public void insertUpdate(javax.swing.event.DocumentEvent evt) {
                jRTextExpressionAreaReferenceTextChanged();
            }
            public void removeUpdate(javax.swing.event.DocumentEvent evt) {
                jRTextExpressionAreaReferenceTextChanged();
            }
        });
 
        
                /*this.jComboBoxChartFactory.getDocument().addDocumentListener( new javax.swing.event.DocumentListener() {
                        public void changedUpdate(javax.swing.event.DocumentEvent evt) {
                                chartFactoryChanged();
                        }
                        public void insertUpdate(javax.swing.event.DocumentEvent evt) {
                                chartFactoryChanged();
                        }
                        public void removeUpdate(javax.swing.event.DocumentEvent evt) {
                                chartFactoryChanged();
                        }
                });*/
        
        this.jTextFieldName.getDocument().addDocumentListener( new javax.swing.event.DocumentListener() {
            public void changedUpdate(javax.swing.event.DocumentEvent evt) {
                jTextFieldNameChanged();
            }
            public void insertUpdate(javax.swing.event.DocumentEvent evt) {
                jTextFieldNameChanged();
            }
            public void removeUpdate(javax.swing.event.DocumentEvent evt) {
                jTextFieldNameChanged();
            }
        });
        
        this.jBarcodeExpressionArea.getDocument().addDocumentListener( new javax.swing.event.DocumentListener() {
            public void changedUpdate(javax.swing.event.DocumentEvent evt) {
                BarcodeActionPerformed(null);
            }
            public void insertUpdate(javax.swing.event.DocumentEvent evt) {
                BarcodeActionPerformed(null);
            }
            public void removeUpdate(javax.swing.event.DocumentEvent evt) {
                BarcodeActionPerformed(null);
            }
        });
        
        boxPanel = new BoxPanel();
        boxPanel.addActionListener( new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                boxActionPerformed(evt);
            }
        });
        
        java.awt.GridBagConstraints gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 4;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.WEST;
        gridBagConstraints.insets = new java.awt.Insets(2, 4, 2, 4);
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.fill = gridBagConstraints.BOTH;
        jPanelBorder.add(boxPanel, gridBagConstraints);

    }
    
    
    public void  boxActionPerformed(java.awt.event.ActionEvent evt)
    {
        if (jrf == null || jrf.getSelectedElements().size()==0) return;
        // Set the new value for all selected elements...
        Enumeration e = jrf.getSelectedElements().elements();
        while (e.hasMoreElements()) {
            ReportElement element = (ReportElement)e.nextElement();
            if (element instanceof ImageReportElement)
            {
                ((ImageReportElement)element).setBox(boxPanel.getBox().cloneMe());
            }
            else if (element instanceof TextReportElement)
            {
                ((TextReportElement)element).setBox(boxPanel.getBox().cloneMe());
            }
        }
        jrf.getJPanelReport().repaint();
    }
    
    public void jTableSubreportParametersListSelectionValueChanged(javax.swing.event.ListSelectionEvent e) {
        if (this.jTableSubreportParameters.getSelectedRowCount() > 0) {
            this.jButtonModParameter.setEnabled(true);
            this.jButtonRemParameter.setEnabled(true);
        }
        else {
            this.jButtonModParameter.setEnabled(false);
            this.jButtonRemParameter.setEnabled(false);
        }
    }
    /** This method is called from within the constructor to
     * initialize the form.
     * WARNING: Do NOT modify this code. The content of this method is
     * always regenerated by the Form Editor.
     */
    private void initComponents() {//GEN-BEGIN:initComponents
        java.awt.GridBagConstraints gridBagConstraints;

        buttonGroupCharts = new javax.swing.ButtonGroup();
        jTabbedPane = new javax.swing.JTabbedPane();
        jPanelCommon = new javax.swing.JPanel();
        jPanel3 = new javax.swing.JPanel();
        jLabel5 = new javax.swing.JLabel();
        jNumberFieldLeft = new it.businesslogic.ireport.gui.JNumberField();
        jLabel4 = new javax.swing.JLabel();
        jLabel7 = new javax.swing.JLabel();
        jComboBoxBand = new javax.swing.JComboBox();
        jLabel1 = new javax.swing.JLabel();
        jNumberFieldWidth = new it.businesslogic.ireport.gui.JNumberField();
        jNumberFieldTop = new it.businesslogic.ireport.gui.JNumberField();
        jLabel2 = new javax.swing.JLabel();
        jLabel6 = new javax.swing.JLabel();
        jNumberFieldHeight = new it.businesslogic.ireport.gui.JNumberField();
        jButtonBackground = new javax.swing.JButton();
        jButtonForeground = new javax.swing.JButton();
        jLabel3 = new javax.swing.JLabel();
        jPanel4 = new javax.swing.JPanel();
        jCheckBoxTransparent = new javax.swing.JCheckBox();
        jCheckBoxRemoveLineWhenBlank = new javax.swing.JCheckBox();
        jCheckBoxPrintInFirstWholeBand = new javax.swing.JCheckBox();
        jCheckBoxPrintWhenDetailOverflows = new javax.swing.JCheckBox();
        jCheckBoxPrintRepeatedValues = new javax.swing.JCheckBox();
        jPanel5 = new javax.swing.JPanel();
        jLabel8 = new javax.swing.JLabel();
        jComboBoxPositionType = new javax.swing.JComboBox();
        jLabel9 = new javax.swing.JLabel();
        jComboBoxGroups = new javax.swing.JComboBox();
        jLabel46 = new javax.swing.JLabel();
        jTextFieldName = new javax.swing.JTextField();
        jPanel6 = new javax.swing.JPanel();
        jLabel10 = new javax.swing.JLabel();
        jRTextExpressionAreaPrintWhenExpression = new it.businesslogic.ireport.gui.JRTextExpressionArea();
        jButtonPrintWhenExpression = new javax.swing.JButton();
        jPanel11 = new javax.swing.JPanel();
        jLabel12 = new javax.swing.JLabel();
        jComboBoxStretchType = new javax.swing.JComboBox();
        jPanelGraphicselement = new javax.swing.JPanel();
        jComboBoxFill = new javax.swing.JComboBox();
        jLabel11 = new javax.swing.JLabel();
        jComboBoxPen = new javax.swing.JComboBox();
        jLabel13 = new javax.swing.JLabel();
        jSeparator7 = new javax.swing.JSeparator();
        jPanelRectangle = new javax.swing.JPanel();
        jPanel1 = new javax.swing.JPanel();
        jLabel14 = new javax.swing.JLabel();
        jNumberFieldRadius = new it.businesslogic.ireport.gui.JNumberField();
        jPanelLine = new javax.swing.JPanel();
        jLabel15 = new javax.swing.JLabel();
        jComboBoxLineDirection = new javax.swing.JComboBox();
        jPanelImage = new javax.swing.JPanel();
        jRTextExpressionAreaImageExpression = new it.businesslogic.ireport.gui.JRTextExpressionArea();
        jLabel16 = new javax.swing.JLabel();
        jButtonFindImage = new javax.swing.JButton();
        jLabel17 = new javax.swing.JLabel();
        jComboBoxImageExpressionClass = new javax.swing.JComboBox();
        jLabel18 = new javax.swing.JLabel();
        jComboBoxScale = new javax.swing.JComboBox();
        jCheckBoxImageCache = new javax.swing.JCheckBox();
        jLabel19 = new javax.swing.JLabel();
        jComboBoxVerticalAlignment = new javax.swing.JComboBox();
        jLabel20 = new javax.swing.JLabel();
        jComboBoxHorizontalAlignment = new javax.swing.JComboBox();
        jLabel21 = new javax.swing.JLabel();
        jComboBoxEvaluationTime = new javax.swing.JComboBox();
        jLabel22 = new javax.swing.JLabel();
        jComboBoxImageGroup = new javax.swing.JComboBox();
        jSeparator1 = new javax.swing.JSeparator();
        jPanelText = new javax.swing.JPanel();
        jScrollPane1 = new javax.swing.JScrollPane();
        jTextAreaText = new javax.swing.JTextArea();
        jPanelFont = new javax.swing.JPanel();
        jPanel7 = new javax.swing.JPanel();
        jLabel23 = new javax.swing.JLabel();
        jComboBoxReportFont = new javax.swing.JComboBox();
        jLabel24 = new javax.swing.JLabel();
        jComboBoxFontName = new javax.swing.JComboBox();
        jNumberComboBoxSize = new it.businesslogic.ireport.gui.JNumberComboBox();
        jLabel27 = new javax.swing.JLabel();
        jLabel25 = new javax.swing.JLabel();
        jComboBoxPDFFontName = new javax.swing.JComboBox();
        jLabelTTF = new javax.swing.JLabel();
        jComboBoxTTFFont = new javax.swing.JComboBox();
        jPanel8 = new javax.swing.JPanel();
        jPanel12 = new javax.swing.JPanel();
        jCheckBoxBold = new javax.swing.JCheckBox();
        jCheckBoxItalic = new javax.swing.JCheckBox();
        jCheckBoxUnderline = new javax.swing.JCheckBox();
        jCheckBoxStrokeTrough = new javax.swing.JCheckBox();
        jCheckBoxStyledText = new javax.swing.JCheckBox();
        jCheckBoxPDFEmbedded = new javax.swing.JCheckBox();
        jSeparator2 = new javax.swing.JSeparator();
        jLabel32 = new javax.swing.JLabel();
        jComboBoxPdfEncoding = new javax.swing.JComboBox();
        jComboBoxHAlign = new javax.swing.JComboBox();
        jComboBoxVAlign = new javax.swing.JComboBox();
        jLabel30 = new javax.swing.JLabel();
        jLabel31 = new javax.swing.JLabel();
        jComboBoxLineSpacing = new javax.swing.JComboBox();
        jLabel29 = new javax.swing.JLabel();
        jLabel49 = new javax.swing.JLabel();
        jComboBoxRotation = new javax.swing.JComboBox();
        jSeparator4 = new javax.swing.JSeparator();
        jSeparator5 = new javax.swing.JSeparator();
        jPanelTextField = new javax.swing.JPanel();
        jLabel28 = new javax.swing.JLabel();
        jComboBoxTextFieldExpressionClass = new javax.swing.JComboBox();
        jLabel37 = new javax.swing.JLabel();
        jComboBoxTextFieldEvaluationTime = new javax.swing.JComboBox();
        jLabel38 = new javax.swing.JLabel();
        jComboBoxTextFieldGroup = new javax.swing.JComboBox();
        jCheckBoxStretchWithOverflow = new javax.swing.JCheckBox();
        jCheckBoxBlankWhenNull = new javax.swing.JCheckBox();
        jLabel39 = new javax.swing.JLabel();
        jLabel40 = new javax.swing.JLabel();
        jRTextExpressionAreaTextFieldExpression = new it.businesslogic.ireport.gui.JRTextExpressionArea();
        jPanel2 = new javax.swing.JPanel();
        jComboBoxPattern = new javax.swing.JComboBox();
        jButtonCreatePattern = new javax.swing.JButton();
        jPanelSubreport1 = new javax.swing.JPanel();
        jLabel41 = new javax.swing.JLabel();
        jLabel42 = new javax.swing.JLabel();
        jRTextExpressionAreaSubreportMapExpression = new it.businesslogic.ireport.gui.JRTextExpressionArea();
        jComboBoxSubreportConnectionType = new javax.swing.JComboBox();
        jRTextExpressionAreaTextConnectionExpression = new it.businesslogic.ireport.gui.JRTextExpressionArea();
        jCheckBoxSubreportCache = new javax.swing.JCheckBox();
        jPanelSubreport2 = new javax.swing.JPanel();
        jLabel26 = new javax.swing.JLabel();
        jRTextExpressionAreaSubreportExpression = new it.businesslogic.ireport.gui.JRTextExpressionArea();
        jLabel33 = new javax.swing.JLabel();
        jComboBoxSubreportExpressionClass = new javax.swing.JComboBox();
        jScrollPane2 = new javax.swing.JScrollPane();
        jTableSubreportParameters = new javax.swing.JTable();
        jLabel34 = new javax.swing.JLabel();
        jButtonAddParameter = new javax.swing.JButton();
        jButtonModParameter = new javax.swing.JButton();
        jButtonRemParameter = new javax.swing.JButton();
        jPanelHyperLink = new javax.swing.JPanel();
        jRTextExpressionAreaAnchorName = new it.businesslogic.ireport.gui.JRTextExpressionArea();
        jLabel35 = new javax.swing.JLabel();
        jSeparator3 = new javax.swing.JSeparator();
        jComboBoxLinkType = new javax.swing.JComboBox();
        jLabel36 = new javax.swing.JLabel();
        jRTextExpressionAreaReference = new it.businesslogic.ireport.gui.JRTextExpressionArea();
        jLabelReference = new javax.swing.JLabel();
        jRTextExpressionAreaAnchor = new it.businesslogic.ireport.gui.JRTextExpressionArea();
        jLabelAnchor = new javax.swing.JLabel();
        jRTextExpressionAreaPage = new it.businesslogic.ireport.gui.JRTextExpressionArea();
        jLabelPage = new javax.swing.JLabel();
        jLabelTarget = new javax.swing.JLabel();
        jComboBoxLinkTarget = new javax.swing.JComboBox();
        jPanelBarcode = new javax.swing.JPanel();
        jLabel47 = new javax.swing.JLabel();
        jComboBoxBarcodeType = new javax.swing.JComboBox();
        jBarcodeExpressionArea = new it.businesslogic.ireport.gui.JRTextExpressionArea();
        jLabel48 = new javax.swing.JLabel();
        jCheckBoxBarcodeCheckSum = new javax.swing.JCheckBox();
        jCheckBoxBarcodeShowText = new javax.swing.JCheckBox();
        jSeparator8 = new javax.swing.JSeparator();
        jComboBoxBarcodeGroup = new javax.swing.JComboBox();
        jLabel43 = new javax.swing.JLabel();
        jComboBoxEvaluationTimeBarcode = new javax.swing.JComboBox();
        jLabel50 = new javax.swing.JLabel();
        jPanelChart = new javax.swing.JPanel();
        jSeparator6 = new javax.swing.JSeparator();
        jSeparator9 = new javax.swing.JSeparator();
        jLabel44 = new javax.swing.JLabel();
        jComboBoxEvaluationTime1 = new javax.swing.JComboBox();
        jLabel45 = new javax.swing.JLabel();
        jComboBoxImageGroup1 = new javax.swing.JComboBox();
        jPanel9 = new javax.swing.JPanel();
        jButton1 = new javax.swing.JButton();
        jPanelBorder = new javax.swing.JPanel();

        addWindowListener(new java.awt.event.WindowAdapter() {
            public void windowClosing(java.awt.event.WindowEvent evt) {
                closeDialog(evt);
            }
        });

        jTabbedPane.setFont(new java.awt.Font("Dialog", 0, 11));
        jTabbedPane.setOpaque(true);
        jTabbedPane.setPreferredSize(new java.awt.Dimension(312, 48));
        jTabbedPane.addChangeListener(new javax.swing.event.ChangeListener() {
            public void stateChanged(javax.swing.event.ChangeEvent evt) {
                jTabbedPaneStateChanged(evt);
            }
        });

        jPanelCommon.setLayout(new java.awt.GridBagLayout());

        jPanel3.setLayout(new java.awt.GridBagLayout());

        jPanel3.setMinimumSize(new java.awt.Dimension(300, 74));
        jPanel3.setPreferredSize(new java.awt.Dimension(300, 74));
        jLabel5.setFont(new java.awt.Font("Dialog", 0, 11));
        jLabel5.setHorizontalAlignment(javax.swing.SwingConstants.RIGHT);
        jLabel5.setText("Height ");
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.WEST;
        gridBagConstraints.insets = new java.awt.Insets(2, 8, 0, 0);
        jPanel3.add(jLabel5, gridBagConstraints);

        jNumberFieldLeft.setHorizontalAlignment(javax.swing.JTextField.RIGHT);
        jNumberFieldLeft.setText("0");
        try {
            jNumberFieldLeft.setDecimals(0);
        } catch (java.beans.PropertyVetoException e1) {
            e1.printStackTrace();
        }
        try {
            jNumberFieldLeft.setInteger(true);
        } catch (java.beans.PropertyVetoException e1) {
            e1.printStackTrace();
        }
        jNumberFieldLeft.setMinimumSize(new java.awt.Dimension(45, 20));
        jNumberFieldLeft.setPreferredSize(new java.awt.Dimension(45, 20));
        jNumberFieldLeft.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                jNumberFieldLeftActionPerformed(evt);
            }
        });

        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.WEST;
        gridBagConstraints.insets = new java.awt.Insets(0, 5, 2, 0);
        jPanel3.add(jNumberFieldLeft, gridBagConstraints);

        jLabel4.setFont(new java.awt.Font("Dialog", 0, 11));
        jLabel4.setHorizontalAlignment(javax.swing.SwingConstants.RIGHT);
        jLabel4.setText("Width ");
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.WEST;
        gridBagConstraints.insets = new java.awt.Insets(2, 8, 0, 0);
        jPanel3.add(jLabel4, gridBagConstraints);

        jLabel7.setFont(new java.awt.Font("Dialog", 0, 11));
        jLabel7.setHorizontalAlignment(javax.swing.SwingConstants.RIGHT);
        jLabel7.setText("Background ");
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 4;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.WEST;
        gridBagConstraints.insets = new java.awt.Insets(2, 8, 0, 0);
        jPanel3.add(jLabel7, gridBagConstraints);

        jComboBoxBand.setFont(new java.awt.Font("Dialog", 0, 11));
        jComboBoxBand.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                jComboBoxBandActionPerformed(evt);
            }
        });

        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 5;
        gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.WEST;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new java.awt.Insets(6, 5, 0, 6);
        jPanel3.add(jComboBoxBand, gridBagConstraints);

        jLabel1.setFont(new java.awt.Font("Dialog", 0, 11));
        jLabel1.setHorizontalAlignment(javax.swing.SwingConstants.RIGHT);
        jLabel1.setText("Band ");
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.WEST;
        gridBagConstraints.insets = new java.awt.Insets(2, 0, 0, 0);
        jPanel3.add(jLabel1, gridBagConstraints);

        jNumberFieldWidth.setHorizontalAlignment(javax.swing.JTextField.RIGHT);
        jNumberFieldWidth.setText("0");
        try {
            jNumberFieldWidth.setDecimals(0);
        } catch (java.beans.PropertyVetoException e1) {
            e1.printStackTrace();
        }
        try {
            jNumberFieldWidth.setInteger(true);
        } catch (java.beans.PropertyVetoException e1) {
            e1.printStackTrace();
        }
        jNumberFieldWidth.setMinimumSize(new java.awt.Dimension(45, 20));
        jNumberFieldWidth.setPreferredSize(new java.awt.Dimension(45, 20));
        jNumberFieldWidth.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                jNumberFieldWidthActionPerformed(evt);
            }
        });

        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.WEST;
        gridBagConstraints.insets = new java.awt.Insets(2, 0, 2, 0);
        jPanel3.add(jNumberFieldWidth, gridBagConstraints);

        jNumberFieldTop.setHorizontalAlignment(javax.swing.JTextField.RIGHT);
        jNumberFieldTop.setText("0");
        try {
            jNumberFieldTop.setDecimals(0);
        } catch (java.beans.PropertyVetoException e1) {
            e1.printStackTrace();
        }
        try {
            jNumberFieldTop.setInteger(true);
        } catch (java.beans.PropertyVetoException e1) {
            e1.printStackTrace();
        }
        jNumberFieldTop.setMinimumSize(new java.awt.Dimension(45, 20));
        jNumberFieldTop.setPreferredSize(new java.awt.Dimension(45, 20));
        jNumberFieldTop.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                jNumberFieldTopActionPerformed(evt);
            }
        });

        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.WEST;
        gridBagConstraints.insets = new java.awt.Insets(2, 5, 2, 0);
        jPanel3.add(jNumberFieldTop, gridBagConstraints);

        jLabel2.setFont(new java.awt.Font("Dialog", 0, 11));
        jLabel2.setHorizontalAlignment(javax.swing.SwingConstants.RIGHT);
        jLabel2.setText("Top ");
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.WEST;
        gridBagConstraints.insets = new java.awt.Insets(2, 0, 0, 0);
        jPanel3.add(jLabel2, gridBagConstraints);

        jLabel6.setFont(new java.awt.Font("Dialog", 0, 11));
        jLabel6.setHorizontalAlignment(javax.swing.SwingConstants.RIGHT);
        jLabel6.setText("Foreground ");
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 4;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.WEST;
        gridBagConstraints.insets = new java.awt.Insets(2, 8, 0, 0);
        jPanel3.add(jLabel6, gridBagConstraints);

        jNumberFieldHeight.setHorizontalAlignment(javax.swing.JTextField.RIGHT);
        jNumberFieldHeight.setText("0");
        try {
            jNumberFieldHeight.setDecimals(0);
        } catch (java.beans.PropertyVetoException e1) {
            e1.printStackTrace();
        }
        try {
            jNumberFieldHeight.setInteger(true);
        } catch (java.beans.PropertyVetoException e1) {
            e1.printStackTrace();
        }
        jNumberFieldHeight.setMinimumSize(new java.awt.Dimension(45, 20));
        jNumberFieldHeight.setPreferredSize(new java.awt.Dimension(45, 20));
        jNumberFieldHeight.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                jNumberFieldHeightActionPerformed(evt);
            }
        });

        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.WEST;
        jPanel3.add(jNumberFieldHeight, gridBagConstraints);

        jButtonBackground.setBackground(new java.awt.Color(255, 255, 255));
        jButtonBackground.setFont(new java.awt.Font("Dialog", 0, 11));
        jButtonBackground.setMaximumSize(new java.awt.Dimension(45, 20));
        jButtonBackground.setMinimumSize(new java.awt.Dimension(45, 20));
        jButtonBackground.setPreferredSize(new java.awt.Dimension(45, 20));
        jButtonBackground.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                jButtonBackgroundActionPerformed(evt);
            }
        });

        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 5;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.WEST;
        jPanel3.add(jButtonBackground, gridBagConstraints);

        jButtonForeground.setBackground(new java.awt.Color(0, 0, 0));
        jButtonForeground.setFont(new java.awt.Font("Dialog", 0, 11));
        jButtonForeground.setMaximumSize(new java.awt.Dimension(45, 20));
        jButtonForeground.setMinimumSize(new java.awt.Dimension(45, 20));
        jButtonForeground.setPreferredSize(new java.awt.Dimension(45, 20));
        jButtonForeground.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                jButtonForegroundActionPerformed(evt);
            }
        });

        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 5;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.WEST;
        jPanel3.add(jButtonForeground, gridBagConstraints);

        jLabel3.setFont(new java.awt.Font("Dialog", 0, 11));
        jLabel3.setHorizontalAlignment(javax.swing.SwingConstants.RIGHT);
        jLabel3.setText("Left ");
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.WEST;
        gridBagConstraints.insets = new java.awt.Insets(2, 0, 0, 0);
        jPanel3.add(jLabel3, gridBagConstraints);

        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.NORTHWEST;
        gridBagConstraints.insets = new java.awt.Insets(6, 6, 4, 6);
        jPanelCommon.add(jPanel3, gridBagConstraints);

        jPanel4.setLayout(new java.awt.GridBagLayout());

        jPanel4.setMinimumSize(new java.awt.Dimension(170, 120));
        jPanel4.setPreferredSize(new java.awt.Dimension(170, 120));
        jCheckBoxTransparent.setFont(new java.awt.Font("Dialog", 0, 11));
        jCheckBoxTransparent.setText("Transparent");
        jCheckBoxTransparent.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                jCheckBoxTransparentActionPerformed(evt);
            }
        });

        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.WEST;
        jPanel4.add(jCheckBoxTransparent, gridBagConstraints);

        jCheckBoxRemoveLineWhenBlank.setFont(new java.awt.Font("Dialog", 0, 11));
        jCheckBoxRemoveLineWhenBlank.setText("Remove line when blank");
        jCheckBoxRemoveLineWhenBlank.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                jCheckBoxRemoveLineWhenBlankActionPerformed(evt);
            }
        });

        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.WEST;
        jPanel4.add(jCheckBoxRemoveLineWhenBlank, gridBagConstraints);

        jCheckBoxPrintInFirstWholeBand.setFont(new java.awt.Font("Dialog", 0, 11));
        jCheckBoxPrintInFirstWholeBand.setText("Print in first whole band");
        jCheckBoxPrintInFirstWholeBand.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                jCheckBoxPrintInFirstWholeBandActionPerformed(evt);
            }
        });

        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.WEST;
        jPanel4.add(jCheckBoxPrintInFirstWholeBand, gridBagConstraints);

        jCheckBoxPrintWhenDetailOverflows.setFont(new java.awt.Font("Dialog", 0, 11));
        jCheckBoxPrintWhenDetailOverflows.setText("Print when detail overflows");
        jCheckBoxPrintWhenDetailOverflows.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                jCheckBoxPrintWhenDetailOverflowsActionPerformed(evt);
            }
        });

        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.WEST;
        jPanel4.add(jCheckBoxPrintWhenDetailOverflows, gridBagConstraints);

        jCheckBoxPrintRepeatedValues.setFont(new java.awt.Font("Dialog", 0, 11));
        jCheckBoxPrintRepeatedValues.setText("Print repeated values");
        jCheckBoxPrintRepeatedValues.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                jCheckBoxPrintRepeatedValuesActionPerformed(evt);
            }
        });

        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.WEST;
        jPanel4.add(jCheckBoxPrintRepeatedValues, gridBagConstraints);

        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.NORTHWEST;
        gridBagConstraints.insets = new java.awt.Insets(3, 6, 0, 0);
        jPanelCommon.add(jPanel4, gridBagConstraints);

        jPanel5.setLayout(new java.awt.GridBagLayout());

        jPanel5.setMinimumSize(new java.awt.Dimension(150, 120));
        jPanel5.setPreferredSize(new java.awt.Dimension(150, 120));
        jLabel8.setFont(new java.awt.Font("Dialog", 0, 11));
        jLabel8.setHorizontalAlignment(javax.swing.SwingConstants.LEFT);
        jLabel8.setText("Position type");
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.NORTHWEST;
        jPanel5.add(jLabel8, gridBagConstraints);

        jComboBoxPositionType.setFont(new java.awt.Font("Dialog", 0, 11));
        jComboBoxPositionType.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                jComboBoxPositionTypeActionPerformed(evt);
            }
        });

        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.WEST;
        jPanel5.add(jComboBoxPositionType, gridBagConstraints);

        jLabel9.setFont(new java.awt.Font("Dialog", 0, 11));
        jLabel9.setHorizontalAlignment(javax.swing.SwingConstants.LEFT);
        jLabel9.setText("Print when group changes");
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.WEST;
        jPanel5.add(jLabel9, gridBagConstraints);

        jComboBoxGroups.setFont(new java.awt.Font("Dialog", 0, 11));
        jComboBoxGroups.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                jComboBoxGroupsActionPerformed(evt);
            }
        });

        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.WEST;
        jPanel5.add(jComboBoxGroups, gridBagConstraints);

        jLabel46.setFont(new java.awt.Font("Dialog", 0, 11));
        jLabel46.setText("Key");
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.WEST;
        jPanel5.add(jLabel46, gridBagConstraints);

        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.WEST;
        jPanel5.add(jTextFieldName, gridBagConstraints);

        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.NORTHWEST;
        gridBagConstraints.insets = new java.awt.Insets(3, 0, 0, 0);
        jPanelCommon.add(jPanel5, gridBagConstraints);

        jPanel6.setLayout(new java.awt.GridBagLayout());

        jPanel6.setPreferredSize(new java.awt.Dimension(300, 40));
        jPanel6.setMinimumSize(new java.awt.Dimension(300, 40));
        jLabel10.setFont(new java.awt.Font("Dialog", 0, 11));
        jLabel10.setHorizontalAlignment(javax.swing.SwingConstants.LEFT);
        jLabel10.setText("Print when expression");
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.WEST;
        jPanel6.add(jLabel10, gridBagConstraints);

        jRTextExpressionAreaPrintWhenExpression.setBorder(new javax.swing.border.EtchedBorder());
        jRTextExpressionAreaPrintWhenExpression.setElectricScroll(0);
        jRTextExpressionAreaPrintWhenExpression.setMinimumSize(new java.awt.Dimension(10, 10));
        jRTextExpressionAreaPrintWhenExpression.setPreferredSize(new java.awt.Dimension(10, 10));
        jRTextExpressionAreaPrintWhenExpression.addInputMethodListener(new java.awt.event.InputMethodListener() {
            public void caretPositionChanged(java.awt.event.InputMethodEvent evt) {
            }
            public void inputMethodTextChanged(java.awt.event.InputMethodEvent evt) {
                jRTextExpressionAreaPrintWhenExpressionInputMethodTextChanged(evt);
            }
        });

        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = java.awt.GridBagConstraints.BOTH;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        jPanel6.add(jRTextExpressionAreaPrintWhenExpression, gridBagConstraints);

        jButtonPrintWhenExpression.setIcon(new javax.swing.ImageIcon(getClass().getResource("/it/businesslogic/ireport/icons/arrow.jpg")));
        jButtonPrintWhenExpression.setMargin(new java.awt.Insets(2, 2, 2, 2));
        jButtonPrintWhenExpression.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                jButtonPrintWhenExpressionActionPerformed(evt);
            }
        });

        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.NORTHWEST;
        jPanel6.add(jButtonPrintWhenExpression, gridBagConstraints);

        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = java.awt.GridBagConstraints.BOTH;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new java.awt.Insets(3, 6, 6, 6);
        jPanelCommon.add(jPanel6, gridBagConstraints);

        jPanel11.setLayout(new java.awt.GridBagLayout());

        jPanel11.setPreferredSize(new java.awt.Dimension(300, 46));
        jPanel11.setMinimumSize(new java.awt.Dimension(300, 46));
        jLabel12.setFont(new java.awt.Font("Dialog", 0, 11));
        jLabel12.setText("Stretch Type");
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.NORTHWEST;
        jPanel11.add(jLabel12, gridBagConstraints);

        jComboBoxStretchType.setFont(new java.awt.Font("Dialog", 0, 11));
        jComboBoxStretchType.setPreferredSize(new java.awt.Dimension(300, 20));
        jComboBoxStretchType.setMinimumSize(new java.awt.Dimension(300, 20));
        jComboBoxStretchType.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                jComboBoxStretchTypeActionPerformed(evt);
            }
        });

        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.NORTHWEST;
        gridBagConstraints.insets = new java.awt.Insets(1, 0, 0, 0);
        jPanel11.add(jComboBoxStretchType, gridBagConstraints);

        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.NORTHWEST;
        gridBagConstraints.insets = new java.awt.Insets(0, 6, 4, 0);
        jPanelCommon.add(jPanel11, gridBagConstraints);

        jTabbedPane.addTab("Common", jPanelCommon);

        jPanelGraphicselement.setLayout(new java.awt.GridBagLayout());

        jComboBoxFill.setFont(new java.awt.Font("Dialog", 0, 11));
        jComboBoxFill.setMinimumSize(new java.awt.Dimension(300, 20));
        jComboBoxFill.setPreferredSize(new java.awt.Dimension(300, 20));
        jComboBoxFill.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                jComboBoxFillActionPerformed(evt);
            }
        });

        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.NORTHWEST;
        gridBagConstraints.insets = new java.awt.Insets(1, 6, 170, 6);
        jPanelGraphicselement.add(jComboBoxFill, gridBagConstraints);

        jLabel11.setFont(new java.awt.Font("Dialog", 0, 11));
        jLabel11.setText("Pen");
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.NORTHWEST;
        gridBagConstraints.insets = new java.awt.Insets(12, 8, 0, 0);
        jPanelGraphicselement.add(jLabel11, gridBagConstraints);

        jComboBoxPen.setFont(new java.awt.Font("Dialog", 0, 11));
        jComboBoxPen.setMinimumSize(new java.awt.Dimension(300, 20));
        jComboBoxPen.setPreferredSize(new java.awt.Dimension(300, 20));
        jComboBoxPen.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                jComboBoxPenActionPerformed(evt);
            }
        });

        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.NORTHWEST;
        gridBagConstraints.insets = new java.awt.Insets(1, 6, 0, 6);
        jPanelGraphicselement.add(jComboBoxPen, gridBagConstraints);

        jLabel13.setFont(new java.awt.Font("Dialog", 0, 11));
        jLabel13.setText("Fill");
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.NORTHWEST;
        gridBagConstraints.insets = new java.awt.Insets(8, 8, 0, 0);
        jPanelGraphicselement.add(jLabel13, gridBagConstraints);

        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 83;
        gridBagConstraints.gridy = 82;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        jPanelGraphicselement.add(jSeparator7, gridBagConstraints);

        jTabbedPane.addTab("Graphics Element", jPanelGraphicselement);

        jPanelRectangle.setLayout(new java.awt.GridBagLayout());

        jPanel1.setLayout(null);

        jPanel1.setBorder(new javax.swing.border.TitledBorder(new javax.swing.border.EtchedBorder(), "Rectangle radius"));
        jPanel1.setMinimumSize(new java.awt.Dimension(302, 55));
        jPanel1.setPreferredSize(new java.awt.Dimension(302, 55));
        jLabel14.setFont(new java.awt.Font("Dialog", 0, 11));
        jLabel14.setText("Radius");
        jPanel1.add(jLabel14);
        jLabel14.setBounds(18, 28, 44, 15);

        jNumberFieldRadius.setHorizontalAlignment(javax.swing.JTextField.RIGHT);
        try {
            jNumberFieldRadius.setDecimals(0);
        } catch (java.beans.PropertyVetoException e1) {
            e1.printStackTrace();
        }
        jNumberFieldRadius.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                jNumberFieldRadiusActionPerformed(evt);
            }
        });

        jPanel1.add(jNumberFieldRadius);
        jNumberFieldRadius.setBounds(64, 26, 40, 20);

        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.NORTHWEST;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new java.awt.Insets(12, 6, 0, 8);
        jPanelRectangle.add(jPanel1, gridBagConstraints);

        jTabbedPane.addTab("Rectangle", jPanelRectangle);

        jPanelLine.setLayout(new java.awt.GridBagLayout());

        jLabel15.setFont(new java.awt.Font("Dialog", 0, 11));
        jLabel15.setText("Line direction");
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.NORTHWEST;
        gridBagConstraints.insets = new java.awt.Insets(12, 8, 0, 0);
        jPanelLine.add(jLabel15, gridBagConstraints);

        jComboBoxLineDirection.setFont(new java.awt.Font("Dialog", 0, 11));
        jComboBoxLineDirection.setMinimumSize(new java.awt.Dimension(300, 20));
        jComboBoxLineDirection.setPreferredSize(new java.awt.Dimension(300, 20));
        jComboBoxLineDirection.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                jComboBoxLineDirectionActionPerformed(evt);
            }
        });

        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.NORTHWEST;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new java.awt.Insets(1, 6, 0, 6);
        jPanelLine.add(jComboBoxLineDirection, gridBagConstraints);

        jTabbedPane.addTab("Line", jPanelLine);

        jPanelImage.setLayout(new java.awt.GridBagLayout());

        jRTextExpressionAreaImageExpression.setBorder(new javax.swing.border.EtchedBorder());
        jRTextExpressionAreaImageExpression.setElectricScroll(0);
        jRTextExpressionAreaImageExpression.setMinimumSize(new java.awt.Dimension(300, 47));
        jRTextExpressionAreaImageExpression.setPreferredSize(new java.awt.Dimension(300, 47));
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = java.awt.GridBagConstraints.BOTH;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.NORTHWEST;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new java.awt.Insets(1, 6, 0, 6);
        jPanelImage.add(jRTextExpressionAreaImageExpression, gridBagConstraints);

        jLabel16.setFont(new java.awt.Font("Dialog", 0, 11));
        jLabel16.setHorizontalAlignment(javax.swing.SwingConstants.LEFT);
        jLabel16.setText("Image Expression");
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.NORTHWEST;
        gridBagConstraints.insets = new java.awt.Insets(10, 8, 0, 0);
        jPanelImage.add(jLabel16, gridBagConstraints);

        jButtonFindImage.setFont(new java.awt.Font("Dialog", 0, 11));
        jButtonFindImage.setText("Find...");
        jButtonFindImage.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                jButtonFindImageActionPerformed(evt);
            }
        });

        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.NORTHEAST;
        gridBagConstraints.insets = new java.awt.Insets(1, 0, 0, 6);
        jPanelImage.add(jButtonFindImage, gridBagConstraints);

        jLabel17.setFont(new java.awt.Font("Dialog", 0, 11));
        jLabel17.setText("Image Expression Class");
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.NORTHWEST;
        gridBagConstraints.insets = new java.awt.Insets(1, 8, 0, 0);
        jPanelImage.add(jLabel17, gridBagConstraints);

        jComboBoxImageExpressionClass.setFont(new java.awt.Font("Dialog", 0, 11));
        jComboBoxImageExpressionClass.setMinimumSize(new java.awt.Dimension(300, 20));
        jComboBoxImageExpressionClass.setPreferredSize(new java.awt.Dimension(300, 20));
        jComboBoxImageExpressionClass.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                jComboBoxImageExpressionClassActionPerformed(evt);
            }
        });

        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.NORTHWEST;
        gridBagConstraints.insets = new java.awt.Insets(1, 6, 0, 6);
        jPanelImage.add(jComboBoxImageExpressionClass, gridBagConstraints);

        jLabel18.setFont(new java.awt.Font("Dialog", 0, 11));
        jLabel18.setText("Scale Image");
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.NORTHWEST;
        gridBagConstraints.insets = new java.awt.Insets(1, 8, 0, 0);
        jPanelImage.add(jLabel18, gridBagConstraints);

        jComboBoxScale.setFont(new java.awt.Font("Dialog", 0, 11));
        jComboBoxScale.setMinimumSize(new java.awt.Dimension(150, 20));
        jComboBoxScale.setPreferredSize(new java.awt.Dimension(150, 20));
        jComboBoxScale.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                jComboBoxScaleActionPerformed(evt);
            }
        });

        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 6;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.NORTHWEST;
        gridBagConstraints.insets = new java.awt.Insets(1, 6, 0, 0);
        jPanelImage.add(jComboBoxScale, gridBagConstraints);

        jCheckBoxImageCache.setFont(new java.awt.Font("Dialog", 0, 11));
        jCheckBoxImageCache.setText("Using cache");
        jCheckBoxImageCache.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                jCheckBoxImageCacheActionPerformed(evt);
            }
        });

        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 6;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.WEST;
        gridBagConstraints.insets = new java.awt.Insets(1, 6, 0, 0);
        jPanelImage.add(jCheckBoxImageCache, gridBagConstraints);

        jLabel19.setFont(new java.awt.Font("Dialog", 0, 11));
        jLabel19.setText("Vertical alignment");
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 7;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.NORTHWEST;
        gridBagConstraints.insets = new java.awt.Insets(1, 8, 0, 0);
        jPanelImage.add(jLabel19, gridBagConstraints);

        jComboBoxVerticalAlignment.setFont(new java.awt.Font("Dialog", 0, 11));
        jComboBoxVerticalAlignment.setMinimumSize(new java.awt.Dimension(150, 20));
        jComboBoxVerticalAlignment.setPreferredSize(new java.awt.Dimension(150, 20));
        jComboBoxVerticalAlignment.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                jComboBoxVerticalAlignmentActionPerformed(evt);
            }
        });

        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 8;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.NORTHWEST;
        gridBagConstraints.insets = new java.awt.Insets(1, 6, 0, 0);
        jPanelImage.add(jComboBoxVerticalAlignment, gridBagConstraints);

        jLabel20.setFont(new java.awt.Font("Dialog", 0, 11));
        jLabel20.setText("Horizontal alignment");
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 7;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.WEST;
        gridBagConstraints.insets = new java.awt.Insets(1, 8, 0, 0);
        jPanelImage.add(jLabel20, gridBagConstraints);

        jComboBoxHorizontalAlignment.setFont(new java.awt.Font("Dialog", 0, 11));
        jComboBoxHorizontalAlignment.setMinimumSize(new java.awt.Dimension(150, 20));
        jComboBoxHorizontalAlignment.setPreferredSize(new java.awt.Dimension(150, 20));
        jComboBoxHorizontalAlignment.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                jComboBoxHorizontalAlignmentActionPerformed(evt);
            }
        });

        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 8;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.WEST;
        gridBagConstraints.insets = new java.awt.Insets(1, 6, 0, 6);
        jPanelImage.add(jComboBoxHorizontalAlignment, gridBagConstraints);

        jLabel21.setFont(new java.awt.Font("Dialog", 0, 11));
        jLabel21.setText("Evaluation time");
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 10;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.NORTHWEST;
        gridBagConstraints.insets = new java.awt.Insets(1, 8, 0, 0);
        jPanelImage.add(jLabel21, gridBagConstraints);

        jComboBoxEvaluationTime.setFont(new java.awt.Font("Dialog", 0, 11));
        jComboBoxEvaluationTime.setMinimumSize(new java.awt.Dimension(150, 20));
        jComboBoxEvaluationTime.setPreferredSize(new java.awt.Dimension(150, 20));
        jComboBoxEvaluationTime.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                jComboBoxEvaluationTimeActionPerformed(evt);
            }
        });

        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 11;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.NORTHWEST;
        gridBagConstraints.insets = new java.awt.Insets(1, 6, 6, 0);
        jPanelImage.add(jComboBoxEvaluationTime, gridBagConstraints);

        jLabel22.setFont(new java.awt.Font("Dialog", 0, 11));
        jLabel22.setText("Evaluation group");
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 10;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.WEST;
        gridBagConstraints.insets = new java.awt.Insets(1, 8, 0, 0);
        jPanelImage.add(jLabel22, gridBagConstraints);

        jComboBoxImageGroup.setFont(new java.awt.Font("Dialog", 0, 11));
        jComboBoxImageGroup.setMinimumSize(new java.awt.Dimension(150, 20));
        jComboBoxImageGroup.setPreferredSize(new java.awt.Dimension(150, 20));
        jComboBoxImageGroup.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                jComboBoxImageGroupActionPerformed(evt);
            }
        });

        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 11;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.NORTHWEST;
        gridBagConstraints.insets = new java.awt.Insets(1, 6, 6, 6);
        jPanelImage.add(jComboBoxImageGroup, gridBagConstraints);

        jSeparator1.setMinimumSize(new java.awt.Dimension(300, 2));
        jSeparator1.setPreferredSize(new java.awt.Dimension(300, 2));
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 9;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.WEST;
        gridBagConstraints.insets = new java.awt.Insets(5, 6, 0, 6);
        jPanelImage.add(jSeparator1, gridBagConstraints);

        jTabbedPane.addTab("Image", jPanelImage);

        jPanelText.setLayout(new java.awt.BorderLayout(15, 15));

        jTextAreaText.addInputMethodListener(new java.awt.event.InputMethodListener() {
            public void caretPositionChanged(java.awt.event.InputMethodEvent evt) {
            }
            public void inputMethodTextChanged(java.awt.event.InputMethodEvent evt) {
                jTextAreaTextInputMethodTextChanged(evt);
            }
        });

        jScrollPane1.setViewportView(jTextAreaText);

        jPanelText.add(jScrollPane1, java.awt.BorderLayout.CENTER);

        jTabbedPane.addTab("Text", jPanelText);

        jPanelFont.setLayout(new java.awt.GridBagLayout());

        jPanel7.setLayout(new java.awt.GridBagLayout());

        jPanel7.setMinimumSize(new java.awt.Dimension(300, 150));
        jPanel7.setPreferredSize(new java.awt.Dimension(300, 150));
        jLabel23.setFont(new java.awt.Font("Dialog", 0, 11));
        jLabel23.setText("Report font");
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.NORTHWEST;
        gridBagConstraints.insets = new java.awt.Insets(0, 2, 0, 0);
        jPanel7.add(jLabel23, gridBagConstraints);

        jComboBoxReportFont.setFont(new java.awt.Font("Dialog", 0, 11));
        jComboBoxReportFont.setMinimumSize(new java.awt.Dimension(300, 20));
        jComboBoxReportFont.setPreferredSize(new java.awt.Dimension(300, 20));
        jComboBoxReportFont.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                jComboBoxReportFontActionPerformed(evt);
            }
        });

        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.NORTHWEST;
        jPanel7.add(jComboBoxReportFont, gridBagConstraints);

        jLabel24.setFont(new java.awt.Font("Dialog", 1, 11));
        jLabel24.setText("Font name");
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.NORTHWEST;
        gridBagConstraints.insets = new java.awt.Insets(0, 2, 0, 0);
        jPanel7.add(jLabel24, gridBagConstraints);

        jComboBoxFontName.setFont(new java.awt.Font("Dialog", 0, 11));
        jComboBoxFontName.setMinimumSize(new java.awt.Dimension(244, 20));
        jComboBoxFontName.setPreferredSize(new java.awt.Dimension(244, 20));
        jComboBoxFontName.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                jComboBoxFontNameActionPerformed(evt);
            }
        });

        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.NORTHWEST;
        jPanel7.add(jComboBoxFontName, gridBagConstraints);

        jNumberComboBoxSize.setFont(new java.awt.Font("Dialog", 0, 12));
        jNumberComboBoxSize.setPreferredSize(new java.awt.Dimension(50, 20));
        jNumberComboBoxSize.setMinimumSize(new java.awt.Dimension(50, 20));
        jNumberComboBoxSize.addItemListener(new java.awt.event.ItemListener() {
            public void itemStateChanged(java.awt.event.ItemEvent evt) {
                jNumberComboBoxSizeItemStateChanged(evt);
            }
        });
        jNumberComboBoxSize.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                jNumberComboBoxSizeActionPerformed(evt);
            }
        });

        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.NORTHWEST;
        gridBagConstraints.insets = new java.awt.Insets(0, 6, 0, 0);
        jPanel7.add(jNumberComboBoxSize, gridBagConstraints);

        jLabel27.setFont(new java.awt.Font("Dialog", 0, 11));
        jLabel27.setText("Size");
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.NORTHWEST;
        gridBagConstraints.insets = new java.awt.Insets(0, 8, 0, 0);
        jPanel7.add(jLabel27, gridBagConstraints);

        jLabel25.setFont(new java.awt.Font("Dialog", 0, 11));
        jLabel25.setText("PDF font name");
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.NORTHWEST;
        gridBagConstraints.insets = new java.awt.Insets(0, 2, 0, 0);
        jPanel7.add(jLabel25, gridBagConstraints);

        jComboBoxPDFFontName.setFont(new java.awt.Font("Dialog", 0, 11));
        jComboBoxPDFFontName.setMinimumSize(new java.awt.Dimension(300, 20));
        jComboBoxPDFFontName.setPreferredSize(new java.awt.Dimension(300, 20));
        jComboBoxPDFFontName.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                jComboBoxPDFFontNameActionPerformed(evt);
            }
        });

        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.NORTHWEST;
        jPanel7.add(jComboBoxPDFFontName, gridBagConstraints);

        jLabelTTF.setFont(new java.awt.Font("Dialog", 0, 11));
        jLabelTTF.setText("TrueType font");
        jLabelTTF.setEnabled(false);
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 6;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.NORTHWEST;
        gridBagConstraints.insets = new java.awt.Insets(0, 2, 0, 0);
        jPanel7.add(jLabelTTF, gridBagConstraints);

        jComboBoxTTFFont.setFont(new java.awt.Font("Dialog", 0, 11));
        jComboBoxTTFFont.setMinimumSize(new java.awt.Dimension(300, 20));
        jComboBoxTTFFont.setPreferredSize(new java.awt.Dimension(300, 20));
        jComboBoxTTFFont.setEnabled(false);
        jComboBoxTTFFont.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                jComboBoxTTFFontActionPerformed(evt);
            }
        });

        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 7;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.NORTHWEST;
        jPanel7.add(jComboBoxTTFFont, gridBagConstraints);

        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.insets = new java.awt.Insets(6, 6, 0, 0);
        jPanelFont.add(jPanel7, gridBagConstraints);

        jPanel8.setLayout(new java.awt.GridBagLayout());

        jPanel8.setMinimumSize(new java.awt.Dimension(300, 150));
        jPanel8.setPreferredSize(new java.awt.Dimension(300, 170));
        jPanel12.setLayout(new java.awt.GridBagLayout());

        jCheckBoxBold.setFont(new java.awt.Font("Dialog", 0, 11));
        jCheckBoxBold.setText("Bold");
        jCheckBoxBold.setMinimumSize(new java.awt.Dimension(100, 20));
        jCheckBoxBold.setPreferredSize(new java.awt.Dimension(100, 20));
        jCheckBoxBold.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                jCheckBoxBoldActionPerformed(evt);
            }
        });

        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.NORTHWEST;
        jPanel12.add(jCheckBoxBold, gridBagConstraints);

        jCheckBoxItalic.setFont(new java.awt.Font("Dialog", 0, 11));
        jCheckBoxItalic.setText("Italic");
        jCheckBoxItalic.setMinimumSize(new java.awt.Dimension(100, 20));
        jCheckBoxItalic.setPreferredSize(new java.awt.Dimension(100, 20));
        jCheckBoxItalic.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                jCheckBoxItalicActionPerformed(evt);
            }
        });

        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.NORTHWEST;
        jPanel12.add(jCheckBoxItalic, gridBagConstraints);

        jCheckBoxUnderline.setFont(new java.awt.Font("Dialog", 0, 11));
        jCheckBoxUnderline.setText("Underline");
        jCheckBoxUnderline.setMinimumSize(new java.awt.Dimension(100, 20));
        jCheckBoxUnderline.setPreferredSize(new java.awt.Dimension(100, 20));
        jCheckBoxUnderline.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                jCheckBoxUnderlineActionPerformed(evt);
            }
        });

        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.NORTHWEST;
        jPanel12.add(jCheckBoxUnderline, gridBagConstraints);

        jCheckBoxStrokeTrough.setFont(new java.awt.Font("Dialog", 0, 11));
        jCheckBoxStrokeTrough.setText("Strike Trough");
        jCheckBoxStrokeTrough.setMinimumSize(new java.awt.Dimension(100, 20));
        jCheckBoxStrokeTrough.setPreferredSize(new java.awt.Dimension(100, 20));
        jCheckBoxStrokeTrough.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                jCheckBoxStrokeTroughActionPerformed(evt);
            }
        });

        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.NORTHWEST;
        jPanel12.add(jCheckBoxStrokeTrough, gridBagConstraints);

        jCheckBoxStyledText.setFont(new java.awt.Font("Dialog", 0, 11));
        jCheckBoxStyledText.setText("Is styled text");
        jCheckBoxStyledText.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                jCheckBoxStyledTextActionPerformed(evt);
            }
        });

        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.NORTHEAST;
        jPanel12.add(jCheckBoxStyledText, gridBagConstraints);

        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridheight = 6;
        gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.NORTHEAST;
        jPanel8.add(jPanel12, gridBagConstraints);

        jCheckBoxPDFEmbedded.setFont(new java.awt.Font("Dialog", 0, 11));
        jCheckBoxPDFEmbedded.setText("PDF Embedded");
        jCheckBoxPDFEmbedded.setMaximumSize(new java.awt.Dimension(100, 20));
        jCheckBoxPDFEmbedded.setMinimumSize(new java.awt.Dimension(100, 20));
        jCheckBoxPDFEmbedded.setPreferredSize(new java.awt.Dimension(100, 20));
        jCheckBoxPDFEmbedded.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                jCheckBoxPDFEmbeddedActionPerformed(evt);
            }
        });

        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 7;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.NORTHWEST;
        jPanel8.add(jCheckBoxPDFEmbedded, gridBagConstraints);

        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 6;
        gridBagConstraints.gridwidth = 3;
        gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.NORTHWEST;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new java.awt.Insets(3, 0, 0, 0);
        jPanel8.add(jSeparator2, gridBagConstraints);

        jLabel32.setFont(new java.awt.Font("Dialog", 0, 11));
        jLabel32.setText("PDF Encoding");
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 7;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.WEST;
        gridBagConstraints.insets = new java.awt.Insets(0, 2, 0, 0);
        jPanel8.add(jLabel32, gridBagConstraints);

        jComboBoxPdfEncoding.setEditable(true);
        jComboBoxPdfEncoding.setFont(new java.awt.Font("Dialog", 0, 11));
        jComboBoxPdfEncoding.setMinimumSize(new java.awt.Dimension(200, 20));
        jComboBoxPdfEncoding.setPreferredSize(new java.awt.Dimension(200, 20));
        jComboBoxPdfEncoding.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                jComboBoxPdfEncodingActionPerformed(evt);
            }
        });

        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 8;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.NORTHWEST;
        jPanel8.add(jComboBoxPdfEncoding, gridBagConstraints);

        jComboBoxHAlign.setFont(new java.awt.Font("Dialog", 0, 11));
        jComboBoxHAlign.setMinimumSize(new java.awt.Dimension(95, 20));
        jComboBoxHAlign.setPreferredSize(new java.awt.Dimension(95, 20));
        jComboBoxHAlign.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                jComboBoxHAlignActionPerformed(evt);
            }
        });

        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.NORTHWEST;
        jPanel8.add(jComboBoxHAlign, gridBagConstraints);

        jComboBoxVAlign.setFont(new java.awt.Font("Dialog", 0, 11));
        jComboBoxVAlign.setMinimumSize(new java.awt.Dimension(95, 20));
        jComboBoxVAlign.setPreferredSize(new java.awt.Dimension(95, 20));
        jComboBoxVAlign.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                jComboBoxVAlignActionPerformed(evt);
            }
        });

        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.NORTHWEST;
        gridBagConstraints.insets = new java.awt.Insets(0, 10, 0, 0);
        jPanel8.add(jComboBoxVAlign, gridBagConstraints);

        jLabel30.setFont(new java.awt.Font("Dialog", 0, 11));
        jLabel30.setText("Horizontal align");
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.WEST;
        gridBagConstraints.insets = new java.awt.Insets(0, 2, 0, 0);
        jPanel8.add(jLabel30, gridBagConstraints);

        jLabel31.setFont(new java.awt.Font("Dialog", 0, 11));
        jLabel31.setText("Vertical align");
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.WEST;
        gridBagConstraints.insets = new java.awt.Insets(0, 12, 0, 0);
        jPanel8.add(jLabel31, gridBagConstraints);

        jComboBoxLineSpacing.setFont(new java.awt.Font("Dialog", 0, 11));
        jComboBoxLineSpacing.setMinimumSize(new java.awt.Dimension(200, 20));
        jComboBoxLineSpacing.setPreferredSize(new java.awt.Dimension(200, 20));
        jComboBoxLineSpacing.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                jComboBoxLineSpacingActionPerformed(evt);
            }
        });

        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.NORTHWEST;
        jPanel8.add(jComboBoxLineSpacing, gridBagConstraints);

        jLabel29.setFont(new java.awt.Font("Dialog", 0, 11));
        jLabel29.setText("Line spacing");
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.WEST;
        gridBagConstraints.insets = new java.awt.Insets(0, 2, 0, 0);
        jPanel8.add(jLabel29, gridBagConstraints);

        jLabel49.setFont(new java.awt.Font("Dialog", 0, 11));
        jLabel49.setText("Rotation");
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.NORTHWEST;
        jPanel8.add(jLabel49, gridBagConstraints);

        jComboBoxRotation.setMinimumSize(new java.awt.Dimension(200, 20));
        jComboBoxRotation.setPreferredSize(new java.awt.Dimension(200, 20));
        jComboBoxRotation.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                jComboBoxRotationActionPerformed(evt);
            }
        });

        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.NORTHWEST;
        jPanel8.add(jComboBoxRotation, gridBagConstraints);

        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.ipady = -13;
        gridBagConstraints.insets = new java.awt.Insets(0, 6, 0, 0);
        jPanelFont.add(jPanel8, gridBagConstraints);

        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 99;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.weightx = 1.0;
        jPanelFont.add(jSeparator4, gridBagConstraints);

        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 99;
        gridBagConstraints.weighty = 1.0;
        jPanelFont.add(jSeparator5, gridBagConstraints);

        jTabbedPane.addTab("Font", jPanelFont);

        jPanelTextField.setLayout(new java.awt.GridBagLayout());

        jLabel28.setFont(new java.awt.Font("Dialog", 0, 11));
        jLabel28.setText("Textfield Expression Class");
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.WEST;
        gridBagConstraints.insets = new java.awt.Insets(10, 8, 0, 0);
        jPanelTextField.add(jLabel28, gridBagConstraints);

        jComboBoxTextFieldExpressionClass.setFont(new java.awt.Font("Dialog", 0, 11));
        jComboBoxTextFieldExpressionClass.setPreferredSize(new java.awt.Dimension(300, 20));
        jComboBoxTextFieldExpressionClass.setMinimumSize(new java.awt.Dimension(300, 20));
        jComboBoxTextFieldExpressionClass.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                jComboBoxTextFieldExpressionClassActionPerformed(evt);
            }
        });

        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.WEST;
        gridBagConstraints.insets = new java.awt.Insets(2, 6, 0, 6);
        jPanelTextField.add(jComboBoxTextFieldExpressionClass, gridBagConstraints);

        jLabel37.setFont(new java.awt.Font("Dialog", 0, 11));
        jLabel37.setText("Evaluation time");
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.WEST;
        gridBagConstraints.insets = new java.awt.Insets(6, 8, 0, 0);
        jPanelTextField.add(jLabel37, gridBagConstraints);

        jComboBoxTextFieldEvaluationTime.setFont(new java.awt.Font("Dialog", 0, 11));
        jComboBoxTextFieldEvaluationTime.setMinimumSize(new java.awt.Dimension(147, 20));
        jComboBoxTextFieldEvaluationTime.setPreferredSize(new java.awt.Dimension(147, 20));
        jComboBoxTextFieldEvaluationTime.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                jComboBoxTextFieldEvaluationTimeActionPerformed(evt);
            }
        });

        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.WEST;
        gridBagConstraints.insets = new java.awt.Insets(2, 6, 0, 0);
        jPanelTextField.add(jComboBoxTextFieldEvaluationTime, gridBagConstraints);

        jLabel38.setFont(new java.awt.Font("Dialog", 0, 11));
        jLabel38.setText("Evaluation group");
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.WEST;
        gridBagConstraints.insets = new java.awt.Insets(6, 6, 0, 0);
        jPanelTextField.add(jLabel38, gridBagConstraints);

        jComboBoxTextFieldGroup.setFont(new java.awt.Font("Dialog", 0, 11));
        jComboBoxTextFieldGroup.setMinimumSize(new java.awt.Dimension(147, 20));
        jComboBoxTextFieldGroup.setPreferredSize(new java.awt.Dimension(147, 20));
        jComboBoxTextFieldGroup.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                jComboBoxTextFieldGroupActionPerformed(evt);
            }
        });

        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.WEST;
        gridBagConstraints.insets = new java.awt.Insets(2, 6, 0, 6);
        jPanelTextField.add(jComboBoxTextFieldGroup, gridBagConstraints);

        jCheckBoxStretchWithOverflow.setFont(new java.awt.Font("Dialog", 0, 11));
        jCheckBoxStretchWithOverflow.setText("Stretch with overflow");
        jCheckBoxStretchWithOverflow.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                jCheckBoxStretchWithOverflowActionPerformed(evt);
            }
        });

        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.WEST;
        gridBagConstraints.insets = new java.awt.Insets(6, 6, 0, 0);
        jPanelTextField.add(jCheckBoxStretchWithOverflow, gridBagConstraints);

        jCheckBoxBlankWhenNull.setFont(new java.awt.Font("Dialog", 0, 11));
        jCheckBoxBlankWhenNull.setText("Blank when null");
        jCheckBoxBlankWhenNull.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                jCheckBoxBlankWhenNullActionPerformed(evt);
            }
        });

        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.WEST;
        gridBagConstraints.insets = new java.awt.Insets(6, 6, 0, 8);
        jPanelTextField.add(jCheckBoxBlankWhenNull, gridBagConstraints);

        jLabel39.setFont(new java.awt.Font("Dialog", 0, 11));
        jLabel39.setText("Pattern");
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.WEST;
        gridBagConstraints.insets = new java.awt.Insets(4, 8, 0, 0);
        jPanelTextField.add(jLabel39, gridBagConstraints);

        jLabel40.setFont(new java.awt.Font("Dialog", 0, 11));
        jLabel40.setHorizontalAlignment(javax.swing.SwingConstants.LEFT);
        jLabel40.setText("Textfield expression");
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 7;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.WEST;
        gridBagConstraints.insets = new java.awt.Insets(8, 8, 0, 142);
        jPanelTextField.add(jLabel40, gridBagConstraints);

        jRTextExpressionAreaTextFieldExpression.setBorder(new javax.swing.border.EtchedBorder());
        jRTextExpressionAreaTextFieldExpression.setElectricScroll(0);
        jRTextExpressionAreaTextFieldExpression.setMinimumSize(new java.awt.Dimension(0, 0));
        jRTextExpressionAreaTextFieldExpression.setPreferredSize(new java.awt.Dimension(0, 0));
        jRTextExpressionAreaTextFieldExpression.setAutoscrolls(true);
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 8;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = java.awt.GridBagConstraints.BOTH;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.WEST;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new java.awt.Insets(1, 6, 6, 6);
        jPanelTextField.add(jRTextExpressionAreaTextFieldExpression, gridBagConstraints);

        jPanel2.setLayout(new java.awt.GridBagLayout());

        jPanel2.setPreferredSize(new java.awt.Dimension(300, 23));
        jPanel2.setMinimumSize(new java.awt.Dimension(100, 43));
        jComboBoxPattern.setEditable(true);
        jComboBoxPattern.setFont(new java.awt.Font("Dialog", 0, 12));
        jComboBoxPattern.setPreferredSize(new java.awt.Dimension(300, 20));
        jComboBoxPattern.setMinimumSize(new java.awt.Dimension(150, 20));
        jComboBoxPattern.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                jComboBoxPatternActionPerformed(evt);
            }
        });
        jComboBoxPattern.addInputMethodListener(new java.awt.event.InputMethodListener() {
            public void caretPositionChanged(java.awt.event.InputMethodEvent evt) {
            }
            public void inputMethodTextChanged(java.awt.event.InputMethodEvent evt) {
                jComboBoxPatternInputMethodTextChanged(evt);
            }
        });

        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.WEST;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new java.awt.Insets(0, 6, 0, 6);
        jPanel2.add(jComboBoxPattern, gridBagConstraints);

        jButtonCreatePattern.setFont(new java.awt.Font("Dialog", 0, 11));
        jButtonCreatePattern.setText("Create...");
        jButtonCreatePattern.setPreferredSize(new java.awt.Dimension(80, 23));
        jButtonCreatePattern.setMaximumSize(new java.awt.Dimension(300, 23));
        jButtonCreatePattern.setMinimumSize(new java.awt.Dimension(80, 23));
        jButtonCreatePattern.setMargin(new java.awt.Insets(2, 4, 2, 4));
        jButtonCreatePattern.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                jButtonCreatePatternActionPerformed(evt);
            }
        });

        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
        jPanel2.add(jButtonCreatePattern, gridBagConstraints);

        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 6;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.NORTHWEST;
        gridBagConstraints.insets = new java.awt.Insets(0, 0, 0, 20);
        jPanelTextField.add(jPanel2, gridBagConstraints);

        jTabbedPane.addTab("Text Field", jPanelTextField);

        jPanelSubreport1.setLayout(new java.awt.GridBagLayout());

        jLabel41.setFont(new java.awt.Font("Dialog", 0, 11));
        jLabel41.setText("Connection / Datasource Expression");
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.WEST;
        gridBagConstraints.insets = new java.awt.Insets(2, 6, 0, 0);
        jPanelSubreport1.add(jLabel41, gridBagConstraints);

        jLabel42.setFont(new java.awt.Font("Dialog", 0, 11));
        jLabel42.setHorizontalAlignment(javax.swing.SwingConstants.LEFT);
        jLabel42.setText("Parameters Map Expression");
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.WEST;
        gridBagConstraints.insets = new java.awt.Insets(6, 6, 0, 0);
        jPanelSubreport1.add(jLabel42, gridBagConstraints);

        jRTextExpressionAreaSubreportMapExpression.setBorder(new javax.swing.border.EtchedBorder());
        jRTextExpressionAreaSubreportMapExpression.setElectricScroll(0);
        jRTextExpressionAreaSubreportMapExpression.setMinimumSize(new java.awt.Dimension(0, 0));
        jRTextExpressionAreaSubreportMapExpression.setPreferredSize(new java.awt.Dimension(0, 0));
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = java.awt.GridBagConstraints.BOTH;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.NORTHWEST;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new java.awt.Insets(2, 6, 0, 6);
        jPanelSubreport1.add(jRTextExpressionAreaSubreportMapExpression, gridBagConstraints);

        jComboBoxSubreportConnectionType.setFont(new java.awt.Font("Dialog", 0, 12));
        jComboBoxSubreportConnectionType.setMinimumSize(new java.awt.Dimension(300, 20));
        jComboBoxSubreportConnectionType.setPreferredSize(new java.awt.Dimension(300, 20));
        jComboBoxSubreportConnectionType.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                jComboBoxSubreportConnectionTypeActionPerformed(evt);
            }
        });

        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.WEST;
        gridBagConstraints.insets = new java.awt.Insets(2, 6, 0, 6);
        jPanelSubreport1.add(jComboBoxSubreportConnectionType, gridBagConstraints);

        jRTextExpressionAreaTextConnectionExpression.setBorder(new javax.swing.border.EtchedBorder());
        jRTextExpressionAreaTextConnectionExpression.setMinimumSize(new java.awt.Dimension(300, 50));
        jRTextExpressionAreaTextConnectionExpression.setPreferredSize(new java.awt.Dimension(300, 50));
        jRTextExpressionAreaTextConnectionExpression.setEnabled(false);
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.fill = java.awt.GridBagConstraints.BOTH;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.NORTHWEST;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new java.awt.Insets(2, 6, 0, 6);
        jPanelSubreport1.add(jRTextExpressionAreaTextConnectionExpression, gridBagConstraints);

        jCheckBoxSubreportCache.setFont(new java.awt.Font("Dialog", 0, 11));
        jCheckBoxSubreportCache.setSelected(true);
        jCheckBoxSubreportCache.setText("Using cache");
        jCheckBoxSubreportCache.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                jCheckBoxSubreportCacheActionPerformed(evt);
            }
        });

        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.WEST;
        gridBagConstraints.insets = new java.awt.Insets(2, 6, 6, 0);
        jPanelSubreport1.add(jCheckBoxSubreportCache, gridBagConstraints);

        jTabbedPane.addTab("Subreport", jPanelSubreport1);

        jPanelSubreport2.setLayout(new java.awt.GridBagLayout());

        jLabel26.setFont(new java.awt.Font("Dialog", 0, 11));
        jLabel26.setHorizontalAlignment(javax.swing.SwingConstants.LEFT);
        jLabel26.setText("Subreport Expression");
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.gridwidth = 3;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.WEST;
        gridBagConstraints.insets = new java.awt.Insets(6, 8, 0, 0);
        jPanelSubreport2.add(jLabel26, gridBagConstraints);

        jRTextExpressionAreaSubreportExpression.setBorder(new javax.swing.border.EtchedBorder());
        jRTextExpressionAreaSubreportExpression.setElectricScroll(0);
        jRTextExpressionAreaSubreportExpression.setMinimumSize(new java.awt.Dimension(0, 0));
        jRTextExpressionAreaSubreportExpression.setPreferredSize(new java.awt.Dimension(300, 50));
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.gridwidth = 3;
        gridBagConstraints.fill = java.awt.GridBagConstraints.BOTH;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.WEST;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new java.awt.Insets(2, 6, 0, 6);
        jPanelSubreport2.add(jRTextExpressionAreaSubreportExpression, gridBagConstraints);

        jLabel33.setFont(new java.awt.Font("Dialog", 0, 11));
        jLabel33.setText("Image Expression Class");
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 3;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.WEST;
        gridBagConstraints.insets = new java.awt.Insets(6, 8, 0, 0);
        jPanelSubreport2.add(jLabel33, gridBagConstraints);

        jComboBoxSubreportExpressionClass.setFont(new java.awt.Font("Dialog", 0, 11));
        jComboBoxSubreportExpressionClass.setMinimumSize(new java.awt.Dimension(300, 20));
        jComboBoxSubreportExpressionClass.setPreferredSize(new java.awt.Dimension(300, 20));
        jComboBoxSubreportExpressionClass.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                jComboBoxSubreportExpressionClassActionPerformed(evt);
            }
        });

        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 3;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.WEST;
        gridBagConstraints.insets = new java.awt.Insets(2, 6, 0, 0);
        jPanelSubreport2.add(jComboBoxSubreportExpressionClass, gridBagConstraints);

        jScrollPane2.setMinimumSize(new java.awt.Dimension(300, 50));
        jScrollPane2.setPreferredSize(new java.awt.Dimension(300, 50));
        jTableSubreportParameters.setModel(new javax.swing.table.DefaultTableModel(
            new Object [][] {

            },
            new String [] {
                "Parameter", "Expression"
            }
        ) {
            boolean[] canEdit = new boolean [] {
                false, false
            };

            public boolean isCellEditable(int rowIndex, int columnIndex) {
                return canEdit [columnIndex];
            }
        });
        jScrollPane2.setViewportView(jTableSubreportParameters);

        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.gridwidth = 3;
        gridBagConstraints.fill = java.awt.GridBagConstraints.BOTH;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.WEST;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new java.awt.Insets(2, 6, 0, 6);
        jPanelSubreport2.add(jScrollPane2, gridBagConstraints);

        jLabel34.setFont(new java.awt.Font("Dialog", 0, 11));
        jLabel34.setHorizontalAlignment(javax.swing.SwingConstants.LEFT);
        jLabel34.setText("Subreport parameters");
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.gridwidth = 3;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.WEST;
        gridBagConstraints.insets = new java.awt.Insets(6, 8, 0, 0);
        jPanelSubreport2.add(jLabel34, gridBagConstraints);

        jButtonAddParameter.setFont(new java.awt.Font("Dialog", 0, 11));
        jButtonAddParameter.setText("Add");
        jButtonAddParameter.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                jButtonAddParameterActionPerformed(evt);
            }
        });

        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 6;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.WEST;
        gridBagConstraints.insets = new java.awt.Insets(4, 6, 6, 0);
        jPanelSubreport2.add(jButtonAddParameter, gridBagConstraints);

        jButtonModParameter.setFont(new java.awt.Font("Dialog", 0, 11));
        jButtonModParameter.setText("Modify");
        jButtonModParameter.setEnabled(false);
        jButtonModParameter.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                jButtonModParameterActionPerformed(evt);
            }
        });

        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 6;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.WEST;
        gridBagConstraints.insets = new java.awt.Insets(4, 6, 6, 0);
        jPanelSubreport2.add(jButtonModParameter, gridBagConstraints);

        jButtonRemParameter.setFont(new java.awt.Font("Dialog", 0, 11));
        jButtonRemParameter.setText("Remove");
        jButtonRemParameter.setEnabled(false);
        jButtonRemParameter.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                jButtonRemParameterActionPerformed(evt);
            }
        });

        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 6;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.WEST;
        gridBagConstraints.insets = new java.awt.Insets(4, 6, 6, 0);
        jPanelSubreport2.add(jButtonRemParameter, gridBagConstraints);

        jTabbedPane.addTab("Subreport (Other)", jPanelSubreport2);

        jPanelHyperLink.setLayout(new java.awt.GridBagLayout());

        jRTextExpressionAreaAnchorName.setBorder(new javax.swing.border.EtchedBorder());
        jRTextExpressionAreaAnchorName.setElectricScroll(0);
        jRTextExpressionAreaAnchorName.setMinimumSize(new java.awt.Dimension(0, 0));
        jRTextExpressionAreaAnchorName.setPreferredSize(new java.awt.Dimension(0, 0));
        jRTextExpressionAreaAnchorName.setViewScrollbars(false);
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = java.awt.GridBagConstraints.BOTH;
        gridBagConstraints.ipadx = 300;
        gridBagConstraints.ipady = 46;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.WEST;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new java.awt.Insets(1, 6, 0, 6);
        jPanelHyperLink.add(jRTextExpressionAreaAnchorName, gridBagConstraints);

        jLabel35.setFont(new java.awt.Font("Dialog", 0, 11));
        jLabel35.setHorizontalAlignment(javax.swing.SwingConstants.LEFT);
        jLabel35.setText("Anchor Name Expression");
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.ipadx = 175;
        gridBagConstraints.insets = new java.awt.Insets(10, 8, 0, 6);
        jPanelHyperLink.add(jLabel35, gridBagConstraints);

        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
        gridBagConstraints.ipadx = 300;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.WEST;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new java.awt.Insets(4, 6, 0, 6);
        jPanelHyperLink.add(jSeparator3, gridBagConstraints);

        jComboBoxLinkType.setFont(new java.awt.Font("Dialog", 0, 11));
        jComboBoxLinkType.setMinimumSize(new java.awt.Dimension(180, 20));
        jComboBoxLinkType.setPreferredSize(new java.awt.Dimension(180, 20));
        jComboBoxLinkType.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                jComboBoxLinkTypeActionPerformed(evt);
            }
        });

        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.WEST;
        gridBagConstraints.insets = new java.awt.Insets(6, 6, 0, 6);
        jPanelHyperLink.add(jComboBoxLinkType, gridBagConstraints);

        jLabel36.setFont(new java.awt.Font("Dialog", 0, 11));
        jLabel36.setHorizontalAlignment(javax.swing.SwingConstants.RIGHT);
        jLabel36.setText("Hyperlink type");
        jLabel36.setMaximumSize(new java.awt.Dimension(200, 25));
        jLabel36.setMinimumSize(new java.awt.Dimension(100, 20));
        jLabel36.setPreferredSize(new java.awt.Dimension(100, 20));
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.ipadx = 22;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.WEST;
        gridBagConstraints.insets = new java.awt.Insets(8, 8, 5, 0);
        jPanelHyperLink.add(jLabel36, gridBagConstraints);

        jRTextExpressionAreaReference.setBorder(new javax.swing.border.EtchedBorder());
        jRTextExpressionAreaReference.setEnabled(false);
        jRTextExpressionAreaReference.setMinimumSize(new java.awt.Dimension(300, 50));
        jRTextExpressionAreaReference.setPreferredSize(new java.awt.Dimension(300, 50));
        jRTextExpressionAreaReference.setViewScrollbars(false);
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 6;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = java.awt.GridBagConstraints.BOTH;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.WEST;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new java.awt.Insets(1, 6, 0, 6);
        jPanelHyperLink.add(jRTextExpressionAreaReference, gridBagConstraints);

        jLabelReference.setFont(new java.awt.Font("Dialog", 0, 11));
        jLabelReference.setHorizontalAlignment(javax.swing.SwingConstants.LEFT);
        jLabelReference.setText("Hyperlink Reference Expression");
        jLabelReference.setEnabled(false);
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.WEST;
        gridBagConstraints.insets = new java.awt.Insets(4, 6, 0, 0);
        jPanelHyperLink.add(jLabelReference, gridBagConstraints);

        jRTextExpressionAreaAnchor.setBorder(new javax.swing.border.EtchedBorder());
        jRTextExpressionAreaAnchor.setEnabled(false);
        jRTextExpressionAreaAnchor.setMinimumSize(new java.awt.Dimension(300, 50));
        jRTextExpressionAreaAnchor.setPreferredSize(new java.awt.Dimension(300, 50));
        jRTextExpressionAreaAnchor.setViewScrollbars(false);
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 8;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = java.awt.GridBagConstraints.BOTH;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.WEST;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new java.awt.Insets(1, 6, 0, 6);
        jPanelHyperLink.add(jRTextExpressionAreaAnchor, gridBagConstraints);

        jLabelAnchor.setFont(new java.awt.Font("Dialog", 0, 11));
        jLabelAnchor.setHorizontalAlignment(javax.swing.SwingConstants.LEFT);
        jLabelAnchor.setText("Hyperlink Anchor Expression");
        jLabelAnchor.setEnabled(false);
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 7;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.WEST;
        gridBagConstraints.insets = new java.awt.Insets(2, 6, 0, 0);
        jPanelHyperLink.add(jLabelAnchor, gridBagConstraints);

        jRTextExpressionAreaPage.setBorder(new javax.swing.border.EtchedBorder());
        jRTextExpressionAreaPage.setEnabled(false);
        jRTextExpressionAreaPage.setMinimumSize(new java.awt.Dimension(300, 50));
        jRTextExpressionAreaPage.setPreferredSize(new java.awt.Dimension(300, 50));
        jRTextExpressionAreaPage.setViewScrollbars(false);
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 10;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = java.awt.GridBagConstraints.BOTH;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.WEST;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new java.awt.Insets(1, 6, 12, 6);
        jPanelHyperLink.add(jRTextExpressionAreaPage, gridBagConstraints);

        jLabelPage.setFont(new java.awt.Font("Dialog", 0, 11));
        jLabelPage.setHorizontalAlignment(javax.swing.SwingConstants.LEFT);
        jLabelPage.setText("Hyperlink Page Expression");
        jLabelPage.setEnabled(false);
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 9;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.WEST;
        gridBagConstraints.insets = new java.awt.Insets(2, 6, 0, 8);
        jPanelHyperLink.add(jLabelPage, gridBagConstraints);

        jLabelTarget.setFont(new java.awt.Font("Dialog", 0, 11));
        jLabelTarget.setHorizontalAlignment(javax.swing.SwingConstants.RIGHT);
        jLabelTarget.setText("Hyperlink target");
        jLabelTarget.setMaximumSize(new java.awt.Dimension(200, 25));
        jLabelTarget.setMinimumSize(new java.awt.Dimension(100, 20));
        jLabelTarget.setPreferredSize(new java.awt.Dimension(100, 20));
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.ipadx = 22;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.WEST;
        gridBagConstraints.insets = new java.awt.Insets(8, 8, 5, 0);
        jPanelHyperLink.add(jLabelTarget, gridBagConstraints);

        jComboBoxLinkTarget.setFont(new java.awt.Font("Dialog", 0, 11));
        jComboBoxLinkTarget.setMinimumSize(new java.awt.Dimension(180, 20));
        jComboBoxLinkTarget.setPreferredSize(new java.awt.Dimension(180, 20));
        jComboBoxLinkTarget.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                jComboBoxLinkTargetActionPerformed(evt);
            }
        });

        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.WEST;
        gridBagConstraints.insets = new java.awt.Insets(6, 6, 0, 6);
        jPanelHyperLink.add(jComboBoxLinkTarget, gridBagConstraints);

        jTabbedPane.addTab("Hyper Link", jPanelHyperLink);

        jPanelBarcode.setLayout(new java.awt.GridBagLayout());

        jLabel47.setFont(new java.awt.Font("Dialog", 0, 11));
        jLabel47.setText("Type");
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.NORTHWEST;
        gridBagConstraints.insets = new java.awt.Insets(2, 8, 0, 0);
        jPanelBarcode.add(jLabel47, gridBagConstraints);

        jComboBoxBarcodeType.setFont(new java.awt.Font("Dialog", 0, 11));
        jComboBoxBarcodeType.setModel(new javax.swing.DefaultComboBoxModel(new String[] { "2of7", "3of9", "Bookland", "Codabar", "Code128", "Code128A", "Code128B", "Code128C", "Code39", "EAN128", "EAN13", "GlobalTradeItemNumber", "Int2of5", "Monarch", "NW7", "PDF417", "SCC14ShippingCode", "ShipmentIdentificationNumber", "SSCC18", "Std2of5", "UCC128", "UPCA", "USD3", "USD4", "USPS" }));
        jComboBoxBarcodeType.setMinimumSize(new java.awt.Dimension(100, 20));
        jComboBoxBarcodeType.setPreferredSize(new java.awt.Dimension(200, 20));
        jComboBoxBarcodeType.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                jComboBoxBarcodeTypeActionPerformed(evt);
            }
        });

        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.NORTHWEST;
        gridBagConstraints.insets = new java.awt.Insets(2, 8, 0, 0);
        jPanelBarcode.add(jComboBoxBarcodeType, gridBagConstraints);

        jBarcodeExpressionArea.setBorder(new javax.swing.border.EtchedBorder());
        jBarcodeExpressionArea.setElectricScroll(0);
        jBarcodeExpressionArea.setMinimumSize(new java.awt.Dimension(0, 0));
        jBarcodeExpressionArea.setPreferredSize(new java.awt.Dimension(0, 0));
        jBarcodeExpressionArea.setAutoscrolls(true);
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 8;
        gridBagConstraints.gridwidth = 3;
        gridBagConstraints.fill = java.awt.GridBagConstraints.BOTH;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.WEST;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new java.awt.Insets(2, 8, 6, 6);
        jPanelBarcode.add(jBarcodeExpressionArea, gridBagConstraints);

        jLabel48.setFont(new java.awt.Font("Dialog", 0, 11));
        jLabel48.setHorizontalAlignment(javax.swing.SwingConstants.LEFT);
        jLabel48.setText("Barcode expression");
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 7;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.WEST;
        gridBagConstraints.insets = new java.awt.Insets(2, 8, 0, 0);
        jPanelBarcode.add(jLabel48, gridBagConstraints);

        jCheckBoxBarcodeCheckSum.setText("Checksum");
        jCheckBoxBarcodeCheckSum.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                BarcodeActionPerformed(evt);
            }
        });

        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.NORTHWEST;
        gridBagConstraints.insets = new java.awt.Insets(2, 8, 0, 0);
        jPanelBarcode.add(jCheckBoxBarcodeCheckSum, gridBagConstraints);

        jCheckBoxBarcodeShowText.setText("Show Text");
        jCheckBoxBarcodeShowText.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                BarcodeActionPerformed(evt);
            }
        });

        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.NORTHWEST;
        gridBagConstraints.insets = new java.awt.Insets(2, 8, 0, 0);
        jPanelBarcode.add(jCheckBoxBarcodeShowText, gridBagConstraints);

        jSeparator8.setPreferredSize(new java.awt.Dimension(300, 2));
        jSeparator8.setMinimumSize(new java.awt.Dimension(300, 2));
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 9;
        gridBagConstraints.gridwidth = 3;
        gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.WEST;
        gridBagConstraints.insets = new java.awt.Insets(5, 6, 0, 6);
        jPanelBarcode.add(jSeparator8, gridBagConstraints);

        jComboBoxBarcodeGroup.setFont(new java.awt.Font("Dialog", 0, 11));
        jComboBoxBarcodeGroup.setPreferredSize(new java.awt.Dimension(150, 20));
        jComboBoxBarcodeGroup.setMinimumSize(new java.awt.Dimension(150, 20));
        jComboBoxBarcodeGroup.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                jComboBoxBarcodeGroupActionPerformed(evt);
            }
        });

        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 11;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.NORTHWEST;
        gridBagConstraints.insets = new java.awt.Insets(1, 6, 6, 6);
        jPanelBarcode.add(jComboBoxBarcodeGroup, gridBagConstraints);

        jLabel43.setFont(new java.awt.Font("Dialog", 0, 11));
        jLabel43.setText("Evaluation group");
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 10;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.WEST;
        gridBagConstraints.insets = new java.awt.Insets(1, 8, 0, 0);
        jPanelBarcode.add(jLabel43, gridBagConstraints);

        jComboBoxEvaluationTimeBarcode.setFont(new java.awt.Font("Dialog", 0, 11));
        jComboBoxEvaluationTimeBarcode.setPreferredSize(new java.awt.Dimension(150, 20));
        jComboBoxEvaluationTimeBarcode.setMinimumSize(new java.awt.Dimension(150, 20));
        jComboBoxEvaluationTimeBarcode.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                jComboBoxEvaluationTimeBarcodeActionPerformed(evt);
            }
        });

        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 11;
        gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.NORTHWEST;
        gridBagConstraints.insets = new java.awt.Insets(1, 6, 6, 0);
        jPanelBarcode.add(jComboBoxEvaluationTimeBarcode, gridBagConstraints);

        jLabel50.setFont(new java.awt.Font("Dialog", 0, 11));
        jLabel50.setText("Evaluation time");
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 10;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.NORTHWEST;
        gridBagConstraints.insets = new java.awt.Insets(1, 8, 0, 0);
        jPanelBarcode.add(jLabel50, gridBagConstraints);

        jTabbedPane.addTab("Barcode", jPanelBarcode);

        jPanelChart.setLayout(new java.awt.GridBagLayout());

        jPanelChart.add(jSeparator6, new java.awt.GridBagConstraints());

        jSeparator9.setMinimumSize(new java.awt.Dimension(300, 2));
        jSeparator9.setPreferredSize(new java.awt.Dimension(300, 2));
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 9;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.WEST;
        gridBagConstraints.insets = new java.awt.Insets(5, 6, 0, 6);
        jPanelChart.add(jSeparator9, gridBagConstraints);

        jLabel44.setFont(new java.awt.Font("Dialog", 0, 11));
        jLabel44.setText("Evaluation time");
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 10;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.NORTHWEST;
        gridBagConstraints.insets = new java.awt.Insets(1, 8, 0, 0);
        jPanelChart.add(jLabel44, gridBagConstraints);

        jComboBoxEvaluationTime1.setFont(new java.awt.Font("Dialog", 0, 11));
        jComboBoxEvaluationTime1.setMinimumSize(new java.awt.Dimension(150, 20));
        jComboBoxEvaluationTime1.setPreferredSize(new java.awt.Dimension(150, 20));
        jComboBoxEvaluationTime1.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                jComboBoxEvaluationTime1ActionPerformed(evt);
            }
        });

        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 11;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.NORTHWEST;
        gridBagConstraints.insets = new java.awt.Insets(1, 6, 6, 0);
        jPanelChart.add(jComboBoxEvaluationTime1, gridBagConstraints);

        jLabel45.setFont(new java.awt.Font("Dialog", 0, 11));
        jLabel45.setText("Evaluation group");
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 10;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.WEST;
        gridBagConstraints.insets = new java.awt.Insets(1, 8, 0, 0);
        jPanelChart.add(jLabel45, gridBagConstraints);

        jComboBoxImageGroup1.setFont(new java.awt.Font("Dialog", 0, 11));
        jComboBoxImageGroup1.setMinimumSize(new java.awt.Dimension(150, 20));
        jComboBoxImageGroup1.setPreferredSize(new java.awt.Dimension(150, 20));
        jComboBoxImageGroup1.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                jComboBoxImageGroup1ActionPerformed(evt);
            }
        });

        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 11;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.NORTHWEST;
        gridBagConstraints.insets = new java.awt.Insets(1, 6, 6, 6);
        jPanelChart.add(jComboBoxImageGroup1, gridBagConstraints);

        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 12;
        gridBagConstraints.gridwidth = 3;
        gridBagConstraints.fill = java.awt.GridBagConstraints.BOTH;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        jPanelChart.add(jPanel9, gridBagConstraints);

        jButton1.setFont(new java.awt.Font("Dialog", 0, 11));
        jButton1.setLabel("Edit chart properties");
        jButton1.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                jButton1ActionPerformed(evt);
            }
        });

        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.NORTHWEST;
        gridBagConstraints.insets = new java.awt.Insets(4, 4, 0, 0);
        jPanelChart.add(jButton1, gridBagConstraints);

        jTabbedPane.addTab("Chart", jPanelChart);

        jPanelBorder.setLayout(new java.awt.GridBagLayout());

        jTabbedPane.addTab("Border", jPanelBorder);

        getContentPane().add(jTabbedPane, java.awt.BorderLayout.CENTER);

        java.awt.Dimension screenSize = java.awt.Toolkit.getDefaultToolkit().getScreenSize();
        setBounds((screenSize.width-457)/2, (screenSize.height-397)/2, 457, 397);
    }//GEN-END:initComponents

    private void jComboBoxLinkTargetActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_jComboBoxLinkTargetActionPerformed
         if (this.isInit()) return;
        
        if (jrf == null || jrf.getSelectedElements().size()==0 || jComboBoxLinkTarget.getSelectedItem() == null || (jComboBoxLinkTarget.getSelectedItem()+"").equals("")) return;
        Enumeration e = jrf.getSelectedElements().elements();
            while (e.hasMoreElements()) {
                HyperLinkableReportElement element = (HyperLinkableReportElement)e.nextElement();
                element.setHyperlinkTarget( ""+jComboBoxLinkTarget.getSelectedItem());
            }
        jComboBoxLinkTarget.removeItem("");
    }//GEN-LAST:event_jComboBoxLinkTargetActionPerformed

    private void jButton1ActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_jButton1ActionPerformed
        it.businesslogic.ireport.chart.gui.IReportChartDialog icd = new it.businesslogic.ireport.chart.gui.IReportChartDialog(this,true);
        icd.setJReportFrame( jrf );
        ChartReportElement cre = (ChartReportElement)jrf.getSelectedElements().elementAt(0) ;
        icd.setProperties(cre.getProps());
        icd.show();     
        if (icd.getDialogResult() == javax.swing.JOptionPane.OK_OPTION)
        {
            // Integrate properties...
            Properties props = icd.getProperties();
            Iterator keys = props.keySet().iterator();
            while (keys.hasNext())
            {
                String key = ""+keys.next();
                String val = props.getProperty(key);
                cre.getProps().setProperty(key, val);
                
            }
            
            cre.updateChartImage();
            //setImg( it.businesslogic.ireport.chart.AvailableCharts.getChartIcon( props.getProperty("chartName")).getImage());
            jrf.getJPanelReport().repaint();
            
        }
        
    }//GEN-LAST:event_jButton1ActionPerformed

    private void jComboBoxImageGroup1ActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_jComboBoxImageGroup1ActionPerformed
         if (this.isInit()) return;
        
        // Set band to all....
        if (jrf == null || jrf.getSelectedElements().size()==0 || jComboBoxImageGroup1.getSelectedItem() == null || (jComboBoxImageGroup1.getSelectedItem()+"").equals("")) return;
        // Set the new value for all selected elements...
        Enumeration e = jrf.getSelectedElements().elements();
        while (e.hasMoreElements()) {
            ImageReportElement element = (ImageReportElement)e.nextElement();
            element.setEvaluationGroup(""+ jComboBoxImageGroup1.getSelectedItem());
        }
        
        this.jComboBoxImageGroup1.removeItem("");
    }//GEN-LAST:event_jComboBoxImageGroup1ActionPerformed

    private void jComboBoxEvaluationTime1ActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_jComboBoxEvaluationTime1ActionPerformed
          if (this.isInit()) return;
        
        // Set band to all....
        if (jrf == null || jrf.getSelectedElements().size()==0 || jComboBoxEvaluationTime1.getSelectedItem() == null || (jComboBoxEvaluationTime1.getSelectedItem()+"").equals("")) return;
        // Set the new value for all selected elements...
        Enumeration e = jrf.getSelectedElements().elements();
        while (e.hasMoreElements()) {
            ImageReportElement element = (ImageReportElement)e.nextElement();
            element.setEvaluationTime(""+ jComboBoxEvaluationTime1.getSelectedItem());
        }
        
        this.jComboBoxEvaluationTime1.removeItem("");
    }//GEN-LAST:event_jComboBoxEvaluationTime1ActionPerformed

    private void jButtonCreatePatternActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_jButtonCreatePatternActionPerformed
       
        FieldPatternDialog fpd = new FieldPatternDialog(MainFrame.getMainInstance() ,true);
        fpd.show();
        if (fpd.getDialogResult() == javax.swing.JOptionPane.OK_OPTION)
        {
            jComboBoxPattern.setSelectedItem( fpd.getPattern() );
        }
        
    }//GEN-LAST:event_jButtonCreatePatternActionPerformed
    
    private void jComboBoxBarcodeGroupActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_jComboBoxBarcodeGroupActionPerformed
        if (this.isInit()) return;
        
        // Set band to all....
        if (jrf == null || jrf.getSelectedElements().size()==0 || jComboBoxBarcodeGroup.getSelectedItem() == null || (jComboBoxBarcodeGroup.getSelectedItem()+"").equals("")) return;
        // Set the new value for all selected elements...
        Enumeration e = jrf.getSelectedElements().elements();
        while (e.hasMoreElements()) {
            ImageReportElement element = (ImageReportElement)e.nextElement();
            element.setEvaluationGroup(""+ jComboBoxBarcodeGroup.getSelectedItem());
        }
        
        this.jComboBoxBarcodeGroup.removeItem("");
    }//GEN-LAST:event_jComboBoxBarcodeGroupActionPerformed
    
    private void jComboBoxEvaluationTimeBarcodeActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_jComboBoxEvaluationTimeBarcodeActionPerformed
        if (this.isInit()) return;
        
        // Set band to all....
        if (jrf == null || jrf.getSelectedElements().size()==0 || jComboBoxEvaluationTimeBarcode.getSelectedItem() == null || (jComboBoxEvaluationTimeBarcode.getSelectedItem()+"").equals("")) return;
        // Set the new value for all selected elements...
        Enumeration e = jrf.getSelectedElements().elements();
        while (e.hasMoreElements()) {
            ImageReportElement element = (ImageReportElement)e.nextElement();
            element.setEvaluationTime(""+ jComboBoxEvaluationTimeBarcode.getSelectedItem());
        }
        
        this.jComboBoxEvaluationTimeBarcode.removeItem("");
    }//GEN-LAST:event_jComboBoxEvaluationTimeBarcodeActionPerformed
                        
    private void jCheckBoxStyledTextActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_jCheckBoxStyledTextActionPerformed
        if (this.isInit()) return;
        
        // Set band to all....
        if (jrf == null || jrf.getSelectedElements().size()==0) return;
        // Set the new value for all selected elements...
        Enumeration e = jrf.getSelectedElements().elements();
        while (e.hasMoreElements()) {
            TextReportElement element = (TextReportElement)e.nextElement();
            element.setIsStyledText(jCheckBoxStyledText.isSelected());
            element.setFont(null);
            /* Adjust PDF font...*/
        }
        jrf.getJPanelReport().repaint();
    }//GEN-LAST:event_jCheckBoxStyledTextActionPerformed
    
    private void jComboBoxRotationActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_jComboBoxRotationActionPerformed
        if (this.isInit()) return;
        
        // Set band to all....
        if (jrf == null || jrf.getSelectedElements().size()==0 || jComboBoxRotation.getSelectedItem() == null || (jComboBoxRotation.getSelectedItem()+"").equals("")) return;
        // Set the new value for all selected elements...
        Enumeration e = jrf.getSelectedElements().elements();
        while (e.hasMoreElements()) {
            TextReportElement element = (TextReportElement)e.nextElement();
            element.setRotate(""+ jComboBoxRotation.getSelectedItem());
        }
        
        this.jComboBoxRotation.removeItem("");
        jrf.getJPanelReport().repaint();
    }//GEN-LAST:event_jComboBoxRotationActionPerformed
    
	private void BarcodeActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_BarcodeActionPerformed
            if (this.isInit()) return;
            
            // Set band to all....
            if (jrf == null || jrf.getSelectedElements().size()==0) return;
            // Set the new value for all selected elements...
            Enumeration e = jrf.getSelectedElements().elements();
            while (e.hasMoreElements()) {
                BarcodeReportElement element = (BarcodeReportElement) e.nextElement();
                element.setType(jComboBoxBarcodeType.getSelectedIndex());
                element.setText(jBarcodeExpressionArea.getText());
                element.setShowText(jCheckBoxBarcodeShowText.isSelected());
                element.setCheckSum(jCheckBoxBarcodeCheckSum.isSelected());
                jrf.getJPanelReport().repaint();
                
                //show last error in console
                if(element.getLastError() != null){
                    jrf.getMainFrame().logOnConsole("Error BarcodeReportElement(" + element.getName() + "): " + element.getLastError()+"\n");
                }
            }
	}//GEN-LAST:event_BarcodeActionPerformed
        
        private void jComboBoxBarcodeTypeActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_jComboBoxBarcodeTypeActionPerformed
            BarcodeActionPerformed(evt);
        }//GEN-LAST:event_jComboBoxBarcodeTypeActionPerformed
        
    private void jNumberFieldLeftActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_jNumberFieldLeftActionPerformed
        if (jrf == null || jrf.getSelectedElements().size()==0) return;
        // Set the new value for all selected elements...
        Enumeration e = jrf.getSelectedElements().elements();
        while (e.hasMoreElements()) {
            ReportElement element = (ReportElement)e.nextElement();
            element.trasform( new Point( (int)jNumberFieldLeft.getValue()- (element.getPosition().x-10- jrf.getReport().getLeftMargin()) ,0 ), TransformationType.TRANSFORMATION_MOVE);
            jrf.fireReportListenerReportElementsChanged(new ReportElementChangedEvent(jrf , element , ReportElementChangedEvent.CHANGED));
        }
        jrf.getJPanelReport().repaint();
    }//GEN-LAST:event_jNumberFieldLeftActionPerformed
    
    private void jNumberFieldTopActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_jNumberFieldTopActionPerformed
        if (jrf == null || jrf.getSelectedElements().size()==0) return;
        // Set the new value for all selected elements...
        Enumeration e = jrf.getSelectedElements().elements();
        Band last_band = null;
        int y_location = 0;
        while (e.hasMoreElements()) {
            ReportElement element = (ReportElement)e.nextElement();
            // 1. Set element properties...
            // For each panel, search
            if (last_band == null || last_band != element.getBand()) {
                y_location = this.jrf.getReport().getBandYLocation(element.getBand());
                last_band = element.getBand();
            }
            
            element.trasform( new Point(0, (int)jNumberFieldTop.getValue()- (element.getPosition().y - 10 - this.jrf.getReport().getBandYLocation(last_band)) ) , TransformationType.TRANSFORMATION_MOVE);
            jrf.fireReportListenerReportElementsChanged(new ReportElementChangedEvent(jrf , element , ReportElementChangedEvent.CHANGED));
            
        }
        jrf.getJPanelReport().repaint();
    }//GEN-LAST:event_jNumberFieldTopActionPerformed
    
    private void jComboBoxBandActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_jComboBoxBandActionPerformed
        if (this.isInit()) return;
        
        // Set band to all....
        if (jrf == null || jrf.getSelectedElements().size()==0 || jComboBoxBand.getSelectedItem() == null || (jComboBoxBand.getSelectedIndex() == 0 && (jComboBoxBand.getSelectedItem()+"").trim().equals("") )) return;
        // Set the new value for all selected elements...
        Enumeration e = jrf.getSelectedElements().elements();
        while (e.hasMoreElements()) {
            ReportElement element = (ReportElement)e.nextElement();
            element.setBand((Band) jComboBoxBand.getSelectedItem() ) ;
            jrf.fireReportListenerReportElementsChanged(new ReportElementChangedEvent(jrf , element , ReportElementChangedEvent.CHANGED));
            
        }
        // Update coords...
        jrf.getJPanelReport().repaint();
        
        e = jrf.getSelectedElements().elements();
        
        boolean isTheFirstElement = true;
        Band last_band = null;
        int y_location = 0;
        while (e.hasMoreElements()) {
            ReportElement re = (ReportElement)e.nextElement();
            // 1. Set element properties...
            // For each panel, search
            if (last_band == null || last_band != re.getBand()) {
                y_location = this.jrf.getReport().getBandYLocation(re.getBand());
                last_band = re.getBand();
            }
            
            this.setElementNumber(isTheFirstElement, re.getWidth(), jNumberFieldWidth);
            this.setElementNumber(isTheFirstElement, re.getHeight(), jNumberFieldHeight);
            this.setElementNumber(isTheFirstElement, re.getPosition().x - 10 - this.jrf.getReport().getLeftMargin(), jNumberFieldLeft);
            this.setElementNumber(isTheFirstElement, re.getPosition().y - y_location - 10, jNumberFieldTop);
            
            this.setCheckBox(isTheFirstElement, re.getTransparent().equals("Transparent"),jCheckBoxTransparent);
            isTheFirstElement=false;
        }
        
        if (!(""+this.jComboBoxBand.getSelectedItem()).equals("")) {
            this.jComboBoxBand.removeItem("");
        }
    }//GEN-LAST:event_jComboBoxBandActionPerformed
    
    private void jNumberFieldHeightActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_jNumberFieldHeightActionPerformed
        if (jrf == null || jrf.getSelectedElements().size()==0) return;
        // Set the new value for all selected elements...
        Enumeration e = jrf.getSelectedElements().elements();
        while (e.hasMoreElements()) {
            ReportElement element = (ReportElement)e.nextElement();
            element.trasform( new Point(0, (int)jNumberFieldHeight.getValue()- element.getHeight() ), TransformationType.TRANSFORMATION_RESIZE_S);
            jrf.fireReportListenerReportElementsChanged(new ReportElementChangedEvent(jrf , element , ReportElementChangedEvent.CHANGED));
        }
        jrf.getJPanelReport().repaint();
    }//GEN-LAST:event_jNumberFieldHeightActionPerformed
    
    private void jNumberFieldWidthActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_jNumberFieldWidthActionPerformed
        if (jrf == null || jrf.getSelectedElements().size()==0) return;
        // Set the new value for all selected elements...
        Enumeration e = jrf.getSelectedElements().elements();
        while (e.hasMoreElements()) {
            ReportElement element = (ReportElement)e.nextElement();
            element.trasform( new Point( (int)jNumberFieldWidth.getValue()- element.getWidth(),0 ), TransformationType.TRANSFORMATION_RESIZE_E);
            jrf.fireReportListenerReportElementsChanged(new ReportElementChangedEvent(jrf , element , ReportElementChangedEvent.CHANGED));
        }
        
        jrf.getJPanelReport().repaint();
    }//GEN-LAST:event_jNumberFieldWidthActionPerformed
    
    private void jButtonForegroundActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_jButtonForegroundActionPerformed
        java.awt.Color color = javax.swing.JColorChooser.showDialog( null, "Select foreground color...",
        this.jButtonForeground.getBackground());
        if (color  != null) {
            this.jButtonForeground.setBackground(color);
            
            if (jrf == null || jrf.getSelectedElements().size()==0) return;
            // Set the new value for all selected elements...
            Enumeration e = jrf.getSelectedElements().elements();
            while (e.hasMoreElements()) {
                ReportElement element = (ReportElement)e.nextElement();
                element.fgcolor =  color;
            }
            jrf.getJPanelReport().repaint();
        }
    }//GEN-LAST:event_jButtonForegroundActionPerformed
    
    private void jButtonBackgroundActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_jButtonBackgroundActionPerformed
        
        java.awt.Color color = javax.swing.JColorChooser.showDialog( null, "Select background color...",
        this.jButtonBackground.getBackground());
        if (color  != null) {
            this.jButtonBackground.setBackground(color);
            if (jrf == null || jrf.getSelectedElements().size()==0) return;
            // Set the new value for all selected elements...
            Enumeration e = jrf.getSelectedElements().elements();
            while (e.hasMoreElements()) {
                ReportElement element = (ReportElement)e.nextElement();
                element.bgcolor =  color;
                
                // Adaptation by Robert Lamping
                // RFE: 704101 [B]
                // setting a background color, resets transparency to false.
                element.setTransparent("Opaque");
                // end of adaptation
            }
            
            // Adaptation by Robert Lamping
            // RFE: 704101 [B]
            // setting a background color, resets transparency to false.
            this.jCheckBoxTransparent.setSelected( false );
            jrf.getMainFrame().logOnConsole("Transparency switched off! \n");
            // End of adaptation
            
            jrf.getJPanelReport().repaint();
        }
        
        
        
        
        
    }//GEN-LAST:event_jButtonBackgroundActionPerformed
    
    private void jButtonPrintWhenExpressionActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_jButtonPrintWhenExpressionActionPerformed
        if (this.jrf == null) return;
        ExpressionEditor ed = new ExpressionEditor();
        ed.setJrf( this.jrf );
        ed.setExpression( this.jRTextExpressionAreaPrintWhenExpression.getText() );
        ed.show();
        if (ed.getDialogResult() == javax.swing.JOptionPane.OK_OPTION) {
            this.jRTextExpressionAreaPrintWhenExpression.setText( ed.getExpression() );
        }
        
        
    }//GEN-LAST:event_jButtonPrintWhenExpressionActionPerformed
    
    private void jComboBoxReportFontActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_jComboBoxReportFontActionPerformed
        if (this.isInit()) return;
        
        // Set band to all....
        if (jrf == null || jrf.getSelectedElements().size()==0 || jComboBoxReportFont.getSelectedItem() == null) return;
        
        
        // Set the new value for all selected elements...
        // Looking for the selected report font...
        Enumeration fonts = jrf.getReport().getFonts().elements();
        IReportFont font = null;
        while (fonts.hasMoreElements()) {
            font = (IReportFont)fonts.nextElement();
            if (font != null && font.getReportFont().equals(""+ jComboBoxReportFont.getSelectedItem() ) ) {
                break;
            }
            else
                font = null;
        }
        
        String reportFontName = "";
        if (font==null)
            reportFontName = "";
        else
            reportFontName = font.getReportFont();
        
        Enumeration e = jrf.getSelectedElements().elements();
        while (e.hasMoreElements()) {
            TextReportElement element = (TextReportElement)e.nextElement();
            element.setReportFont(reportFontName);
            if (font != null) {
                element.setFontName( font.getFontName());
                element.setBold( font.isBold());
                element.setItalic( font.isItalic());
                element.setUnderline( font.isUnderline());
                element.setStrikeTrought( font.isStrikeTrought());
                element.setPDFFontName( font.getPDFFontName());
                element.setPdfEmbedded( font.isPdfEmbedded());
                element.setPdfEncoding( font.getPdfEncoding());
                element.setTTFFont( font.getTTFFont());
                element.setFontSize( font.getFontSize());
            }
        }
        
        this.updateSelection();
        this.jrf.getReportPanel().repaint();
        
        this.jComboBoxFontName.removeItem("");
        jrf.getJPanelReport().repaint();
    }//GEN-LAST:event_jComboBoxReportFontActionPerformed
                                    
    private void jComboBoxLinkTypeActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_jComboBoxLinkTypeActionPerformed
        if (this.isInit()) return;
        
        if (jrf == null || jrf.getSelectedElements().size()==0 || jComboBoxLinkType.getSelectedItem() == null || (jComboBoxLinkType.getSelectedItem()+"").equals("")) return;
        Enumeration e = jrf.getSelectedElements().elements();
        if (((String)this.jComboBoxLinkType.getSelectedItem()).equals("None")) {
            // Set to blank all link fields...
            while (e.hasMoreElements()) {
                HyperLinkableReportElement element = (HyperLinkableReportElement)e.nextElement();
                element.setHyperlinkType( ""+jComboBoxLinkType.getSelectedItem());
                element.setHyperlinkReferenceExpression("");
                element.setHyperlinkAnchorExpression("");
                element.setHyperlinkPageExpression("");
                this.jRTextExpressionAreaAnchor.setText("");
                this.jRTextExpressionAreaAnchor.setEnabled(false);
                this.jLabelAnchor.setEnabled(false);
                this.jRTextExpressionAreaPage.setText("");
                this.jRTextExpressionAreaPage.setEnabled(false);
                this.jLabelPage.setEnabled(false);
                this.jRTextExpressionAreaReference.setText("");
                this.jRTextExpressionAreaReference.setEnabled(false);
                this.jLabelReference.setEnabled(false);
            }
        }
        else if (((String)this.jComboBoxLinkType.getSelectedItem()).equals("Reference")) {
            // Set to blank all link fields...
            while (e.hasMoreElements()) {
                HyperLinkableReportElement element = (HyperLinkableReportElement)e.nextElement();
                element.setHyperlinkType( ""+jComboBoxLinkType.getSelectedItem());
                element.setHyperlinkReferenceExpression("");
                element.setHyperlinkAnchorExpression("");
                element.setHyperlinkPageExpression("");
                this.jRTextExpressionAreaAnchor.setText("");
                this.jRTextExpressionAreaAnchor.setEnabled(false);
                this.jLabelAnchor.setEnabled(false);
                this.jRTextExpressionAreaPage.setText("");
                this.jRTextExpressionAreaPage.setEnabled(false);
                this.jLabelPage.setEnabled(false);
                this.jRTextExpressionAreaReference.setText("");
                this.jRTextExpressionAreaReference.setEnabled(true);
                this.jLabelReference.setEnabled(true);
            }
        }
        else if (((String)this.jComboBoxLinkType.getSelectedItem()).equals("LocalAnchor")) {
            // Set to blank all link fields...
            while (e.hasMoreElements()) {
                HyperLinkableReportElement element = (HyperLinkableReportElement)e.nextElement();
                element.setHyperlinkType( ""+jComboBoxLinkType.getSelectedItem());
                element.setHyperlinkReferenceExpression("");
                element.setHyperlinkAnchorExpression("");
                element.setHyperlinkPageExpression("");
                this.jRTextExpressionAreaAnchor.setText("");
                this.jRTextExpressionAreaAnchor.setEnabled(true);
                this.jLabelAnchor.setEnabled(true);
                this.jRTextExpressionAreaPage.setText("");
                this.jRTextExpressionAreaPage.setEnabled(false);
                this.jLabelPage.setEnabled(false);
                this.jRTextExpressionAreaReference.setText("");
                this.jRTextExpressionAreaReference.setEnabled(false);
                this.jLabelReference.setEnabled(false);
            }
        }
        else if (((String)this.jComboBoxLinkType.getSelectedItem()).equals("LocalPage")) {
            // Set to blank all link fields...
            while (e.hasMoreElements()) {
                HyperLinkableReportElement element = (HyperLinkableReportElement)e.nextElement();
                element.setHyperlinkType( ""+jComboBoxLinkType.getSelectedItem());
                element.setHyperlinkReferenceExpression("");
                element.setHyperlinkAnchorExpression("");
                element.setHyperlinkPageExpression("");
                this.jRTextExpressionAreaAnchor.setText("");
                this.jRTextExpressionAreaAnchor.setEnabled(false);
                this.jLabelAnchor.setEnabled(false);
                this.jRTextExpressionAreaPage.setText("");
                this.jRTextExpressionAreaPage.setEnabled(true);
                this.jLabelPage.setEnabled(true);
                this.jRTextExpressionAreaReference.setText("");
                this.jRTextExpressionAreaReference.setEnabled(false);
                this.jLabelReference.setEnabled(false);
            }
        }
        
        else if (((String)this.jComboBoxLinkType.getSelectedItem()).equals("RemoteAnchor")) {
            // Set to blank all link fields...
            while (e.hasMoreElements()) {
                HyperLinkableReportElement element = (HyperLinkableReportElement)e.nextElement();
                element.setHyperlinkType( ""+jComboBoxLinkType.getSelectedItem());
                element.setHyperlinkReferenceExpression("");
                element.setHyperlinkAnchorExpression("");
                element.setHyperlinkPageExpression("");
                this.jRTextExpressionAreaAnchor.setText("");
                this.jRTextExpressionAreaAnchor.setEnabled(true);
                this.jLabelAnchor.setEnabled(true);
                this.jRTextExpressionAreaPage.setText("");
                this.jRTextExpressionAreaPage.setEnabled(false);
                this.jLabelPage.setEnabled(false);
                this.jRTextExpressionAreaReference.setText("");
                this.jRTextExpressionAreaReference.setEnabled(true);
                this.jLabelReference.setEnabled(true);
            }
        }
        else if (((String)this.jComboBoxLinkType.getSelectedItem()).equals("RemotePage")) {
            // Set to blank all link fields...
            while (e.hasMoreElements()) {
                HyperLinkableReportElement element = (HyperLinkableReportElement)e.nextElement();
                element.setHyperlinkType( ""+jComboBoxLinkType.getSelectedItem());
                element.setHyperlinkReferenceExpression("");
                element.setHyperlinkAnchorExpression("");
                element.setHyperlinkPageExpression("");
                this.jRTextExpressionAreaAnchor.setText("");
                this.jRTextExpressionAreaAnchor.setEnabled(false);
                this.jLabelAnchor.setEnabled(false);
                this.jRTextExpressionAreaPage.setText("");
                this.jRTextExpressionAreaPage.setEnabled(true);
                this.jLabelPage.setEnabled(true);
                this.jRTextExpressionAreaReference.setText("");
                this.jRTextExpressionAreaReference.setEnabled(true);
                this.jLabelReference.setEnabled(true);
            }
        }
        
        jComboBoxLinkType.removeItem("");
    }//GEN-LAST:event_jComboBoxLinkTypeActionPerformed
    
    private void jButtonRemParameterActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_jButtonRemParameterActionPerformed
        if (this.isInit()) return;
        
        if (jrf == null || jrf.getSelectedElements().size()==0) return;
        
        Enumeration e = jrf.getSelectedElements().elements();
        SubReportElement element = (SubReportElement)e.nextElement();
        
        jTableSubreportParameters.getSelectedRows();
        int[]  rows= jTableSubreportParameters.getSelectedRows();
        for (int i=rows.length-1; i>=0; --i) {
            element.getSubreportParameters().removeElement( jTableSubreportParameters.getValueAt( rows[i], 0) );
            //this.jTableParameters.removeRowSelectionInterval( rows[i],rows[i]);
        }
        
        javax.swing.table.DefaultTableModel dtm = (javax.swing.table.DefaultTableModel)jTableSubreportParameters.getModel();
        dtm.setRowCount(0);
        
        java.util.Enumeration enum_parameters = element.getSubreportParameters().elements();
        while (enum_parameters.hasMoreElements()) {
            it.businesslogic.ireport.JRSubreportParameter parameter = (it.businesslogic.ireport.JRSubreportParameter)enum_parameters.nextElement();
            Vector row = new Vector();
            row.addElement(parameter);
            row.addElement(parameter.getExpression());
            dtm.addRow(row);
        }
    }//GEN-LAST:event_jButtonRemParameterActionPerformed
    
    private void jButtonModParameterActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_jButtonModParameterActionPerformed
        if (this.isInit()) return;
        
        if (jrf == null || jrf.getSelectedElements().size()==0) return;
        
        Enumeration e = jrf.getSelectedElements().elements();
        SubReportElement element = (SubReportElement)e.nextElement();
        
        JRSubreportParameter parameter = (JRSubreportParameter)jTableSubreportParameters.getValueAt( jTableSubreportParameters.getSelectedRow(), 0);
        
        JRSubreportParameterDialog jrpd = new JRSubreportParameterDialog(null, true);
        jrpd.setParameter( parameter );
        jrpd.show();
        
        if (jrpd.getDialogResult() == javax.swing.JOptionPane.OK_OPTION) {
            parameter.setName( jrpd.getParameter().getName() );
            parameter.setExpression( jrpd.getParameter().getExpression());
            javax.swing.table.DefaultTableModel dtm = (javax.swing.table.DefaultTableModel)jTableSubreportParameters.getModel();
            dtm.setRowCount(0);
            
            java.util.Enumeration enum_parameters = element.getSubreportParameters().elements();
            while (enum_parameters.hasMoreElements()) {
                it.businesslogic.ireport.JRSubreportParameter parameter2 = (it.businesslogic.ireport.JRSubreportParameter)enum_parameters.nextElement();
                Vector row = new Vector();
                row.addElement(parameter2);
                row.addElement(parameter2.getExpression());
                dtm.addRow(row);
            }
        }
    }//GEN-LAST:event_jButtonModParameterActionPerformed
    
    private void jButtonAddParameterActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_jButtonAddParameterActionPerformed
        
        if (this.isInit()) return;
        
        if (jrf == null || jrf.getSelectedElements().size()==0) return;
        // Set the new value for all selected elements...
        Enumeration e = jrf.getSelectedElements().elements();
        SubReportElement element = (SubReportElement)e.nextElement();
        
        JRSubreportParameterDialog jrpd = new JRSubreportParameterDialog(null, true);
        jrpd.show();
        
        if (jrpd.getDialogResult() == javax.swing.JOptionPane.OK_OPTION) {
            it.businesslogic.ireport.JRSubreportParameter parameter = jrpd.getParameter();
            element.getSubreportParameters().addElement( parameter );
            javax.swing.table.DefaultTableModel dtm = (javax.swing.table.DefaultTableModel)jTableSubreportParameters.getModel();
            dtm.addRow(new Object[]{parameter, parameter.getExpression()});
        }
    }//GEN-LAST:event_jButtonAddParameterActionPerformed
    
    private void jComboBoxSubreportExpressionClassActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_jComboBoxSubreportExpressionClassActionPerformed
        if (this.isInit()) return;
        
        // Set band to all....
        if (jrf == null || jrf.getSelectedElements().size()==0 || jComboBoxSubreportExpressionClass.getSelectedItem() == null || (jComboBoxSubreportExpressionClass.getSelectedItem()+"").equals("")) return;
        // Set the new value for all selected elements...
        Enumeration e = jrf.getSelectedElements().elements();
        while (e.hasMoreElements()) {
            SubReportElement element = (SubReportElement)e.nextElement();
            element.setSubreportExpressionClass(""+ jComboBoxSubreportExpressionClass.getSelectedItem());
        }
        
        this.jComboBoxSubreportExpressionClass.removeItem("");
    }//GEN-LAST:event_jComboBoxSubreportExpressionClassActionPerformed
    
    private void jCheckBoxSubreportCacheActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_jCheckBoxSubreportCacheActionPerformed
        if (this.isInit()) return;
        
        // Set band to all....
        if (jrf == null || jrf.getSelectedElements().size()==0) return;
        // Set the new value for all selected elements...
        Enumeration e = jrf.getSelectedElements().elements();
        while (e.hasMoreElements()) {
            SubReportElement element = (SubReportElement)e.nextElement();
            element.setIsUsingCache(jCheckBoxSubreportCache.isSelected());
        }
    }//GEN-LAST:event_jCheckBoxSubreportCacheActionPerformed
    
    private void jComboBoxSubreportConnectionTypeActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_jComboBoxSubreportConnectionTypeActionPerformed
        if (this.isInit()) return;
        
        if (jrf == null || jrf.getSelectedElements().size()==0) return;
        // Set the new value for all selected elements...
        Enumeration e = jrf.getSelectedElements().elements();
        SubReportElement element = (SubReportElement)e.nextElement();
        
        if (jComboBoxSubreportConnectionType.getSelectedIndex() == 0) {
            element.setUseConnection(false);
            element.setConnectionExpression("");
            element.setDataSourceExpression("");
            jRTextExpressionAreaTextConnectionExpression.setText("");
            jRTextExpressionAreaTextConnectionExpression.setEnabled(false);
            jRTextExpressionAreaTextConnectionExpression.setBackground(Color.LIGHT_GRAY);
        }
        else if (jComboBoxSubreportConnectionType.getSelectedIndex() == 1) {
            element.setUseConnection(true);
            element.setDataSourceExpression("");
            element.setConnectionExpression("$P{REPORT_CONNECTION}");
            jRTextExpressionAreaTextConnectionExpression.setText("$P{REPORT_CONNECTION}");
            jRTextExpressionAreaTextConnectionExpression.setEnabled(true);
            jRTextExpressionAreaTextConnectionExpression.setBackground(Color.WHITE);
        }
        else if (jComboBoxSubreportConnectionType.getSelectedIndex() == 2) {
            element.setUseConnection(false);
            element.setDataSourceExpression("$P{MyDataource}");
            element.setConnectionExpression("");
            jRTextExpressionAreaTextConnectionExpression.setText("$P{MyDataource}");
            jRTextExpressionAreaTextConnectionExpression.setEnabled(true);
            jRTextExpressionAreaTextConnectionExpression.setBackground(Color.WHITE);
        }
        
    }//GEN-LAST:event_jComboBoxSubreportConnectionTypeActionPerformed
    
    private void jComboBoxPatternInputMethodTextChanged(java.awt.event.InputMethodEvent evt) {//GEN-FIRST:event_jComboBoxPatternInputMethodTextChanged
        
        
        
    }//GEN-LAST:event_jComboBoxPatternInputMethodTextChanged
    
    private void jComboBoxPatternActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_jComboBoxPatternActionPerformed
        if (this.isInit()) return;
        
        // Set band to all....
        if (jrf == null || jrf.getSelectedElements().size()==0 || jComboBoxPdfEncoding.getSelectedItem() == null || (jComboBoxPdfEncoding.getSelectedItem()+"").equals("")) return;
        // Set the new value for all selected elements...
        Enumeration e = jrf.getSelectedElements().elements();
        
        Object pattern = jComboBoxPattern.getSelectedItem();
        
        if (pattern instanceof PdfEncoding)
        {
            pattern = ""+ ((PdfEncoding)pattern).getEncoding();
            jComboBoxPattern.setSelectedItem(pattern);
        }
        else
            pattern = ""+ pattern+"";
        while (e.hasMoreElements()) {
            TextFieldReportElement element = (TextFieldReportElement)e.nextElement();
            element.setPattern(""+ pattern+"");
        }

    }//GEN-LAST:event_jComboBoxPatternActionPerformed
    
    private void jCheckBoxBlankWhenNullActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_jCheckBoxBlankWhenNullActionPerformed
        if (this.isInit()) return;
        
        // Set band to all....
        if (jrf == null || jrf.getSelectedElements().size()==0) return;
        // Set the new value for all selected elements...
        Enumeration e = jrf.getSelectedElements().elements();
        while (e.hasMoreElements()) {
            TextFieldReportElement element = (TextFieldReportElement)e.nextElement();
            element.setBlankWhenNull(jCheckBoxBlankWhenNull.isSelected());
        }
    }//GEN-LAST:event_jCheckBoxBlankWhenNullActionPerformed
    
    private void jCheckBoxStretchWithOverflowActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_jCheckBoxStretchWithOverflowActionPerformed
        if (this.isInit()) return;
        
        // Set band to all....
        if (jrf == null || jrf.getSelectedElements().size()==0) return;
        // Set the new value for all selected elements...
        Enumeration e = jrf.getSelectedElements().elements();
        while (e.hasMoreElements()) {
            TextFieldReportElement element = (TextFieldReportElement)e.nextElement();
            element.setStretchWithOverflow(jCheckBoxStretchWithOverflow.isSelected());
        }
    }//GEN-LAST:event_jCheckBoxStretchWithOverflowActionPerformed
    
    private void jComboBoxTextFieldGroupActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_jComboBoxTextFieldGroupActionPerformed
        if (this.isInit()) return;
        
        // Set band to all....
        if (jrf == null || jrf.getSelectedElements().size()==0 || jComboBoxTextFieldGroup.getSelectedItem() == null || (jComboBoxTextFieldGroup.getSelectedItem()+"").equals("")) return;
        // Set the new value for all selected elements...
        Enumeration e = jrf.getSelectedElements().elements();
        while (e.hasMoreElements()) {
            TextFieldReportElement element = (TextFieldReportElement)e.nextElement();
            element.setGroup(""+ jComboBoxTextFieldGroup.getSelectedItem());
        }
        
        this.jComboBoxTextFieldGroup.removeItem("");
    }//GEN-LAST:event_jComboBoxTextFieldGroupActionPerformed
    
    private void jComboBoxTextFieldEvaluationTimeActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_jComboBoxTextFieldEvaluationTimeActionPerformed
        if (this.isInit()) return;
        
        // Set band to all....
        if (jrf == null || jrf.getSelectedElements().size()==0 || jComboBoxTextFieldEvaluationTime.getSelectedItem() == null || (jComboBoxTextFieldEvaluationTime.getSelectedItem()+"").equals("")) return;
        // Set the new value for all selected elements...
        Enumeration e = jrf.getSelectedElements().elements();
        while (e.hasMoreElements()) {
            TextFieldReportElement element = (TextFieldReportElement)e.nextElement();
            element.setEvaluationTime(""+ jComboBoxTextFieldEvaluationTime.getSelectedItem());
        }
        
        this.jComboBoxTextFieldEvaluationTime.removeItem("");
    }//GEN-LAST:event_jComboBoxTextFieldEvaluationTimeActionPerformed
    
    private void jComboBoxTextFieldExpressionClassActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_jComboBoxTextFieldExpressionClassActionPerformed
        if (this.isInit()) return;
        
        // Set band to all....
        if (jrf == null || jrf.getSelectedElements().size()==0 || jComboBoxTextFieldExpressionClass.getSelectedItem() == null || (jComboBoxTextFieldExpressionClass.getSelectedItem()+"").equals("")) return;
        // Set the new value for all selected elements...
        Enumeration e = jrf.getSelectedElements().elements();
        while (e.hasMoreElements()) {
            TextFieldReportElement element = (TextFieldReportElement)e.nextElement();
            element.setClassExpression(""+ jComboBoxTextFieldExpressionClass.getSelectedItem());
        }
        
        this.jComboBoxTextFieldExpressionClass.removeItem("");
    }//GEN-LAST:event_jComboBoxTextFieldExpressionClassActionPerformed
    
    private void jCheckBoxPDFEmbeddedActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_jCheckBoxPDFEmbeddedActionPerformed
        if (this.isInit()) return;
        
        // Set band to all....
        if (jrf == null || jrf.getSelectedElements().size()==0) return;
        // Set the new value for all selected elements...
        Enumeration e = jrf.getSelectedElements().elements();
        while (e.hasMoreElements()) {
            TextReportElement element = (TextReportElement)e.nextElement();
            element.setPdfEmbedded(jCheckBoxPDFEmbedded.isSelected());
        }
    }//GEN-LAST:event_jCheckBoxPDFEmbeddedActionPerformed
    
    private void jComboBoxPdfEncodingActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_jComboBoxPdfEncodingActionPerformed
        if (this.isInit()) return;
        
        // Set band to all....
        if (jrf == null || jrf.getSelectedElements().size()==0 || jComboBoxPdfEncoding.getSelectedItem() == null || (jComboBoxPdfEncoding.getSelectedItem()+"").equals("")) return;
        // Set the new value for all selected elements...
        Enumeration e = jrf.getSelectedElements().elements();
        while (e.hasMoreElements()) {
            TextReportElement element = (TextReportElement)e.nextElement();
            Object encoding = jComboBoxPdfEncoding.getSelectedItem();
            if (encoding instanceof PdfEncoding)
                element.setPdfEncoding(""+ ((PdfEncoding)encoding).getEncoding() );
            else
                element.setPdfEncoding(""+ encoding+"");
        }
    }//GEN-LAST:event_jComboBoxPdfEncodingActionPerformed
    
    private void jComboBoxVAlignActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_jComboBoxVAlignActionPerformed
        if (this.isInit()) return;
        
        // Set band to all....
        if (jrf == null || jrf.getSelectedElements().size()==0 || jComboBoxVAlign.getSelectedItem() == null || (jComboBoxVAlign.getSelectedItem()+"").equals("")) return;
        // Set the new value for all selected elements...
        Enumeration e = jrf.getSelectedElements().elements();
        while (e.hasMoreElements()) {
            TextReportElement element = (TextReportElement)e.nextElement();
            element.setVerticalAlign(""+ jComboBoxVAlign.getSelectedItem());
        }
        
        this.jComboBoxVAlign.removeItem("");
        jrf.getJPanelReport().repaint();
    }//GEN-LAST:event_jComboBoxVAlignActionPerformed
    
    private void jComboBoxHAlignActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_jComboBoxHAlignActionPerformed
        if (this.isInit()) return;
        
        // Set band to all....
        if (jrf == null || jrf.getSelectedElements().size()==0 || jComboBoxHAlign.getSelectedItem() == null || (jComboBoxHAlign.getSelectedItem()+"").equals("")) return;
        // Set the new value for all selected elements...
        Enumeration e = jrf.getSelectedElements().elements();
        while (e.hasMoreElements()) {
            TextReportElement element = (TextReportElement)e.nextElement();
            element.setAlign(""+ jComboBoxHAlign.getSelectedItem());
        }
        
        this.jComboBoxHAlign.removeItem("");
        jrf.getJPanelReport().repaint();
    }//GEN-LAST:event_jComboBoxHAlignActionPerformed
    
    private void jComboBoxLineSpacingActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_jComboBoxLineSpacingActionPerformed
        if (this.isInit()) return;
        
        // Set band to all....
        if (jrf == null || jrf.getSelectedElements().size()==0 || jComboBoxLineSpacing.getSelectedItem() == null || (jComboBoxLineSpacing.getSelectedItem()+"").equals("")) return;
        // Set the new value for all selected elements...
        Enumeration e = jrf.getSelectedElements().elements();
        while (e.hasMoreElements()) {
            TextReportElement element = (TextReportElement)e.nextElement();
            element.setLineSpacing(""+ jComboBoxLineSpacing.getSelectedItem());
        }
        
        this.jComboBoxLineSpacing.removeItem("");
        jrf.getJPanelReport().repaint();
    }//GEN-LAST:event_jComboBoxLineSpacingActionPerformed
    
    private void jCheckBoxStrokeTroughActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_jCheckBoxStrokeTroughActionPerformed
        if (this.isInit()) return;
        
        // Set band to all....
        if (jrf == null || jrf.getSelectedElements().size()==0) return;
        // Set the new value for all selected elements...
        Enumeration e = jrf.getSelectedElements().elements();
        while (e.hasMoreElements()) {
            TextReportElement element = (TextReportElement)e.nextElement();
            element.setStrikeTrought(jCheckBoxStrokeTrough.isSelected());
            element.setFont(null);
            /* Adjust PDF font...*/
        }
        jrf.getJPanelReport().repaint();
    }//GEN-LAST:event_jCheckBoxStrokeTroughActionPerformed
    
    private void jCheckBoxUnderlineActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_jCheckBoxUnderlineActionPerformed
        if (this.isInit()) return;
        
        // Set band to all....
        if (jrf == null || jrf.getSelectedElements().size()==0) return;
        // Set the new value for all selected elements...
        Enumeration e = jrf.getSelectedElements().elements();
        while (e.hasMoreElements()) {
            TextReportElement element = (TextReportElement)e.nextElement();
            element.setUnderline(jCheckBoxUnderline.isSelected());
            element.setFont(null);
            /* Adjust PDF font...*/
        }
        jrf.getJPanelReport().repaint();
    }//GEN-LAST:event_jCheckBoxUnderlineActionPerformed
    
    private void jCheckBoxItalicActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_jCheckBoxItalicActionPerformed
        if (this.isInit()) return;
        
        // Set band to all....
        if (jrf == null || jrf.getSelectedElements().size()==0) return;
        // Set the new value for all selected elements...
        Enumeration e = jrf.getSelectedElements().elements();
        while (e.hasMoreElements()) {
            TextReportElement element = (TextReportElement)e.nextElement();
            element.setItalic(jCheckBoxItalic.isSelected());
            element.setFont(null);
            /* Adjust PDF font...*/
        }
        jrf.getJPanelReport().repaint();
    }//GEN-LAST:event_jCheckBoxItalicActionPerformed
    
    private void jCheckBoxBoldActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_jCheckBoxBoldActionPerformed
        if (this.isInit()) return;
        
        // Set band to all....
        if (jrf == null || jrf.getSelectedElements().size()==0) return;
        // Set the new value for all selected elements...
        Enumeration e = jrf.getSelectedElements().elements();
        while (e.hasMoreElements()) {
            TextReportElement element = (TextReportElement)e.nextElement();
            element.setBold(jCheckBoxBold.isSelected());
            element.setFont(null);
            /* Adjust PDF font...*/
        }
        jrf.getJPanelReport().repaint();
    }//GEN-LAST:event_jCheckBoxBoldActionPerformed
    
    private void jNumberComboBoxSizeItemStateChanged(java.awt.event.ItemEvent evt) {//GEN-FIRST:event_jNumberComboBoxSizeItemStateChanged
        jNumberComboBoxSizeActionPerformed(new java.awt.event.ActionEvent(jNumberComboBoxSize,0,""));
    }//GEN-LAST:event_jNumberComboBoxSizeItemStateChanged
    
    private void jComboBoxTTFFontActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_jComboBoxTTFFontActionPerformed
        
        if (this.isInit()) return;
        
        // Set band to all....
        if (jrf == null || jrf.getSelectedElements().size()==0 || jComboBoxTTFFont.getSelectedItem() == null || (jComboBoxTTFFont.getSelectedItem()+"").equals("")) return;
        // Set the new value for all selected elements...
        Enumeration e = jrf.getSelectedElements().elements();
        while (e.hasMoreElements()) {
            TextReportElement element = (TextReportElement)e.nextElement();
            Object font = jComboBoxTTFFont.getSelectedItem();
            if (font instanceof IRFont) {
                element.setPDFFontName(((IRFont)font).getFile().getName());
            }
        }
        
        this.jComboBoxTTFFont.removeItem("");
    }//GEN-LAST:event_jComboBoxTTFFontActionPerformed
    
    private void jTextAreaTextInputMethodTextChanged(java.awt.event.InputMethodEvent evt) {//GEN-FIRST:event_jTextAreaTextInputMethodTextChanged
        
    }//GEN-LAST:event_jTextAreaTextInputMethodTextChanged
    
    private void jComboBoxFontNameActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_jComboBoxFontNameActionPerformed
        if (this.isInit()) return;
        
        // Set band to all....
        if (jrf == null || jrf.getSelectedElements().size()==0 || jComboBoxFontName.getSelectedItem() == null || (jComboBoxFontName.getSelectedItem()+"").equals("")) return;
        // Set the new value for all selected elements...
        Enumeration e = jrf.getSelectedElements().elements();
        while (e.hasMoreElements()) {
            TextReportElement element = (TextReportElement)e.nextElement();
            element.setFontName(""+ jComboBoxFontName.getSelectedItem());
        }
        
        this.jComboBoxFontName.removeItem("");
        jrf.getJPanelReport().repaint();
    }//GEN-LAST:event_jComboBoxFontNameActionPerformed
    
    private void jNumberComboBoxSizeActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_jNumberComboBoxSizeActionPerformed
        if (this.isInit()) return;
        
        // Set band to all....
        if (jrf == null || jrf.getSelectedElements().size()==0 || jNumberComboBoxSize.getValue() ==0) return;
        // Set the new value for all selected elements...
        Enumeration e = jrf.getSelectedElements().elements();
        while (e.hasMoreElements()) {
            TextReportElement element = (TextReportElement)e.nextElement();
            element.setFontSize((int)jNumberComboBoxSize.getValue());
        }
        
        jrf.getJPanelReport().repaint();
    }//GEN-LAST:event_jNumberComboBoxSizeActionPerformed
    
    private void jComboBoxPDFFontNameActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_jComboBoxPDFFontNameActionPerformed
        if (this.isInit()) return;
        
        // Set band to all....
        if (jrf == null || jrf.getSelectedElements().size()==0 || jComboBoxPDFFontName.getSelectedItem() == null || (jComboBoxPDFFontName.getSelectedItem()+"").equals("")) return;
        // Set the new value for all selected elements...
        String fontName = ""+ jComboBoxPDFFontName.getSelectedItem();
        //System.out.println(fontName);
        if (fontName != null && fontName.equals("External TTF font...")) {
            this.jComboBoxTTFFont.setEnabled(true);
            this.jLabelTTF.setEnabled(true);
            jComboBoxTTFFontActionPerformed(evt);
        }
        else {
            this.jComboBoxTTFFont.setEnabled(false);
            this.jLabelTTF.setEnabled(false);
            Enumeration e = jrf.getSelectedElements().elements();
            while (e.hasMoreElements()) {
                TextReportElement element = (TextReportElement)e.nextElement();
                element.setPDFFontName(fontName);
            }
        }
        
        this.jComboBoxPDFFontName.removeItem("");
        this.jComboBoxTTFFont.removeItem("");
        //jrf.getJPanelReport().repaint();
    }//GEN-LAST:event_jComboBoxPDFFontNameActionPerformed
    
    private void jButtonFindImageActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_jButtonFindImageActionPerformed
        String fileName = "";
        javax.swing.JFileChooser jfc = new javax.swing.JFileChooser( this.jrf.getMainFrame().getCurrentDirectory()  );
        jfc.setDialogTitle("Load XML jasperreports file....");
        jfc.setFileFilter( new javax.swing.filechooser.FileFilter() {
            public boolean accept(java.io.File file) {
                String filename = file.getName();
                return (filename.endsWith(".jpg") ||
                filename.endsWith(".jpeg") ||
                filename.endsWith(".gif") ||
                file.isDirectory()) ;
            }
            public String getDescription() {
                return "Image *.gif|*.jpg";
            }
        });
        
        jfc.setMultiSelectionEnabled(false);
        jfc.setDialogType( javax.swing.JFileChooser.OPEN_DIALOG);
        if  (jfc.showOpenDialog( null) == javax.swing.JOptionPane.OK_OPTION) {
            this.jRTextExpressionAreaImageExpression.setText("\""+ Misc.string_replace("\\\\","\\",jfc.getSelectedFile().getPath() +"\""));
            this.jrf.getMainFrame().setCurrentDirectory(jfc.getSelectedFile(), true);
        }
    }//GEN-LAST:event_jButtonFindImageActionPerformed
    
    private void jCheckBoxImageCacheActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_jCheckBoxImageCacheActionPerformed
        if (jrf == null || jrf.getSelectedElements().size()==0) return;
        // Set the new value for all selected elements...
        Enumeration e = jrf.getSelectedElements().elements();
        while (e.hasMoreElements()) {
            ImageReportElement element = (ImageReportElement)e.nextElement();
            element.setIsUsingCache( jCheckBoxImageCache.isSelected() );
        }
    }//GEN-LAST:event_jCheckBoxImageCacheActionPerformed
    
    private void jComboBoxImageGroupActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_jComboBoxImageGroupActionPerformed
        if (this.isInit()) return;
        
        // Set band to all....
        if (jrf == null || jrf.getSelectedElements().size()==0 || jComboBoxImageGroup.getSelectedItem() == null || (jComboBoxImageGroup.getSelectedItem()+"").equals("")) return;
        // Set the new value for all selected elements...
        Enumeration e = jrf.getSelectedElements().elements();
        while (e.hasMoreElements()) {
            ImageReportElement element = (ImageReportElement)e.nextElement();
            element.setEvaluationGroup(""+ jComboBoxImageGroup.getSelectedItem());
        }
        
        this.jComboBoxImageGroup.removeItem("");
    }//GEN-LAST:event_jComboBoxImageGroupActionPerformed
    
    private void jComboBoxEvaluationTimeActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_jComboBoxEvaluationTimeActionPerformed
        if (this.isInit()) return;
        
        // Set band to all....
        if (jrf == null || jrf.getSelectedElements().size()==0 || jComboBoxEvaluationTime.getSelectedItem() == null || (jComboBoxEvaluationTime.getSelectedItem()+"").equals("")) return;
        // Set the new value for all selected elements...
        Enumeration e = jrf.getSelectedElements().elements();
        while (e.hasMoreElements()) {
            ImageReportElement element = (ImageReportElement)e.nextElement();
            element.setEvaluationTime(""+ jComboBoxEvaluationTime.getSelectedItem());
        }
        
        this.jComboBoxEvaluationTime.removeItem("");
    }//GEN-LAST:event_jComboBoxEvaluationTimeActionPerformed
    
    private void jComboBoxImageExpressionClassActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_jComboBoxImageExpressionClassActionPerformed
        if (this.isInit()) return;
        
        // Set band to all....
        if (jrf == null || jrf.getSelectedElements().size()==0 || jComboBoxImageExpressionClass.getSelectedItem() == null || (jComboBoxImageExpressionClass.getSelectedItem()+"").equals("")) return;
        // Set the new value for all selected elements...
        Enumeration e = jrf.getSelectedElements().elements();
        while (e.hasMoreElements()) {
            ImageReportElement element = (ImageReportElement)e.nextElement();
            element.setImageClass(""+ jComboBoxImageExpressionClass.getSelectedItem());
        }
        
        this.jComboBoxImageExpressionClass.removeItem("");
    }//GEN-LAST:event_jComboBoxImageExpressionClassActionPerformed
    
    private void jComboBoxHorizontalAlignmentActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_jComboBoxHorizontalAlignmentActionPerformed
        if (this.isInit()) return;
        
        // Set band to all....
        if (jrf == null || jrf.getSelectedElements().size()==0 || jComboBoxHorizontalAlignment.getSelectedItem() == null || (jComboBoxHorizontalAlignment.getSelectedItem()+"").equals("")) return;
        // Set the new value for all selected elements...
        Enumeration e = jrf.getSelectedElements().elements();
        while (e.hasMoreElements()) {
            ImageReportElement element = (ImageReportElement)e.nextElement();
            element.setHorizontalAlignment(""+ jComboBoxHorizontalAlignment.getSelectedItem());
        }
        
        this.jComboBoxHorizontalAlignment.removeItem("");
        jrf.getJPanelReport().repaint();
    }//GEN-LAST:event_jComboBoxHorizontalAlignmentActionPerformed
    
    private void jComboBoxVerticalAlignmentActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_jComboBoxVerticalAlignmentActionPerformed
        if (this.isInit()) return;
        
        // Set band to all....
        if (jrf == null || jrf.getSelectedElements().size()==0 || jComboBoxVerticalAlignment.getSelectedItem() == null || (jComboBoxVerticalAlignment.getSelectedItem()+"").equals("")) return;
        // Set the new value for all selected elements...
        Enumeration e = jrf.getSelectedElements().elements();
        while (e.hasMoreElements()) {
            ImageReportElement element = (ImageReportElement)e.nextElement();
            element.setVerticalAlignment(""+ jComboBoxVerticalAlignment.getSelectedItem());
        }
        
        this.jComboBoxVerticalAlignment.removeItem("");
        jrf.getJPanelReport().repaint();
    }//GEN-LAST:event_jComboBoxVerticalAlignmentActionPerformed
    
    private void jComboBoxScaleActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_jComboBoxScaleActionPerformed
        if (this.isInit()) return;
        
        // Set band to all....
        if (jrf == null || jrf.getSelectedElements().size()==0 || jComboBoxScale.getSelectedItem() == null || (jComboBoxScale.getSelectedItem()+"").equals("")) return;
        // Set the new value for all selected elements...
        Enumeration e = jrf.getSelectedElements().elements();
        while (e.hasMoreElements()) {
            ImageReportElement element = (ImageReportElement)e.nextElement();
            element.setScaleImage(""+ jComboBoxScale.getSelectedItem());
        }
        
        this.jComboBoxScale.removeItem("");
        jrf.getJPanelReport().repaint();
    }//GEN-LAST:event_jComboBoxScaleActionPerformed
    
    private void jComboBoxLineDirectionActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_jComboBoxLineDirectionActionPerformed
        if (this.isInit()) return;
        
        // Set band to all....
        if (jrf == null || jrf.getSelectedElements().size()==0 || jComboBoxLineDirection.getSelectedItem() == null || (jComboBoxLineDirection.getSelectedItem()+"").equals("")) return;
        // Set the new value for all selected elements...
        Enumeration e = jrf.getSelectedElements().elements();
        while (e.hasMoreElements()) {
            LineReportElement element = (LineReportElement)e.nextElement();
            element.direction = ""+ jComboBoxLineDirection.getSelectedItem();
        }
        
        this.jComboBoxLineDirection.removeItem("");
        jrf.getJPanelReport().repaint();
    }//GEN-LAST:event_jComboBoxLineDirectionActionPerformed
    
    private void jNumberFieldRadiusActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_jNumberFieldRadiusActionPerformed
        if (jrf == null || jrf.getSelectedElements().size()==0) return;
        // Set the new value for all selected elements...
        Enumeration e = jrf.getSelectedElements().elements();
        while (e.hasMoreElements()) {
            RectangleReportElement element = (RectangleReportElement)e.nextElement();
            element.radius = (int)jNumberFieldRadius.getValue();
        }
        jrf.getJPanelReport().repaint();
    }//GEN-LAST:event_jNumberFieldRadiusActionPerformed
    
    private void jTabbedPaneStateChanged(javax.swing.event.ChangeEvent evt) {//GEN-FIRST:event_jTabbedPaneStateChanged
        if (this.isInit()) return;
        if (jTabbedPane.getSelectedComponent() != null) {
            lastSelectedPanel = (javax.swing.JPanel)jTabbedPane.getSelectedComponent();
            lastSelectedPaneName = jTabbedPane.getTitleAt(jTabbedPane.getSelectedIndex());
            
        }
    }//GEN-LAST:event_jTabbedPaneStateChanged
    
    private void jComboBoxFillActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_jComboBoxFillActionPerformed
        if (this.isInit()) return;
        
        // Set band to all....
        if (jrf == null || jrf.getSelectedElements().size()==0 || jComboBoxFill.getSelectedItem() == null || (jComboBoxFill.getSelectedItem()+"").equals("")) return;
        // Set the new value for all selected elements...
        Enumeration e = jrf.getSelectedElements().elements();
        while (e.hasMoreElements()) {
            GraphicReportElement element = (GraphicReportElement)e.nextElement();
            element.setFill(""+ jComboBoxFill.getSelectedItem());
        }
        
        this.jComboBoxFill.removeItem("");
    }//GEN-LAST:event_jComboBoxFillActionPerformed
    
    private void jComboBoxStretchTypeActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_jComboBoxStretchTypeActionPerformed
        if (this.isInit()) return;
        
        // Set band to all....
        if (jrf == null || jrf.getSelectedElements().size()==0 || jComboBoxStretchType.getSelectedItem() == null || (jComboBoxStretchType.getSelectedItem()+"").equals("")) return;
        // Set the new value for all selected elements...
        Enumeration e = jrf.getSelectedElements().elements();
        while (e.hasMoreElements()) {
            ReportElement element = (ReportElement)e.nextElement();
            element.setStretchType(""+ jComboBoxStretchType.getSelectedItem());
        }
        
        this.jComboBoxStretchType.removeItem("");
    }//GEN-LAST:event_jComboBoxStretchTypeActionPerformed
    
    private void jComboBoxPenActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_jComboBoxPenActionPerformed
        if (this.isInit()) return;
        
        // Set band to all....
        if (jrf == null || jrf.getSelectedElements().size()==0 || jComboBoxPen.getSelectedItem() == null || (jComboBoxPen.getSelectedItem()+"").equals("")) return;
        // Set the new value for all selected elements...
        Enumeration e = jrf.getSelectedElements().elements();
        while (e.hasMoreElements()) {
            GraphicReportElement element = (GraphicReportElement)e.nextElement();
            element.setGraphicElementPen(""+ jComboBoxPen.getSelectedItem());
        }
        
        this.jComboBoxPen.removeItem("");
        jrf.getJPanelReport().repaint();
        
    }//GEN-LAST:event_jComboBoxPenActionPerformed
    
    private void jComboBoxGroupsActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_jComboBoxGroupsActionPerformed
        if (this.isInit()) return;
        
        // Set band to all....
        if (jrf == null || jrf.getSelectedElements().size()==0) return;
        // Set the new value for all selected elements...
        Enumeration e = jrf.getSelectedElements().elements();
        while (e.hasMoreElements()) {
            ReportElement element = (ReportElement)e.nextElement();
            element.printWhenGroupChanges = ""+ jComboBoxGroups.getSelectedItem();
        }
    }//GEN-LAST:event_jComboBoxGroupsActionPerformed
    
    private void jRTextExpressionAreaPrintWhenExpressionInputMethodTextChanged(java.awt.event.InputMethodEvent evt) {//GEN-FIRST:event_jRTextExpressionAreaPrintWhenExpressionInputMethodTextChanged
        
    }//GEN-LAST:event_jRTextExpressionAreaPrintWhenExpressionInputMethodTextChanged
    
    private void jComboBoxPositionTypeActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_jComboBoxPositionTypeActionPerformed
        if (this.isInit()) return;
        
        // Set band to all....
        if (jrf == null || jrf.getSelectedElements().size()==0 || jComboBoxPositionType.getSelectedItem() == null || (jComboBoxPositionType.getSelectedItem()+"").equals("")) return;
        // Set the new value for all selected elements...
        Enumeration e = jrf.getSelectedElements().elements();
        while (e.hasMoreElements()) {
            ReportElement element = (ReportElement)e.nextElement();
            element.positionType = ""+ jComboBoxPositionType.getSelectedItem();
        }
        
        this.jComboBoxPositionType.removeItem("");
    }//GEN-LAST:event_jComboBoxPositionTypeActionPerformed
    
    private void jCheckBoxPrintRepeatedValuesActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_jCheckBoxPrintRepeatedValuesActionPerformed
        if (jrf == null || jrf.getSelectedElements().size()==0) return;
        // Set the new value for all selected elements...
        Enumeration e = jrf.getSelectedElements().elements();
        while (e.hasMoreElements()) {
            ReportElement element = (ReportElement)e.nextElement();
            element.isPrintRepeatedValues = jCheckBoxPrintRepeatedValues.isSelected();
        }
    }//GEN-LAST:event_jCheckBoxPrintRepeatedValuesActionPerformed
    
    private void jCheckBoxPrintWhenDetailOverflowsActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_jCheckBoxPrintWhenDetailOverflowsActionPerformed
        if (jrf == null || jrf.getSelectedElements().size()==0) return;
        // Set the new value for all selected elements...
        Enumeration e = jrf.getSelectedElements().elements();
        while (e.hasMoreElements()) {
            ReportElement element = (ReportElement)e.nextElement();
            element.isPrintWhenDetailOverflows = jCheckBoxPrintWhenDetailOverflows.isSelected();
        }
    }//GEN-LAST:event_jCheckBoxPrintWhenDetailOverflowsActionPerformed
    
    private void jCheckBoxPrintInFirstWholeBandActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_jCheckBoxPrintInFirstWholeBandActionPerformed
        if (jrf == null || jrf.getSelectedElements().size()==0) return;
        // Set the new value for all selected elements...
        Enumeration e = jrf.getSelectedElements().elements();
        while (e.hasMoreElements()) {
            ReportElement element = (ReportElement)e.nextElement();
            element.isPrintInFirstWholeBand = jCheckBoxPrintInFirstWholeBand.isSelected();
        }
        
    }//GEN-LAST:event_jCheckBoxPrintInFirstWholeBandActionPerformed
    
    private void jCheckBoxRemoveLineWhenBlankActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_jCheckBoxRemoveLineWhenBlankActionPerformed
        if (jrf == null || jrf.getSelectedElements().size()==0) return;
        // Set the new value for all selected elements...
        Enumeration e = jrf.getSelectedElements().elements();
        while (e.hasMoreElements()) {
            ReportElement element = (ReportElement)e.nextElement();
            element.isRemoveLineWhenBlank = jCheckBoxRemoveLineWhenBlank.isSelected();
        }
        
        //jrf.getJPanelReport().repaint();
    }//GEN-LAST:event_jCheckBoxRemoveLineWhenBlankActionPerformed
    
    private void jCheckBoxTransparentActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_jCheckBoxTransparentActionPerformed
        if (jrf == null || jrf.getSelectedElements().size()==0) return;
        // Set the new value for all selected elements...
        Enumeration e = jrf.getSelectedElements().elements();
        while (e.hasMoreElements()) {
            ReportElement element = (ReportElement)e.nextElement();
            element.setTransparent(( (jCheckBoxTransparent.isSelected()) ? "Transparent" : "Opaque") );
        }
        
        jrf.getJPanelReport().repaint();
    }//GEN-LAST:event_jCheckBoxTransparentActionPerformed
    
    /** Closes the dialog */
    private void closeDialog(java.awt.event.WindowEvent evt) {//GEN-FIRST:event_closeDialog
        setVisible(false);
    }//GEN-LAST:event_closeDialog
    
    /**
     * @param args the command line arguments
     */
    public static void main(String args[]) {
        new ElementPropertiesDialog(new javax.swing.JFrame(), true).show();
    }
    
    
    // Variables declaration - do not modify//GEN-BEGIN:variables
    private javax.swing.ButtonGroup buttonGroupCharts;
    private it.businesslogic.ireport.gui.JRTextExpressionArea jBarcodeExpressionArea;
    private javax.swing.JButton jButton1;
    private javax.swing.JButton jButtonAddParameter;
    private javax.swing.JButton jButtonBackground;
    private javax.swing.JButton jButtonCreatePattern;
    private javax.swing.JButton jButtonFindImage;
    private javax.swing.JButton jButtonForeground;
    private javax.swing.JButton jButtonModParameter;
    private javax.swing.JButton jButtonPrintWhenExpression;
    private javax.swing.JButton jButtonRemParameter;
    private javax.swing.JCheckBox jCheckBoxBarcodeCheckSum;
    private javax.swing.JCheckBox jCheckBoxBarcodeShowText;
    private javax.swing.JCheckBox jCheckBoxBlankWhenNull;
    private javax.swing.JCheckBox jCheckBoxBold;
    private javax.swing.JCheckBox jCheckBoxImageCache;
    private javax.swing.JCheckBox jCheckBoxItalic;
    private javax.swing.JCheckBox jCheckBoxPDFEmbedded;
    private javax.swing.JCheckBox jCheckBoxPrintInFirstWholeBand;
    private javax.swing.JCheckBox jCheckBoxPrintRepeatedValues;
    private javax.swing.JCheckBox jCheckBoxPrintWhenDetailOverflows;
    private javax.swing.JCheckBox jCheckBoxRemoveLineWhenBlank;
    private javax.swing.JCheckBox jCheckBoxStretchWithOverflow;
    private javax.swing.JCheckBox jCheckBoxStrokeTrough;
    private javax.swing.JCheckBox jCheckBoxStyledText;
    private javax.swing.JCheckBox jCheckBoxSubreportCache;
    private javax.swing.JCheckBox jCheckBoxTransparent;
    private javax.swing.JCheckBox jCheckBoxUnderline;
    private javax.swing.JComboBox jComboBoxBand;
    private javax.swing.JComboBox jComboBoxBarcodeGroup;
    private javax.swing.JComboBox jComboBoxBarcodeType;
    private javax.swing.JComboBox jComboBoxEvaluationTime;
    private javax.swing.JComboBox jComboBoxEvaluationTime1;
    private javax.swing.JComboBox jComboBoxEvaluationTimeBarcode;
    private javax.swing.JComboBox jComboBoxFill;
    private javax.swing.JComboBox jComboBoxFontName;
    private javax.swing.JComboBox jComboBoxGroups;
    private javax.swing.JComboBox jComboBoxHAlign;
    private javax.swing.JComboBox jComboBoxHorizontalAlignment;
    private javax.swing.JComboBox jComboBoxImageExpressionClass;
    private javax.swing.JComboBox jComboBoxImageGroup;
    private javax.swing.JComboBox jComboBoxImageGroup1;
    private javax.swing.JComboBox jComboBoxLineDirection;
    private javax.swing.JComboBox jComboBoxLineSpacing;
    private javax.swing.JComboBox jComboBoxLinkTarget;
    private javax.swing.JComboBox jComboBoxLinkType;
    private javax.swing.JComboBox jComboBoxPDFFontName;
    private javax.swing.JComboBox jComboBoxPattern;
    private javax.swing.JComboBox jComboBoxPdfEncoding;
    private javax.swing.JComboBox jComboBoxPen;
    private javax.swing.JComboBox jComboBoxPositionType;
    private javax.swing.JComboBox jComboBoxReportFont;
    private javax.swing.JComboBox jComboBoxRotation;
    private javax.swing.JComboBox jComboBoxScale;
    private javax.swing.JComboBox jComboBoxStretchType;
    private javax.swing.JComboBox jComboBoxSubreportConnectionType;
    private javax.swing.JComboBox jComboBoxSubreportExpressionClass;
    private javax.swing.JComboBox jComboBoxTTFFont;
    private javax.swing.JComboBox jComboBoxTextFieldEvaluationTime;
    private javax.swing.JComboBox jComboBoxTextFieldExpressionClass;
    private javax.swing.JComboBox jComboBoxTextFieldGroup;
    private javax.swing.JComboBox jComboBoxVAlign;
    private javax.swing.JComboBox jComboBoxVerticalAlignment;
    private javax.swing.JLabel jLabel1;
    private javax.swing.JLabel jLabel10;
    private javax.swing.JLabel jLabel11;
    private javax.swing.JLabel jLabel12;
    private javax.swing.JLabel jLabel13;
    private javax.swing.JLabel jLabel14;
    private javax.swing.JLabel jLabel15;
    private javax.swing.JLabel jLabel16;
    private javax.swing.JLabel jLabel17;
    private javax.swing.JLabel jLabel18;
    private javax.swing.JLabel jLabel19;
    private javax.swing.JLabel jLabel2;
    private javax.swing.JLabel jLabel20;
    private javax.swing.JLabel jLabel21;
    private javax.swing.JLabel jLabel22;
    private javax.swing.JLabel jLabel23;
    private javax.swing.JLabel jLabel24;
    private javax.swing.JLabel jLabel25;
    private javax.swing.JLabel jLabel26;
    private javax.swing.JLabel jLabel27;
    private javax.swing.JLabel jLabel28;
    private javax.swing.JLabel jLabel29;
    private javax.swing.JLabel jLabel3;
    private javax.swing.JLabel jLabel30;
    private javax.swing.JLabel jLabel31;
    private javax.swing.JLabel jLabel32;
    private javax.swing.JLabel jLabel33;
    private javax.swing.JLabel jLabel34;
    private javax.swing.JLabel jLabel35;
    private javax.swing.JLabel jLabel36;
    private javax.swing.JLabel jLabel37;
    private javax.swing.JLabel jLabel38;
    private javax.swing.JLabel jLabel39;
    private javax.swing.JLabel jLabel4;
    private javax.swing.JLabel jLabel40;
    private javax.swing.JLabel jLabel41;
    private javax.swing.JLabel jLabel42;
    private javax.swing.JLabel jLabel43;
    private javax.swing.JLabel jLabel44;
    private javax.swing.JLabel jLabel45;
    private javax.swing.JLabel jLabel46;
    private javax.swing.JLabel jLabel47;
    private javax.swing.JLabel jLabel48;
    private javax.swing.JLabel jLabel49;
    private javax.swing.JLabel jLabel5;
    private javax.swing.JLabel jLabel50;
    private javax.swing.JLabel jLabel6;
    private javax.swing.JLabel jLabel7;
    private javax.swing.JLabel jLabel8;
    private javax.swing.JLabel jLabel9;
    private javax.swing.JLabel jLabelAnchor;
    private javax.swing.JLabel jLabelPage;
    private javax.swing.JLabel jLabelReference;
    private javax.swing.JLabel jLabelTTF;
    private javax.swing.JLabel jLabelTarget;
    private it.businesslogic.ireport.gui.JNumberComboBox jNumberComboBoxSize;
    private it.businesslogic.ireport.gui.JNumberField jNumberFieldHeight;
    private it.businesslogic.ireport.gui.JNumberField jNumberFieldLeft;
    private it.businesslogic.ireport.gui.JNumberField jNumberFieldRadius;
    private it.businesslogic.ireport.gui.JNumberField jNumberFieldTop;
    private it.businesslogic.ireport.gui.JNumberField jNumberFieldWidth;
    private javax.swing.JPanel jPanel1;
    private javax.swing.JPanel jPanel11;
    private javax.swing.JPanel jPanel12;
    private javax.swing.JPanel jPanel2;
    private javax.swing.JPanel jPanel3;
    private javax.swing.JPanel jPanel4;
    private javax.swing.JPanel jPanel5;
    private javax.swing.JPanel jPanel6;
    private javax.swing.JPanel jPanel7;
    private javax.swing.JPanel jPanel8;
    private javax.swing.JPanel jPanel9;
    private javax.swing.JPanel jPanelBarcode;
    private javax.swing.JPanel jPanelBorder;
    private javax.swing.JPanel jPanelChart;
    private javax.swing.JPanel jPanelCommon;
    private javax.swing.JPanel jPanelFont;
    private javax.swing.JPanel jPanelGraphicselement;
    private javax.swing.JPanel jPanelHyperLink;
    private javax.swing.JPanel jPanelImage;
    private javax.swing.JPanel jPanelLine;
    private javax.swing.JPanel jPanelRectangle;
    private javax.swing.JPanel jPanelSubreport1;
    private javax.swing.JPanel jPanelSubreport2;
    private javax.swing.JPanel jPanelText;
    private javax.swing.JPanel jPanelTextField;
    private it.businesslogic.ireport.gui.JRTextExpressionArea jRTextExpressionAreaAnchor;
    private it.businesslogic.ireport.gui.JRTextExpressionArea jRTextExpressionAreaAnchorName;
    private it.businesslogic.ireport.gui.JRTextExpressionArea jRTextExpressionAreaImageExpression;
    private it.businesslogic.ireport.gui.JRTextExpressionArea jRTextExpressionAreaPage;
    private it.businesslogic.ireport.gui.JRTextExpressionArea jRTextExpressionAreaPrintWhenExpression;
    private it.businesslogic.ireport.gui.JRTextExpressionArea jRTextExpressionAreaReference;
    private it.businesslogic.ireport.gui.JRTextExpressionArea jRTextExpressionAreaSubreportExpression;
    private it.businesslogic.ireport.gui.JRTextExpressionArea jRTextExpressionAreaSubreportMapExpression;
    private it.businesslogic.ireport.gui.JRTextExpressionArea jRTextExpressionAreaTextConnectionExpression;
    private it.businesslogic.ireport.gui.JRTextExpressionArea jRTextExpressionAreaTextFieldExpression;
    private javax.swing.JScrollPane jScrollPane1;
    private javax.swing.JScrollPane jScrollPane2;
    private javax.swing.JSeparator jSeparator1;
    private javax.swing.JSeparator jSeparator2;
    private javax.swing.JSeparator jSeparator3;
    private javax.swing.JSeparator jSeparator4;
    private javax.swing.JSeparator jSeparator5;
    private javax.swing.JSeparator jSeparator6;
    private javax.swing.JSeparator jSeparator7;
    private javax.swing.JSeparator jSeparator8;
    private javax.swing.JSeparator jSeparator9;
    private javax.swing.JTabbedPane jTabbedPane;
    private javax.swing.JTable jTableSubreportParameters;
    private javax.swing.JTextArea jTextAreaText;
    private javax.swing.JTextField jTextFieldName;
    // End of variables declaration//GEN-END:variables
    
    private boolean init;
    
    /**
     *  Set the report form to work with...
     */
    public void setJReportFrame(JReportFrame jrf) {
        this.jrf = jrf;
        if (jrf == null) {
            setVisible(false);
            this.jTabbedPane.removeAll();
            return;
        }
        
        this.setTitle(jrf.getReport().getName());
        updateBands();
        updateGroups();
        updateReportFonts();
        updateSelection();
        
        initExpressionArea(jRTextExpressionAreaSubreportExpression);
        initExpressionArea(jRTextExpressionAreaAnchor);
        initExpressionArea(jRTextExpressionAreaAnchorName);
        initExpressionArea(jRTextExpressionAreaImageExpression);
        initExpressionArea(jRTextExpressionAreaPage);
        initExpressionArea(jRTextExpressionAreaPrintWhenExpression);
        initExpressionArea(jRTextExpressionAreaReference);
        initExpressionArea(jRTextExpressionAreaSubreportExpression);
        initExpressionArea(jRTextExpressionAreaSubreportMapExpression);
        initExpressionArea(jRTextExpressionAreaTextConnectionExpression);
        initExpressionArea(jRTextExpressionAreaTextFieldExpression);
        initExpressionArea(jBarcodeExpressionArea);
    }
    
    /**
     *  This method responde to a virtual event like "element selection changed"
     */
    public void updateSelection() {
        if (!this.isVisible()) return;
        
        
        jTabbedPane.removeAll();
        if (jrf == null || jrf.getSelectedElements().size() == 0) {
            return;
        }
        else {
            
            updateBands();
            updateGroups();
            updateReportFonts();
            this.setInit(true);
            
            Enumeration e = jrf.getSelectedElements().elements();
            
            boolean isTheFirstElement = true;
            Band last_band = null;
            int y_location = 0;
            //______ COMMON ATTRIBUTES __________
            boolean sameTransparent = true;
            boolean sameWidth = true;
            boolean sameHeight = true;
            boolean sameTop = true;
            boolean sameLeft = true;
            boolean sameBand = true;
            boolean sameRemoveLineWhenBlank = true;
            boolean samePrintInFirstWholeBand = true;
            boolean samePrintWhenDetailOverflows = true;
            boolean samePrintRepeatedValues = true;
            boolean samePositionType = true;
            boolean sameBackgroud = true;
            boolean sameForecolor = true;
            boolean samePrintWhenGroupChanges = true;
            boolean samePrintWhenExpression = true;
            boolean sameKey = true;
            boolean sameStretchWithOverflow = true;
            //______ GRAPHIC ELEMENT ATTRIBUTES __________
            boolean areAllGraphicsElements = true;
            boolean samePen = true;
            boolean sameStretchType = true;
            boolean sameFill = true;
            //______ RECTANGLE ELEMENT ATTRIBUTES __________
            boolean areAllRectangleElements = true;
            boolean sameRadius = true;
            //______ LINE ELEMENT ATTRIBUTES __________
            boolean areAllLineElements = true;
            boolean sameLineDirection = true;
            //______ IMAGE ELEMENT ATTRIBUTES __________
            boolean areAllImageElements = true;
            boolean sameScaleImage = true;
            boolean sameImageExpression = true;
            boolean sameImageGroup = true;
            boolean sameEvaluationTime = true;
            boolean sameVerticalAlignment = true;
            boolean sameHorizontalAlignment = true;
            boolean sameImageCache = true;
            boolean sameImageExpressionClass = true;
            //______ TEXT ELEMENT ATTRIBUTES __________
            boolean areAllTextElements = true;
            boolean sameReportFont = true;
            boolean sameFontName = true;
            boolean samePDFFontName = true;
            boolean sameTTFFont = true;
            boolean sameFontSize = true;
            boolean sameIsBold = true;
            boolean sameIsItalic = true;
            boolean sameIsUnderline = true;
            boolean sameIsStrokeTrough = true;
            boolean sameTextVAlign = true;
            boolean sameTextHAlign = true;
            boolean sameTextLineSpacing = true;
            boolean sameIsPdfEmbedded = true;
            boolean samePdfEncoding = true;
            boolean sameRotation = true;
            boolean sameIsStyledTexdt = true;
            //______ STATIC ELEMENT ATTRIBUTES __________
            boolean areAllStaticTextElements = true;
            boolean sameText = true;
            //______ TEXTFIELD ELEMENT ATTRIBUTES __________
            boolean areAllTextFieldElements = true;
            boolean sameTextExpressionClass = true;
            boolean sameTextExpression = true;
            boolean sameTextEvaluationTime = true;
            boolean sameTextGroup = true;
            boolean sameTextStretchWithOverflow = true;
            boolean sameTextBlankWhenNull = true;
            boolean sameTextPattern = true;
            //______ HyperLinkable ELEMENT ATTRIBUTES __________
            boolean areAllHyperLinkableElements = true;
            boolean sameHyperLinkAnchorName = true;
            boolean sameHyperLinkType = true;
            boolean sameHyperLinkTarget = true;
            boolean sameHyperLinkAnchor = true;
            boolean sameHyperLinkPage = true;
            boolean sameHyperLinkReference = true;
            
            //______ BARCODE ELEMENT ATTRIBUTES __________
            boolean areAllBarcodeElements = true;
            boolean sameBarcodeExpression = true;
            boolean sameBarcodeGroup = true;
            boolean sameBarcodeEvaluationTime = true;
            boolean sameBarcodeShowText = true;
            boolean sameBarcodeChecksum = true;
            boolean sameBarcodeText = true;
            boolean sameBarcodeType = true;
            
            boolean isSubreportElement = false;
            boolean isChartElement = false;
            
            // ______ BOX _____________
            boolean areAllBorder = true;
            
            
            //boolean isBarcodeElement = false;
            
            if (!jComboBoxPositionType.getItemAt(0).equals(""))
                this.jComboBoxPositionType.insertItemAt("",0);
            if (!jComboBoxPen.getItemAt(0).equals(""))
                this.jComboBoxPen.insertItemAt("",0);
            if (!jComboBoxStretchType.getItemAt(0).equals(""))
                this.jComboBoxStretchType.insertItemAt("",0);
            if (!jComboBoxFill.getItemAt(0).equals(""))
                this.jComboBoxFill.insertItemAt("",0);
            if (!jComboBoxLineDirection.getItemAt(0).equals(""))
                this.jComboBoxLineDirection.insertItemAt("",0);
            if (!jComboBoxScale.getItemAt(0).equals(""))
                this.jComboBoxScale.insertItemAt("",0);
            if (!jComboBoxImageExpressionClass.getItemAt(0).equals(""))
                this.jComboBoxImageExpressionClass.insertItemAt("",0);
            if (!jComboBoxVerticalAlignment.getItemAt(0).equals(""))
                this.jComboBoxVerticalAlignment.insertItemAt("",0);
            if (!jComboBoxHorizontalAlignment.getItemAt(0).equals(""))
                this.jComboBoxHorizontalAlignment.insertItemAt("",0);
            if (!jComboBoxEvaluationTime.getItemAt(0).equals(""))
                this.jComboBoxEvaluationTime.insertItemAt("",0);
            if (jComboBoxReportFont.getItemCount() == 0 || !jComboBoxReportFont.getItemAt(0).equals(""))
                this.jComboBoxReportFont.insertItemAt("",0);
            if (!jComboBoxPDFFontName.getItemAt(0).equals(""))
                this.jComboBoxPDFFontName.insertItemAt("",0);
            if (jComboBoxTTFFont.getItemCount() == 0 || !jComboBoxTTFFont.getItemAt(0).equals(""))
                this.jComboBoxTTFFont.insertItemAt("",0);
            if (jComboBoxHAlign.getItemCount() == 0 || !jComboBoxHAlign.getItemAt(0).equals(""))
                this.jComboBoxHAlign.insertItemAt("",0);
            if (jComboBoxVAlign.getItemCount() == 0 || !jComboBoxVAlign.getItemAt(0).equals(""))
                this.jComboBoxVAlign.insertItemAt("",0);
            if (jComboBoxLineSpacing.getItemCount() == 0 || !jComboBoxLineSpacing.getItemAt(0).equals(""))
                this.jComboBoxLineSpacing.insertItemAt("",0);
            if (jComboBoxPdfEncoding.getItemCount() == 0 || !jComboBoxPdfEncoding.getItemAt(0).equals(""))
                this.jComboBoxPdfEncoding.insertItemAt("",0);
            if (jComboBoxTextFieldEvaluationTime.getItemCount() == 0 || !jComboBoxTextFieldEvaluationTime.getItemAt(0).equals(""))
                this.jComboBoxTextFieldEvaluationTime.insertItemAt("",0);
            if (jComboBoxTextFieldExpressionClass.getItemCount() == 0 || !jComboBoxTextFieldExpressionClass.getItemAt(0).equals(""))
                this.jComboBoxTextFieldExpressionClass.insertItemAt("",0);
            if (jComboBoxTextFieldGroup.getItemCount() == 0 || !jComboBoxTextFieldGroup.getItemAt(0).equals(""))
                this.jComboBoxTextFieldGroup.insertItemAt("",0);
            if (jComboBoxPattern.getItemCount() == 0 || !jComboBoxPattern.getItemAt(0).equals(""))
                this.jComboBoxPattern.insertItemAt("",0);
            if (jComboBoxLinkType.getItemCount() == 0 || !jComboBoxLinkType.getItemAt(0).equals(""))
                this.jComboBoxLinkType.insertItemAt("",0);
            if (jComboBoxPattern.getItemCount() == 0 || !jComboBoxPattern.getItemAt(0).equals(""))
                this.jComboBoxPattern.insertItemAt("",0);
            if (!jComboBoxRotation.getItemAt(0).equals(""))
                this.jComboBoxRotation.insertItemAt("",0);
            if (jComboBoxEvaluationTimeBarcode.getItemCount() == 0 || !jComboBoxEvaluationTimeBarcode.getItemAt(0).equals(""))
                this.jComboBoxEvaluationTimeBarcode.insertItemAt("",0);
            if (jComboBoxBarcodeGroup.getItemCount() == 0 || !jComboBoxBarcodeGroup.getItemAt(0).equals(""))
                this.jComboBoxBarcodeGroup.insertItemAt("",0);
            if (jComboBoxBarcodeType.getItemCount() == 0 || !jComboBoxBarcodeType.getItemAt(0).equals(""))
                this.jComboBoxBarcodeType.insertItemAt("",0);
            if (jComboBoxLinkTarget.getItemCount() == 0 || !jComboBoxLinkTarget.getItemAt(0).equals(""))
                this.jComboBoxLinkTarget.insertItemAt("",0);
            
            jComboBoxPattern.setSelectedItem("");
            jComboBoxTTFFont.setEnabled(false);
            jLabelTTF.setEnabled(false);
            
            while (e.hasMoreElements()) {
                ReportElement re = (ReportElement)e.nextElement();
                // 1. Set element properties...
                // For each panel, search
                if (last_band == null || last_band != re.getBand()) {
                    y_location = this.jrf.getReport().getBandYLocation(re.getBand());
                    last_band = re.getBand();
                }
                
                if (sameStretchType) sameStretchType = this.setComboBoxText(isTheFirstElement, re.getStretchType() , jComboBoxStretchType );
                if (sameKey)  sameKey = this.setTextField(isTheFirstElement, re.getKey(), jTextFieldName);
                if (sameWidth)  sameWidth = this.setElementNumber(isTheFirstElement, re.getWidth(), jNumberFieldWidth);
                if (sameHeight)  sameHeight = this.setElementNumber(isTheFirstElement, re.getHeight(), jNumberFieldHeight);
                if (sameLeft)  sameLeft = this.setElementNumber(isTheFirstElement, re.getPosition().x - 10 - this.jrf.getReport().getLeftMargin(), jNumberFieldLeft);
                if (sameTop)  sameTop = this.setElementNumber(isTheFirstElement, re.getPosition().y - y_location - 10, jNumberFieldTop);
                if (sameTransparent) sameTransparent = this.setCheckBox(isTheFirstElement, re.getTransparent().equals("Transparent"), jCheckBoxTransparent);
                if (sameBand) sameBand = this.setComboBox(isTheFirstElement, re.getBand(), jComboBoxBand );
                if (sameRemoveLineWhenBlank) sameRemoveLineWhenBlank = this.setCheckBox(isTheFirstElement, re.isRemoveLineWhenBlank, jCheckBoxRemoveLineWhenBlank);
                if (samePrintInFirstWholeBand) samePrintInFirstWholeBand = this.setCheckBox(isTheFirstElement, re.isPrintInFirstWholeBand, jCheckBoxPrintInFirstWholeBand);
                if (samePrintWhenDetailOverflows) samePrintWhenDetailOverflows = this.setCheckBox(isTheFirstElement, re.isPrintWhenDetailOverflows, jCheckBoxPrintWhenDetailOverflows);
                if (samePrintRepeatedValues) samePrintRepeatedValues = this.setCheckBox(isTheFirstElement, re.isPrintRepeatedValues, jCheckBoxPrintRepeatedValues);
                if (samePositionType) samePositionType = this.setComboBoxText(isTheFirstElement, re.positionType, jComboBoxPositionType );
                if (sameBackgroud) sameBackgroud= setElementColor(isTheFirstElement, re.bgcolor, jButtonBackground);
                if (sameForecolor) sameForecolor = setElementColor(isTheFirstElement, re.fgcolor, jButtonForeground);
                if (samePrintWhenExpression) samePrintWhenExpression = setTextArea(isTheFirstElement, re.printWhenExpression, jRTextExpressionAreaPrintWhenExpression);
                if (samePrintWhenGroupChanges) samePrintWhenGroupChanges = this.setComboBoxText(isTheFirstElement, Misc.nvl( re.printWhenGroupChanges,""), jComboBoxGroups);
                
                // Tab Graphics Element
                if (areAllGraphicsElements && (re instanceof GraphicReportElement)) {
                    GraphicReportElement gre = (GraphicReportElement)re;
                    if (samePen) samePen = this.setComboBoxText(isTheFirstElement, gre.getGraphicElementPen() , jComboBoxPen );
                    
                    if (sameFill) sameFill = this.setComboBoxText(isTheFirstElement, gre.getFill() , jComboBoxFill );
                }
                else {
                    areAllGraphicsElements = false;
                }
                
                // Tab Rectangle Element
                if (areAllRectangleElements && (re instanceof RectangleReportElement)) {
                    RectangleReportElement rre = (RectangleReportElement)re;
                    if (sameRadius)  sameRadius = this.setElementNumber(isTheFirstElement, rre.radius, jNumberFieldRadius);
                    
                }
                else {
                    areAllRectangleElements = false;
                }
                
                // Tab Line Element
                if (areAllLineElements && (re instanceof LineReportElement)) {
                    LineReportElement lre = (LineReportElement)re;
                    if (sameLineDirection) samePen = this.setComboBoxText(isTheFirstElement, lre.direction , jComboBoxLineDirection );
                }
                else {
                    areAllLineElements = false;
                }
                
                // Tab Image Element
                if (areAllBarcodeElements && re instanceof BarcodeReportElement) {
                    BarcodeReportElement bre = (BarcodeReportElement)re;
                    if (sameBarcodeExpression) sameBarcodeExpression = setTextArea(isTheFirstElement, bre.getText(), jBarcodeExpressionArea);
                    if (sameBarcodeGroup) sameBarcodeGroup = this.setComboBoxText(isTheFirstElement, Misc.nvl( bre.getEvaluationGroup(),""), jComboBoxBarcodeGroup);
                    if (sameBarcodeType) sameBarcodeType = this.setComboBoxText(isTheFirstElement, ""+jComboBoxBarcodeType.getModel().getElementAt(bre.getType()), jComboBoxBarcodeType);
                    if (sameBarcodeEvaluationTime) sameBarcodeEvaluationTime = this.setComboBoxText(isTheFirstElement, Misc.nvl( bre.getEvaluationTime(),""), jComboBoxEvaluationTimeBarcode);
                    if (sameBarcodeShowText) sameBarcodeShowText = this.setCheckBox(isTheFirstElement, bre.isShowText(), jCheckBoxBarcodeShowText );
                    if (sameBarcodeChecksum) sameBarcodeChecksum = this.setCheckBox(isTheFirstElement, bre.isCheckSum(), jCheckBoxBarcodeCheckSum );
                }
                else {
                    areAllBarcodeElements = false;
                }
                
                
                if (areAllImageElements && (re instanceof ImageReportElement ) && !(re instanceof ChartReportElement )  && !(re instanceof BarcodeReportElement )) {
                    ImageReportElement ire = (ImageReportElement)re;
                    if (sameScaleImage) sameScaleImage = this.setComboBoxText(isTheFirstElement, ire.getScaleImage() , jComboBoxScale );
                    if (sameImageExpression) sameImageExpression = setTextArea(isTheFirstElement, ire.getImageExpression(), jRTextExpressionAreaImageExpression);
                    if (sameImageGroup) sameImageGroup = this.setComboBoxText(isTheFirstElement, Misc.nvl( ire.getEvaluationGroup(),""), jComboBoxImageGroup);
                    if (sameEvaluationTime) sameEvaluationTime = this.setComboBoxText(isTheFirstElement, Misc.nvl( ire.getEvaluationTime(),""), jComboBoxEvaluationTime);
                    if (sameVerticalAlignment) sameVerticalAlignment = this.setComboBoxText(isTheFirstElement, Misc.nvl( ire.getVerticalAlignment(),""), jComboBoxVerticalAlignment);
                    if (sameHorizontalAlignment) sameHorizontalAlignment = this.setComboBoxText(isTheFirstElement, Misc.nvl( ire.getHorizontalAlignment(),""), jComboBoxHorizontalAlignment);
                    if (sameImageCache) sameImageCache = this.setCheckBox(isTheFirstElement, ire.isIsUsingCache(), jCheckBoxImageCache );
                    if (sameImageExpressionClass) sameImageExpressionClass = this.setComboBoxText(isTheFirstElement, Misc.nvl( ire.getImageClass(),""), jComboBoxImageExpressionClass);
                }
                else {
                    areAllImageElements = false;
                }
                
                // Tab Font Element
                if (areAllTextElements && (re instanceof TextReportElement)) {
                    TextReportElement tre = (TextReportElement)re;
                    if (sameReportFont) sameReportFont = this.setComboBoxText(isTheFirstElement, tre.getReportFont() , jComboBoxReportFont );
                    if (sameFontName) sameFontName = setComboBoxText(isTheFirstElement, tre.getFontName() , jComboBoxFontName);
                    if (samePDFFontName) {
                        if (tre.getPDFFontName().toUpperCase().endsWith(".TTF") || tre.getPDFFontName().toUpperCase().indexOf(".TTC,") >= 0)
                            samePDFFontName = this.setComboBoxText(isTheFirstElement, "External TTF font..." , jComboBoxPDFFontName );
                        else
                            samePDFFontName = this.setComboBoxText(isTheFirstElement, tre.getPDFFontName() , jComboBoxPDFFontName );
                    }
                    if (sameFontSize) sameFontSize = this.setElementComboNumber(isTheFirstElement, tre.getFontSize() , jNumberComboBoxSize );
                    if (sameIsBold) sameIsBold = this.setCheckBox(isTheFirstElement, tre.isBold(), jCheckBoxBold );
                    if (sameIsStyledTexdt) sameIsStyledTexdt = this.setCheckBox(isTheFirstElement, tre.isIsStyledText(), jCheckBoxStyledText );
                    if (sameIsItalic) sameIsItalic = this.setCheckBox(isTheFirstElement, tre.isItalic(), jCheckBoxItalic );
                    if (sameIsUnderline) sameIsUnderline = this.setCheckBox(isTheFirstElement, tre.isUnderline(), jCheckBoxUnderline );
                    if (sameIsStrokeTrough) sameIsStrokeTrough = this.setCheckBox(isTheFirstElement, tre.isStrikeTrought(),  jCheckBoxStrokeTrough );
                    if (sameTextVAlign) sameTextVAlign = this.setComboBoxText(isTheFirstElement, tre.getVerticalAlign(), jComboBoxVAlign );
                    if (sameTextHAlign) sameTextHAlign = this.setComboBoxText(isTheFirstElement, tre.getAlign() , jComboBoxHAlign );
                    if (sameTextLineSpacing) sameTextHAlign = this.setComboBoxText(isTheFirstElement, tre.getLineSpacing() , jComboBoxLineSpacing );
                    if (sameIsPdfEmbedded) sameIsPdfEmbedded = this.setCheckBox(isTheFirstElement, tre.isPdfEmbedded(),  jCheckBoxPDFEmbedded );
                    if (samePdfEncoding) samePdfEncoding = this.setPdfEncodingComboBox(isTheFirstElement, tre.getPdfEncoding() , jComboBoxPdfEncoding );
                    
                    if (sameRotation) sameRotation = this.setComboBoxText(isTheFirstElement, tre.getRotate(), jComboBoxRotation);
                    
                    if (samePDFFontName && tre.getPDFFontName().toUpperCase().endsWith(".TTF") || tre.getPDFFontName().toUpperCase().indexOf(".TTC,") >= 0) {
                        jComboBoxTTFFont.setEnabled(true);
                        jLabelTTF.setEnabled(true);
                        if (sameTTFFont)  this.setFontComboBox(isTheFirstElement, tre.getPDFFontName() , jComboBoxTTFFont );
                    }
                    else {
                        jComboBoxTTFFont.setEnabled(false);
                        jLabelTTF.setEnabled(false);
                    }
                }
                else {
                    areAllTextElements = false;
                }
                
                // Tab StaticText Element
                if (areAllStaticTextElements && (re instanceof StaticTextReportElement)) {
                    TextReportElement tre = (TextReportElement)re;
                    if (sameText) sameText = this.setJTextArea(isTheFirstElement, tre.getText() , jTextAreaText );
                }
                else {
                    areAllStaticTextElements = false;
                }
                
                 
                
                if (areAllBorder && (re instanceof TextReportElement || re instanceof ImageReportElement)) {
                    if (isTheFirstElement)
                    {
                        if (re instanceof TextReportElement)
                            boxPanel.setBox( ((TextReportElement)re).getBox().cloneMe() );
                        else
                            boxPanel.setBox( ((ImageReportElement)re).getBox().cloneMe() );
                    }
                }
                else {
                    areAllBorder = false;
                }
                
                // Tab TextField Element
                if (areAllTextFieldElements && (re instanceof TextFieldReportElement)) {
                    TextFieldReportElement tre = (TextFieldReportElement)re;
                    if (sameTextExpression) sameText = this.setTextArea(isTheFirstElement, tre.getText() , jRTextExpressionAreaTextFieldExpression );
                    if (sameTextExpressionClass) sameTextExpressionClass  = this.setComboBoxText(isTheFirstElement, tre.getClassExpression(), jComboBoxTextFieldExpressionClass );
                    if (sameTextEvaluationTime) sameTextEvaluationTime = this.setComboBoxText(isTheFirstElement, tre.getEvaluationTime(), jComboBoxTextFieldEvaluationTime );
                    if (sameTextGroup) sameTextGroup = this.setComboBoxText(isTheFirstElement, tre.getGroup(), jComboBoxTextFieldGroup );
                    if (sameTextStretchWithOverflow)  sameTextStretchWithOverflow = this.setCheckBox(isTheFirstElement, tre.isStretchWithOverflow(),  jCheckBoxStretchWithOverflow);
                    if (sameTextBlankWhenNull) sameTextBlankWhenNull = this.setCheckBox(isTheFirstElement, tre.isBlankWhenNull(),  jCheckBoxBlankWhenNull);
                    if (sameTextPattern) sameTextPattern = this.setWritableComboBoxText(isTheFirstElement, tre.getPattern(),  jComboBoxPattern);
                }
                else {
                    areAllTextFieldElements = false;
                }
                
                if (areAllHyperLinkableElements && (re instanceof HyperLinkableReportElement)) {
                    HyperLinkableReportElement hlre = (HyperLinkableReportElement)re;
                    if (sameHyperLinkAnchorName) sameHyperLinkAnchorName = setTextArea(isTheFirstElement, hlre.getAnchorNameExpression(), jRTextExpressionAreaAnchorName);
                    if (sameHyperLinkType) sameHyperLinkType = this.setComboBoxText(isTheFirstElement, hlre.getHyperlinkType(), jComboBoxLinkType);
                    if (sameHyperLinkTarget) sameHyperLinkTarget = this.setComboBoxText(isTheFirstElement, hlre.getHyperlinkTarget(), jComboBoxLinkTarget);
                    if (sameHyperLinkType) {
                        if (sameHyperLinkAnchor) sameHyperLinkAnchor = setTextArea(isTheFirstElement, hlre.getHyperlinkAnchorExpression(), jRTextExpressionAreaAnchor);
                        if (sameHyperLinkPage) sameHyperLinkPage = setTextArea(isTheFirstElement, hlre.getHyperlinkPageExpression(), jRTextExpressionAreaPage);
                        if (sameHyperLinkReference) sameHyperLinkReference = setTextArea(isTheFirstElement, hlre.getHyperlinkReferenceExpression(), jRTextExpressionAreaReference);
                        
                    }
                    else {
                        jRTextExpressionAreaAnchor.setText("");
                        jRTextExpressionAreaAnchor.setText("");
                        jRTextExpressionAreaPage.setText("");
                        jRTextExpressionAreaReference.setText("");
                    }
                    
                }
                else {
                    areAllHyperLinkableElements = false;
                }
                
                if (isTheFirstElement && !e.hasMoreElements() && re instanceof SubReportElement) {
                    isSubreportElement = true;
                    SubReportElement sre = (SubReportElement)re;
                    this.setTextArea(isTheFirstElement, sre.getParametersMapExpression(), jRTextExpressionAreaSubreportMapExpression );
                    this.setComboBoxText(isTheFirstElement, sre.getSubreportExpressionClass(), jComboBoxSubreportExpressionClass);
                    this.setTextArea(isTheFirstElement, sre.getSubreportExpression(), jRTextExpressionAreaSubreportExpression);
                    if (!sre.isUseConnection() &&  Misc.nvl( sre.getDataSourceExpression(),"").trim().equals("")) {
                        this.jComboBoxSubreportConnectionType.setSelectedIndex(0);
                        this.jRTextExpressionAreaTextConnectionExpression.setEnabled(false);
                        this.jRTextExpressionAreaTextConnectionExpression.setBackground(Color.LIGHT_GRAY);
                        this.jRTextExpressionAreaTextConnectionExpression.setText("");
                    }
                    else if (sre.isUseConnection()) {
                        this.jComboBoxSubreportConnectionType.setSelectedIndex(1);
                        this.jRTextExpressionAreaTextConnectionExpression.setEnabled(true);
                        this.jRTextExpressionAreaTextConnectionExpression.setBackground(Color.WHITE);
                        this.jRTextExpressionAreaTextConnectionExpression.setText( sre.getConnectionExpression());
                    }
                    else {
                        this.jComboBoxSubreportConnectionType.setSelectedIndex(2);
                        this.jRTextExpressionAreaTextConnectionExpression.setEnabled(true);
                        this.jRTextExpressionAreaTextConnectionExpression.setBackground(Color.WHITE);
                        this.jRTextExpressionAreaTextConnectionExpression.setText( sre.getDataSourceExpression());
                    }
                    
                    jCheckBoxSubreportCache.setSelected( sre.isIsUsingCache());
                    
                    //Add parameters...
                    javax.swing.table.DefaultTableModel dtm = (javax.swing.table.DefaultTableModel)jTableSubreportParameters.getModel();
                    dtm.setRowCount(0);
                    
                    java.util.Enumeration enum_parameters = sre.getSubreportParameters().elements();
                    while (enum_parameters.hasMoreElements()) {
                        it.businesslogic.ireport.JRSubreportParameter parameter = (it.businesslogic.ireport.JRSubreportParameter)enum_parameters.nextElement();
                        Vector row = new Vector();
                        row.addElement(parameter);
                        row.addElement(parameter.getExpression());
                        dtm.addRow(row);
                    }
                    
                }
                else
                    isSubreportElement = false;
                
                if (isTheFirstElement && !e.hasMoreElements() && re instanceof ChartReportElement) {
                    isChartElement = true;
                    
                    ImageReportElement ire = (ImageReportElement)re;
                    this.setComboBoxText(isTheFirstElement, Misc.nvl( ire.getEvaluationGroup(),""), jComboBoxImageGroup1);
                    this.setComboBoxText(isTheFirstElement, Misc.nvl( ire.getEvaluationTime(),""), jComboBoxEvaluationTime1);
                }
                else
                    isChartElement = false;
                
                                /*
                                if (isTheFirstElement && !e.hasMoreElements() && re instanceof BarcodeReportElement) {
                                        isBarcodeElement = true;
                                        BarcodeReportElement cre = (BarcodeReportElement) re;
                                 
                                 
                                        jComboBoxBarcodeType.setSelectedIndex(cre.getType());
                                        jBarcodeExpressionArea.setText(cre.getText());
                                        jCheckBoxBarcodeShowText.setSelected(cre.isShowText());
                                        jCheckBoxBarcodeCheckSum.setSelected(cre.isCheckSum());
                                 
                                }
                                else
                                        isBarcodeElement = false;
                                 */
                
                isTheFirstElement=false;
            }
            
            
            
            // If not useful, remove blank combo entries...
            if (this.jComboBoxBand.getSelectedIndex() != 0) {
                this.jComboBoxBand.removeItemAt(0);
            }
            if (this.jComboBoxPositionType.getSelectedIndex() != 0) {
                this.jComboBoxPositionType.removeItemAt(0);
            }
            
            if (this.jComboBoxLineDirection.getSelectedIndex() != 0)  this.jComboBoxLineDirection.removeItemAt(0);
            if (this.jComboBoxPen.getSelectedIndex() != 0)  this.jComboBoxPen.removeItemAt(0);
            if (this.jComboBoxStretchType.getSelectedIndex() != 0)  this.jComboBoxStretchType.removeItemAt(0);
            if (this.jComboBoxFill.getSelectedIndex() != 0)  this.jComboBoxFill.removeItemAt(0);
            if (this.jComboBoxScale.getSelectedIndex() != 0)  this.jComboBoxScale.removeItemAt(0);
            if (this.jComboBoxVerticalAlignment.getSelectedIndex() != 0)  this.jComboBoxVerticalAlignment.removeItemAt(0);
            if (this.jComboBoxHorizontalAlignment.getSelectedIndex() != 0)  this.jComboBoxHorizontalAlignment.removeItemAt(0);
            if (this.jComboBoxImageExpressionClass.getSelectedIndex() != 0)  this.jComboBoxImageExpressionClass.removeItemAt(0);
            if (this.jComboBoxEvaluationTime.getSelectedIndex() != 0)  this.jComboBoxEvaluationTime.removeItemAt(0);
            if (this.jComboBoxPDFFontName.getSelectedIndex() != 0)  this.jComboBoxPDFFontName.removeItemAt(0);
            if (this.jComboBoxTTFFont.getSelectedIndex() != 0)  this.jComboBoxTTFFont.removeItemAt(0);
            //if (this.jComboBoxReportFont.getSelectedIndex() != 0)  this.jComboBoxReportFont.removeItemAt(0);
            if (this.jComboBoxHAlign.getSelectedIndex() != 0)  this.jComboBoxHAlign.removeItemAt(0);
            if (this.jComboBoxVAlign.getSelectedIndex() != 0)  this.jComboBoxVAlign.removeItemAt(0);
            if (this.jComboBoxLineSpacing.getSelectedIndex() != 0)  this.jComboBoxLineSpacing.removeItemAt(0);
            if (this.jComboBoxTextFieldEvaluationTime.getSelectedIndex() != 0)  this.jComboBoxTextFieldEvaluationTime.removeItemAt(0);
            if (this.jComboBoxTextFieldExpressionClass.getSelectedIndex() != 0)  this.jComboBoxTextFieldExpressionClass.removeItemAt(0);
            if (this.jComboBoxLinkTarget.getSelectedIndex() != 0)  this.jComboBoxLinkTarget.removeItemAt(0);
            //if (this.jComboBoxSubreportExpressionClass.getSelectedIndex() != 0)  this.jComboBoxTextFieldExpressionClass.removeItemAt(0);
            if (this.jComboBoxLinkType.getSelectedIndex() != 0) {
                this.jComboBoxLinkType.removeItemAt(0);
                if (((String)this.jComboBoxLinkType.getSelectedItem()).equals("None")) {
                    this.jRTextExpressionAreaAnchor.setEnabled(false);
                    this.jLabelAnchor.setEnabled(false);
                    this.jRTextExpressionAreaPage.setEnabled(false);
                    this.jLabelPage.setEnabled(false);
                    this.jRTextExpressionAreaReference.setEnabled(false);
                    this.jLabelReference.setEnabled(false);
                }
                else if (((String)this.jComboBoxLinkType.getSelectedItem()).equals("Reference")) {
                    this.jRTextExpressionAreaAnchor.setEnabled(false);
                    this.jLabelAnchor.setEnabled(false);
                    this.jRTextExpressionAreaPage.setEnabled(false);
                    this.jLabelPage.setEnabled(false);
                    this.jRTextExpressionAreaReference.setEnabled(true);
                    this.jLabelReference.setEnabled(true);
                }
                else if (((String)this.jComboBoxLinkType.getSelectedItem()).equals("LocalAnchor")) {
                    this.jRTextExpressionAreaAnchor.setEnabled(true);
                    this.jLabelAnchor.setEnabled(true);
                    this.jRTextExpressionAreaPage.setEnabled(false);
                    this.jLabelPage.setEnabled(false);
                    this.jRTextExpressionAreaReference.setEnabled(false);
                    this.jLabelReference.setEnabled(false);
                }
                else if (((String)this.jComboBoxLinkType.getSelectedItem()).equals("LocalPage")) {
                    this.jRTextExpressionAreaAnchor.setEnabled(false);
                    this.jLabelAnchor.setEnabled(false);
                    this.jRTextExpressionAreaPage.setEnabled(true);
                    this.jLabelPage.setEnabled(true);
                    this.jRTextExpressionAreaReference.setEnabled(false);
                    this.jLabelReference.setEnabled(false);
                }
                
                else if (((String)this.jComboBoxLinkType.getSelectedItem()).equals("RemoteAnchor")) {
                    this.jRTextExpressionAreaAnchor.setEnabled(true);
                    this.jLabelAnchor.setEnabled(true);
                    this.jRTextExpressionAreaPage.setEnabled(false);
                    this.jLabelPage.setEnabled(false);
                    this.jRTextExpressionAreaReference.setEnabled(true);
                    this.jLabelReference.setEnabled(true);
                }
                else if (((String)this.jComboBoxLinkType.getSelectedItem()).equals("RemotePage")) {
                    this.jRTextExpressionAreaAnchor.setEnabled(false);
                    this.jLabelAnchor.setEnabled(false);
                    this.jRTextExpressionAreaPage.setEnabled(true);
                    this.jLabelPage.setEnabled(true);
                    this.jRTextExpressionAreaReference.setEnabled(true);
                    this.jLabelReference.setEnabled(true);
                }
            }
            else {
                this.jRTextExpressionAreaAnchor.setEnabled(false);
                this.jLabelAnchor.setEnabled(false);
                this.jRTextExpressionAreaPage.setEnabled(false);
                this.jLabelPage.setEnabled(false);
                this.jRTextExpressionAreaReference.setEnabled(false);
                this.jLabelReference.setEnabled(false);
            }
            jTabbedPane.add("Common", jPanelCommon);
            if (areAllGraphicsElements) jTabbedPane.add("Graphics Element", jPanelGraphicselement);
            if (areAllRectangleElements) jTabbedPane.add("Rectangle", jPanelRectangle);
            if (areAllLineElements) jTabbedPane.add("Line", jPanelLine );
            if (areAllImageElements) jTabbedPane.add("Image", jPanelImage );
            if (areAllTextElements) jTabbedPane.add("Font", jPanelFont);
            if (areAllStaticTextElements) jTabbedPane.add("Static Text", jPanelText);
            if (areAllTextFieldElements) jTabbedPane.add("Text Field", jPanelTextField);
            if (areAllHyperLinkableElements) jTabbedPane.add("Hyper Link", jPanelHyperLink);
            if (isSubreportElement) jTabbedPane.add("Subreport", jPanelSubreport1);
            if (isSubreportElement) jTabbedPane.add("Subreport (Other)", jPanelSubreport2);
            if (isChartElement) jTabbedPane.add("Chart", jPanelChart);
            if (areAllBarcodeElements) jTabbedPane.add("Barcode", jPanelBarcode);
            if (areAllBorder) jTabbedPane.add("Border", jPanelBorder);
            
            if (lastSelectedPanel != null)
                
                try {
                    jTabbedPane.setSelectedComponent( lastSelectedPanel);
                } catch (Exception ex) {
                    lastSelectedPanel = jPanelCommon;
                }
            jTabbedPane.updateUI();
            this.setInit(false);
        }
    }
    
    /**
     *  This method populate the groups comboboxes...
     */
    public void updateGroups() {
        this.setInit(true);
        // Use the name of the group and not the group object....
        Vector group_names = new Vector();
        Enumeration e = jrf.getReport().getGroups().elements();
        while (e.hasMoreElements()) {
            group_names.addElement(""+e.nextElement());
        }
        Misc.updateComboBox( jComboBoxGroups, group_names,true);
        Misc.updateComboBox( jComboBoxImageGroup , group_names,true);
        Misc.updateComboBox( jComboBoxImageGroup1 , group_names,true);
        Misc.updateComboBox( jComboBoxTextFieldGroup , group_names,true);
        Misc.updateComboBox( jComboBoxBarcodeGroup , group_names,true);
        this.setInit(false);
    }
    
    /**
     *  This method populate the report fonts comboboxes...
     */
    public void updateReportFonts() {
        this.setInit(true);
        // Use the name of the group and not the group object....
        Vector font_names = new Vector();
        Enumeration e = jrf.getReport().getFonts().elements();
        while (e.hasMoreElements()) {
            font_names.addElement(""+e.nextElement());
        }
        Misc.updateStringComboBox(jComboBoxReportFont, font_names,true);
        this.setInit(false);
    }
    
    /**
     *  This method populate the bands combobox...
     */
    public void updateBands() {
        this.setInit(true);
        Misc.updateComboBox( jComboBoxBand, jrf.getReport().getBands(), true);
        this.setInit(false);
    }
    
    public void updateFonts(Vector iRFonts) {
        this.setInit(true);
        Misc.updateComboBox( jComboBoxTTFFont, iRFonts, false);
        this.setInit(false);
    }
    
    protected boolean setElementNumber( boolean firstTime, double value, JNumberField numberField ) {
        if (( ! firstTime ) && (!(numberField.getValue() == value))) {
            numberField.setText("");
            return false;
        }
        else {
            try {
                numberField.setValue( value );
            } catch (Exception ex){
                ex.printStackTrace();
            }
        }
        return true;
    }
    
    protected boolean setElementComboNumber( boolean firstTime, double value, JNumberComboBox numberField ) {
        if (( ! firstTime ) && (!(numberField.getValue() == value))) {
            numberField.setSelectedItem("");
            return false;
        }
        else {
            try {
                numberField.setValue( value );
            } catch (Exception ex){
                ex.printStackTrace();
            }
        }
        return true;
    }
    
    protected boolean setCheckBox( boolean firstTime, boolean value, javax.swing.JCheckBox checkField ) {
        if (( ! firstTime ) && (!(checkField.isSelected() == value))) {
            checkField.setSelected(false);
            return false;
        }
        else {
            try {
                checkField.setSelected( value );
            } catch (Exception ex){
                ex.printStackTrace();
            }
        }
        return true;
    }
    
    protected boolean setComboBox( boolean firstTime, Object value, javax.swing.JComboBox comboField ) {
        if (( ! firstTime ) && (!(comboField.getSelectedItem() == value))) {
            comboField.setSelectedIndex(0);
            return false;
        }
        else {
            try {
                comboField.setSelectedItem( value );
            } catch (Exception ex){
                ex.printStackTrace();
            }
        }
        return true;
    }
    
    protected boolean setFontComboBox( boolean firstTime, String value, javax.swing.JComboBox comboField ) {
        if (( ! firstTime ) && (!(comboField.getSelectedItem()!=null && comboField.getSelectedItem() instanceof IRFont && ((IRFont)comboField.getSelectedItem()).getFile().equals(value)))) {
            if (comboField.getItemCount() > 0)
                comboField.setSelectedIndex(0);
            return false;
        }
        else {
            try {
                for (int i=0; i<comboField.getItemCount(); ++i) {
                    if (comboField.getItemAt(i) instanceof IRFont && ((IRFont)comboField.getItemAt(i)).getFile().getName().equals(value) ) {
                        comboField.setSelectedIndex(i);
                        return true;
                    }
                }
                if (comboField.getItemCount() > 0)
                    comboField.setSelectedIndex(0);
            } catch (Exception ex){
                ex.printStackTrace();
            }
        }
        return true;
    }
    
    protected boolean setPdfEncodingComboBox( boolean firstTime, String value, javax.swing.JComboBox comboField ) {
        if (( ! firstTime ) && (!(comboField.getSelectedItem()!=null && ( (comboField.getSelectedItem() instanceof PdfEncoding && ((PdfEncoding)comboField.getSelectedItem()).getEncoding().equalsIgnoreCase(value)) || (comboField.getSelectedItem()+"").equals(value) )))) {
            if (comboField.getItemCount() > 0)
                comboField.setSelectedIndex(0);
            return false;
        }
        else {
            try {
                for (int i=0; i<comboField.getItemCount(); ++i) {
                    if (comboField.getItemAt(i) instanceof PdfEncoding && ((PdfEncoding)comboField.getItemAt(i)).getEncoding().equals(value) ) {
                        comboField.setSelectedIndex(i);
                        return true;
                    }
                }
                comboField.setSelectedItem(value);
            } catch (Exception ex){
                ex.printStackTrace();
            }
        }
        return true;
    }
    
    protected boolean setComboBoxText( boolean firstTime, String value, javax.swing.JComboBox comboField ) {
        if (( ! firstTime ) && (!( Misc.nvl(comboField.getSelectedItem(),"").equalsIgnoreCase(value)))) {
            comboField.setSelectedIndex(0);
            return false;
        }
        else {
            try {
                comboField.setSelectedItem( value );
            } catch (Exception ex){
                ex.printStackTrace();
            }
        }
        return true;
    }
    
    public void setVisible(boolean visible) {
        if (visible == isVisible()) return;
        super.setVisible(visible);
        if (visible == true) {
            this.updateSelection();
        }
    }
    
    /** Getter for property init.
     * @return Value of property init.
     *
     */
    public boolean isInit() {
        return init;
    }
    
    /** Setter for property init.
     * @param init New value of property init.
     *
     */
    public void setInit(boolean init) {
        this.init = init;
    }
    
    
    protected boolean setElementColor( boolean firstTime, Color value, javax.swing.JButton colorField ) {
        if (( ! firstTime ) && (!(colorField.getBackground() == value))) {
            colorField.setBackground( Color.GRAY);
            return false;
        }
        else {
            try {
                colorField.setBackground( value );
            } catch (Exception ex){
                ex.printStackTrace();
            }
        }
        return true;
    }
    
    protected boolean setTextArea( boolean firstTime, String value, JRTextExpressionArea textField ) {
        
        
        if (( ! firstTime ) && (!(textField.getText().equals(value) ))) {
            textField.setText("");
            ((org.syntax.jedit.SyntaxDocument)textField.getDocument()).getUM().discardAllEdits();
            return false;
        }
        else {
            try {
                textField.setText( value );
                ((org.syntax.jedit.SyntaxDocument)textField.getDocument()).getUM().discardAllEdits();
            } catch (Exception ex){
                ex.printStackTrace();
            }
        }
        return true;
    }
    
    protected boolean setJTextArea( boolean firstTime, String value, javax.swing.JTextArea textField ) {
        
        if (( ! firstTime ) && (!(textField.getText().equals(value) ))) {
            textField.setText("");
            return false;
        }
        else {
            try {
                textField.setText( value );
                
            } catch (Exception ex){
                ex.printStackTrace();
            }
        }
        return true;
    }
    
    protected boolean setTextField( boolean firstTime, String value, javax.swing.JTextField textField ) {
        if (( ! firstTime ) && (!(textField.getText().equals(value) ))) {
            textField.setText("");
            return false;
        }
        else {
            try {
                textField.setText( value );
            } catch (Exception ex){
                ex.printStackTrace();
            }
        }
        return true;
    }
    
     protected boolean setPatternComboBox( boolean firstTime, String value, javax.swing.JComboBox comboField ) {
        if (( !firstTime) && (!((comboField.getSelectedItem()+"").equals(value) ))) {
            comboField.setSelectedItem("");
            return false;
        }
        else {
            try {
                comboField.addItem(value);
                comboField.setSelectedItem( value );
            } catch (Exception ex){
                ex.printStackTrace();
            }
        }
        return true;
    }
    
    protected boolean setWritableComboBoxText( boolean firstTime, String value, javax.swing.JComboBox comboField ) {

        if (( !firstTime) && (!((comboField.getSelectedItem()+"").equals(value) ))) {
            comboField.setSelectedItem("");
            return false;
        }
        else {
            try {

                comboField.setSelectedItem( value );
            } catch (Exception ex){
                ex.printStackTrace();
            }
        }
        return true;
    }
    
    public void jRTextExpressionAreaPrintWhenExpressionTextChanged() {
        if (this.isInit()) return;
        
        Enumeration e = jrf.getSelectedElements().elements();
        while (e.hasMoreElements()) {
            ReportElement element = (ReportElement)e.nextElement();
            element.printWhenExpression = jRTextExpressionAreaPrintWhenExpression.getText();
            //System.out.println("associato testo: "+element.printWhenExpression);
        }
    }
    
    public void jRTextExpressionAreaImageExpressionTextChanged() {
        if (this.isInit()) return;
        Enumeration e = jrf.getSelectedElements().elements();
        while (e.hasMoreElements()) {
            ImageReportElement element = (ImageReportElement)e.nextElement();
            element.setImageExpression( jRTextExpressionAreaImageExpression.getText());
        }
        jrf.getJPanelReport().repaint();
    }
    public void jTextAreaTextChanged() {
        if (this.isInit()) return;
        
        // Set band to all....
        if (jrf == null || jrf.getSelectedElements().size()==0) return;
        // Set the new value for all selected elements...
        Enumeration e = jrf.getSelectedElements().elements();
        while (e.hasMoreElements()) {
            TextReportElement element = (TextReportElement)e.nextElement();
            element.setText(""+ jTextAreaText.getText());
        }
        jrf.getJPanelReport().repaint();
    }
    
    public void jRTextExpressionAreaTextFieldExpressionTextChanged() {
        if (this.isInit()) return;
        Enumeration e = jrf.getSelectedElements().elements();
        while (e.hasMoreElements()) {
            TextFieldReportElement element = (TextFieldReportElement)e.nextElement();
            element.setText(""+jRTextExpressionAreaTextFieldExpression.getText());
        }
        jrf.getJPanelReport().repaint();
    }
    
    public void jRTextExpressionAreaSubreportExpressionTextChanged() {
        if (this.isInit()) return;
        Enumeration e = jrf.getSelectedElements().elements();
        while (e.hasMoreElements()) {
            SubReportElement element = (SubReportElement)e.nextElement();
            element.setSubreportExpression(""+jRTextExpressionAreaSubreportExpression.getText());
        }
        jrf.getJPanelReport().repaint();
    }
    
    public void jRTextExpressionAreaTextConnectionExpressionTextChanged() {
        if (this.isInit()) return;
        Enumeration e = jrf.getSelectedElements().elements();
        while (e.hasMoreElements()) {
            SubReportElement element = (SubReportElement)e.nextElement();
            if (element.isUseConnection())
                element.setConnectionExpression(""+jRTextExpressionAreaTextConnectionExpression.getText());
            else
                element.setDataSourceExpression(""+jRTextExpressionAreaTextConnectionExpression.getText());
        }
        jrf.getJPanelReport().repaint();
    }
    
    
    
    public void jRTextExpressionAreaSubreportMapExpressionTextChanged() {
        if (this.isInit()) return;
        Enumeration e = jrf.getSelectedElements().elements();
        while (e.hasMoreElements()) {
            SubReportElement element = (SubReportElement)e.nextElement();
            element.setParametersMapExpression(""+jRTextExpressionAreaSubreportMapExpression.getText());
            jrf.getJPanelReport().repaint();
        }
    }
    
    public void jRTextExpressionAreaAnchorNameTextChanged() {
        if (this.isInit()) return;
        Enumeration e = jrf.getSelectedElements().elements();
        while (e.hasMoreElements()) {
            HyperLinkableReportElement element = (HyperLinkableReportElement)e.nextElement();
            element.setAnchorNameExpression(""+jRTextExpressionAreaAnchorName.getText());
        }
    }
    
    public void jRTextExpressionAreaAnchorTextChanged() {
        if (this.isInit()) return;
        Enumeration e = jrf.getSelectedElements().elements();
        while (e.hasMoreElements()) {
            HyperLinkableReportElement element = (HyperLinkableReportElement)e.nextElement();
            element.setHyperlinkAnchorExpression(""+jRTextExpressionAreaAnchor.getText());
        }
    }
    
    public void jRTextExpressionAreaPageTextChanged() {
        if (this.isInit()) return;
        Enumeration e = jrf.getSelectedElements().elements();
        while (e.hasMoreElements()) {
            HyperLinkableReportElement element = (HyperLinkableReportElement)e.nextElement();
            element.setHyperlinkPageExpression(""+jRTextExpressionAreaPage.getText());
        }
    }
    
    public void jRTextExpressionAreaReferenceTextChanged() {
        if (this.isInit()) return;
        Enumeration e = jrf.getSelectedElements().elements();
        while (e.hasMoreElements()) {
            HyperLinkableReportElement element = (HyperLinkableReportElement)e.nextElement();
            element.setHyperlinkReferenceExpression(""+jRTextExpressionAreaReference.getText());
        }
    }
    
   
    public JRTextExpressionArea getJRTextExpressionArea(javax.swing.JComponent c, int x, int y) {
        JRTextExpressionArea xxx= null;
        //System.out.println(">>> " + c);
        if (c.getClass().isAssignableFrom(it.businesslogic.ireport.gui.JRTextExpressionArea.class) ) {
            if ( ((JRTextExpressionArea)c).isRequestFocusEnabled() == true && c.contains(x,y)) {
                //System.out.println( ((JRTextExpressionArea)c).getText() );
                return (JRTextExpressionArea)c;
            }
            return null;
        }
        else {
            for (int i=0; i< c.getComponentCount(); ++i) {
                Component child = c.getComponent(i);
                if (child instanceof javax.swing.JComponent) {
                    xxx = getJRTextExpressionArea((javax.swing.JComponent)child, x, y );
                    if (xxx != null) return xxx;
                }
            }
            
        }
        return null;
    }
    
   
    
    
    public void gotoTab(int tabCode ) {
        try {
            switch (tabCode) {
                case GRAPHICS_TAB:
                    jTabbedPane.setSelectedComponent( jPanelGraphicselement );
                    break;
                case RECTANGLE_TAB:
                    jTabbedPane.setSelectedComponent( jPanelRectangle);
                    break;
                case LINE_TAB:
                    jTabbedPane.setSelectedComponent( jPanelLine );
                    break;
                case IMAGE_TAB:
                    jTabbedPane.setSelectedComponent( jPanelImage );
                    break;
                case FONT_TAB:
                    jTabbedPane.setSelectedComponent( jPanelFont );
                    break;
                case STATITEXT_TAB:
                    jTabbedPane.setSelectedComponent( jPanelText );
                    break;
                case TEXTFIELD_TAB:
                    jTabbedPane.setSelectedComponent( jPanelTextField );
                    break;
                case HYPERLINK_TAB:
                    jTabbedPane.setSelectedComponent( jPanelHyperLink );
                    break;
                case SUBREPORT1_TAB:
                    jTabbedPane.setSelectedComponent( jPanelSubreport1 );
                    break;
                case SUBREPORT2_TAB:
                    jTabbedPane.setSelectedComponent( jPanelSubreport2 );
                    break;
                case CHART_TAB:
                    jTabbedPane.setSelectedComponent( jPanelChart );
                    break;
                case BARCODE_TAB:
                    jTabbedPane.setSelectedComponent( jPanelBarcode );
                    break;
                case COMMON_TAB:
                default:
                    jTabbedPane.setSelectedComponent( jPanelCommon );
                    break;
            }
            
        } catch (Exception ex) {}
    }
    
    /** Initalize the TextExpressionArea with keywords (variables, parameters
     *    and fields) from the report.
     */
    private void initExpressionArea( JRTextExpressionArea area) {
        area.getTokenMarker().setKeywordLookup(jrf.getReport().getKeywordLookup());
    }
    
    public void jTextFieldNameChanged() {
        if (this.isInit()) return;
        
        if (jrf == null || jrf.getSelectedElements().size()==0) return;
        
        Enumeration e = jrf.getSelectedElements().elements();
        ReportElement element = (ReportElement)e.nextElement();
        
        element.setKey(  jTextFieldName.getText() );
        jrf.fireReportListenerReportElementsChanged(new ReportElementChangedEvent(jrf , element , ReportElementChangedEvent.CHANGED));
        jrf.getJPanelReport().repaint();
    }
}
