/*
 * Decompiled with CFR 0.152.
 */
package it.businesslogic.ireport.undo;

import it.businesslogic.ireport.Band;
import it.businesslogic.ireport.IReportFont;
import it.businesslogic.ireport.ReportElement;
import it.businesslogic.ireport.TextReportElement;
import it.businesslogic.ireport.UndoOperation;
import it.businesslogic.ireport.undo.ITransformation;
import java.awt.Point;
import java.awt.Rectangle;

public class ElementTransformation
implements UndoOperation,
ITransformation {
    public ReportElement element;
    public Rectangle oldBounds;
    public Rectangle newBounds;
    public Band oldBand;
    public Band newBand;
    private int oldFontSize;
    private int newFontSize;

    public boolean equals(Object obj) {
        boolean isEqual = false;
        if (obj instanceof ReportElement && this.element != null) {
            isEqual = this.element.equals((ReportElement)obj);
        }
        return isEqual;
    }

    public void undo() {
        this.element.setPosition(new Point(this.oldBounds.x, this.oldBounds.y));
        this.element.setWidth(this.oldBounds.width);
        this.element.setHeight(this.oldBounds.height);
        this.element.updateBounds();
        if (this.oldBand != null) {
            this.element.setBand(this.oldBand);
        }
        if (this.element instanceof TextReportElement) {
            try {
                IReportFont font = ((TextReportElement)this.element).getIReportFont();
                font.setFontSize(this.oldFontSize);
                ((TextReportElement)this.element).setIReportFont(font);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public void redo() {
        this.element.setPosition(new Point(this.newBounds.x, this.newBounds.y));
        this.element.setWidth(this.newBounds.width);
        this.element.setHeight(this.newBounds.height);
        this.element.updateBounds();
        if (this.newBand != null) {
            this.element.setBand(this.newBand);
        }
        if (this.element instanceof TextReportElement) {
            try {
                IReportFont font = ((TextReportElement)this.element).getIReportFont();
                font.setFontSize(this.newFontSize);
                ((TextReportElement)this.element).setIReportFont(font);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public void captureCurrent(Object obj) {
        ReportElement element;
        this.element = element = (ReportElement)obj;
        this.oldBounds = new Rectangle(element.getBounds());
        this.oldBand = element.getBand();
        if (element instanceof TextReportElement) {
            this.oldFontSize = ((TextReportElement)element).getIReportFont().getFontSize();
        }
    }

    public void captureModified(Object obj) {
        ReportElement element = (ReportElement)obj;
        this.newBounds = new Rectangle(element.getBounds());
        this.newBand = element.getBand();
        if (element instanceof TextReportElement) {
            this.newFontSize = ((TextReportElement)element).getIReportFont().getFontSize();
        }
    }
}

