/*
 * Decompiled with CFR 0.152.
 */
package de.muntjak.tinylookandfeel;

import de.muntjak.tinylookandfeel.MenuItemIconFactory;
import de.muntjak.tinylookandfeel.Theme;
import de.muntjak.tinylookandfeel.TinyDefaultTheme;
import de.muntjak.tinylookandfeel.borders.TinyFrameBorder;
import de.muntjak.tinylookandfeel.borders.TinyPopupMenuBorder;
import de.muntjak.tinylookandfeel.borders.TinyScrollPaneBorder;
import de.muntjak.tinylookandfeel.borders.TinyTextFieldBorder;
import de.muntjak.tinylookandfeel.controlpanel.ControlPanel;
import de.muntjak.tinylookandfeel.skin.SkinImageCache;
import java.awt.Color;
import java.awt.Font;
import java.awt.Image;
import java.awt.Insets;
import javax.swing.ImageIcon;
import javax.swing.UIDefaults;
import javax.swing.UIManager;
import javax.swing.border.AbstractBorder;
import javax.swing.border.CompoundBorder;
import javax.swing.border.EmptyBorder;
import javax.swing.border.LineBorder;
import javax.swing.plaf.ColorUIResource;
import javax.swing.plaf.InsetsUIResource;
import javax.swing.plaf.basic.BasicBorders;
import javax.swing.plaf.metal.MetalLookAndFeel;
import javax.swing.plaf.metal.MetalTheme;

public class TinyLookAndFeel
extends MetalLookAndFeel {
    protected static TinyDefaultTheme defaultTheme;
    private static boolean isInstalled;
    private static boolean themeHasBeenSet;

    static {
        isInstalled = false;
        themeHasBeenSet = false;
        if (!ControlPanel.isInstantiated && Theme.loadTheme("Default.theme", 3)) {
            Theme.style = 3;
        }
    }

    public TinyLookAndFeel() {
        if (!isInstalled) {
            isInstalled = true;
            UIManager.installLookAndFeel(new UIManager.LookAndFeelInfo("TinyLookAndFeel", "de.muntjak.tinylookandfeel.TinyLookAndFeel"));
        }
    }

    public String getID() {
        return "TinyLookAndFeel";
    }

    public String getName() {
        return "TinyLookAndFeel";
    }

    public String getDescription() {
        return "TinyLookAndFeel: Fun w/Swing.";
    }

    public boolean isNativeLookAndFeel() {
        return false;
    }

    public final boolean isSupportedLookAndFeel() {
        return true;
    }

    public boolean getSupportsWindowDecorations() {
        return true;
    }

    protected void initClassDefaults(UIDefaults table) {
        super.initClassDefaults(table);
        table.putDefaults(new Object[]{"ButtonUI", "de.muntjak.tinylookandfeel.TinyButtonUI", "CheckBoxUI", "de.muntjak.tinylookandfeel.TinyCheckBoxUI", "TextFieldUI", "de.muntjak.tinylookandfeel.TinyTextFieldUI", "TextAreaUI", "de.muntjak.tinylookandfeel.TinyTextAreaUI", "FormattedTextFieldUI", "de.muntjak.tinylookandfeel.TinyTextFieldUI", "SliderUI", "de.muntjak.tinylookandfeel.TinySliderUI", "SpinnerUI", "de.muntjak.tinylookandfeel.TinySpinnerUI", "ToolBarUI", "de.muntjak.tinylookandfeel.TinyToolBarUI", "MenuBarUI", "de.muntjak.tinylookandfeel.TinyMenuBarUI", "MenuUI", "de.muntjak.tinylookandfeel.TinyMenuUI", "MenuItemUI", "de.muntjak.tinylookandfeel.TinyMenuItemUI", "CheckBoxMenuItemUI", "de.muntjak.tinylookandfeel.TinyCheckBoxMenuItemUI", "RadioButtonMenuItemUI", "de.muntjak.tinylookandfeel.TinyRadioButtonMenuItemUI", "ScrollBarUI", "de.muntjak.tinylookandfeel.TinyScrollBarUI", "TabbedPaneUI", "de.muntjak.tinylookandfeel.TinyTabbedPaneUI", "ToggleButtonUI", "de.muntjak.tinylookandfeel.TinyButtonUI", "ScrollPaneUI", "de.muntjak.tinylookandfeel.TinyScrollPaneUI", "ProgressBarUI", "de.muntjak.tinylookandfeel.TinyProgressBarUI", "InternalFrameUI", "de.muntjak.tinylookandfeel.TinyInternalFrameUI", "RadioButtonUI", "de.muntjak.tinylookandfeel.TinyRadioButtonUI", "ComboBoxUI", "de.muntjak.tinylookandfeel.TinyComboBoxUI", "PopupMenuSeparatorUI", "de.muntjak.tinylookandfeel.TinyPopupMenuSeparatorUI", "SplitPaneUI", "de.muntjak.tinylookandfeel.TinySplitPaneUI", "FileChooserUI", "de.muntjak.tinylookandfeel.TinyFileChooserUI", "ListUI", "de.muntjak.tinylookandfeel.TinyListUI", "TreeUI", "de.muntjak.tinylookandfeel.TinyTreeUI", "LabelUI", "de.muntjak.tinylookandfeel.TinyLabelUI", "TableUI", "de.muntjak.tinylookandfeel.TinyTableUI", "TableHeaderUI", "de.muntjak.tinylookandfeel.TinyTableHeaderUI", "ToolTipUI", "de.muntjak.tinylookandfeel.TinyToolTipUI", "RootPaneUI", "de.muntjak.tinylookandfeel.TinyRootPaneUI"});
    }

    protected void createDefaultTheme() {
        if (!themeHasBeenSet) {
            defaultTheme = new TinyDefaultTheme();
            TinyLookAndFeel.setCurrentTheme(defaultTheme);
        }
    }

    public static void setCurrentTheme(MetalTheme theme) {
        MetalLookAndFeel.setCurrentTheme(theme);
        themeHasBeenSet = true;
    }

    protected void initSystemColorDefaults(UIDefaults table) {
        super.initSystemColorDefaults(table);
        table.put("textHighlight", MetalLookAndFeel.getTextHighlightColor());
    }

    protected void initComponentDefaults(UIDefaults table) {
        super.initComponentDefaults(table);
        AbstractBorder border = new EmptyBorder(0, 0, 0, 0);
        table.put("Button.margin", new InsetsUIResource(Theme.buttonMarginTop[Theme.style], Theme.buttonMarginLeft[Theme.style], Theme.buttonMarginBottom[Theme.style], Theme.buttonMarginRight[Theme.style]));
        table.put("Button.border", new BasicBorders.MarginBorder());
        table.put("ToggleButton.margin", new InsetsUIResource(4, 16, 4, 16));
        table.put("ToggleButton.border", new BasicBorders.MarginBorder());
        table.put("TextField.border", new TinyTextFieldBorder());
        table.put("ComboBox.border", border);
        table.put("Spinner.border", new TinyTextFieldBorder(new Insets(2, 2, 2, 2)));
        border = new EmptyBorder(2, 2, 2, 2);
        table.put("ToolBar.border", border);
        table.put("InternalFrame.border", border);
        table.put("InternalFrame.paletteBorder", border);
        table.put("InternalFrame.optionDialogBorder", border);
        border = new EmptyBorder(2, 4, 2, 4);
        table.put("Menu.border", border);
        table.put("MenuItem.border", border);
        table.put("CheckBoxMenuItem.border", border);
        table.put("RadioButtonMenuItem.border", border);
        border = new TinyPopupMenuBorder();
        table.put("PopupMenu.border", border);
        table.put("ScrollPane.border", new TinyScrollPaneBorder());
        table.put("Slider.trackWidth", new Integer(4));
        table.put("SplitPane.dividerSize", new Integer(6));
        table.put("InternalFrame.paletteTitleHeight", new Integer(10));
        table.put("InternalFrame.frameTitleHeight", new Integer(21));
        table.put("InternalFrame.normalTitleFont", new Font("dialog", 1, 13));
        table.put("TabbedPane.tabInsets", new Insets(1, 6, 4, 6));
        table.put("TabbedPane.tabAreaInsets", new Insets(6, Theme.firstTabDistance[Theme.style], 0, 0));
        table.put("TabbedPane.selectedTabPadInsets", new Insets(2, 2, 1, 2));
        table.put("TabbedPane.contentBorderInsets", Theme.tabInsets[Theme.style]);
        table.put("TabbedPane.unselected", new ColorUIResource(0, 0, 0));
        table.put("PopupMenu.background", new Color(0, 255, 0));
        table.put("PopupMenu.foreground", new Color(255, 0, 0));
        table.put("TextField.selectionForeground", Color.white);
        table.put("TextField.selectionBackground", Theme.textSelectedBgColor[Theme.style]);
        table.put("TextArea.selectionForeground", Color.white);
        table.put("TextArea.selectionBackground", Theme.textSelectedBgColor[Theme.style]);
        table.put("TextField.background", Color.white);
        table.put("TextField.disabledBackground", Theme.textDisabledBgColor[Theme.style]);
        table.put("ComboBox.foreground", Color.black);
        table.put("ComboBox.background", Color.white);
        table.put("ComboBox.selectionForeground", Theme.comboSelectedTextColor[Theme.style]);
        table.put("ComboBox.selectionBackground", Theme.comboSelectedBgColor[Theme.style]);
        table.put("ComboBox.focusBackground", Theme.comboFocusBgColor[Theme.style]);
        table.put("InternalFrame.frameTitleHeight", new Integer(25));
        table.put("InternalFrame.paletteTitleHeight", new Integer(16));
        table.put("InternalFrame.icon", TinyLookAndFeel.loadIcon("XPInternalFrameIcon.png", this));
        table.put("RootPane.colorChooserDialogBorder", TinyFrameBorder.getInstance());
        table.put("RootPane.errorDialogBorder", TinyFrameBorder.getInstance());
        table.put("RootPane.fileChooserDialogBorder", TinyFrameBorder.getInstance());
        table.put("RootPane.frameBorder", TinyFrameBorder.getInstance());
        table.put("RootPane.informationDialogBorder", TinyFrameBorder.getInstance());
        table.put("RootPane.plainDialogBorder", TinyFrameBorder.getInstance());
        table.put("RootPane.questionDialogBorder", TinyFrameBorder.getInstance());
        table.put("RootPane.warningDialogBorder", TinyFrameBorder.getInstance());
        table.put("ToolTip.background", new Color(255, 255, 225));
        table.put("ToolTip.foreground", new Color(0, 0, 0));
        table.put("ToolTip.font", defaultTheme.getControlTextFont());
        table.put("ToolTip.border", new CompoundBorder(new LineBorder(Color.black, 1), new EmptyBorder(2, 2, 2, 2)));
        table.put("RadioButton.margin", new InsetsUIResource(0, 0, 0, 0));
        table.put("CheckBox.margin", new InsetsUIResource(0, 0, 0, 0));
        table.put("CheckBoxMenuItem.checkIcon", MenuItemIconFactory.getCheckBoxMenuItemIcon());
        table.put("RadioButtonMenuItem.checkIcon", MenuItemIconFactory.getRadioButtonMenuItemIcon());
        table.put("Tree.selectionForeground", Color.white);
        table.put("Tree.selectionBackground", Theme.comboSelectedBgColor[Theme.style]);
        table.put("Tree.textBackground", Theme.backColor[Theme.style]);
        table.put("Tree.expandedIcon", TinyLookAndFeel.loadIcon("XPTreeMinus.png", this));
        table.put("Tree.collapsedIcon", TinyLookAndFeel.loadIcon("XPTreePlus.png", this));
        table.put("Tree.openIcon", TinyLookAndFeel.loadIcon("XPTreeFolderOpened.png", this));
        table.put("Tree.closedIcon", TinyLookAndFeel.loadIcon("XPTreeFolderClosed.png", this));
        table.put("Tree.leafIcon", TinyLookAndFeel.loadIcon("XPTreeLeaf.png", this));
        table.put("List.selectionForeground", Theme.listSelectedTextColor);
        table.put("List.selectionBackground", Theme.listSelectedBgColor);
        table.put("FileView.directoryIcon", TinyLookAndFeel.loadIcon("XPFolderClosed.png", this));
        table.put("FileView.computerIcon", TinyLookAndFeel.loadIcon("XPComputerIcon.png", this));
        table.put("FileView.fileIcon", TinyLookAndFeel.loadIcon("XPDocument.png", this));
        table.put("FileView.floppyDriveIcon", TinyLookAndFeel.loadIcon("XPFloppy.png", this));
        table.put("FileView.hardDriveIcon", TinyLookAndFeel.loadIcon("XPHarddisk.png", this));
        table.put("FileChooser.detailsViewIcon", TinyLookAndFeel.loadIcon("XPFileDetails.png", this));
        table.put("FileChooser.homeFolderIcon", TinyLookAndFeel.loadIcon("XPDesktopIcon.png", this));
        table.put("FileChooser.listViewIcon", TinyLookAndFeel.loadIcon("XPFileList.png", this));
        table.put("FileChooser.newFolderIcon", TinyLookAndFeel.loadIcon("XPNewFolder.png", this));
        table.put("FileChooser.upFolderIcon", TinyLookAndFeel.loadIcon("XPParentDirectory.png", this));
        table.put("OptionPane.errorIcon", TinyLookAndFeel.loadIcon("XPError.png", this));
        table.put("OptionPane.informationIcon", TinyLookAndFeel.loadIcon("XPInformation.png", this));
        table.put("OptionPane.warningIcon", TinyLookAndFeel.loadIcon("XPWarning.png", this));
        table.put("OptionPane.questionIcon", TinyLookAndFeel.loadIcon("XPQuestion.png", this));
    }

    public static ImageIcon loadIcon(String file, Object invoker) {
        return TinyLookAndFeel.loadIconImmediately(file, invoker);
    }

    public static ImageIcon loadIconImmediately(String file, Object invoker) {
        try {
            Image img = SkinImageCache.getInstance().getImage(file);
            ImageIcon icon = new ImageIcon(img);
            if (icon.getIconWidth() <= 0) {
                System.out.println("******************** File " + file + " not found. Exiting");
                System.exit(1);
            }
            return icon;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            System.out.println("Error getting resource " + file);
            return null;
        }
    }

    public static Color getLightControl() {
        return defaultTheme.getControlHighlight();
    }

    public static Color getDarkControl() {
        return defaultTheme.getDarkControl();
    }
}

