/*
 * Decompiled with CFR 0.152.
 */
package it.businesslogic.ireport.gui;

import it.businesslogic.ireport.CompatibilitySupport;
import it.businesslogic.ireport.gui.JRVersionItem;
import it.businesslogic.ireport.gui.MainFrame;
import it.businesslogic.ireport.util.Misc;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.Properties;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.border.EtchedBorder;
import javax.swing.border.TitledBorder;

public class CompatibilityDialog
extends JDialog {
    MainFrame mf = null;
    private ButtonGroup buttonGroup1;
    private JButton jButtonCancel;
    private JButton jButtonOk;
    private JComboBox jComboBox1;
    private JPanel jPanel1;
    private JPanel jPanel2;
    private JPanel jPanel9;

    public CompatibilityDialog(Frame parent, boolean modal) {
        super(parent, modal);
        this.mf = (MainFrame)parent;
        this.initComponents();
        this.setSize(330, 150);
        this.jComboBox1.addItem(new JRVersionItem(60, "JasperReports 0.6.0"));
        this.jComboBox1.addItem(new JRVersionItem(61, "JasperReports 0.6.1"));
        this.jComboBox1.addItem(new JRVersionItem(62, "JasperReports 0.6.2"));
        this.jComboBox1.addItem(new JRVersionItem(63, "JasperReports 0.6.3"));
        this.jComboBox1.addItem(new JRVersionItem(64, "JasperReports 0.6.4 - 0.6.5"));
        this.jComboBox1.addItem(new JRVersionItem(66, "JasperReports 0.6.6"));
        this.jComboBox1.addItem(new JRVersionItem(67, "JasperReports 0.6.7 - 0.6.8"));
        this.jComboBox1.addItem(new JRVersionItem(69, "JasperReports 0.6.9"));
        this.jComboBox1.addItem(new JRVersionItem(100, "JasperReports 1.0.0"));
        this.jComboBox1.addItem(new JRVersionItem(999999, "Last available version"));
        this.load();
        Misc.centerFrame(this);
    }

    private void initComponents() {
        this.buttonGroup1 = new ButtonGroup();
        this.jPanel1 = new JPanel();
        this.jPanel9 = new JPanel();
        this.jComboBox1 = new JComboBox();
        this.jPanel2 = new JPanel();
        this.jButtonOk = new JButton();
        this.jButtonCancel = new JButton();
        this.setTitle("Compatibility options");
        this.setResizable(false);
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent evt) {
                CompatibilityDialog.this.closeDialog(evt);
            }
        });
        this.jPanel1.setLayout(new BorderLayout());
        this.jPanel9.setLayout(new GridBagLayout());
        this.jPanel9.setBorder(new TitledBorder(new EtchedBorder(), "JasperReports Version Compatibility", 0, 0, new Font("Dialog", 0, 11)));
        this.jPanel9.setMinimumSize(new Dimension(250, 150));
        this.jPanel9.setPreferredSize(new Dimension(250, 150));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        this.jPanel9.add((Component)this.jComboBox1, gridBagConstraints);
        this.jPanel1.add((Component)this.jPanel9, "Center");
        this.getContentPane().add((Component)this.jPanel1, "Center");
        this.jPanel2.setLayout(new FlowLayout(2));
        this.jButtonOk.setFont(new Font("Dialog", 0, 11));
        this.jButtonOk.setMnemonic('o');
        this.jButtonOk.setText("Ok");
        this.jButtonOk.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                CompatibilityDialog.this.jButtonOkActionPerformed(evt);
            }
        });
        this.jPanel2.add(this.jButtonOk);
        this.jButtonCancel.setFont(new Font("Dialog", 0, 11));
        this.jButtonCancel.setText("Cancel");
        this.jButtonCancel.setMnemonic('c');
        this.jButtonCancel.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                CompatibilityDialog.this.jButtonCancelActionPerformed(evt);
            }
        });
        this.jPanel2.add(this.jButtonCancel);
        this.getContentPane().add((Component)this.jPanel2, "South");
        this.pack();
    }

    private void jButtonCancelActionPerformed(ActionEvent evt) {
        this.close();
    }

    private void jButtonOkActionPerformed(ActionEvent evt) {
        this.save();
        this.close();
    }

    private void closeDialog(WindowEvent evt) {
    }

    private void load() {
        if (this.mf == null || this.mf.getProperties() == null) {
            return;
        }
        Properties prop = this.mf.getProperties();
        try {
            for (int i = 0; i < this.jComboBox1.getItemCount(); ++i) {
                JRVersionItem jvi = (JRVersionItem)this.jComboBox1.getItemAt(i);
                if (jvi.getVersion() != CompatibilitySupport.version) continue;
                this.jComboBox1.setSelectedIndex(i);
                break;
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    private void save() {
        if (this.mf == null || this.mf.getProperties() == null) {
            return;
        }
        Properties prop = this.mf.getProperties();
        try {
            int compatibility = 999999;
            if (this.jComboBox1.getSelectedItem() != null) {
                compatibility = ((JRVersionItem)this.jComboBox1.getSelectedItem()).getVersion();
            }
            CompatibilitySupport.version = compatibility;
            prop.put("Compatibility", "" + compatibility);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    private void close() {
        this.setVisible(false);
        this.dispose();
    }

    public static void main(String[] args) {
        new CompatibilityDialog((Frame)new JFrame(), true).show();
    }
}

