/*
 * Decompiled with CFR 0.152.
 */
package it.businesslogic.ireport.undo;

import it.businesslogic.ireport.ReportElement;
import it.businesslogic.ireport.UndoOperation;
import it.businesslogic.ireport.gui.JReportFrame;
import it.businesslogic.ireport.gui.event.ReportElementChangedEvent;
import it.businesslogic.ireport.undo.PasteStyledElementItem;
import java.util.Enumeration;
import java.util.Vector;

public class PasteStyleOperation
implements UndoOperation {
    private Vector transformations = new Vector();
    private JReportFrame jrf = null;

    public PasteStyleOperation(JReportFrame jrf) {
        this.jrf = jrf;
    }

    public void redo() {
        if (this.jrf == null) {
            return;
        }
        Enumeration e = this.getTransformations().elements();
        while (e.hasMoreElements()) {
            PasteStyledElementItem ri = (PasteStyledElementItem)e.nextElement();
            ReportElement element = ri.getElement();
            JReportFrame.applyStyle(element, ri.getNewStyle());
            this.jrf.fireReportListenerReportElementsChanged(new ReportElementChangedEvent(this.jrf, element, 3));
        }
        this.jrf.getMainFrame().getElementPropertiesDialog().updateSelection();
        this.jrf.getReportPanel().repaint();
    }

    public void undo() {
        if (this.jrf == null) {
            return;
        }
        Enumeration e = this.getTransformations().elements();
        while (e.hasMoreElements()) {
            PasteStyledElementItem ri = (PasteStyledElementItem)e.nextElement();
            ReportElement element = ri.getElement();
            JReportFrame.applyStyle(element, ri.getOriginalStyle());
            this.jrf.fireReportListenerReportElementsChanged(new ReportElementChangedEvent(this.jrf, element, 3));
        }
        this.jrf.getMainFrame().getElementPropertiesDialog().updateSelection();
        this.jrf.getReportPanel().repaint();
    }

    public String toString() {
        return "paste style";
    }

    public Vector getTransformations() {
        return this.transformations;
    }

    public void setTransformations(Vector transformations) {
        this.transformations = transformations;
    }

    public void addElement(ReportElement element, ReportElement originalStyle, ReportElement newStyle) {
        PasteStyledElementItem et = new PasteStyledElementItem(element, originalStyle, newStyle);
        this.getTransformations().add(et);
    }
}

