/*
 * Decompiled with CFR 0.152.
 */
package org.hsqldb;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.StringWriter;
import java.sql.SQLException;
import org.hsqldb.Trace;

class StringConverter {
    private static final char[] HEXCHAR = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'a', 'b', 'c', 'd', 'e', 'f'};
    private static final String HEXINDEX = "0123456789abcdef          ABCDEF";

    StringConverter() {
    }

    public static byte[] hexToByte(String string) {
        int n = string.length() / 2;
        byte[] byArray = new byte[n];
        int n2 = 0;
        int n3 = 0;
        while (n3 < n) {
            char c = string.charAt(n2++);
            int n4 = HEXINDEX.indexOf(c);
            int n5 = (n4 & 0xF) << 4;
            c = string.charAt(n2++);
            n4 = HEXINDEX.indexOf(c);
            byArray[n3] = (byte)(n5 += n4 & 0xF);
            ++n3;
        }
        return byArray;
    }

    static String byteToHex(byte[] byArray) {
        int n = byArray.length;
        StringBuffer stringBuffer = new StringBuffer();
        int n2 = 0;
        while (n2 < n) {
            int n3 = byArray[n2] & 0xFF;
            stringBuffer.append(HEXCHAR[n3 >> 4 & 0xF]);
            stringBuffer.append(HEXCHAR[n3 & 0xF]);
            ++n2;
        }
        return stringBuffer.toString();
    }

    static String unicodeToHexString(String string) {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        DataOutputStream dataOutputStream = new DataOutputStream(byteArrayOutputStream);
        try {
            dataOutputStream.writeUTF(string);
            dataOutputStream.close();
            byteArrayOutputStream.close();
        }
        catch (IOException iOException) {
            return null;
        }
        return StringConverter.byteToHex(byteArrayOutputStream.toByteArray());
    }

    public static String hexStringToUnicode(String string) {
        byte[] byArray = StringConverter.hexToByte(string);
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray);
        DataInputStream dataInputStream = new DataInputStream(byteArrayInputStream);
        try {
            return dataInputStream.readUTF();
        }
        catch (IOException iOException) {
            return null;
        }
    }

    public static String unicodeToAscii(String string) {
        if (string == null || string.equals("")) {
            return string;
        }
        int n = string.length();
        StringBuffer stringBuffer = new StringBuffer(n);
        int n2 = 0;
        while (n2 < n) {
            char c = string.charAt(n2);
            if (c == '\\') {
                if (n2 < n - 1 && string.charAt(n2 + 1) == 'u') {
                    stringBuffer.append(c);
                    stringBuffer.append("u005c");
                } else {
                    stringBuffer.append(c);
                }
            } else if (c >= ' ' && c <= '\u007f') {
                stringBuffer.append(c);
            } else {
                stringBuffer.append("\\u");
                stringBuffer.append(HEXCHAR[c >> 12 & 0xF]);
                stringBuffer.append(HEXCHAR[c >> 8 & 0xF]);
                stringBuffer.append(HEXCHAR[c >> 4 & 0xF]);
                stringBuffer.append(HEXCHAR[c & 0xF]);
            }
            ++n2;
        }
        return stringBuffer.toString();
    }

    public static String asciiToUnicode(String string) {
        if (string == null || string.indexOf("\\u") == -1) {
            return string;
        }
        int n = string.length();
        char[] cArray = new char[n];
        int n2 = 0;
        int n3 = 0;
        while (n3 < n) {
            char c = string.charAt(n3);
            if (c != '\\' || n3 == n - 1) {
                cArray[n2++] = c;
            } else if ((c = string.charAt(++n3)) != 'u' || n3 == n - 1) {
                cArray[n2++] = 92;
                cArray[n2++] = c;
            } else {
                int n4 = (HEXINDEX.indexOf(string.charAt(++n3)) & 0xF) << 12;
                n4 += (HEXINDEX.indexOf(string.charAt(++n3)) & 0xF) << 8;
                n4 += (HEXINDEX.indexOf(string.charAt(++n3)) & 0xF) << 4;
                cArray[n2++] = (char)(n4 += HEXINDEX.indexOf(string.charAt(++n3)) & 0xF);
            }
            ++n3;
        }
        return new String(cArray, 0, n2);
    }

    public static String InputStreamToString(InputStream inputStream) throws SQLException {
        InputStreamReader inputStreamReader = new InputStreamReader(inputStream);
        StringWriter stringWriter = new StringWriter();
        int n = 8192;
        char[] cArray = new char[n];
        try {
            int n2;
            while ((n2 = inputStreamReader.read(cArray, 0, n)) != -1) {
                stringWriter.write(cArray, 0, n2);
            }
            stringWriter.close();
            inputStream.close();
        }
        catch (IOException iOException) {
            throw Trace.error(32, iOException.getMessage());
        }
        return stringWriter.toString();
    }
}

