/*
 * Decompiled with CFR 0.152.
 */
package com.lowagie.text.pdf;

import com.lowagie.text.DocWriter;
import com.lowagie.text.DocumentException;
import com.lowagie.text.ExceptionConverter;
import com.lowagie.text.Image;
import com.lowagie.text.Rectangle;
import com.lowagie.text.pdf.AcroFields;
import com.lowagie.text.pdf.ByteBuffer;
import com.lowagie.text.pdf.FdfReader;
import com.lowagie.text.pdf.PdfAction;
import com.lowagie.text.pdf.PdfAnnotation;
import com.lowagie.text.pdf.PdfContentByte;
import com.lowagie.text.pdf.PdfDictionary;
import com.lowagie.text.pdf.PdfEncodings;
import com.lowagie.text.pdf.PdfException;
import com.lowagie.text.pdf.PdfImportedPage;
import com.lowagie.text.pdf.PdfName;
import com.lowagie.text.pdf.PdfReader;
import com.lowagie.text.pdf.PdfSigGenericPKCS;
import com.lowagie.text.pdf.PdfSignatureAppearance;
import com.lowagie.text.pdf.PdfStamperImp;
import com.lowagie.text.pdf.PdfString;
import com.lowagie.text.pdf.PdfTransition;
import com.lowagie.text.pdf.PdfWriter;
import java.io.EOFException;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.RandomAccessFile;
import java.security.SignatureException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;

public class PdfStamper {
    protected PdfStamperImp stamper;
    private HashMap moreInfo;
    private boolean hasSignature;
    private PdfSignatureAppearance sigApp;

    public PdfStamper(PdfReader reader, OutputStream os) throws DocumentException, IOException {
        this.stamper = new PdfStamperImp(reader, os, '\u0000', false);
    }

    public PdfStamper(PdfReader reader, OutputStream os, char pdfVersion) throws DocumentException, IOException {
        this.stamper = new PdfStamperImp(reader, os, pdfVersion, false);
    }

    public PdfStamper(PdfReader reader, OutputStream os, char pdfVersion, boolean append) throws DocumentException, IOException {
        this.stamper = new PdfStamperImp(reader, os, pdfVersion, append);
    }

    public HashMap getMoreInfo() {
        return this.moreInfo;
    }

    public void setMoreInfo(HashMap moreInfo) {
        this.moreInfo = moreInfo;
    }

    public void insertPage(int pageNumber, Rectangle mediabox) {
        this.stamper.insertPage(pageNumber, mediabox);
    }

    public PdfSignatureAppearance getSignatureAppearance() {
        return this.sigApp;
    }

    private String getNewSigName() {
        AcroFields af = this.getAcroFields();
        String name = "Signature";
        int step = 0;
        boolean found = false;
        block0: while (!found) {
            String n1 = String.valueOf(name) + ++step;
            if (af.getFieldItem(n1) != null) continue;
            n1 = String.valueOf(n1) + ".";
            found = true;
            Iterator it = af.getFields().keySet().iterator();
            while (it.hasNext()) {
                String fn = (String)it.next();
                if (!fn.startsWith(n1)) continue;
                found = false;
                continue block0;
            }
        }
        name = String.valueOf(name) + step;
        return name;
    }

    public void close() throws DocumentException, IOException {
        if (!this.hasSignature) {
            this.stamper.close(this.moreInfo);
            return;
        }
        this.sigApp.preClose();
        PdfSigGenericPKCS sig = this.sigApp.getSigStandard();
        byte[] buf = new byte[8192];
        InputStream inp = this.sigApp.getRangeStream();
        try {
            int n;
            while ((n = inp.read(buf)) > 0) {
                sig.getSigner().update(buf, 0, n);
            }
        }
        catch (SignatureException se) {
            throw new ExceptionConverter(se);
        }
        PdfString str = new PdfString(sig.getSignerContents());
        str.setHexWriting(true);
        PdfDictionary dic = new PdfDictionary();
        dic.put(PdfName.CONTENTS, str);
        this.sigApp.close(dic);
        this.stamper.reader.close();
    }

    private static int indexArray(byte[] bout, int position, String search) {
        byte[] ss = PdfEncodings.convertToBytes(search, null);
        while (true) {
            int k = 0;
            while (k < ss.length) {
                if (ss[k] != bout[position + k]) break;
                ++k;
            }
            if (k == ss.length) {
                return position;
            }
            ++position;
        }
    }

    private static int indexFile(RandomAccessFile raf, int position, String search) throws IOException {
        byte[] ss = PdfEncodings.convertToBytes(search, null);
        while (true) {
            raf.seek(position);
            int k = 0;
            while (k < ss.length) {
                int b = raf.read();
                if (b < 0) {
                    throw new EOFException("Unexpected EOF");
                }
                if (ss[k] != (byte)b) break;
                ++k;
            }
            if (k == ss.length) {
                return position;
            }
            ++position;
        }
    }

    public PdfContentByte getUnderContent(int pageNum) {
        return this.stamper.getUnderContent(pageNum);
    }

    public PdfContentByte getOverContent(int pageNum) {
        return this.stamper.getOverContent(pageNum);
    }

    public boolean isRotateContents() {
        return this.stamper.isRotateContents();
    }

    public void setRotateContents(boolean rotateContents) {
        this.stamper.setRotateContents(rotateContents);
    }

    public void setEncryption(byte[] userPassword, byte[] ownerPassword, int permissions, boolean strength128Bits) throws DocumentException {
        if (this.stamper.isAppend()) {
            throw new DocumentException("Append mode does not support encryption.");
        }
        if (this.stamper.isContentWritten()) {
            throw new DocumentException("Content was already written to the output.");
        }
        this.stamper.setEncryption(userPassword, ownerPassword, permissions, strength128Bits);
    }

    public void setEncryption(boolean strength, String userPassword, String ownerPassword, int permissions) throws DocumentException {
        this.setEncryption(DocWriter.getISOBytes(userPassword), DocWriter.getISOBytes(ownerPassword), permissions, strength);
    }

    public PdfImportedPage getImportedPage(PdfReader reader, int pageNumber) {
        return this.stamper.getImportedPage(reader, pageNumber);
    }

    public PdfWriter getWriter() {
        return this.stamper;
    }

    public PdfReader getReader() {
        return this.stamper.reader;
    }

    public AcroFields getAcroFields() {
        return this.stamper.getAcroFields();
    }

    public void setFormFlattening(boolean flat) {
        this.stamper.setFormFlattening(flat);
    }

    public void addAnnotation(PdfAnnotation annot, int page) {
        this.stamper.addAnnotation(annot, page);
    }

    public void addComments(FdfReader fdf) throws IOException {
        this.stamper.addComments(fdf);
    }

    public void setOutlines(List outlines) throws IOException {
        this.stamper.setOutlines(outlines);
    }

    public void setThumbnail(Image image, int page) throws PdfException, DocumentException {
        this.stamper.setThumbnail(image, page);
    }

    public boolean partialFormFlattening(String name) {
        return this.stamper.partialFormFlattening(name);
    }

    public void addJavaScript(String js) {
        this.stamper.addJavaScript(js, !PdfEncodings.isPdfDocEncoding(js));
    }

    public void setViewerPreferences(int preferences) {
        this.stamper.setViewerPreferences(preferences);
    }

    public boolean isFullCompression() {
        return this.stamper.isFullCompression();
    }

    public void setFullCompression() {
        if (this.stamper.isAppend()) {
            return;
        }
        this.stamper.setFullCompression();
    }

    public void setPageAction(PdfName actionType, PdfAction action, int page) throws PdfException {
        this.stamper.setPageAction(actionType, action, page);
    }

    public void setDuration(int seconds, int page) {
        this.stamper.setDuration(seconds, page);
    }

    public void setTransition(PdfTransition transition, int page) {
        this.stamper.setTransition(transition, page);
    }

    public static PdfStamper createSignature(PdfReader reader, OutputStream os, char pdfVersion, File tempFile, boolean append) throws DocumentException, IOException {
        PdfStamper stp;
        if (tempFile == null) {
            ByteBuffer bout = new ByteBuffer();
            stp = new PdfStamper(reader, bout, pdfVersion, append);
            stp.sigApp = new PdfSignatureAppearance(stp.stamper);
            stp.sigApp.setSigout(bout);
        } else {
            if (tempFile.isDirectory()) {
                tempFile = File.createTempFile("pdf", null, tempFile);
            }
            FileOutputStream fout = new FileOutputStream(tempFile);
            stp = new PdfStamper(reader, fout, pdfVersion, append);
            stp.sigApp = new PdfSignatureAppearance(stp.stamper);
            stp.sigApp.setTempFile(tempFile);
        }
        stp.sigApp.setOriginalout(os);
        stp.sigApp.setStamper(stp);
        stp.hasSignature = true;
        return stp;
    }

    public static PdfStamper createSignature(PdfReader reader, OutputStream os, char pdfVersion) throws DocumentException, IOException {
        return PdfStamper.createSignature(reader, os, pdfVersion, null, false);
    }

    public static PdfStamper createSignature(PdfReader reader, OutputStream os, char pdfVersion, File tempFile) throws DocumentException, IOException {
        return PdfStamper.createSignature(reader, os, pdfVersion, tempFile, false);
    }
}

