/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.engine.base;

import java.io.Serializable;
import java.util.HashSet;
import java.util.List;
import java.util.Random;
import net.sf.jasperreports.engine.JRPrintElement;
import net.sf.jasperreports.engine.JRVirtualizable;
import net.sf.jasperreports.engine.JRVirtualizer;
import net.sf.jasperreports.engine.JasperPrint;
import net.sf.jasperreports.engine.base.JRBasePrintPage;

public class JRVirtualPrintPage
extends JRBasePrintPage
implements JRVirtualizable {
    private static final long serialVersionUID = 10101L;
    private static final Random random = new Random(System.currentTimeMillis());
    private static short counter = 1;
    private final String uid;
    private transient JRVirtualizer virtualizer;
    private transient IdentityDataProvider[] identityProviders;

    public JRVirtualPrintPage(JasperPrint printObject, JRVirtualizer virtualizer) {
        this.uid = JRVirtualPrintPage.makeUID(printObject);
        this.virtualizer = virtualizer;
        this.identityProviders = null;
        if (virtualizer != null) {
            virtualizer.registerObject(this);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String makeUID(JasperPrint printObject) {
        Random random = JRVirtualPrintPage.random;
        synchronized (random) {
            short s = counter;
            counter = (short)(s + 1);
            return Integer.toString(System.identityHashCode(printObject)) + "_" + printObject.getPages().size() + "_" + Integer.toString(s) + "_" + Integer.toString(JRVirtualPrintPage.random.nextInt());
        }
    }

    public final String getUID() {
        return this.uid;
    }

    public void setVirtualData(Object o) {
        super.setElements((List)o);
    }

    public Object getVirtualData() {
        return super.getElements();
    }

    public void removeVirtualData() {
        super.setElements(null);
    }

    public void setIdentityData(Object o) {
        if (this.identityProviders != null) {
            for (int i = 0; i < this.identityProviders.length; ++i) {
                this.identityProviders[i].setIdentityData(this, (ObjectIDPair[])o);
            }
        }
    }

    public Object getIdentityData() {
        ObjectIDPair[] data;
        if (this.identityProviders != null) {
            if (this.identityProviders.length == 1) {
                data = this.identityProviders[0].getIdentityData(this);
            } else if (this.identityProviders.length > 1) {
                HashSet<ObjectIDPair> list = new HashSet<ObjectIDPair>();
                for (int i = 0; i < this.identityProviders.length; ++i) {
                    ObjectIDPair[] pairs = this.identityProviders[i].getIdentityData(this);
                    if (pairs == null) continue;
                    for (int j = 0; j < pairs.length; ++j) {
                        list.add(pairs[j]);
                    }
                }
                data = list.toArray(new ObjectIDPair[list.size()]);
            } else {
                data = null;
            }
        } else {
            data = null;
        }
        return data;
    }

    public boolean isVirtualized() {
        return super.getElements() == null;
    }

    public void setVirtualizer(JRVirtualizer virtualizer) {
        this.virtualizer = virtualizer;
    }

    public JRVirtualizer getVirtualizer() {
        return this.virtualizer;
    }

    public void addIdentityDataProvider(IdentityDataProvider p) {
        if (this.identityProviders == null) {
            this.identityProviders = new IdentityDataProvider[]{p};
        } else {
            IdentityDataProvider[] newList = new IdentityDataProvider[this.identityProviders.length + 1];
            System.arraycopy(this.identityProviders, 0, newList, 0, this.identityProviders.length);
            newList[this.identityProviders.length] = p;
            this.identityProviders = newList;
        }
    }

    public void removeIdentityDataProvider(IdentityDataProvider p) {
        if (this.identityProviders != null) {
            for (int idx = 0; idx < this.identityProviders.length; ++idx) {
                if (this.identityProviders[idx] != p) continue;
                IdentityDataProvider[] newList = new IdentityDataProvider[this.identityProviders.length - 1];
                System.arraycopy(this.identityProviders, 0, newList, 0, idx);
                int remaining = this.identityProviders.length - idx - 1;
                if (remaining > 0) {
                    System.arraycopy(this.identityProviders, idx + 1, newList, idx, remaining);
                }
                this.identityProviders = newList;
                break;
            }
        }
    }

    public List getElements() {
        if (this.virtualizer != null) {
            if (this.isVirtualized()) {
                this.virtualizer.requestData(this);
            } else {
                this.virtualizer.touch(this);
            }
        }
        return super.getElements();
    }

    public void setElements(List elements) {
        if (this.virtualizer != null) {
            if (this.isVirtualized()) {
                this.virtualizer.clearData(this);
            } else {
                this.virtualizer.touch(this);
            }
        }
        super.setElements(elements);
    }

    public void addElement(JRPrintElement element) {
        if (this.virtualizer != null) {
            if (this.isVirtualized()) {
                this.virtualizer.requestData(this);
            } else {
                this.virtualizer.touch(this);
            }
        }
        super.addElement(element);
    }

    public static interface IdentityDataProvider {
        public ObjectIDPair[] getIdentityData(JRVirtualPrintPage var1);

        public void setIdentityData(JRVirtualPrintPage var1, ObjectIDPair[] var2);
    }

    public static class ObjectIDPair
    implements Serializable {
        private static final long serialVersionUID = 10101L;
        private final Object o;
        private final int id;

        public ObjectIDPair(Object o) {
            this.o = o;
            this.id = System.identityHashCode(o);
        }

        public Object getObject() {
            return this.o;
        }

        public int getIdentity() {
            return this.id;
        }
    }
}

