/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.engine.fill;

import java.sql.PreparedStatement;
import java.util.HashMap;
import java.util.Map;
import net.sf.jasperreports.engine.JRException;
import net.sf.jasperreports.engine.JRPrintImage;
import net.sf.jasperreports.engine.JRPrintPage;

public class JRFillContext {
    private Map loadedImages = new HashMap();
    private boolean usingVirtualizer = false;
    private boolean perPageBoundElements = false;
    private JRPrintPage printPage = null;
    private boolean ignorePagination = false;
    private PreparedStatement runningStatement;

    public boolean hasLoadedImage(Object source) {
        return this.loadedImages.containsKey(source);
    }

    public JRPrintImage getLoadedImage(Object source) {
        return (JRPrintImage)this.loadedImages.get(source);
    }

    public void registerLoadedImage(Object source, JRPrintImage image) {
        this.loadedImages.put(source, image);
    }

    public void setUsingVirtualizer(boolean usingVirtualizer) {
        this.usingVirtualizer = usingVirtualizer;
    }

    public boolean isUsingVirtualizer() {
        return this.usingVirtualizer;
    }

    public void setPerPageBoundElements(boolean perPageBoundElements) {
        this.perPageBoundElements = perPageBoundElements;
    }

    public boolean isPerPageBoundElements() {
        return this.perPageBoundElements;
    }

    public void setPrintPage(JRPrintPage page) {
        this.printPage = page;
    }

    public JRPrintPage getPrintPage() {
        return this.printPage;
    }

    public void setIgnorePagination(boolean ignorePagination) {
        this.ignorePagination = ignorePagination;
    }

    public boolean isIgnorePagination() {
        return this.ignorePagination;
    }

    public synchronized void setRunningStatement(PreparedStatement runningStatement) {
        this.runningStatement = runningStatement;
    }

    public synchronized void clearRunningStatement() {
        this.runningStatement = null;
    }

    public synchronized boolean cancelRunningStatement() throws JRException {
        if (this.runningStatement != null) {
            try {
                this.runningStatement.cancel();
                return true;
            }
            catch (Throwable t) {
                throw new JRException("Error cancelling SQL statement", t);
            }
        }
        return false;
    }
}

