/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.engine.fill;

import java.io.IOException;
import java.text.DateFormat;
import java.text.DecimalFormat;
import java.text.Format;
import java.text.NumberFormat;
import java.text.SimpleDateFormat;
import java.util.Locale;
import java.util.Map;
import net.sf.jasperreports.engine.JRAbstractObjectFactory;
import net.sf.jasperreports.engine.JRChild;
import net.sf.jasperreports.engine.JRException;
import net.sf.jasperreports.engine.JRExpression;
import net.sf.jasperreports.engine.JRExpressionCollector;
import net.sf.jasperreports.engine.JRGroup;
import net.sf.jasperreports.engine.JRPrintElement;
import net.sf.jasperreports.engine.JRPrintText;
import net.sf.jasperreports.engine.JRTextField;
import net.sf.jasperreports.engine.fill.JRBaseFiller;
import net.sf.jasperreports.engine.fill.JRCloneable;
import net.sf.jasperreports.engine.fill.JRFillCloneFactory;
import net.sf.jasperreports.engine.fill.JRFillObjectFactory;
import net.sf.jasperreports.engine.fill.JRFillTextElement;
import net.sf.jasperreports.engine.fill.JRTemplatePrintText;
import net.sf.jasperreports.engine.fill.JRTemplateText;
import net.sf.jasperreports.engine.xml.JRXmlWriter;

public class JRFillTextField
extends JRFillTextElement
implements JRTextField {
    private JRGroup evaluationGroup = null;
    private Format format = null;
    private String anchorName = null;
    private String hyperlinkReference = null;
    private String hyperlinkAnchor = null;
    private Integer hyperlinkPage = null;
    static /* synthetic */ Class class$java$util$Date;
    static /* synthetic */ Class class$java$lang$Number;

    protected JRFillTextField(JRBaseFiller filler, JRTextField textField, JRFillObjectFactory factory) {
        super(filler, textField, factory);
        Class expressionClass;
        JRExpression expression = this.getExpression();
        if (expression != null && ((class$java$util$Date == null ? (class$java$util$Date = JRFillTextField.class$("java.util.Date")) : class$java$util$Date).isAssignableFrom(expressionClass = expression.getValueClass()) || (class$java$lang$Number == null ? (class$java$lang$Number = JRFillTextField.class$("java.lang.Number")) : class$java$lang$Number).isAssignableFrom(expressionClass))) {
            filler.formattedTextFields.add(this);
        }
        this.evaluationGroup = factory.getGroup(textField.getEvaluationGroup());
    }

    protected JRFillTextField(JRFillTextField textField, JRFillCloneFactory factory) {
        super(textField, factory);
        this.format = textField.format;
        this.evaluationGroup = textField.evaluationGroup;
    }

    public boolean isStretchWithOverflow() {
        return ((JRTextField)this.parent).isStretchWithOverflow();
    }

    public void setStretchWithOverflow(boolean isStretchWithOverflow) {
    }

    public byte getEvaluationTime() {
        return ((JRTextField)this.parent).getEvaluationTime();
    }

    public String getPattern() {
        return ((JRTextField)this.parent).getPattern();
    }

    public String getOwnPattern() {
        return ((JRTextField)this.parent).getOwnPattern();
    }

    public void setPattern(String pattern) {
    }

    public boolean isBlankWhenNull() {
        return ((JRTextField)this.parent).isBlankWhenNull();
    }

    public Boolean isOwnBlankWhenNull() {
        return ((JRTextField)this.parent).isOwnBlankWhenNull();
    }

    public void setBlankWhenNull(boolean isBlank) {
    }

    public void setBlankWhenNull(Boolean isBlank) {
    }

    public byte getHyperlinkType() {
        return ((JRTextField)this.parent).getHyperlinkType();
    }

    public byte getHyperlinkTarget() {
        return ((JRTextField)this.parent).getHyperlinkTarget();
    }

    public JRGroup getEvaluationGroup() {
        return this.evaluationGroup;
    }

    public JRExpression getExpression() {
        return ((JRTextField)this.parent).getExpression();
    }

    public JRExpression getAnchorNameExpression() {
        return ((JRTextField)this.parent).getAnchorNameExpression();
    }

    public JRExpression getHyperlinkReferenceExpression() {
        return ((JRTextField)this.parent).getHyperlinkReferenceExpression();
    }

    public JRExpression getHyperlinkAnchorExpression() {
        return ((JRTextField)this.parent).getHyperlinkAnchorExpression();
    }

    public JRExpression getHyperlinkPageExpression() {
        return ((JRTextField)this.parent).getHyperlinkPageExpression();
    }

    protected String getAnchorName() {
        return this.anchorName;
    }

    protected String getHyperlinkReference() {
        return this.hyperlinkReference;
    }

    protected String getHyperlinkAnchor() {
        return this.hyperlinkAnchor;
    }

    protected Integer getHyperlinkPage() {
        return this.hyperlinkPage;
    }

    protected JRTemplateText getJRTemplateText() {
        if (this.template == null) {
            this.template = new JRTemplateText(this.filler.getJasperPrint().getDefaultStyleProvider(), (JRTextField)this.parent);
        }
        return (JRTemplateText)this.template;
    }

    protected void evaluate(byte evaluation) throws JRException {
        this.reset();
        this.evaluatePrintWhenExpression(evaluation);
        if ((this.isPrintWhenExpressionNull() || !this.isPrintWhenExpressionNull() && this.isPrintWhenTrue()) && this.getEvaluationTime() == 1) {
            this.evaluateText(evaluation);
        }
    }

    protected void evaluateText(byte evaluation) throws JRException {
        Object textFieldValue = this.evaluateExpression(this.getExpression(), evaluation);
        if (textFieldValue == null) {
            if (this.isBlankWhenNull()) {
                textFieldValue = "";
            }
        } else if (this.format != null) {
            textFieldValue = this.format.format(textFieldValue);
        }
        String newRawText = String.valueOf(textFieldValue);
        String oldRawText = this.getRawText();
        this.setRawText(newRawText);
        this.setTextStart(0);
        this.setTextEnd(0);
        this.setValueRepeating(oldRawText == null && newRawText == null || oldRawText != null && oldRawText.equals(newRawText));
        this.anchorName = (String)this.evaluateExpression(this.getAnchorNameExpression(), evaluation);
        this.hyperlinkReference = (String)this.evaluateExpression(this.getHyperlinkReferenceExpression(), evaluation);
        this.hyperlinkAnchor = (String)this.evaluateExpression(this.getHyperlinkAnchorExpression(), evaluation);
        this.hyperlinkPage = (Integer)this.evaluateExpression(this.getHyperlinkPageExpression(), evaluation);
    }

    protected boolean prepare(int availableStretchHeight, boolean isOverflow) throws JRException {
        boolean willOverflow = false;
        super.prepare(availableStretchHeight, isOverflow);
        if (!this.isToPrint()) {
            return willOverflow;
        }
        boolean isToPrint = true;
        boolean isReprinted = false;
        if (this.getEvaluationTime() == 1) {
            if (isOverflow) {
                if (this.getPositionType() == 3) {
                    this.setTextStart(0);
                    this.setTextEnd(0);
                }
                if ((this.getTextEnd() >= this.getText().length() || !this.isStretchWithOverflow() || this.getRotation() != 0) && this.isAlreadyPrinted()) {
                    if (this.isPrintWhenDetailOverflows()) {
                        this.setTextStart(0);
                        this.setTextEnd(0);
                        isReprinted = true;
                    } else {
                        isToPrint = false;
                    }
                }
                if (isToPrint && this.isPrintWhenExpressionNull() && !this.isPrintRepeatedValues() && this.isValueRepeating()) {
                    isToPrint = false;
                }
            } else if (!(!this.isPrintWhenExpressionNull() || this.isPrintRepeatedValues() || !this.isValueRepeating() || this.isPrintInFirstWholeBand() && this.getBand().isFirstWholeOnPageColumn() || this.getPrintWhenGroupChanges() != null && this.getBand().isNewGroup(this.getPrintWhenGroupChanges()))) {
                isToPrint = false;
            }
            if (isToPrint) {
                if (availableStretchHeight >= this.getRelativeY() - this.getY() - this.getBandBottomY()) {
                    if (this.getTextEnd() < this.getText().length() || this.getTextEnd() == 0) {
                        if (this.isStretchWithOverflow() && this.getRotation() == 0) {
                            this.chopTextElement(availableStretchHeight - this.getRelativeY() + this.getY() + this.getBandBottomY());
                            if (this.getTextEnd() < this.getText().length()) {
                                willOverflow = true;
                            }
                        } else {
                            this.chopTextElement(0);
                        }
                    } else {
                        isToPrint = false;
                    }
                } else {
                    isToPrint = false;
                    willOverflow = true;
                }
            }
            if (isToPrint && this.isRemoveLineWhenBlank() && this.getText().substring(this.getTextStart(), this.getTextEnd()).trim().length() == 0) {
                isToPrint = false;
            }
        } else {
            if (isOverflow && this.isAlreadyPrinted()) {
                if (this.isPrintWhenDetailOverflows()) {
                    isReprinted = true;
                } else {
                    isToPrint = false;
                }
            }
            if (isToPrint && availableStretchHeight < this.getRelativeY() - this.getY() - this.getBandBottomY()) {
                isToPrint = false;
                willOverflow = true;
            }
        }
        this.setToPrint(isToPrint);
        this.setReprinted(isReprinted);
        return willOverflow;
    }

    protected JRPrintElement fill() {
        JRTemplatePrintText text = null;
        text = new JRTemplatePrintText(this.getJRTemplateText());
        text.setX(this.getX());
        text.setY(this.getRelativeY());
        text.setWidth(this.getWidth());
        if (this.getRotation() == 0) {
            text.setHeight(this.getStretchHeight());
        } else {
            text.setHeight(this.getHeight());
        }
        text.setRunDirection(this.getRunDirection());
        switch (this.getEvaluationTime()) {
            case 2: {
                this.filler.reportBoundElements.put(text, this);
                break;
            }
            case 3: {
                this.filler.pageBoundElements.put(text, this);
                break;
            }
            case 4: {
                this.filler.columnBoundElements.put(text, this);
                break;
            }
            case 5: {
                Map specificGroupBoundTexts = (Map)this.filler.groupBoundElements.get(this.getEvaluationGroup().getName());
                specificGroupBoundTexts.put(text, this);
                break;
            }
            case 6: {
                this.band.boundElements.put(text, this);
                break;
            }
            default: {
                this.copy(text);
            }
        }
        return text;
    }

    protected void copy(JRPrintText text) {
        text.setLineSpacingFactor(this.getLineSpacingFactor());
        text.setLeadingOffset(this.getLeadingOffset());
        text.setTextHeight(this.getTextHeight());
        text.setText(this.textChopper.chop(this, this.getTextStart(), this.getTextEnd()));
        text.setAnchorName(this.getAnchorName());
        text.setHyperlinkReference(this.getHyperlinkReference());
        text.setHyperlinkAnchor(this.getHyperlinkAnchor());
        text.setHyperlinkPage(this.getHyperlinkPage());
        text.setBookmarkLevel(this.getBookmarkLevel());
    }

    protected void setFormat() {
        Class expressionClass;
        String pattern = this.getPattern();
        if ((class$java$util$Date == null ? (class$java$util$Date = JRFillTextField.class$("java.util.Date")) : class$java$util$Date).isAssignableFrom(expressionClass = this.getExpression().getValueClass())) {
            this.setDateFormat(pattern);
        } else if ((class$java$lang$Number == null ? (class$java$lang$Number = JRFillTextField.class$("java.lang.Number")) : class$java$lang$Number).isAssignableFrom(expressionClass) && pattern != null && pattern.trim().length() > 0) {
            this.format = NumberFormat.getNumberInstance(this.filler.getLocale());
            if (this.format instanceof DecimalFormat) {
                ((DecimalFormat)this.format).applyPattern(pattern);
            }
        }
    }

    protected void setDateFormat(String pattern) {
        int sepIdx;
        String dateTok;
        int[] dateStyle = null;
        int[] timeStyle = null;
        if (pattern != null && pattern.trim().length() > 0 && (dateStyle = JRFillTextField.getDateStyle(dateTok = (sepIdx = pattern.indexOf(",")) < 0 ? pattern : pattern.substring(0, sepIdx))) != null) {
            if (sepIdx >= 0) {
                String timeTok = pattern.substring(sepIdx + ",".length());
                timeStyle = JRFillTextField.getDateStyle(timeTok);
            } else {
                timeStyle = dateStyle;
            }
        }
        if (dateStyle != null && timeStyle != null) {
            this.format = JRFillTextField.getDateFormat(dateStyle, timeStyle, this.filler.getLocale());
        } else {
            this.format = DateFormat.getDateTimeInstance(3, 3, this.filler.getLocale());
            if (pattern != null && pattern.trim().length() > 0 && this.format instanceof SimpleDateFormat) {
                ((SimpleDateFormat)this.format).applyPattern(pattern);
            }
        }
    }

    protected static int[] getDateStyle(String pattern) {
        if (pattern.equalsIgnoreCase("default")) {
            return new int[]{2};
        }
        if (pattern.equalsIgnoreCase("short")) {
            return new int[]{3};
        }
        if (pattern.equalsIgnoreCase("medium")) {
            return new int[]{2};
        }
        if (pattern.equalsIgnoreCase("long")) {
            return new int[]{1};
        }
        if (pattern.equalsIgnoreCase("full")) {
            return new int[]{0};
        }
        if (pattern.equalsIgnoreCase("hide")) {
            return new int[0];
        }
        return null;
    }

    protected static DateFormat getDateFormat(int[] dateStyle, int[] timeStyle, Locale locale) {
        if (dateStyle.length == 0) {
            if (timeStyle.length == 0) {
                return new SimpleDateFormat("");
            }
            return DateFormat.getTimeInstance(timeStyle[0], locale);
        }
        if (timeStyle.length == 0) {
            return DateFormat.getDateInstance(dateStyle[0], locale);
        }
        return DateFormat.getDateTimeInstance(dateStyle[0], timeStyle[0], locale);
    }

    public JRChild getCopy(JRAbstractObjectFactory factory) {
        return factory.getTextField(this);
    }

    public void collectExpressions(JRExpressionCollector collector) {
        collector.collect(this);
    }

    public void writeXml(JRXmlWriter xmlWriter) throws IOException {
        xmlWriter.writeTextField(this);
    }

    protected void resolveElement(JRPrintElement element, byte evaluation) throws JRException {
        this.evaluateText(evaluation);
        this.chopTextElement(0);
        this.copy((JRPrintText)element);
    }

    public int getBookmarkLevel() {
        return ((JRTextField)this.parent).getBookmarkLevel();
    }

    public JRCloneable createClone(JRFillCloneFactory factory) {
        return new JRFillTextField(this, factory);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

