/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.chart;

import java.awt.Graphics2D;
import java.awt.geom.Rectangle2D;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import javax.swing.event.EventListenerList;
import org.jfree.chart.ChartRenderingInfo;
import org.jfree.chart.DefaultOldLegend;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.event.LegendChangeEvent;
import org.jfree.chart.event.LegendChangeListener;

public abstract class OldLegend
implements Serializable,
Cloneable {
    private static final long serialVersionUID = 7706174413964908242L;
    private static final int NORTHWEST = 160;
    private static final int NORTHEAST = 176;
    private static final int SOUTHEAST = 192;
    private static final int SOUTHWEST = 208;
    public static final int WEST = 0;
    public static final int WEST_NORTHWEST = 160;
    public static final int WEST_SOUTHWEST = 208;
    public static final int NORTH = 1;
    public static final int NORTH_NORTHWEST = 161;
    public static final int NORTH_NORTHEAST = 177;
    public static final int EAST = 2;
    public static final int EAST_NORTHEAST = 178;
    public static final int EAST_SOUTHEAST = 194;
    public static final int SOUTH = 3;
    public static final int SOUTH_SOUTHWEST = 211;
    public static final int SOUTH_SOUTHEAST = 195;
    protected static final int INVERTED = 2;
    protected static final int HORIZONTAL = 1;
    private int anchor = 3;
    private JFreeChart chart;
    private transient EventListenerList listenerList = new EventListenerList();
    static /* synthetic */ Class class$org$jfree$chart$event$LegendChangeListener;

    public static OldLegend createInstance(JFreeChart chart) {
        return new DefaultOldLegend();
    }

    public JFreeChart getChart() {
        return this.chart;
    }

    protected void registerChart(JFreeChart chart) {
        this.chart = chart;
    }

    public abstract Rectangle2D draw(Graphics2D var1, Rectangle2D var2, ChartRenderingInfo var3);

    public void addChangeListener(LegendChangeListener listener) {
        this.listenerList.add(class$org$jfree$chart$event$LegendChangeListener == null ? (class$org$jfree$chart$event$LegendChangeListener = OldLegend.class$("org.jfree.chart.event.LegendChangeListener")) : class$org$jfree$chart$event$LegendChangeListener, listener);
    }

    public void removeChangeListener(LegendChangeListener listener) {
        this.listenerList.remove(class$org$jfree$chart$event$LegendChangeListener == null ? (class$org$jfree$chart$event$LegendChangeListener = OldLegend.class$("org.jfree.chart.event.LegendChangeListener")) : class$org$jfree$chart$event$LegendChangeListener, listener);
    }

    protected void notifyListeners(LegendChangeEvent event) {
        Object[] listeners = this.listenerList.getListenerList();
        for (int i = listeners.length - 2; i >= 0; i -= 2) {
            if (listeners[i] != (class$org$jfree$chart$event$LegendChangeListener == null ? OldLegend.class$("org.jfree.chart.event.LegendChangeListener") : class$org$jfree$chart$event$LegendChangeListener)) continue;
            ((LegendChangeListener)listeners[i + 1]).legendChanged(event);
        }
    }

    public int getAnchor() {
        return this.anchor;
    }

    public void setAnchor(int anchor) {
        if (this.isValidAnchor(anchor)) {
            this.anchor = anchor;
            this.notifyListeners(new LegendChangeEvent(this));
        }
    }

    private boolean isValidAnchor(int anchor) {
        switch (anchor) {
            case 0: 
            case 1: 
            case 2: 
            case 3: 
            case 160: 
            case 161: 
            case 177: 
            case 178: 
            case 194: 
            case 195: 
            case 208: 
            case 211: {
                return true;
            }
        }
        return false;
    }

    protected boolean isAnchoredToTop() {
        switch (this.anchor) {
            case 1: 
            case 160: 
            case 161: 
            case 177: 
            case 178: {
                return true;
            }
        }
        return false;
    }

    protected boolean isAnchoredToMiddle() {
        return this.anchor == 2 || this.anchor == 0;
    }

    protected boolean isAnchoredToBottom() {
        switch (this.anchor) {
            case 3: 
            case 194: 
            case 195: 
            case 208: 
            case 211: {
                return true;
            }
        }
        return false;
    }

    protected boolean isAnchoredToLeft() {
        switch (this.anchor) {
            case 0: 
            case 160: 
            case 161: 
            case 208: 
            case 211: {
                return true;
            }
        }
        return false;
    }

    protected boolean isAnchoredToRight() {
        switch (this.anchor) {
            case 2: 
            case 177: 
            case 178: 
            case 194: 
            case 195: {
                return true;
            }
        }
        return false;
    }

    protected boolean isAnchoredToCenter() {
        return this.anchor == 1 || this.anchor == 3;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj instanceof OldLegend) {
            OldLegend l = (OldLegend)obj;
            return this.anchor == l.anchor;
        }
        return false;
    }

    private void writeObject(ObjectOutputStream stream) throws IOException {
        stream.defaultWriteObject();
    }

    private void readObject(ObjectInputStream stream) throws IOException, ClassNotFoundException {
        stream.defaultReadObject();
        this.listenerList = new EventListenerList();
    }

    protected Object clone() throws CloneNotSupportedException {
        OldLegend ret = (OldLegend)super.clone();
        this.listenerList = new EventListenerList();
        return ret;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

