/*
 * Chart.java
 *
 * Created on 8 luglio 2005, 18.00
 *
 * To change this template, choose Tools | Options and locate the template under
 * the Source Creation and Management node. Right-click the template and choose
 * Open. You can then make changes to the template in the Source Editor.
 */

package it.businesslogic.ireport.chart;
import it.businesslogic.ireport.HyperLinkableReportElement;
/**
 *
 * @author Administrator
 */
public class Chart implements HyperLinkableReportElement {
    
    private ChartTitle title = null;
    private ChartTitle subTitle = null;
    private boolean showLegend = true;
    protected Plot plot = null;
    private Dataset dataset = null;
    
    private String customizerClass = "";
    
    private java.awt.Image chartImage = null;
    
    private String anchorNameExpression = "";
    
    private String hyperlinkAnchorExpression = "";
    
    private String hyperlinkPageExpression = "";
    
    private String hyperlinkReferenceExpression = "";
    
    private String hyperlinkType = "None";
    
    private String hyperlinkTarget = "Self";
    
    private int bookmarkLevel = 0;
    
    /** Creates a new instance of Chart */
    public Chart() {
        
        setTitle(new ChartTitle(""));
        setSubTitle(new ChartTitle(""));
        plot = new Plot(); // This line shold be overridden in the derived classes.. 
        dataset = new Dataset();
          
    }
    
    public ChartTitle getTitle() {
        return title;
    }

    public void setTitle(ChartTitle title) {
        this.title = title;
    }

    public ChartTitle getSubTitle() {
        return subTitle;
    }

    public void setSubTitle(ChartTitle subTitle) {
        this.subTitle = subTitle;
    }

    public boolean isShowLegend() {
        return showLegend;
    }

    public void setShowLegend(boolean showLegend) {
        this.showLegend = showLegend;
    }

    public java.awt.Image getChartImage() {
        return chartImage;
    }

    public void setChartImage(java.awt.Image chartImage) {
        this.chartImage = chartImage;
    }

    public Plot getPlot() {
        return plot;
    }

    public void setPlot(Plot plot) {
        this.plot = plot;
    }

    public Dataset getDataset() {
        return dataset;
    }

    public void setDataset(Dataset dataset) {
        this.dataset = dataset;
    }
    
    public Chart cloneMe()
    {
        Chart chart = cloneBaseChart();
        chart.setTitle( getTitle().cloneMe() );
        chart.setSubTitle( getSubTitle().cloneMe() );
        chart.setPlot( getPlot().cloneMe() );
        chart.setDataset( getDataset().cloneMe() );
        chart.setShowLegend( isShowLegend() );
        
        chart.setAnchorNameExpression( getAnchorNameExpression() );
        chart.setHyperlinkAnchorExpression( getHyperlinkAnchorExpression() );
        chart.setHyperlinkPageExpression( getHyperlinkPageExpression() );
        chart.setHyperlinkReferenceExpression( getHyperlinkReferenceExpression() );
        chart.setHyperlinkType( getHyperlinkType() );
        chart.setHyperlinkTarget( getHyperlinkTarget() );
        chart.setCustomizerClass( getCustomizerClass() );
        
        return chart;
    }
    
    public Chart cloneBaseChart()
    {
        return new Chart();
    }

    public String getAnchorNameExpression() {
        return anchorNameExpression;
    }

    public void setAnchorNameExpression(String anchorNameExpression) {
        this.anchorNameExpression = anchorNameExpression;
    }

    public String getHyperlinkAnchorExpression() {
        return hyperlinkAnchorExpression;
    }

    public void setHyperlinkAnchorExpression(String hyperlinkAnchorExpression) {
        this.hyperlinkAnchorExpression = hyperlinkAnchorExpression;
    }

    public String getHyperlinkPageExpression() {
        return hyperlinkPageExpression;
    }

    public void setHyperlinkPageExpression(String hyperlinkPageExpression) {
        this.hyperlinkPageExpression = hyperlinkPageExpression;
    }

    public String getHyperlinkReferenceExpression() {
        return hyperlinkReferenceExpression;
    }

    public void setHyperlinkReferenceExpression(String hyperlinkReferenceExpression) {
        this.hyperlinkReferenceExpression = hyperlinkReferenceExpression;
    }

    public String getHyperlinkType() {
        return hyperlinkType;
    }

    public void setHyperlinkType(String hyperlinkType) {
        this.hyperlinkType = hyperlinkType;
    }

    public String getHyperlinkTarget() {
        return hyperlinkTarget;
    }

    public void setHyperlinkTarget(String hyperlinkTarget) {
        this.hyperlinkTarget = hyperlinkTarget;
    }

    public int getBookmarkLevel() {
        return bookmarkLevel;
    }

    public void setBookmarkLevel(int bookmarkLevel) {
        this.bookmarkLevel = bookmarkLevel;
    }

    public String getCustomizerClass() {
        return customizerClass;
    }

    public void setCustomizerClass(String customizerClass) {
        this.customizerClass = customizerClass;
    }
    
}
