/*
 * ChartPropertiesFrame.java
 *
 * Created on 15 agosto 2005, 10.19
 */

package it.businesslogic.ireport.chart.gui;
import it.businesslogic.ireport.gui.sheet.*;
import it.businesslogic.ireport.chart.*;
import it.businesslogic.ireport.*;
import it.businesslogic.ireport.gui.JRSubreportParameterDialog;
import it.businesslogic.ireport.gui.JReportFrame;
import it.businesslogic.ireport.gui.event.SheetPropertyValueChangedEvent;
import it.businesslogic.ireport.gui.event.SheetPropertyValueChangedListener;
import javax.swing.JOptionPane;
import it.businesslogic.ireport.util.Misc;
import java.awt.Color;
import java.util.Vector;
/**
 *
 * @author  Administrator
 */
public class ChartPropertiesDialog extends javax.swing.JDialog implements SheetPropertyValueChangedListener  {
    
    private CategorySheetPanel sheetPanel = null;
    private ChartReportElement2 currentSelectedChartElement = null;
    private int dialogResult = javax.swing.JOptionPane.OK_OPTION;
    private JReportFrame jReportFrame = null;
    private boolean init = false;
       
    public void setChartElement(ChartReportElement2 chartReportElement)
    {
        setInit(true);
        
        try {
            
        currentSelectedChartElement = chartReportElement;

        jButtonPaste.setEnabled( it.businesslogic.ireport.gui.MainFrame.getMainInstance().getChartDatasetClipBoard() != null ) ;
        
        if (currentSelectedChartElement == null)
        {
            // We have to clean all the gui....
            sheetPanel.removeAllProperties();
            jComboBoxTypeOfData.removeAllItems();
            jPanelDataDefinition.removeAll();
        }
        else
        {
            updateGroups();
            updateSubDatasets();
            // Case by case...
            addCommonChartProperties();
            
            // Set general dataset data...
            Misc.setComboboxSelectedTagValue(jComboBoxIncrementType, currentSelectedChartElement.getChart().getDataset().getIncrementType());
            jComboBoxIncrementGroup.setSelectedItem( currentSelectedChartElement.getChart().getDataset().getIncrementGroup() );
            Misc.setComboboxSelectedTagValue(jComboBoxResetType, currentSelectedChartElement.getChart().getDataset().getResetType());
            jComboBoxResetGroup.setSelectedItem( currentSelectedChartElement.getChart().getDataset().getResetGroup() );
            
            if (currentSelectedChartElement.getChart().getDataset().getSubDataset() != null)
            {
                jComboBoxSubDataset.setSelectedItem(currentSelectedChartElement.getChart().getDataset().getSubDataset());
                jTabbedPane2.setVisible(true);
            
                jRTextExpressionAreaMapExpression.setText( currentSelectedChartElement.getChart().getDataset().getParametersMapExpression()  );
                if (!currentSelectedChartElement.getChart().getDataset().isUseConnection() &&  Misc.nvl( currentSelectedChartElement.getChart().getDataset().getDataSourceExpression(),"").trim().equals("")) {
                    this.jComboBoxDatasetConnectionType.setSelectedIndex(0);
                    this.jRTextExpressionAreaTextConnectionExpression.setEnabled(false);
                    this.jRTextExpressionAreaTextConnectionExpression.setBackground(Color.LIGHT_GRAY);
                    this.jRTextExpressionAreaTextConnectionExpression.setText("");
                }
                else if (currentSelectedChartElement.getChart().getDataset().isUseConnection()) {
                    this.jComboBoxDatasetConnectionType.setSelectedIndex(1);
                    this.jRTextExpressionAreaTextConnectionExpression.setEnabled(true);
                    this.jRTextExpressionAreaTextConnectionExpression.setBackground(Color.WHITE);
                    this.jRTextExpressionAreaTextConnectionExpression.setText( currentSelectedChartElement.getChart().getDataset().getConnectionExpression());
                }
                else {
                    this.jComboBoxDatasetConnectionType.setSelectedIndex(2);
                    this.jRTextExpressionAreaTextConnectionExpression.setEnabled(true);
                    this.jRTextExpressionAreaTextConnectionExpression.setBackground(Color.WHITE);
                    this.jRTextExpressionAreaTextConnectionExpression.setText( currentSelectedChartElement.getChart().getDataset().getDataSourceExpression());
                }

                //Add parameters...
                javax.swing.table.DefaultTableModel dtm = (javax.swing.table.DefaultTableModel)jTableDatasetParameters.getModel();
                dtm.setRowCount(0);

                java.util.Enumeration enum_parameters = currentSelectedChartElement.getChart().getDataset().getSubreportParameters().elements();
                while (enum_parameters.hasMoreElements()) {
                    it.businesslogic.ireport.JRSubreportParameter parameter = (it.businesslogic.ireport.JRSubreportParameter)enum_parameters.nextElement();
                    Vector row = new Vector();
                    row.addElement(parameter);
                    row.addElement(parameter.getExpression());
                    dtm.addRow(row);
                }            
            
            }
            else
            {
                javax.swing.table.DefaultTableModel dtm = (javax.swing.table.DefaultTableModel)jTableDatasetParameters.getModel();
                dtm.setRowCount(0);
                this.jComboBoxDatasetConnectionType.setSelectedIndex(0);
                this.jRTextExpressionAreaTextConnectionExpression.setEnabled(false);
                this.jRTextExpressionAreaTextConnectionExpression.setBackground(Color.LIGHT_GRAY);
                this.jRTextExpressionAreaTextConnectionExpression.setText("");
                jRTextExpressionAreaMapExpression.setText("");
                
                jComboBoxSubDataset.setSelectedIndex(0);
                jTabbedPane2.setVisible(false);
            }
            
            java.awt.GridBagConstraints gridBagConstraints = new java.awt.GridBagConstraints();
            gridBagConstraints.gridx = 4;
            gridBagConstraints.gridy = 2;
            gridBagConstraints.anchor = java.awt.GridBagConstraints.WEST;
            gridBagConstraints.weightx = 1.0;
            gridBagConstraints.weighty = 1.0;
            gridBagConstraints.fill = gridBagConstraints.BOTH;
            gridBagConstraints.insets = new java.awt.Insets(4, 4, 4, 4);
        
            if (currentSelectedChartElement.getChart() instanceof PieChart ||
                currentSelectedChartElement.getChart() instanceof Pie3DChart)
            {
                jComboBoxTypeOfData.addItem(new Tag("it.businesslogic.ireport.chart.PieDataset", "Pie dataset"));
            }
            else if (currentSelectedChartElement.getChart() instanceof BarChart ||
                     currentSelectedChartElement.getChart() instanceof Bar3DChart ||
                     currentSelectedChartElement.getChart() instanceof StackedBarChart ||
                     currentSelectedChartElement.getChart() instanceof StackedBar3DChart ||
                     currentSelectedChartElement.getChart() instanceof LineChart ||
                     currentSelectedChartElement.getChart() instanceof AreaChart)
            {
                jComboBoxTypeOfData.addItem(new Tag("it.businesslogic.ireport.chart.CategoryDataset", "Category dataset"));
            }
            else if (currentSelectedChartElement.getChart() instanceof XYBarChart)
            {
                jComboBoxTypeOfData.addItem(new Tag("it.businesslogic.ireport.chart.TimePeriodDataset", "Time period dataset"));
                jComboBoxTypeOfData.addItem(new Tag("it.businesslogic.ireport.chart.TimeSeriesDataset", "Time series dataset"));
                jComboBoxTypeOfData.addItem(new Tag("it.businesslogic.ireport.chart.XYDataset", "XY dataset"));
            }
            else if ( currentSelectedChartElement.getChart() instanceof XYLineChart ||
                      currentSelectedChartElement.getChart() instanceof XYAreaChart || 
                      currentSelectedChartElement.getChart() instanceof ScatterChart )
            {
                jComboBoxTypeOfData.addItem(new Tag("it.businesslogic.ireport.chart.XYDataset", "XY dataset"));
            }
            else if ( currentSelectedChartElement.getChart() instanceof BubbleChart )
            {
                jComboBoxTypeOfData.addItem(new Tag("it.businesslogic.ireport.chart.XYZDataset", "XYZ dataset"));
            }
            else if ( currentSelectedChartElement.getChart() instanceof TimeSeriesChart )
            {
                jComboBoxTypeOfData.addItem(new Tag("it.businesslogic.ireport.chart.TimeSeriesDataset", "Time series dataset"));
            }
            else if ( currentSelectedChartElement.getChart() instanceof HighLowChart ||
                      currentSelectedChartElement.getChart() instanceof CandlestickChart)
            {
                jComboBoxTypeOfData.addItem(new Tag("it.businesslogic.ireport.chart.HighLowDataset", "High low dataset"));
            }
            
            setDatasetPanel( currentSelectedChartElement.getChart().getDataset() );
            setPlotSheetProperties( currentSelectedChartElement.getChart().getPlot() );
        }
        
        sheetPanel.recreateSheet();
        
        } catch (Exception ex)
        {
            ex.printStackTrace();
        }
        setInit(false);
    }
         
    /** Creates new dialog ChartPropertiesDialog */
    public ChartPropertiesDialog(java.awt.Dialog parent, boolean modal) {
        super(parent,modal);
        initAll();
    }
     
    /** Creates new dialog ChartPropertiesDialog */
    public ChartPropertiesDialog(java.awt.Frame parent, boolean modal) {
        super(parent,modal);
        initAll();
    }
     
    public void initAll()
    {
        initComponents();
        
        
        java.awt.GridBagConstraints gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 4;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.WEST;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.fill = gridBagConstraints.BOTH;
        gridBagConstraints.insets = new java.awt.Insets(0, -1, -1, -1);
        sheetPanel = new CategorySheetPanel();
        sheetPanel.addSheetPropertyValueChangedListener(this);
        
        jPanelProperties.add(sheetPanel, gridBagConstraints);
        
        applyI18n();
        
        this.jComboBoxResetType.addItem(new Tag("None",it.businesslogic.ireport.util.I18n.getString("resetType.None","None")));
        this.jComboBoxResetType.addItem(new Tag("Report",it.businesslogic.ireport.util.I18n.getString("resetType.Report","Report")));
        this.jComboBoxResetType.addItem(new Tag("Page",it.businesslogic.ireport.util.I18n.getString("resetType.Page","Page")));
        this.jComboBoxResetType.addItem(new Tag("Column",it.businesslogic.ireport.util.I18n.getString("resetType.Column","Column")));
        this.jComboBoxResetType.addItem(new Tag("Group",it.businesslogic.ireport.util.I18n.getString("resetType.Group","Group")));

        this.jComboBoxIncrementType.addItem(new Tag("None",it.businesslogic.ireport.util.I18n.getString("incrementType.None","None")));
        this.jComboBoxIncrementType.addItem(new Tag("Report",it.businesslogic.ireport.util.I18n.getString("incrementType.Report","Report")));
        this.jComboBoxIncrementType.addItem(new Tag("Page",it.businesslogic.ireport.util.I18n.getString("incrementType.Page","Page")));
        this.jComboBoxIncrementType.addItem(new Tag("Column",it.businesslogic.ireport.util.I18n.getString("incrementType.Column","Column")));
        this.jComboBoxIncrementType.addItem(new Tag("Group",it.businesslogic.ireport.util.I18n.getString("incrementType.Group","Group")));
         
        jComboBoxDatasetConnectionType.addItem(new Tag("Don't use connection or datasource",it.businesslogic.ireport.util.I18n.getString("ConnectionType.1","Don't use connection or datasource")));
        jComboBoxDatasetConnectionType.addItem(new Tag("Use connection expression",it.businesslogic.ireport.util.I18n.getString("ConnectionType.2","Use connection expression")));
        jComboBoxDatasetConnectionType.addItem(new Tag("Use datasource expression",it.businesslogic.ireport.util.I18n.getString("ConnectionType.3","Use datasource expression")));
        
        this.jRTextExpressionAreaMapExpression.getDocument().addDocumentListener( new javax.swing.event.DocumentListener() {
            public void changedUpdate(javax.swing.event.DocumentEvent evt) {
                jRTextExpressionAreaMapExpressionTextChanged();
            }
            public void insertUpdate(javax.swing.event.DocumentEvent evt) {
                jRTextExpressionAreaMapExpressionTextChanged();
            }
            public void removeUpdate(javax.swing.event.DocumentEvent evt) {
                jRTextExpressionAreaMapExpressionTextChanged();
            }
        });
        
        this.jRTextExpressionAreaTextConnectionExpression.getDocument().addDocumentListener( new javax.swing.event.DocumentListener() {
            public void changedUpdate(javax.swing.event.DocumentEvent evt) {
                jRTextExpressionAreaTextConnectionExpressionTextChanged();
            }
            public void insertUpdate(javax.swing.event.DocumentEvent evt) {
                jRTextExpressionAreaTextConnectionExpressionTextChanged();
            }
            public void removeUpdate(javax.swing.event.DocumentEvent evt) {
                jRTextExpressionAreaTextConnectionExpressionTextChanged();
            }
        });
        
        javax.swing.DefaultListSelectionModel dlsm =  (javax.swing.DefaultListSelectionModel)this.jTableDatasetParameters.getSelectionModel();
        dlsm.addListSelectionListener(new javax.swing.event.ListSelectionListener() {
            public void valueChanged(javax.swing.event.ListSelectionEvent e)  {
                jTableDatasetParametersListSelectionValueChanged(e);
            }
        });
        
        this.setSize(670,480);
        it.businesslogic.ireport.util.Misc.centerFrame(this);
    }
    
    
    public void jRTextExpressionAreaMapExpressionTextChanged() {
        if (this.isInit()) return; 
        if (currentSelectedChartElement != null)
        {
            currentSelectedChartElement.getChart().getDataset().setParametersMapExpression(""+jRTextExpressionAreaMapExpression.getText());
        }
    }

    public void jRTextExpressionAreaTextConnectionExpressionTextChanged() {
        if (this.isInit()) return; 
        if (currentSelectedChartElement != null)
        {
            if (currentSelectedChartElement.getChart().getDataset().isUseConnection())
                currentSelectedChartElement.getChart().getDataset().setConnectionExpression(""+jRTextExpressionAreaTextConnectionExpression.getText());
            else
                currentSelectedChartElement.getChart().getDataset().setDataSourceExpression(""+jRTextExpressionAreaTextConnectionExpression.getText());
        }
    }
    
    public void jTableDatasetParametersListSelectionValueChanged(javax.swing.event.ListSelectionEvent e) {
        if (this.jTableDatasetParameters.getSelectedRowCount() > 0) {
            this.jButtonModParameter.setEnabled(true);
            this.jButtonRemParameter.setEnabled(true);
        }
        else {
            this.jButtonModParameter.setEnabled(false);
            this.jButtonRemParameter.setEnabled(false);
        }
    }
    
    
    /** This method is called from within the constructor to
     * initialize the form.
     * WARNING: Do NOT modify this code. The content of this method is
     * always regenerated by the Form Editor.
     */
    // <editor-fold defaultstate="collapsed" desc=" Generated Code ">//GEN-BEGIN:initComponents
    private void initComponents() {
        java.awt.GridBagConstraints gridBagConstraints;

        jTabbedPane1 = new javax.swing.JTabbedPane();
        jPanelProperties = new javax.swing.JPanel();
        jPanelData = new javax.swing.JPanel();
        jLabelTypeOfData = new javax.swing.JLabel();
        jComboBoxTypeOfData = new javax.swing.JComboBox();
        jTabbedPaneData = new javax.swing.JTabbedPane();
        jPanelDataset = new javax.swing.JPanel();
        jLabelResetType = new javax.swing.JLabel();
        jComboBoxResetType = new javax.swing.JComboBox();
        jLabelResetGroup = new javax.swing.JLabel();
        jComboBoxResetGroup = new javax.swing.JComboBox();
        jLabelIncrementType = new javax.swing.JLabel();
        jComboBoxIncrementType = new javax.swing.JComboBox();
        jLabelIncrementGroup = new javax.swing.JLabel();
        jComboBoxIncrementGroup = new javax.swing.JComboBox();
        jPanel1 = new javax.swing.JPanel();
        jLabelIncrementType1 = new javax.swing.JLabel();
        jComboBoxSubDataset = new javax.swing.JComboBox();
        jPanel7 = new javax.swing.JPanel();
        jTabbedPane2 = new javax.swing.JTabbedPane();
        jPanel4 = new javax.swing.JPanel();
        jPanel16 = new javax.swing.JPanel();
        jScrollPane2 = new javax.swing.JScrollPane();
        jTableDatasetParameters = new javax.swing.JTable();
        jPanel10 = new javax.swing.JPanel();
        jButtonAddParameter = new javax.swing.JButton();
        jButtonModParameter = new javax.swing.JButton();
        jButtonRemParameter = new javax.swing.JButton();
        jPanel13 = new javax.swing.JPanel();
        jPanel5 = new javax.swing.JPanel();
        jLabel26 = new javax.swing.JLabel();
        jRTextExpressionAreaMapExpression = new it.businesslogic.ireport.gui.JRTextExpressionArea();
        jPanel6 = new javax.swing.JPanel();
        jLabel41 = new javax.swing.JLabel();
        jComboBoxDatasetConnectionType = new javax.swing.JComboBox();
        jRTextExpressionAreaTextConnectionExpression = new it.businesslogic.ireport.gui.JRTextExpressionArea();
        jPanel2 = new javax.swing.JPanel();
        jButtonCopy = new javax.swing.JButton();
        jButtonPaste = new javax.swing.JButton();
        jPanel3 = new javax.swing.JPanel();
        jPanelDataDefinition = new javax.swing.JPanel();

        setDefaultCloseOperation(javax.swing.WindowConstants.DISPOSE_ON_CLOSE);
        setTitle("Chart details");
        jTabbedPane1.setFont(new java.awt.Font("Dialog", 0, 11));
        jPanelProperties.setLayout(new java.awt.GridBagLayout());

        jTabbedPane1.addTab("Chart properties", jPanelProperties);

        jPanelData.setLayout(new java.awt.GridBagLayout());

        jLabelTypeOfData.setFont(new java.awt.Font("Dialog", 0, 11));
        jLabelTypeOfData.setText("Type of dataset");
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.insets = new java.awt.Insets(4, 4, 4, 4);
        jPanelData.add(jLabelTypeOfData, gridBagConstraints);

        jComboBoxTypeOfData.setFont(new java.awt.Font("Dialog", 0, 11));
        jComboBoxTypeOfData.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                jComboBoxTypeOfDataActionPerformed(evt);
            }
        });

        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new java.awt.Insets(4, 0, 4, 4);
        jPanelData.add(jComboBoxTypeOfData, gridBagConstraints);

        jTabbedPaneData.setFont(new java.awt.Font("Dialog", 0, 11));
        jPanelDataset.setLayout(new java.awt.GridBagLayout());

        jLabelResetType.setFont(new java.awt.Font("Dialog", 0, 11));
        jLabelResetType.setText("Reset type");
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.NORTHWEST;
        gridBagConstraints.insets = new java.awt.Insets(3, 3, 0, 3);
        jPanelDataset.add(jLabelResetType, gridBagConstraints);

        jComboBoxResetType.setFont(new java.awt.Font("Dialog", 0, 11));
        jComboBoxResetType.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                jComboBoxResetTypeActionPerformed(evt);
            }
        });

        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.NORTHWEST;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new java.awt.Insets(3, 3, 3, 3);
        jPanelDataset.add(jComboBoxResetType, gridBagConstraints);

        jLabelResetGroup.setFont(new java.awt.Font("Dialog", 0, 11));
        jLabelResetGroup.setText("Reset group");
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.NORTHWEST;
        gridBagConstraints.insets = new java.awt.Insets(3, 3, 0, 3);
        jPanelDataset.add(jLabelResetGroup, gridBagConstraints);

        jComboBoxResetGroup.setFont(new java.awt.Font("Dialog", 0, 11));
        jComboBoxResetGroup.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                jComboBoxResetGroupActionPerformed(evt);
            }
        });

        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.NORTHWEST;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new java.awt.Insets(3, 3, 3, 3);
        jPanelDataset.add(jComboBoxResetGroup, gridBagConstraints);

        jLabelIncrementType.setFont(new java.awt.Font("Dialog", 0, 11));
        jLabelIncrementType.setText("Increment type");
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 6;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.NORTHWEST;
        gridBagConstraints.insets = new java.awt.Insets(3, 3, 0, 3);
        jPanelDataset.add(jLabelIncrementType, gridBagConstraints);

        jComboBoxIncrementType.setFont(new java.awt.Font("Dialog", 0, 11));
        jComboBoxIncrementType.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                jComboBoxIncrementTypeActionPerformed(evt);
            }
        });

        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 7;
        gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.NORTHWEST;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new java.awt.Insets(3, 3, 3, 3);
        jPanelDataset.add(jComboBoxIncrementType, gridBagConstraints);

        jLabelIncrementGroup.setFont(new java.awt.Font("Dialog", 0, 11));
        jLabelIncrementGroup.setText("Increment group");
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 6;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.NORTHWEST;
        gridBagConstraints.insets = new java.awt.Insets(3, 3, 0, 3);
        jPanelDataset.add(jLabelIncrementGroup, gridBagConstraints);

        jComboBoxIncrementGroup.setFont(new java.awt.Font("Dialog", 0, 11));
        jComboBoxIncrementGroup.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                jComboBoxIncrementGroupActionPerformed(evt);
            }
        });

        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 7;
        gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.NORTHWEST;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new java.awt.Insets(3, 3, 3, 3);
        jPanelDataset.add(jComboBoxIncrementGroup, gridBagConstraints);

        jPanel1.setLayout(new java.awt.GridBagLayout());

        jPanel1.setBorder(javax.swing.BorderFactory.createTitledBorder(javax.swing.BorderFactory.createEtchedBorder(), "Dataset run", javax.swing.border.TitledBorder.DEFAULT_JUSTIFICATION, javax.swing.border.TitledBorder.DEFAULT_POSITION, new java.awt.Font("Dialog", 0, 11)));
        jLabelIncrementType1.setFont(new java.awt.Font("Dialog", 0, 11));
        jLabelIncrementType1.setText("Sub dataset");
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.WEST;
        gridBagConstraints.insets = new java.awt.Insets(3, 3, 0, 3);
        jPanel1.add(jLabelIncrementType1, gridBagConstraints);

        jComboBoxSubDataset.setFont(new java.awt.Font("Dialog", 0, 11));
        jComboBoxSubDataset.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                jComboBoxSubDatasetActionPerformed(evt);
            }
        });

        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.WEST;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new java.awt.Insets(3, 3, 3, 3);
        jPanel1.add(jComboBoxSubDataset, gridBagConstraints);

        jPanel7.setLayout(new java.awt.GridBagLayout());

        jTabbedPane2.setFont(new java.awt.Font("Dialog", 0, 11));
        jPanel4.setLayout(new java.awt.GridBagLayout());

        jPanel16.setLayout(new java.awt.GridBagLayout());

        jScrollPane2.setFont(new java.awt.Font("Dialog", 0, 11));
        jScrollPane2.setMinimumSize(new java.awt.Dimension(300, 50));
        jScrollPane2.setPreferredSize(new java.awt.Dimension(300, 50));
        jTableDatasetParameters.setFont(new java.awt.Font("Dialog", 0, 11));
        jTableDatasetParameters.setModel(new javax.swing.table.DefaultTableModel(
            new Object [][] {

            },
            new String [] {
                "Parameter", "Expression"
            }
        ) {
            boolean[] canEdit = new boolean [] {
                false, false
            };

            public boolean isCellEditable(int rowIndex, int columnIndex) {
                return canEdit [columnIndex];
            }
        });
        jTableDatasetParameters.addMouseListener(new java.awt.event.MouseAdapter() {
            public void mouseClicked(java.awt.event.MouseEvent evt) {
                jTableDatasetParametersMouseClicked(evt);
            }
        });

        jScrollPane2.setViewportView(jTableDatasetParameters);

        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 7;
        gridBagConstraints.gridwidth = 3;
        gridBagConstraints.fill = java.awt.GridBagConstraints.BOTH;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.WEST;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new java.awt.Insets(2, 6, 0, 6);
        jPanel16.add(jScrollPane2, gridBagConstraints);

        jPanel10.setLayout(new java.awt.GridBagLayout());

        jButtonAddParameter.setFont(new java.awt.Font("Dialog", 0, 11));
        jButtonAddParameter.setText("Add");
        jButtonAddParameter.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                jButtonAddParameterActionPerformed(evt);
            }
        });

        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.WEST;
        gridBagConstraints.insets = new java.awt.Insets(4, 0, 6, 0);
        jPanel10.add(jButtonAddParameter, gridBagConstraints);

        jButtonModParameter.setFont(new java.awt.Font("Dialog", 0, 11));
        jButtonModParameter.setText("Modify");
        jButtonModParameter.setEnabled(false);
        jButtonModParameter.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                jButtonModParameterActionPerformed(evt);
            }
        });

        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.WEST;
        gridBagConstraints.insets = new java.awt.Insets(4, 6, 6, 0);
        jPanel10.add(jButtonModParameter, gridBagConstraints);

        jButtonRemParameter.setFont(new java.awt.Font("Dialog", 0, 11));
        jButtonRemParameter.setText("Remove");
        jButtonRemParameter.setEnabled(false);
        jButtonRemParameter.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                jButtonRemParameterActionPerformed(evt);
            }
        });

        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.WEST;
        gridBagConstraints.insets = new java.awt.Insets(4, 6, 6, 0);
        jPanel10.add(jButtonRemParameter, gridBagConstraints);

        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 4;
        gridBagConstraints.weightx = 1.0;
        jPanel10.add(jPanel13, gridBagConstraints);

        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridy = 9;
        gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new java.awt.Insets(0, 6, 0, 6);
        jPanel16.add(jPanel10, gridBagConstraints);

        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.fill = java.awt.GridBagConstraints.BOTH;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        jPanel4.add(jPanel16, gridBagConstraints);

        jTabbedPane2.addTab("Parameters", jPanel4);

        jPanel5.setLayout(new java.awt.GridBagLayout());

        jLabel26.setFont(new java.awt.Font("Dialog", 0, 11));
        jLabel26.setHorizontalAlignment(javax.swing.SwingConstants.LEFT);
        jLabel26.setText("Parameters Map Expression");
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.gridwidth = 3;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.WEST;
        gridBagConstraints.insets = new java.awt.Insets(6, 8, 0, 0);
        jPanel5.add(jLabel26, gridBagConstraints);

        jRTextExpressionAreaMapExpression.setBorder(javax.swing.BorderFactory.createEtchedBorder());
        jRTextExpressionAreaMapExpression.setElectricScroll(0);
        jRTextExpressionAreaMapExpression.setMinimumSize(new java.awt.Dimension(0, 0));
        jRTextExpressionAreaMapExpression.setPreferredSize(new java.awt.Dimension(300, 50));
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.gridwidth = 3;
        gridBagConstraints.fill = java.awt.GridBagConstraints.BOTH;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.WEST;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new java.awt.Insets(2, 4, 4, 4);
        jPanel5.add(jRTextExpressionAreaMapExpression, gridBagConstraints);

        jTabbedPane2.addTab("Parameters map exp", jPanel5);

        jPanel6.setLayout(new java.awt.GridBagLayout());

        jLabel41.setFont(new java.awt.Font("Dialog", 0, 11));
        jLabel41.setText("Connection / Datasource Expression");
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.WEST;
        gridBagConstraints.insets = new java.awt.Insets(2, 6, 0, 0);
        jPanel6.add(jLabel41, gridBagConstraints);

        jComboBoxDatasetConnectionType.setFont(new java.awt.Font("Dialog", 0, 11));
        jComboBoxDatasetConnectionType.setMinimumSize(new java.awt.Dimension(300, 20));
        jComboBoxDatasetConnectionType.setPreferredSize(new java.awt.Dimension(300, 20));
        jComboBoxDatasetConnectionType.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                jComboBoxDatasetConnectionTypeActionPerformed(evt);
            }
        });

        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.WEST;
        gridBagConstraints.insets = new java.awt.Insets(2, 6, 0, 6);
        jPanel6.add(jComboBoxDatasetConnectionType, gridBagConstraints);

        jRTextExpressionAreaTextConnectionExpression.setBorder(javax.swing.BorderFactory.createEtchedBorder());
        jRTextExpressionAreaTextConnectionExpression.setEnabled(false);
        jRTextExpressionAreaTextConnectionExpression.setMinimumSize(new java.awt.Dimension(300, 50));
        jRTextExpressionAreaTextConnectionExpression.setPreferredSize(new java.awt.Dimension(300, 50));
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.fill = java.awt.GridBagConstraints.BOTH;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.NORTHWEST;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new java.awt.Insets(2, 4, 4, 4);
        jPanel6.add(jRTextExpressionAreaTextConnectionExpression, gridBagConstraints);

        jTabbedPane2.addTab("Connection/Datasource exp", jPanel6);

        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = java.awt.GridBagConstraints.BOTH;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new java.awt.Insets(4, 0, 0, 0);
        jPanel7.add(jTabbedPane2, gridBagConstraints);

        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = java.awt.GridBagConstraints.BOTH;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        jPanel1.add(jPanel7, gridBagConstraints);

        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridy = 100;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = java.awt.GridBagConstraints.BOTH;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new java.awt.Insets(4, 4, 4, 4);
        jPanelDataset.add(jPanel1, gridBagConstraints);

        jPanel2.setLayout(new java.awt.GridBagLayout());

        jButtonCopy.setFont(new java.awt.Font("Dialog", 0, 11));
        jButtonCopy.setText("Copy dataset");
        jButtonCopy.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                jButtonCopyActionPerformed(evt);
            }
        });

        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.insets = new java.awt.Insets(0, 0, 0, 4);
        jPanel2.add(jButtonCopy, gridBagConstraints);

        jButtonPaste.setFont(new java.awt.Font("Dialog", 0, 11));
        jButtonPaste.setText("Paste dataset");
        jButtonPaste.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                jButtonPasteActionPerformed(evt);
            }
        });

        jPanel2.add(jButtonPaste, new java.awt.GridBagConstraints());

        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.weightx = 1.0;
        jPanel2.add(jPanel3, gridBagConstraints);

        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 101;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = java.awt.GridBagConstraints.BOTH;
        gridBagConstraints.insets = new java.awt.Insets(4, 4, 4, 0);
        jPanelDataset.add(jPanel2, gridBagConstraints);

        jTabbedPaneData.addTab("Dataset", jPanelDataset);

        jPanelDataDefinition.setLayout(new java.awt.GridBagLayout());

        jTabbedPaneData.addTab("Details", jPanelDataDefinition);

        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = java.awt.GridBagConstraints.BOTH;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new java.awt.Insets(2, 4, 4, 4);
        jPanelData.add(jTabbedPaneData, gridBagConstraints);

        jTabbedPane1.addTab("Chart data", jPanelData);

        getContentPane().add(jTabbedPane1, java.awt.BorderLayout.CENTER);

        pack();
    }
    // </editor-fold>//GEN-END:initComponents

    private void jTableDatasetParametersMouseClicked(java.awt.event.MouseEvent evt) {//GEN-FIRST:event_jTableDatasetParametersMouseClicked

        if (evt.getClickCount() == 2 && evt.getButton() == evt.BUTTON1)
        {
            if (jTableDatasetParameters.getSelectedRowCount() > 0)
            {
                jButtonModParameterActionPerformed(null);
            }
        }
        
    }//GEN-LAST:event_jTableDatasetParametersMouseClicked

    private void jButtonRemParameterActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_jButtonRemParameterActionPerformed
        if (this.isInit()) return;
        
        if (currentSelectedChartElement == null) return;
        
        javax.swing.table.DefaultTableModel dtm = (javax.swing.table.DefaultTableModel)jTableDatasetParameters.getModel();
        
        while (jTableDatasetParameters.getSelectedRowCount() > 0) {
            int i=jTableDatasetParameters.getSelectedRowCount();
            currentSelectedChartElement.getChart().getDataset().getSubreportParameters().removeElement( jTableDatasetParameters.getValueAt( i, 0) );
            dtm.removeRow(i);
        }
    }//GEN-LAST:event_jButtonRemParameterActionPerformed

    private void jButtonModParameterActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_jButtonModParameterActionPerformed
        
        if (this.isInit()) return;
        
        if (currentSelectedChartElement == null) return;
                int rowNumber = jTableDatasetParameters.getSelectedRow();
        JRSubreportParameter parameter = (JRSubreportParameter)jTableDatasetParameters.getValueAt( jTableDatasetParameters.getSelectedRow(), 0);
        
        JRSubreportParameterDialog jrpd = new JRSubreportParameterDialog(this, true);
        jrpd.setParameter( parameter );
        jrpd.show();
        
        if (jrpd.getDialogResult() == javax.swing.JOptionPane.OK_OPTION) {
            parameter.setName( jrpd.getParameter().getName() );
            parameter.setExpression( jrpd.getParameter().getExpression());
            javax.swing.table.DefaultTableModel dtm = (javax.swing.table.DefaultTableModel)jTableDatasetParameters.getModel();
            dtm.setValueAt(parameter, rowNumber, 0);
            dtm.setValueAt(parameter.getExpression(), rowNumber, 1);
            jTableDatasetParameters.updateUI();
        }
    }//GEN-LAST:event_jButtonModParameterActionPerformed

    private void jButtonAddParameterActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_jButtonAddParameterActionPerformed
        if (this.isInit()) return;
        
        if (currentSelectedChartElement == null) return;
        // Set the new value for all selected elements...
                
        JRSubreportParameterDialog jrpd = new JRSubreportParameterDialog(this, true);
        jrpd.show();
        
        if (jrpd.getDialogResult() == javax.swing.JOptionPane.OK_OPTION) {
            it.businesslogic.ireport.JRSubreportParameter parameter = jrpd.getParameter();
            currentSelectedChartElement.getChart().getDataset().getSubreportParameters().addElement( parameter );
            javax.swing.table.DefaultTableModel dtm = (javax.swing.table.DefaultTableModel)jTableDatasetParameters.getModel();
            dtm.addRow(new Object[]{parameter, parameter.getExpression()});
        }
    }//GEN-LAST:event_jButtonAddParameterActionPerformed

    private void jComboBoxSubDatasetActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_jComboBoxSubDatasetActionPerformed
        
        if (this.isInit()) return; 

       
            if (currentSelectedChartElement != null)
            {
                if (this.jComboBoxSubDataset.getSelectedIndex() > 0)
                {
                        if ( currentSelectedChartElement.getChart().getDataset().getSubDataset() != jComboBoxSubDataset.getSelectedItem())
                        {
                            currentSelectedChartElement.getChart().getDataset().setSubDataset( (SubDataset)jComboBoxSubDataset.getSelectedItem() );
                            jTabbedPane2.setVisible(true);
                        }
                            
                // Check subdataset parameters.... (TODO)
                }
                else
                {
                    currentSelectedChartElement.getChart().getDataset().setSubDataset( null );
                    currentSelectedChartElement.getChart().getDataset().getSubreportParameters().removeAllElements();
                    currentSelectedChartElement.getChart().getDataset().setParametersMapExpression("");
                    currentSelectedChartElement.getChart().getDataset().setConnectionExpression("");
                    currentSelectedChartElement.getChart().getDataset().setDataSourceExpression("");
                    currentSelectedChartElement.getChart().getDataset().setUseConnection(false);
                    
                    javax.swing.table.DefaultTableModel dtm = (javax.swing.table.DefaultTableModel)jTableDatasetParameters.getModel();
                    dtm.setRowCount(0);
                    this.jComboBoxDatasetConnectionType.setSelectedIndex(0);
                    this.jRTextExpressionAreaTextConnectionExpression.setEnabled(false);
                    this.jRTextExpressionAreaTextConnectionExpression.setBackground(Color.LIGHT_GRAY);
                    this.jRTextExpressionAreaTextConnectionExpression.setText("");
                    jRTextExpressionAreaMapExpression.setText("");
                
                    jTabbedPane2.setVisible(false);
                    jTabbedPane2.updateUI();
                }
        }
    }//GEN-LAST:event_jComboBoxSubDatasetActionPerformed

    private void jComboBoxDatasetConnectionTypeActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_jComboBoxDatasetConnectionTypeActionPerformed
        if (isInit() || currentSelectedChartElement == null) return;
                
        if (jComboBoxDatasetConnectionType.getSelectedIndex() == 0) {
            currentSelectedChartElement.getChart().getDataset().setUseConnection(false);
            currentSelectedChartElement.getChart().getDataset().setConnectionExpression("");
            currentSelectedChartElement.getChart().getDataset().setDataSourceExpression("");
            jRTextExpressionAreaTextConnectionExpression.setText("");
            jRTextExpressionAreaTextConnectionExpression.setEnabled(false);
            jRTextExpressionAreaTextConnectionExpression.setBackground(Color.LIGHT_GRAY);
        }
        else if (jComboBoxDatasetConnectionType.getSelectedIndex() == 1) {
            currentSelectedChartElement.getChart().getDataset().setUseConnection(true);
            currentSelectedChartElement.getChart().getDataset().setDataSourceExpression("");
            currentSelectedChartElement.getChart().getDataset().setConnectionExpression("$P{REPORT_CONNECTION}");
            jRTextExpressionAreaTextConnectionExpression.setText("$P{REPORT_CONNECTION}");
            jRTextExpressionAreaTextConnectionExpression.setEnabled(true);
            jRTextExpressionAreaTextConnectionExpression.setBackground(Color.WHITE);
        }
        else if (jComboBoxDatasetConnectionType.getSelectedIndex() == 2) {
            currentSelectedChartElement.getChart().getDataset().setUseConnection(false);
            currentSelectedChartElement.getChart().getDataset().setDataSourceExpression("$P{MyDataource}");
            currentSelectedChartElement.getChart().getDataset().setConnectionExpression("");
            jRTextExpressionAreaTextConnectionExpression.setText("$P{MyDataource}");
            jRTextExpressionAreaTextConnectionExpression.setEnabled(true);
            jRTextExpressionAreaTextConnectionExpression.setBackground(Color.WHITE);
        }
    }//GEN-LAST:event_jComboBoxDatasetConnectionTypeActionPerformed

    private void jButtonPasteActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_jButtonPasteActionPerformed

        
        if (currentSelectedChartElement == null) return;
        if (it.businesslogic.ireport.gui.MainFrame.getMainInstance().getChartDatasetClipBoard() == null) return;
        
        Dataset theDataset = it.businesslogic.ireport.gui.MainFrame.getMainInstance().getChartDatasetClipBoard();
        
        currentSelectedChartElement.getChart().getDataset().setIncrementType( it.businesslogic.ireport.gui.MainFrame.getMainInstance().getChartDatasetClipBoard().getIncrementType());
        currentSelectedChartElement.getChart().getDataset().setIncrementGroup( it.businesslogic.ireport.gui.MainFrame.getMainInstance().getChartDatasetClipBoard().getIncrementGroup());
        currentSelectedChartElement.getChart().getDataset().setResetType( it.businesslogic.ireport.gui.MainFrame.getMainInstance().getChartDatasetClipBoard().getResetType());
        currentSelectedChartElement.getChart().getDataset().setResetGroup( it.businesslogic.ireport.gui.MainFrame.getMainInstance().getChartDatasetClipBoard().getResetGroup());
        
        currentSelectedChartElement.getChart().getDataset().setUseConnection( theDataset.isUseConnection());
        currentSelectedChartElement.getChart().getDataset().setSubDataset( theDataset.getSubDataset());
        currentSelectedChartElement.getChart().getDataset().setParametersMapExpression( theDataset.getParametersMapExpression());
        currentSelectedChartElement.getChart().getDataset().setConnectionExpression( theDataset.getConnectionExpression());
        currentSelectedChartElement.getChart().getDataset().setDataSourceExpression( theDataset.getDataSourceExpression());
        
        for (int i=0; i< theDataset.getSubreportParameters().size(); ++i)
        {
            currentSelectedChartElement.getChart().getDataset().getSubreportParameters().add( ((JRSubreportParameter)theDataset.getSubreportParameters().elementAt(i)).cloneMe() );
        }
            
        if (it.businesslogic.ireport.gui.MainFrame.getMainInstance().getChartDatasetClipBoard().getClass().getName().equals(
            currentSelectedChartElement.getChart().getDataset().getClass().getName() ) )
        {
            currentSelectedChartElement.getChart().setDataset(  it.businesslogic.ireport.gui.MainFrame.getMainInstance().getChartDatasetClipBoard().cloneMe() );
            this.setDatasetPanel( currentSelectedChartElement.getChart().getDataset() );
        }
        
        init = true;
        
        Misc.setComboboxSelectedTagValue(jComboBoxIncrementType, currentSelectedChartElement.getChart().getDataset().getIncrementType());
        jComboBoxIncrementGroup.setSelectedItem( currentSelectedChartElement.getChart().getDataset().getIncrementGroup() );
        Misc.setComboboxSelectedTagValue(jComboBoxResetType, currentSelectedChartElement.getChart().getDataset().getResetType());
        jComboBoxResetGroup.setSelectedItem( currentSelectedChartElement.getChart().getDataset().getResetGroup() );
        
        if (currentSelectedChartElement.getChart().getDataset().getSubDataset() != null)
            {
                jComboBoxSubDataset.setSelectedItem(currentSelectedChartElement.getChart().getDataset().getSubDataset());
                jTabbedPane2.setVisible(true);
            
                jRTextExpressionAreaMapExpression.setText( currentSelectedChartElement.getChart().getDataset().getParametersMapExpression()  );
                if (!currentSelectedChartElement.getChart().getDataset().isUseConnection() &&  Misc.nvl( currentSelectedChartElement.getChart().getDataset().getDataSourceExpression(),"").trim().equals("")) {
                    this.jComboBoxDatasetConnectionType.setSelectedIndex(0);
                    this.jRTextExpressionAreaTextConnectionExpression.setEnabled(false);
                    this.jRTextExpressionAreaTextConnectionExpression.setBackground(Color.LIGHT_GRAY);
                    this.jRTextExpressionAreaTextConnectionExpression.setText("");
                }
                else if (currentSelectedChartElement.getChart().getDataset().isUseConnection()) {
                    this.jComboBoxDatasetConnectionType.setSelectedIndex(1);
                    this.jRTextExpressionAreaTextConnectionExpression.setEnabled(true);
                    this.jRTextExpressionAreaTextConnectionExpression.setBackground(Color.WHITE);
                    this.jRTextExpressionAreaTextConnectionExpression.setText( currentSelectedChartElement.getChart().getDataset().getConnectionExpression());
                }
                else {
                    this.jComboBoxDatasetConnectionType.setSelectedIndex(2);
                    this.jRTextExpressionAreaTextConnectionExpression.setEnabled(true);
                    this.jRTextExpressionAreaTextConnectionExpression.setBackground(Color.WHITE);
                    this.jRTextExpressionAreaTextConnectionExpression.setText( currentSelectedChartElement.getChart().getDataset().getDataSourceExpression());
                }

                //Add parameters...
                javax.swing.table.DefaultTableModel dtm = (javax.swing.table.DefaultTableModel)jTableDatasetParameters.getModel();
                dtm.setRowCount(0);

                java.util.Enumeration enum_parameters = currentSelectedChartElement.getChart().getDataset().getSubreportParameters().elements();
                while (enum_parameters.hasMoreElements()) {
                    it.businesslogic.ireport.JRSubreportParameter parameter = (it.businesslogic.ireport.JRSubreportParameter)enum_parameters.nextElement();
                    Vector row = new Vector();
                    row.addElement(parameter);
                    row.addElement(parameter.getExpression());
                    dtm.addRow(row);
                }            
            
            }
            else
            {
                javax.swing.table.DefaultTableModel dtm = (javax.swing.table.DefaultTableModel)jTableDatasetParameters.getModel();
                dtm.setRowCount(0);
                this.jComboBoxDatasetConnectionType.setSelectedIndex(0);
                this.jRTextExpressionAreaTextConnectionExpression.setEnabled(false);
                this.jRTextExpressionAreaTextConnectionExpression.setBackground(Color.LIGHT_GRAY);
                this.jRTextExpressionAreaTextConnectionExpression.setText("");
                jRTextExpressionAreaMapExpression.setText("");
                
                jComboBoxSubDataset.setSelectedIndex(0);
                jTabbedPane2.setVisible(false);
            }
        
        init = false;
        
    }//GEN-LAST:event_jButtonPasteActionPerformed

    private void jButtonCopyActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_jButtonCopyActionPerformed

        if (currentSelectedChartElement == null) return;
        it.businesslogic.ireport.gui.MainFrame.getMainInstance().setChartDatasetClipBoard( currentSelectedChartElement.getChart().getDataset().cloneMe() );
        jButtonPaste.setEnabled(true);
    }//GEN-LAST:event_jButtonCopyActionPerformed

    private void jComboBoxTypeOfDataActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_jComboBoxTypeOfDataActionPerformed

        if (isInit() || currentSelectedChartElement == null || !(currentSelectedChartElement.getChart() instanceof XYBarChart )) return;
        
        if (jComboBoxTypeOfData.getSelectedItem() != null)
        {
            String typeOfDataset = ((Tag)jComboBoxTypeOfData.getSelectedItem()).getValue()+"";
            if (currentSelectedChartElement.getChart().getDataset().getClass().getName().equals(typeOfDataset)) return;
            
            try {
                jPanelDataDefinition.removeAll();
                Dataset dataset = (Dataset)this.getClass().forName( typeOfDataset ).newInstance();
                currentSelectedChartElement.getChart().setDataset(dataset);
                
            
            } catch (Exception ex)
            {
                 currentSelectedChartElement.getChart().setDataset(new Dataset());
            }
            setDatasetPanel(currentSelectedChartElement.getChart().getDataset());
        }
        
    }//GEN-LAST:event_jComboBoxTypeOfDataActionPerformed

    
    
    
    
    private void jComboBoxIncrementGroupActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_jComboBoxIncrementGroupActionPerformed
        if (isInit() || currentSelectedChartElement == null) return;
        currentSelectedChartElement.getChart().getDataset().setIncrementGroup( ""+jComboBoxIncrementGroup.getSelectedItem());
    }//GEN-LAST:event_jComboBoxIncrementGroupActionPerformed

    private void jComboBoxIncrementTypeActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_jComboBoxIncrementTypeActionPerformed
        
        if (isInit() || currentSelectedChartElement == null) return;
        currentSelectedChartElement.getChart().getDataset().setIncrementType( ((Tag)jComboBoxIncrementType.getSelectedItem()).getValue()+"");
        
        if (currentSelectedChartElement.getChart().getDataset().getIncrementType().equals("Group"))
        {
            // We have to removethe null entry...
            if (jComboBoxIncrementGroup.getItemAt(0).equals(""))
            {
                jComboBoxIncrementGroup.removeItemAt(0);
            }
            jComboBoxIncrementGroup.setSelectedIndex(0);
        }
        else
        {
            if (!jComboBoxIncrementGroup.getItemAt(0).equals(""))
            {
                jComboBoxIncrementGroup.insertItemAt("",0);
            }
            jComboBoxIncrementGroup.setSelectedIndex(0);
        }
    }//GEN-LAST:event_jComboBoxIncrementTypeActionPerformed

    private void jComboBoxResetGroupActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_jComboBoxResetGroupActionPerformed

        if (isInit() || currentSelectedChartElement == null) return;
        currentSelectedChartElement.getChart().getDataset().setResetGroup( ""+jComboBoxResetGroup.getSelectedItem());
        
    }//GEN-LAST:event_jComboBoxResetGroupActionPerformed

    private void jComboBoxResetTypeActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_jComboBoxResetTypeActionPerformed

        if (isInit() || currentSelectedChartElement == null) return;
        currentSelectedChartElement.getChart().getDataset().setResetType( ((Tag)jComboBoxResetType.getSelectedItem()).getValue()+"" );
        
        if (currentSelectedChartElement.getChart().getDataset().getResetType().equals("Group"))
        {
            // We have to remove the null entry...
            if (jComboBoxResetGroup.getItemAt(0).equals(""))
            {
                jComboBoxResetGroup.removeItemAt(0);
            }
            jComboBoxResetGroup.setSelectedIndex(0);
        }
        else
        {
            if (!jComboBoxResetGroup.getItemAt(0).equals(""))
            {
                jComboBoxResetGroup.insertItemAt("",0);
            }
            jComboBoxResetGroup.setSelectedIndex(0);
        }
        
    }//GEN-LAST:event_jComboBoxResetTypeActionPerformed
    
    
    // Variables declaration - do not modify//GEN-BEGIN:variables
    private javax.swing.JButton jButtonAddParameter;
    private javax.swing.JButton jButtonCopy;
    private javax.swing.JButton jButtonModParameter;
    private javax.swing.JButton jButtonPaste;
    private javax.swing.JButton jButtonRemParameter;
    private javax.swing.JComboBox jComboBoxDatasetConnectionType;
    private javax.swing.JComboBox jComboBoxIncrementGroup;
    private javax.swing.JComboBox jComboBoxIncrementType;
    private javax.swing.JComboBox jComboBoxResetGroup;
    private javax.swing.JComboBox jComboBoxResetType;
    private javax.swing.JComboBox jComboBoxSubDataset;
    private javax.swing.JComboBox jComboBoxTypeOfData;
    private javax.swing.JLabel jLabel26;
    private javax.swing.JLabel jLabel41;
    private javax.swing.JLabel jLabelIncrementGroup;
    private javax.swing.JLabel jLabelIncrementType;
    private javax.swing.JLabel jLabelIncrementType1;
    private javax.swing.JLabel jLabelResetGroup;
    private javax.swing.JLabel jLabelResetType;
    private javax.swing.JLabel jLabelTypeOfData;
    private javax.swing.JPanel jPanel1;
    private javax.swing.JPanel jPanel10;
    private javax.swing.JPanel jPanel13;
    private javax.swing.JPanel jPanel16;
    private javax.swing.JPanel jPanel2;
    private javax.swing.JPanel jPanel3;
    private javax.swing.JPanel jPanel4;
    private javax.swing.JPanel jPanel5;
    private javax.swing.JPanel jPanel6;
    private javax.swing.JPanel jPanel7;
    private javax.swing.JPanel jPanelData;
    private javax.swing.JPanel jPanelDataDefinition;
    private javax.swing.JPanel jPanelDataset;
    private javax.swing.JPanel jPanelProperties;
    private it.businesslogic.ireport.gui.JRTextExpressionArea jRTextExpressionAreaMapExpression;
    private it.businesslogic.ireport.gui.JRTextExpressionArea jRTextExpressionAreaTextConnectionExpression;
    private javax.swing.JScrollPane jScrollPane2;
    private javax.swing.JTabbedPane jTabbedPane1;
    private javax.swing.JTabbedPane jTabbedPane2;
    private javax.swing.JTabbedPane jTabbedPaneData;
    private javax.swing.JTable jTableDatasetParameters;
    // End of variables declaration//GEN-END:variables
    
    /**
     * This method add entries in the properties sheet to edit all common chart properties.
     * The common chart properties are all the ones listed in the chart tag:
     * isShowLegend
     * evaluationTime
     * 
     */
    public void addCommonChartProperties()
    {
        if (currentSelectedChartElement != null)
        {
            ExpressionSheetProperty chartTitleProperty = new ExpressionSheetProperty("chartTitle","Chart title expression");
            chartTitleProperty.setValue( currentSelectedChartElement.getChart().getTitle().getTitleExpression());
            sheetPanel.addSheetProperty("Common", chartTitleProperty);
            
            FontSheetProperty chartTitleFontProperty = new FontSheetProperty("chartTitleFont","Chart title font");
            chartTitleFontProperty.setValue(  currentSelectedChartElement.getChart().getTitle().getFont());
            sheetPanel.addSheetProperty("Common", chartTitleFontProperty);
            
            SheetProperty chartTitleColorProperty = new SheetProperty("chartTitleColor","Chart title color", SheetProperty.COLOR);
            chartTitleColorProperty.setValue(  currentSelectedChartElement.getChart().getTitle().getColor());
            sheetPanel.addSheetProperty("Common", chartTitleColorProperty);
            
            SheetProperty chartTitlePositionProperty = new SheetProperty("chartTitlePosition","Chart title position", SheetProperty.COMBOBOX);
            chartTitlePositionProperty.setTags( new Tag[]{ new Tag("Top","Top"),
                                                           new Tag("Bottom","Bottom"),
                                                           new Tag("Left","Left"),
                                                           new Tag("Right","Right")});
            chartTitlePositionProperty.setValue(  currentSelectedChartElement.getChart().getTitle().getPosition());
            sheetPanel.addSheetProperty("Common", chartTitlePositionProperty);
            
            ExpressionSheetProperty chartSubTitleProperty = new ExpressionSheetProperty("chartSubTitle","Chart subtitle expression");
            chartSubTitleProperty.setValue( currentSelectedChartElement.getChart().getSubTitle().getTitleExpression());
            sheetPanel.addSheetProperty("Common", chartSubTitleProperty);
            
            FontSheetProperty chartSubTitleFontProperty = new FontSheetProperty("chartSubTitleFont","Chart subtitle font");
            chartSubTitleFontProperty.setValue(  currentSelectedChartElement.getChart().getSubTitle().getFont());
            sheetPanel.addSheetProperty("Common", chartSubTitleFontProperty);
            
            SheetProperty chartSubTitleColorProperty = new SheetProperty("chartSubTitleColor","Chart subtitle color", SheetProperty.COLOR);
            chartSubTitleColorProperty.setValue( currentSelectedChartElement.getChart().getSubTitle().getColor());
            sheetPanel.addSheetProperty("Common", chartSubTitleColorProperty);

            SheetProperty isShowLegendProperty = new SheetProperty("isShowLegend","Show legend", SheetProperty.BOOLEAN);
            isShowLegendProperty.setValue(new Boolean( currentSelectedChartElement.getChart().isShowLegend() ));
            sheetPanel.addSheetProperty("Common", isShowLegendProperty);
            
            SheetProperty plotOrientationProperty = new SheetProperty("orientation","Orientation", SheetProperty.COMBOBOX);
            plotOrientationProperty.setTags( new Tag[]{ new Tag("Vertical","Vertical"),
                                                        new Tag("Horizontal","Horizontal")});
            plotOrientationProperty.setValue(  currentSelectedChartElement.getChart().getPlot().getOrientation());
            sheetPanel.addSheetProperty("Common", plotOrientationProperty);
            
            SheetProperty chartBackcolorProperty = new SheetProperty("chartBackcolor","Backcolor", SheetProperty.COLOR);
            chartBackcolorProperty.setValue( currentSelectedChartElement.getChart().getPlot().getBackcolor() );
            sheetPanel.addSheetProperty("Common", chartBackcolorProperty);
            
            SheetProperty backgroundAlphaProperty = new DoubleSheetProperty("backgroundAlpha","Background Alpha (%)");
            backgroundAlphaProperty.setValue( new Double(currentSelectedChartElement.getChart().getPlot().getBackgroundAlpha() ));
            sheetPanel.addSheetProperty("Common", backgroundAlphaProperty);
            
            SheetProperty foregroundAlphaProperty = new DoubleSheetProperty("foregroundAlpha","Foreground Alpha (%)");
            foregroundAlphaProperty.setValue( new Double(currentSelectedChartElement.getChart().getPlot().getForegroundAlpha() ));
            sheetPanel.addSheetProperty("Common", foregroundAlphaProperty);
            
            SheetProperty customizerClassProperty = new SheetProperty("customizerClass","Customizer class", SheetProperty.STRING);
            customizerClassProperty.setValue( currentSelectedChartElement.getChart().getCustomizerClass());
            sheetPanel.addSheetProperty("Common", customizerClassProperty);
            
        }
    }

    public int getDialogResult() {
        return dialogResult;
    }

    public void setDialogResult(int dialogResult) {
        this.dialogResult = dialogResult;
    }

    public JReportFrame getJReportFrame() {
        return jReportFrame;
    }

    public void setJReportFrame(JReportFrame jReportFrame) {
        this.jReportFrame = jReportFrame;
        
    }
    
     public void sheetPropertyValueChanged(SheetPropertyValueChangedEvent evt)
     {
         if (currentSelectedChartElement == null) return;
        
         String property = evt.getPropertyName();

         if (property.equals("chartTitle")) currentSelectedChartElement.getChart().getTitle().setTitleExpression( ""+evt.getNewValue() );
         else if (property.equals("chartTitleFont")) currentSelectedChartElement.getChart().getTitle().setFont( (it.businesslogic.ireport.IReportFont)evt.getNewValue() );
         else if (property.equals("chartTitleColor")) currentSelectedChartElement.getChart().getTitle().setColor( (java.awt.Color) ColorSelectorPanel.parseColorString( ""+evt.getNewValue()) );
         else if (property.equals("chartTitlePosition")) currentSelectedChartElement.getChart().getTitle().setPosition( ""+evt.getNewValue() );
         else if (property.equals("chartSubTitle")) currentSelectedChartElement.getChart().getSubTitle().setTitleExpression( ""+evt.getNewValue() );
         else if (property.equals("chartSubTitleFont")) currentSelectedChartElement.getChart().getSubTitle().setFont( (it.businesslogic.ireport.IReportFont)evt.getNewValue() );
         else if (property.equals("chartSubTitleColor")) currentSelectedChartElement.getChart().getSubTitle().setColor( (java.awt.Color) ColorSelectorPanel.parseColorString( ""+evt.getNewValue()) );
         else if (property.equals("isShowLegend")) currentSelectedChartElement.getChart().setShowLegend( ((Boolean)evt.getNewValue()).booleanValue() );
         else if (property.equals("chartBackcolor")) currentSelectedChartElement.getChart().getPlot().setBackcolor( (java.awt.Color) ColorSelectorPanel.parseColorString( ""+evt.getNewValue()) );
         else if (property.equals("orientation")) currentSelectedChartElement.getChart().getPlot().setOrientation( ""+evt.getNewValue() );
         else if (property.equals("backgroundAlpha")) {
             double newval = ((Double)evt.getNewValue()).doubleValue();
             if (newval < 0.0 || newval > 1.0)
             {
                 JOptionPane.showMessageDialog(this,"Background Alpha must be a number between 0 and 1.","Value not valid",JOptionPane.ERROR_MESSAGE);
                 sheetPanel.setPropertyValue(evt.getPropertyName(), evt.getOldValue() );
             }
             else
             {
                currentSelectedChartElement.getChart().getPlot().setBackgroundAlpha( ((Double)evt.getNewValue()).doubleValue());
             }
         }
         else if (property.equals("foregroundAlpha")){
             double newval = ((Double)evt.getNewValue()).doubleValue();
             if (newval < 0.0 || newval > 1.0)
             {
                 JOptionPane.showMessageDialog(this,"Foreground Alpha must be a number between 0 and 1.","Value not valid",JOptionPane.ERROR_MESSAGE);
                 sheetPanel.setPropertyValue(evt.getPropertyName(), evt.getOldValue() );
             }
             else
             {
                currentSelectedChartElement.getChart().getPlot().setForegroundAlpha( ((Double)evt.getNewValue()).doubleValue());
             }
         }
         else if (property.equals("depthFactor") && currentSelectedChartElement.getChart().getPlot() instanceof Pie3DPlot) ((Pie3DPlot)currentSelectedChartElement.getChart().getPlot()).setDepthFactor( ((Double)evt.getNewValue()).doubleValue() );
         else if (property.equals("isShowLabelsBarPlot") && currentSelectedChartElement.getChart().getPlot() instanceof BarPlot) ((BarPlot)currentSelectedChartElement.getChart().getPlot()).setShowLabels(  ((Boolean)evt.getNewValue()).booleanValue()  );
         else if (property.equals("isShowTickMarksBarPlot") && currentSelectedChartElement.getChart().getPlot() instanceof BarPlot) ((BarPlot)currentSelectedChartElement.getChart().getPlot()).setShowTickMarks(  ((Boolean)evt.getNewValue()).booleanValue()  );
         else if (property.equals("isShowTickLabelsBarPlot") && currentSelectedChartElement.getChart().getPlot() instanceof BarPlot) ((BarPlot)currentSelectedChartElement.getChart().getPlot()).setShowTickLabels(  ((Boolean)evt.getNewValue()).booleanValue()  );
         else if (property.equals("categoryAxisLabelExpressionBarPlot") && currentSelectedChartElement.getChart().getPlot() instanceof BarPlot) ((BarPlot)currentSelectedChartElement.getChart().getPlot()).setCategoryAxisLabelExpression( ""+evt.getNewValue()  );
         else if (property.equals("valueAxisLabelExpressionBarPlot") && currentSelectedChartElement.getChart().getPlot() instanceof BarPlot) ((BarPlot)currentSelectedChartElement.getChart().getPlot()).setValueAxisLabelExpression( ""+evt.getNewValue()  );
         else if (property.equals("isShowLabelsBar3DPlot") && currentSelectedChartElement.getChart().getPlot() instanceof Bar3DPlot) ((Bar3DPlot)currentSelectedChartElement.getChart().getPlot()).setShowLabels(  ((Boolean)evt.getNewValue()).booleanValue()  );
         else if (property.equals("xOffsetBar3DPlot") && currentSelectedChartElement.getChart().getPlot() instanceof Bar3DPlot) ((Bar3DPlot)currentSelectedChartElement.getChart().getPlot()).setXOffset( ((Double)evt.getNewValue()).doubleValue() );
         else if (property.equals("yOffsetBar3DPlot") && currentSelectedChartElement.getChart().getPlot() instanceof Bar3DPlot) ((Bar3DPlot)currentSelectedChartElement.getChart().getPlot()).setYOffset( ((Double)evt.getNewValue()).doubleValue() );
         else if (property.equals("categoryAxisLabelExpressionBar3DPlot") && currentSelectedChartElement.getChart().getPlot() instanceof Bar3DPlot) ((Bar3DPlot)currentSelectedChartElement.getChart().getPlot()).setCategoryAxisLabelExpression( ""+evt.getNewValue()  );
         else if (property.equals("valueAxisLabelExpressionBar3DPlot") && currentSelectedChartElement.getChart().getPlot() instanceof Bar3DPlot) ((Bar3DPlot)currentSelectedChartElement.getChart().getPlot()).setValueAxisLabelExpression( ""+evt.getNewValue()  );
         else if (property.equals("isShowLinesLinePlot") && currentSelectedChartElement.getChart().getPlot() instanceof LinePlot) ((LinePlot)currentSelectedChartElement.getChart().getPlot()).setShowLines(  ((Boolean)evt.getNewValue()).booleanValue()  );
         else if (property.equals("isShowShapesLinePlot") && currentSelectedChartElement.getChart().getPlot() instanceof LinePlot) ((LinePlot)currentSelectedChartElement.getChart().getPlot()).setShowShapes(  ((Boolean)evt.getNewValue()).booleanValue()  );
         else if (property.equals("categoryAxisLabelExpressionLinePlot") && currentSelectedChartElement.getChart().getPlot() instanceof LinePlot) ((LinePlot)currentSelectedChartElement.getChart().getPlot()).setCategoryAxisLabelExpression( ""+evt.getNewValue()  );
         else if (property.equals("valueAxisLabelExpressionLinePlot") && currentSelectedChartElement.getChart().getPlot() instanceof LinePlot) ((LinePlot)currentSelectedChartElement.getChart().getPlot()).setValueAxisLabelExpression( ""+evt.getNewValue()  );
         else if (property.equals("categoryAxisLabelExpressionAreaPlot") && currentSelectedChartElement.getChart().getPlot() instanceof AreaPlot) ((AreaPlot)currentSelectedChartElement.getChart().getPlot()).setCategoryAxisLabelExpression( ""+evt.getNewValue()  );
         else if (property.equals("valueAxisLabelExpressionAreaPlot") && currentSelectedChartElement.getChart().getPlot() instanceof AreaPlot) ((AreaPlot)currentSelectedChartElement.getChart().getPlot()).setValueAxisLabelExpression( ""+evt.getNewValue()  );
         else if (property.equals("isShowLinesScatterPlot") && currentSelectedChartElement.getChart().getPlot() instanceof ScatterPlot) ((ScatterPlot)currentSelectedChartElement.getChart().getPlot()).setShowLines(  ((Boolean)evt.getNewValue()).booleanValue()  );
         else if (property.equals("isShowShapesScatterPlot") && currentSelectedChartElement.getChart().getPlot() instanceof ScatterPlot) ((ScatterPlot)currentSelectedChartElement.getChart().getPlot()).setShowShapes(  ((Boolean)evt.getNewValue()).booleanValue()  );
         else if (property.equals("xAxisLabelExpressionScatterPlot") && currentSelectedChartElement.getChart().getPlot() instanceof ScatterPlot) ((ScatterPlot)currentSelectedChartElement.getChart().getPlot()).setXAxisLabelExpression( ""+evt.getNewValue()  );
         else if (property.equals("yAxisLabelExpressionScatterPlot") && currentSelectedChartElement.getChart().getPlot() instanceof ScatterPlot) ((ScatterPlot)currentSelectedChartElement.getChart().getPlot()).setYAxisLabelExpression( ""+evt.getNewValue()  );
         else if (property.equals("scaleTypeBubblePlot") && currentSelectedChartElement.getChart().getPlot() instanceof BubblePlot) ((BubblePlot)currentSelectedChartElement.getChart().getPlot()).setScaleType( ""+evt.getNewValue()  );
         else if (property.equals("xAxisLabelExpressionBubblePlot") && currentSelectedChartElement.getChart().getPlot() instanceof BubblePlot) ((BubblePlot)currentSelectedChartElement.getChart().getPlot()).setXAxisLabelExpression( ""+evt.getNewValue()  );
         else if (property.equals("yAxisLabelExpressionBubblePlot") && currentSelectedChartElement.getChart().getPlot() instanceof BubblePlot) ((BubblePlot)currentSelectedChartElement.getChart().getPlot()).setYAxisLabelExpression( ""+evt.getNewValue()  );
         else if (property.equals("isShowLinesTimeSeriesPlot") && currentSelectedChartElement.getChart().getPlot() instanceof TimeSeriesPlot) ((TimeSeriesPlot)currentSelectedChartElement.getChart().getPlot()).setShowLines(  ((Boolean)evt.getNewValue()).booleanValue()  );
         else if (property.equals("isShowShapesTimeSeriesPlot") && currentSelectedChartElement.getChart().getPlot() instanceof TimeSeriesPlot) ((TimeSeriesPlot)currentSelectedChartElement.getChart().getPlot()).setShowShapes(  ((Boolean)evt.getNewValue()).booleanValue()  );
         else if (property.equals("timeAxisLabelExpressionTimeSeriesPlot") && currentSelectedChartElement.getChart().getPlot() instanceof TimeSeriesPlot) ((TimeSeriesPlot)currentSelectedChartElement.getChart().getPlot()).setTimeAxisLabelExpression( ""+evt.getNewValue()  );
         else if (property.equals("valueAxisLabelExpressionTimeSeriesPlot") && currentSelectedChartElement.getChart().getPlot() instanceof TimeSeriesPlot) ((TimeSeriesPlot)currentSelectedChartElement.getChart().getPlot()).setValueAxisLabelExpression( ""+evt.getNewValue()  );
         else if (property.equals("isShowOpenTicksHighLowPlot") && currentSelectedChartElement.getChart().getPlot() instanceof HighLowPlot) ((HighLowPlot)currentSelectedChartElement.getChart().getPlot()).setShowOpenTicks(  ((Boolean)evt.getNewValue()).booleanValue()  );
         else if (property.equals("isShowCloseTicksHighLowPlot") && currentSelectedChartElement.getChart().getPlot() instanceof HighLowPlot) ((HighLowPlot)currentSelectedChartElement.getChart().getPlot()).setShowCloseTicks(  ((Boolean)evt.getNewValue()).booleanValue()  );
         else if (property.equals("timeAxisLabelExpressionHighLowPlot") && currentSelectedChartElement.getChart().getPlot() instanceof HighLowPlot) ((HighLowPlot)currentSelectedChartElement.getChart().getPlot()).setTimeAxisLabelExpression( ""+evt.getNewValue()  );
         else if (property.equals("valueAxisLabelExpressionHighLowPlot") && currentSelectedChartElement.getChart().getPlot() instanceof HighLowPlot) ((HighLowPlot)currentSelectedChartElement.getChart().getPlot()).setValueAxisLabelExpression( ""+evt.getNewValue()  );
         else if (property.equals("isShowVolumeCandlestickPlot") && currentSelectedChartElement.getChart().getPlot() instanceof CandlestickPlot) ((CandlestickPlot)currentSelectedChartElement.getChart().getPlot()).setShowVolume(  ((Boolean)evt.getNewValue()).booleanValue()  );
         else if (property.equals("timeAxisLabelExpressionCandlestickPlot") && currentSelectedChartElement.getChart().getPlot() instanceof CandlestickPlot) ((CandlestickPlot)currentSelectedChartElement.getChart().getPlot()).setTimeAxisLabelExpression( ""+evt.getNewValue()  );
         else if (property.equals("valueAxisLabelExpressionCandlestickPlot") && currentSelectedChartElement.getChart().getPlot() instanceof CandlestickPlot) ((CandlestickPlot)currentSelectedChartElement.getChart().getPlot()).setValueAxisLabelExpression( ""+evt.getNewValue()  );
         else if (property.equals("customizerClass")) currentSelectedChartElement.getChart().setCustomizerClass( ""+evt.getNewValue() );
     
     }
     
     
     /**
     * This method update the comboboxes where is present the goup list.
     */
    public void updateGroups()
    {

        if (it.businesslogic.ireport.gui.MainFrame.getMainInstance().getActiveReportFrame() == null)
	{
            jComboBoxResetGroup.removeAllItems();
            jComboBoxResetGroup.addItem("");
        }	
        else
        {
            Misc.updateStringComboBox(jComboBoxResetGroup, 
                                      it.businesslogic.ireport.gui.MainFrame.getMainInstance().getActiveReportFrame().getReport().getGroups(), true);
            Misc.updateStringComboBox(jComboBoxIncrementGroup, 
                                      it.businesslogic.ireport.gui.MainFrame.getMainInstance().getActiveReportFrame().getReport().getGroups(), true);
        }
        
    }
    
    
    public void updateSubDatasets()
    {

        if (it.businesslogic.ireport.gui.MainFrame.getMainInstance().getActiveReportFrame() == null)
	{
            jComboBoxSubDataset.removeAllItems();
            jComboBoxSubDataset.addItem("");
        }	
        else
        {
            Misc.updateComboBox(jComboBoxSubDataset, it.businesslogic.ireport.gui.MainFrame.getMainInstance().getActiveReportFrame().getReport().getSubDatasets(), true);
        }
    }
    
    public void applyI18n()
        {
            jTabbedPane1.setTitleAt(0, it.businesslogic.ireport.util.I18n.getString("gui.ChartPropertiesDialog.TabChartProperties","Chart properties"));
            jTabbedPane1.setTitleAt(1, it.businesslogic.ireport.util.I18n.getString("gui.ChartPropertiesDialog.TabChartData","Chart data"));
            jLabelTypeOfData.setText( it.businesslogic.ireport.util.I18n.getString("gui.ChartPropertiesDialog.LabelTypeOfDataset","Type of dataset"));
            jTabbedPaneData.setTitleAt(0, it.businesslogic.ireport.util.I18n.getString("gui.ChartPropertiesDialog.TabDataset","Dataset"));
            jTabbedPaneData.setTitleAt(1, it.businesslogic.ireport.util.I18n.getString("gui.ChartPropertiesDialog.TabDatasetDetails","Details"));
            
            jLabelResetType.setText( it.businesslogic.ireport.util.I18n.getString("resetType","Reset type"));
            jLabelResetGroup.setText( it.businesslogic.ireport.util.I18n.getString("resetGroup","Reset group"));
            jLabelIncrementType.setText( it.businesslogic.ireport.util.I18n.getString("incrementType","Increment type"));
            jLabelIncrementGroup.setText( it.businesslogic.ireport.util.I18n.getString("incrementGroup","Increment group"));
            
            jButtonCopy.setText( it.businesslogic.ireport.util.I18n.getString("charts.copyDataset","Copy dataset"));
            jButtonPaste.setText( it.businesslogic.ireport.util.I18n.getString("charts.pasteDataset","Paste dataset"));
            
            this.setTitle(it.businesslogic.ireport.util.I18n.getString("gui.ChartPropertiesDialog.title","Chart properties"));
            this.getRootPane().updateUI();
        }
    
    private void setDatasetPanel( Dataset dataset )
    {
        jPanelDataDefinition.removeAll();
        
        java.awt.GridBagConstraints gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 4;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.WEST;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.fill = gridBagConstraints.BOTH;
        gridBagConstraints.insets = new java.awt.Insets(4, 4, 4, 4);
                
        if (dataset instanceof TimePeriodDataset)
        {
             TimePeriodDatasetPanel pdp = new TimePeriodDatasetPanel();
             pdp.setTimePeriodDataset((TimePeriodDataset)dataset);
             this.jPanelDataDefinition.add(pdp, gridBagConstraints);
        }
        else if (dataset instanceof CategoryDataset)
        {
             CategoryDatasetPanel pdp = new CategoryDatasetPanel();
             pdp.setCategoryDataset((CategoryDataset)dataset);
             this.jPanelDataDefinition.add(pdp, gridBagConstraints);
        }
        else if (dataset instanceof PieDataset)
        {
             PieDatasetPanel pdp = new PieDatasetPanel();
             pdp.setPieDataset((PieDataset)dataset);
             this.jPanelDataDefinition.add(pdp, gridBagConstraints);
        }
        else if (dataset instanceof TimeSeriesDataset)
        {
             TimeSeriesDatasetPanel pdp = new TimeSeriesDatasetPanel();
             pdp.setTimeSeriesDataset((TimeSeriesDataset)dataset);
             this.jPanelDataDefinition.add(pdp, gridBagConstraints);
        }
        else if (dataset instanceof XYDataset)
        {
             XYDatasetPanel pdp = new XYDatasetPanel();
             pdp.setXYDataset((XYDataset)dataset);
             this.jPanelDataDefinition.add(pdp, gridBagConstraints);
        }
        else if (dataset instanceof XYZDataset)
        {
             XYZDatasetPanel pdp = new XYZDatasetPanel();
             pdp.setXYZDataset((XYZDataset)dataset);
             this.jPanelDataDefinition.add(pdp, gridBagConstraints);
        }
        else if (dataset instanceof HighLowDataset)
        {
            HighLowDatasetPanel pdp = new HighLowDatasetPanel();
             pdp.setHighLowDataset((HighLowDataset)dataset);
             this.jPanelDataDefinition.add(pdp, gridBagConstraints);
        }
        
        Misc.setComboboxSelectedTagValue(jComboBoxTypeOfData, dataset.getClass().getName());
        jPanelDataDefinition.updateUI();
    }
    
    private void setPlotSheetProperties( Plot plot )
    {
        if (plot instanceof Pie3DPlot)
        {
             DoubleSheetProperty chartDepthFactorProperty = new DoubleSheetProperty("depthFactor",it.businesslogic.ireport.util.I18n.getString("charts.depthFactor","Depth factor"));
             chartDepthFactorProperty.setValue( new Double(((Pie3DPlot)plot).getDepthFactor()));
             sheetPanel.addSheetProperty("Pie3D plot", chartDepthFactorProperty);
        }
        else if (plot instanceof BarPlot)
        {
             SheetProperty isShowLabelsProperty = new SheetProperty("isShowLabelsBarPlot",it.businesslogic.ireport.util.I18n.getString("charts.isShowLabelsBarPlot","Show labels"), SheetProperty.BOOLEAN);
                isShowLabelsProperty.setValue( new Boolean(((BarPlot)plot).isShowLabels()) );
                sheetPanel.addSheetProperty("Bar plot", isShowLabelsProperty);
                
                SheetProperty isShowTickMarksProperty = new SheetProperty("isShowTickMarksBarPlot",it.businesslogic.ireport.util.I18n.getString("charts.isShowTickMarksBarPlot","Show tick marks"), SheetProperty.BOOLEAN);
                isShowTickMarksProperty.setValue( new Boolean(((BarPlot)plot).isShowTickMarks()) );
                sheetPanel.addSheetProperty("Bar plot", isShowTickMarksProperty);
                
                SheetProperty isShowTickLabelsProperty = new SheetProperty("isShowTickLabelsBarPlot",it.businesslogic.ireport.util.I18n.getString("charts.isShowTickLabelsBarPlot","Show tick labels"), SheetProperty.BOOLEAN);
                isShowTickLabelsProperty.setValue( new Boolean(((BarPlot)plot).isShowTickLabels()) );
                sheetPanel.addSheetProperty("Bar plot", isShowTickLabelsProperty);
                
                ExpressionSheetProperty categoryAxisLabelExpressionProperty = new ExpressionSheetProperty("categoryAxisLabelExpressionBarPlot",it.businesslogic.ireport.util.I18n.getString("charts.categoryAxisLabelExpressionPlot","Category axis label expression"));
                categoryAxisLabelExpressionProperty.setValue( ((BarPlot)plot).getCategoryAxisLabelExpression() );
                sheetPanel.addSheetProperty("Bar plot", categoryAxisLabelExpressionProperty);
            
                ExpressionSheetProperty valueAxisLabelExpressionProperty = new ExpressionSheetProperty("valueAxisLabelExpressionBarPlot",it.businesslogic.ireport.util.I18n.getString("charts.valueAxisLabelExpressionPlot","Value axis label expression"));
                valueAxisLabelExpressionProperty.setValue(  ((BarPlot)plot).getValueAxisLabelExpression() );
                sheetPanel.addSheetProperty("Bar plot", valueAxisLabelExpressionProperty);  
        }
        else if (plot instanceof Bar3DPlot)
        {
                SheetProperty isShowLabelsProperty = new SheetProperty("isShowLabelsBar3DPlot","Show labels", SheetProperty.BOOLEAN);
                isShowLabelsProperty.setValue( new Boolean(((Bar3DPlot)plot).isShowLabels()) );
                sheetPanel.addSheetProperty("Bar3D plot", isShowLabelsProperty);
                
                DoubleSheetProperty yOffsetProperty = new DoubleSheetProperty("xOffsetBar3DPlot","X offset");
                yOffsetProperty.setValue( new Double(((Bar3DPlot)plot).getXOffset()));
                sheetPanel.addSheetProperty("Bar3D plot", yOffsetProperty);
                
                DoubleSheetProperty xOffsetProperty = new DoubleSheetProperty("yOffsetBar3DPlot","Y offset");
                xOffsetProperty.setValue( new Double(((Bar3DPlot)plot).getYOffset()));
                sheetPanel.addSheetProperty("Bar3D plot", xOffsetProperty);
                
                ExpressionSheetProperty categoryAxisLabelExpressionProperty = new ExpressionSheetProperty("categoryAxisLabelExpressionBar3DPlot",it.businesslogic.ireport.util.I18n.getString("charts.categoryAxisLabelExpressionPlot","Category axis label expression"));
                categoryAxisLabelExpressionProperty.setValue( ((Bar3DPlot)plot).getCategoryAxisLabelExpression() );
                sheetPanel.addSheetProperty("Bar3D plot", categoryAxisLabelExpressionProperty);
            
                ExpressionSheetProperty valueAxisLabelExpressionProperty = new ExpressionSheetProperty("valueAxisLabelExpressionBar3DPlot",it.businesslogic.ireport.util.I18n.getString("charts.valueAxisLabelExpressionPlot","Value axis label expression"));
                valueAxisLabelExpressionProperty.setValue(  ((Bar3DPlot)plot).getValueAxisLabelExpression() );
                sheetPanel.addSheetProperty("Bar3D plot", valueAxisLabelExpressionProperty);
        }
        else if (plot instanceof LinePlot)
        {
                SheetProperty isShowLinesProperty = new SheetProperty("isShowLinesLinePlot",it.businesslogic.ireport.util.I18n.getString("charts.isShowLinesPlot","Show lines"), SheetProperty.BOOLEAN);
                isShowLinesProperty.setValue( new Boolean(((LinePlot)plot).isShowLines()) );
                sheetPanel.addSheetProperty("Line plot", isShowLinesProperty);
                
                SheetProperty isShowShapesProperty = new SheetProperty("isShowShapesLinePlot",it.businesslogic.ireport.util.I18n.getString("charts.isShowShapesPlot","Show shapes"), SheetProperty.BOOLEAN);
                isShowShapesProperty.setValue( new Boolean(((LinePlot)plot).isShowShapes()) );
                sheetPanel.addSheetProperty("Line plot", isShowShapesProperty);
                
                ExpressionSheetProperty categoryAxisLabelExpressionProperty = new ExpressionSheetProperty("categoryAxisLabelExpressionLinePlot",it.businesslogic.ireport.util.I18n.getString("charts.categoryAxisLabelExpressionPlot","Category axis label expression"));
                categoryAxisLabelExpressionProperty.setValue( ((LinePlot)plot).getCategoryAxisLabelExpression() );
                sheetPanel.addSheetProperty("Line plot", categoryAxisLabelExpressionProperty);
            
                ExpressionSheetProperty valueAxisLabelExpressionProperty = new ExpressionSheetProperty("valueAxisLabelExpressionLinePlot",it.businesslogic.ireport.util.I18n.getString("charts.valueAxisLabelExpressionPlot","Value axis label expression"));
                valueAxisLabelExpressionProperty.setValue(  ((LinePlot)plot).getValueAxisLabelExpression() );
                sheetPanel.addSheetProperty("Line plot", valueAxisLabelExpressionProperty);  
        }
        else if (plot instanceof AreaPlot)
        {
                ExpressionSheetProperty categoryAxisLabelExpressionProperty = new ExpressionSheetProperty("categoryAxisLabelExpressionAreaPlot",it.businesslogic.ireport.util.I18n.getString("charts.categoryAxisLabelExpressionPlot","Category axis label expression"));
                categoryAxisLabelExpressionProperty.setValue( ((AreaPlot)plot).getCategoryAxisLabelExpression() );
                sheetPanel.addSheetProperty("Area plot", categoryAxisLabelExpressionProperty);
            
                ExpressionSheetProperty valueAxisLabelExpressionProperty = new ExpressionSheetProperty("valueAxisLabelExpressionAreaPlot",it.businesslogic.ireport.util.I18n.getString("charts.valueAxisLabelExpressionPlot","Value axis label expression"));
                valueAxisLabelExpressionProperty.setValue(  ((AreaPlot)plot).getValueAxisLabelExpression() );
                sheetPanel.addSheetProperty("Area plot", valueAxisLabelExpressionProperty);  
        }
        else if (plot instanceof ScatterPlot)
        {
                SheetProperty isShowLinesProperty = new SheetProperty("isShowLinesScatterPlot",it.businesslogic.ireport.util.I18n.getString("charts.isShowLinesPlot","Show lines"), SheetProperty.BOOLEAN);
                isShowLinesProperty.setValue( new Boolean(((ScatterPlot)plot).isShowLines()) );
                sheetPanel.addSheetProperty("Scatter plot", isShowLinesProperty);
                
                SheetProperty isShowShapesProperty = new SheetProperty("isShowShapesScatterPlot",it.businesslogic.ireport.util.I18n.getString("charts.isShowShapesPlot","Show shapes"), SheetProperty.BOOLEAN);
                isShowShapesProperty.setValue( new Boolean(((ScatterPlot)plot).isShowShapes()) );
                sheetPanel.addSheetProperty("Scatter plot", isShowShapesProperty);
                
                ExpressionSheetProperty categoryAxisLabelExpressionProperty = new ExpressionSheetProperty("xAxisLabelExpressionScatterPlot",it.businesslogic.ireport.util.I18n.getString("charts.xAxisLabelExpressionPlot","X axis label expression"));
                categoryAxisLabelExpressionProperty.setValue( ((ScatterPlot)plot).getXAxisLabelExpression() );
                sheetPanel.addSheetProperty("Scatter plot", categoryAxisLabelExpressionProperty);
            
                ExpressionSheetProperty valueAxisLabelExpressionProperty = new ExpressionSheetProperty("yAxisLabelExpressionScatterPlot",it.businesslogic.ireport.util.I18n.getString("charts.yAxisLabelExpressionPlot","Y axis label expression"));
                valueAxisLabelExpressionProperty.setValue(  ((ScatterPlot)plot).getYAxisLabelExpression() );
                sheetPanel.addSheetProperty("Scatter plot", valueAxisLabelExpressionProperty);  
        }
        else if (plot instanceof BubblePlot)
        {
                //BothAxes | DomainAxis | RangeAxis
                SheetProperty scaleTypeProperty = new SheetProperty("scaleTypeBubblePlot",it.businesslogic.ireport.util.I18n.getString("charts.scaleTypeBubblePlot","Scale type"), SheetProperty.COMBOBOX);
                scaleTypeProperty.setTags( new Tag[]{ new Tag("BothAxes",it.businesslogic.ireport.util.I18n.getString("charts.scaleType.BothAxes","Both axes")),
                                                           new Tag("DomainAxis",it.businesslogic.ireport.util.I18n.getString("charts.scaleType.DomainAxis","Domain axis")),
                                                           new Tag("RangeAxis",it.businesslogic.ireport.util.I18n.getString("charts.scaleType.RangeAxis","Range axis"))});
               scaleTypeProperty.setValue(  ((BubblePlot)plot).getScaleType() );
               sheetPanel.addSheetProperty("Bubble plot", scaleTypeProperty);
                
                ExpressionSheetProperty categoryAxisLabelExpressionProperty = new ExpressionSheetProperty("xAxisLabelExpressionBubblePlot",it.businesslogic.ireport.util.I18n.getString("charts.xAxisLabelExpressionPlot","X axis label expression"));
                categoryAxisLabelExpressionProperty.setValue( ((BubblePlot)plot).getXAxisLabelExpression() );
                sheetPanel.addSheetProperty("Bubble plot", categoryAxisLabelExpressionProperty);
            
                ExpressionSheetProperty valueAxisLabelExpressionProperty = new ExpressionSheetProperty("yAxisLabelExpressionBubblePlot",it.businesslogic.ireport.util.I18n.getString("charts.yAxisLabelExpressionPlot","Y axis label expression"));
                valueAxisLabelExpressionProperty.setValue(  ((BubblePlot)plot).getYAxisLabelExpression() );
                sheetPanel.addSheetProperty("Bubble plot", valueAxisLabelExpressionProperty);  
        }
        else if (plot instanceof TimeSeriesPlot)
        {
                SheetProperty isShowLinesProperty = new SheetProperty("isShowLinesTimeSeriesPlot",it.businesslogic.ireport.util.I18n.getString("charts.isShowLinesPlot","Show lines"), SheetProperty.BOOLEAN);
                isShowLinesProperty.setValue( new Boolean(((TimeSeriesPlot)plot).isShowLines()) );
                sheetPanel.addSheetProperty("Time series plot", isShowLinesProperty);
                
                SheetProperty isShowShapesProperty = new SheetProperty("isShowShapesTimeSeriesPlot",it.businesslogic.ireport.util.I18n.getString("charts.isShowShapesPlot","Show shapes"), SheetProperty.BOOLEAN);
                isShowShapesProperty.setValue( new Boolean(((TimeSeriesPlot)plot).isShowShapes()) );
                sheetPanel.addSheetProperty("Time series plot", isShowShapesProperty);
                
                ExpressionSheetProperty timeAxisLabelExpressionProperty = new ExpressionSheetProperty("timeAxisLabelExpressionTimeSeriesPlot",it.businesslogic.ireport.util.I18n.getString("charts.timeAxisLabelExpressionPlot","Time axis label expression"));
                timeAxisLabelExpressionProperty.setValue( ((TimeSeriesPlot)plot).getTimeAxisLabelExpression() );
                sheetPanel.addSheetProperty("Time series plot", timeAxisLabelExpressionProperty);
            
                ExpressionSheetProperty valueAxisLabelExpressionProperty = new ExpressionSheetProperty("valueAxisLabelExpressionTimeSeriesPlot",it.businesslogic.ireport.util.I18n.getString("charts.valueAxisLabelExpressionPlot","Value axis label expression"));
                valueAxisLabelExpressionProperty.setValue(  ((TimeSeriesPlot)plot).getValueAxisLabelExpression() );
                sheetPanel.addSheetProperty("Time series plot", valueAxisLabelExpressionProperty);  
        }
        else if (plot instanceof HighLowPlot)
        {
                SheetProperty isShowLinesProperty = new SheetProperty("isShowCloseTicksHighLowPlot",it.businesslogic.ireport.util.I18n.getString("charts.isShowCloseTicksPlot","Show close ticks"), SheetProperty.BOOLEAN);
                isShowLinesProperty.setValue( new Boolean(((HighLowPlot)plot).isShowCloseTicks()) );
                sheetPanel.addSheetProperty("High low plot", isShowLinesProperty);
                
                SheetProperty isShowShapesProperty = new SheetProperty("isShowOpenTicksHighLowPlot",it.businesslogic.ireport.util.I18n.getString("charts.isShowOpenTicksPlot","Show open ticks"), SheetProperty.BOOLEAN);
                isShowShapesProperty.setValue( new Boolean(((HighLowPlot)plot).isShowOpenTicks()) );
                sheetPanel.addSheetProperty("High low plot", isShowShapesProperty);
                
                ExpressionSheetProperty timeAxisLabelExpressionProperty = new ExpressionSheetProperty("timeAxisLabelExpressionHighLowPlot",it.businesslogic.ireport.util.I18n.getString("charts.timeAxisLabelExpressionPlot","Time axis label expression"));
                timeAxisLabelExpressionProperty.setValue( ((HighLowPlot)plot).getTimeAxisLabelExpression() );
                sheetPanel.addSheetProperty("High low plot", timeAxisLabelExpressionProperty);
            
                ExpressionSheetProperty valueAxisLabelExpressionProperty = new ExpressionSheetProperty("valueAxisLabelExpressionHighLowPlot",it.businesslogic.ireport.util.I18n.getString("charts.valueAxisLabelExpressionPlot","Value axis label expression"));
                valueAxisLabelExpressionProperty.setValue(  ((HighLowPlot)plot).getValueAxisLabelExpression() );
                sheetPanel.addSheetProperty("High low plot", valueAxisLabelExpressionProperty);  
        }
        else if (plot instanceof CandlestickPlot)
        {
                SheetProperty isShowVolumeProperty = new SheetProperty("isShowVolumeCandlestickPlot",it.businesslogic.ireport.util.I18n.getString("charts.isShowVolumePlot","Show volume"), SheetProperty.BOOLEAN);
                isShowVolumeProperty.setValue( new Boolean(((CandlestickPlot)plot).isShowVolume()) );
                sheetPanel.addSheetProperty("Candlestick plot", isShowVolumeProperty);
                
                ExpressionSheetProperty timeAxisLabelExpressionProperty = new ExpressionSheetProperty("timeAxisLabelExpressionCandlestickPlot",it.businesslogic.ireport.util.I18n.getString("charts.timeAxisLabelExpressionPlot","Time axis label expression"));
                timeAxisLabelExpressionProperty.setValue( ((CandlestickPlot)plot).getTimeAxisLabelExpression() );
                sheetPanel.addSheetProperty("Candlestick plot", timeAxisLabelExpressionProperty);
            
                ExpressionSheetProperty valueAxisLabelExpressionProperty = new ExpressionSheetProperty("valueAxisLabelExpressionCandlestickPlot",it.businesslogic.ireport.util.I18n.getString("charts.valueAxisLabelExpressionPlot","Value axis label expression"));
                valueAxisLabelExpressionProperty.setValue(  ((CandlestickPlot)plot).getValueAxisLabelExpression() );
                sheetPanel.addSheetProperty("Candlestick plot", valueAxisLabelExpressionProperty);  
        }

    }

    public boolean isInit() {
        return init;
    }

    public void setInit(boolean init) {
        this.init = init;
    }
}
