/*
 * JRParameter.java
 *
 * 
 *  iReport  --  Visual designer for generating JasperReports Documents
 *  Copyright (C) 2002  Giulio Toffoli gt@businesslogic.it
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 *  Giulio Toffoli
 *  Via T.Aspetti, 233
 *  35100 Padova ITALY
 *  gt@businesslogic.it
 *
 *  Created on 12 febbraio 2003, 21.47
 *
 */
package it.businesslogic.ireport.crosstab;

public class CrosstabParameter
{
	private String name;
	private String classType;
	private String parameterValueExpression="";
    
	public  CrosstabParameter(String name, String classType, String parameterValueExpression)
	{
		this.name = name;
		this.setClassType(classType);
		this.setParameterValueExpression(parameterValueExpression);
	}
        
	public  CrosstabParameter(String name, String classType)
	{
                this(name, classType, "");
	}
        
        public  CrosstabParameter(String name)
	{
                this(name, "java.lang.String", "");
	}
	
			
	public String toString()
	{
		return name;
	}
        
        /** Getter for property classType.
         * @return Value of property classType.
         *
         */
        public java.lang.String getClassType() {
            return classType;
        }
        
        /** Setter for property classType.
         * @param classType New value of property classType.
         *
         */
        public void setClassType(java.lang.String classType) {
            this.classType = classType;
        }
        
                
        /** Getter for property name.
         * @return Value of property name.
         *
         */
        public java.lang.String getName() {
            return name;
        }
        
        /** Setter for property name.
         * @param name New value of property name.
         *
         */
        public void setName(java.lang.String name) {
            this.name = name;
        }
        
        public CrosstabParameter cloneMe()
        {
        	CrosstabParameter jrp = new CrosstabParameter(name, getClassType(), getParameterValueExpression());
        	return jrp;
        }

    public String getParameterValueExpression() {
        return parameterValueExpression;
    }

    public void setParameterValueExpression(String parameterValueExpression) {
        this.parameterValueExpression = parameterValueExpression;
    }
        
}
