/*
 * JRParameterDialog.java
 *
 *  iReport  --  Visual designer for generating JasperReports Documents
 *  Copyright (C) 2002-2003  Giulio Toffoli gt@businesslogic.it
 *
 *  This program is free software; you can redistribute  and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 *  Giulio Toffoli
 *  Via T.Aspetti, 233
 *  35100 Padova ITALY
 *  gt@businesslogic.it
 *
 *
 * Created on 9 maggio 2003, 17.25
 */

package it.businesslogic.ireport.gui;

import it.businesslogic.ireport.util.*;
import it.businesslogic.ireport.*;
import it.businesslogic.ireport.connection.*;

import java.awt.Component;
import java.sql.*;
import javax.swing.*;
/**
 *
 * @author  Administrator
 */
public class ConnectionDialog extends javax.swing.JDialog {
    /** Creates new form JRParameterDialog */
    JRParameter tmpParameter = null;
    private boolean init = false;
    
    public ConnectionDialog(java.awt.Frame parent, boolean modal) {
        
        super(parent, modal);
        initComponents();
//        this.setSize(400, 300);

        Misc.centerFrame(this);
        init = true;
        jComboBoxConnectionType.addItem( "Database JDBC connection"); // Type 0
        jComboBoxConnectionType.addItem( "XML file datasource"); // Type 1
        jComboBoxConnectionType.addItem( "JavaBeans set datasource"); // Type 2
        jComboBoxConnectionType.addItem( "Custom JRDataSource"); // Type 3        
        jComboBoxConnectionType.addItem( "File CSV datasource"); // Type 4        
        jComboBoxConnectionType.addItem( "JRDataSourceProvider"); // Type 5 
        
        jComboBoxJDBCDriver.addItem("com.mysql.jdbc.Driver");
        jComboBoxJDBCDriver.addItem("org.gjt.mm.mysql.Driver");
        jComboBoxJDBCDriver.addItem("com.internetcds.jdbc.tds.Driver");
	jComboBoxJDBCDriver.addItem("net.sourceforge.jtds.jdbc.Driver");
        jComboBoxJDBCDriver.addItem("com.microsoft.jdbc.sqlserver.SQLServerDriver");
	jComboBoxJDBCDriver.addItem("sun.jdbc.odbc.JdbcOdbcDriver");
	jComboBoxJDBCDriver.addItem("com.ms.jdbc.odbc.JdbcOdbcDriver");
	jComboBoxJDBCDriver.addItem("oracle.jdbc.driver.OracleDriver");
	jComboBoxJDBCDriver.addItem("COM.ibm.db2.jdbc.app.DB2Driver");
	jComboBoxJDBCDriver.addItem("com.informix.jdbc.IfxDriver");
	jComboBoxJDBCDriver.addItem("com.sybase.jdbc2.jdbc.SybDriver");
	jComboBoxJDBCDriver.addItem("com.merant.datadirect.jdbc.sqlserver.SQLServerDriver");
	jComboBoxJDBCDriver.addItem("com.inet.tds.TdsDriver");
	jComboBoxJDBCDriver.addItem("org.postgresql.Driver");
	jComboBoxJDBCDriver.addItem("org.hsqldb.jdbcDriver");
	jComboBoxJDBCDriver.addItem("COM.cloudscape.JDBCDriver");
        
        
        init = false;
        
        jComboBoxConnectionType.setSelectedIndex(0);
    }

    /** This method is called from within the constructor to
     * initialize the form.
     * WARNING: Do NOT modify this code. The content of this method is
     * always regenerated by the Form Editor.
     */
    private void initComponents() {//GEN-BEGIN:initComponents
        java.awt.GridBagConstraints gridBagConstraints;

        buttonGroupBeansSetType = new javax.swing.ButtonGroup();
        jPanel1 = new javax.swing.JPanel();
        jPanelConnectionType = new javax.swing.JPanel();
        jLabel4 = new javax.swing.JLabel();
        jComboBoxConnectionType = new javax.swing.JComboBox();
        jLabel1 = new javax.swing.JLabel();
        jTextFieldName = new javax.swing.JTextField();
        jSeparator2 = new javax.swing.JSeparator();
        jPanelConnectionRoot = new javax.swing.JPanel();
        jPanelXML = new javax.swing.JPanel();
        jLabel9 = new javax.swing.JLabel();
        jTextFieldXMLFile = new javax.swing.JTextField();
        jButton2 = new javax.swing.JButton();
        jLabel16 = new javax.swing.JLabel();
        jTextFieldRecordPath = new javax.swing.JTextField();
        jPanel3 = new javax.swing.JPanel();
        jPanelBeansSet = new javax.swing.JPanel();
        jLabel12 = new javax.swing.JLabel();
        jTextFieldJBSetFactoryClass = new javax.swing.JTextField();
        jRadioButtonJBSetCollection = new javax.swing.JRadioButton();
        jRadioButtonJBSetArray = new javax.swing.JRadioButton();
        jLabel13 = new javax.swing.JLabel();
        jTextFieldJBSetMethodToCall = new javax.swing.JTextField();
        jPanelJDBC = new javax.swing.JPanel();
        jLabel2 = new javax.swing.JLabel();
        jLabel3 = new javax.swing.JLabel();
        jComboBoxJDBCDriver = new javax.swing.JComboBox();
        jTextFieldJDBCUrl = new javax.swing.JTextField();
        jPanel2 = new javax.swing.JPanel();
        jLabel14 = new javax.swing.JLabel();
        jLabel5 = new javax.swing.JLabel();
        jTextFieldDBName = new javax.swing.JTextField();
        jTextFieldServerAddress = new javax.swing.JTextField();
        jButtonWizard = new javax.swing.JButton();
        jLabel6 = new javax.swing.JLabel();
        jLabel7 = new javax.swing.JLabel();
        jTextArea1 = new javax.swing.JTextArea();
        jTextFieldPassword = new javax.swing.JPasswordField();
        jTextFieldUsername = new javax.swing.JTextField();
        jCheckBoxSavePassword = new javax.swing.JCheckBox();
        jPanelCustomDataSourceFactory = new javax.swing.JPanel();
        jLabel10 = new javax.swing.JLabel();
        jTextFieldJRCustomDataSourceFactoryClass = new javax.swing.JTextField();
        jLabel11 = new javax.swing.JLabel();
        jTextFieldJRCustomDataSourceMethod = new javax.swing.JTextField();
        jSeparator1 = new javax.swing.JSeparator();
        jPanelCSV = new javax.swing.JPanel();
        jLabel15 = new javax.swing.JLabel();
        jTextFieldCSVFilename = new javax.swing.JTextField();
        jButtonCSVFilename = new javax.swing.JButton();
        jPanelDatasourceProvider = new javax.swing.JPanel();
        jLabel17 = new javax.swing.JLabel();
        jTextFieldJRDataSourceProvider = new javax.swing.JTextField();
        jSeparator3 = new javax.swing.JSeparator();
        jPanelButtons = new javax.swing.JPanel();
        jButtonOK = new javax.swing.JButton();
        jButtonCancel = new javax.swing.JButton();
        jButtonOK1 = new javax.swing.JButton();

        setTitle("Connections properties");
        setModal(true);
        setResizable(false);
        addWindowListener(new java.awt.event.WindowAdapter() {
            public void windowClosing(java.awt.event.WindowEvent evt) {
                closeDialog(evt);
            }
        });

        jPanel1.setLayout(new java.awt.BorderLayout());

        jPanelConnectionType.setLayout(new java.awt.GridBagLayout());

        jPanelConnectionType.setPreferredSize(new java.awt.Dimension(10, 70));
        jLabel4.setFont(new java.awt.Font("Dialog", 0, 11));
        jLabel4.setText("Type of connection / datasource");
        jLabel4.setPreferredSize(new java.awt.Dimension(157, 21));
        jLabel4.setMaximumSize(new java.awt.Dimension(157, 21));
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.NORTHWEST;
        gridBagConstraints.insets = new java.awt.Insets(3, 5, 5, 3);
        jPanelConnectionType.add(jLabel4, gridBagConstraints);

        jComboBoxConnectionType.setMinimumSize(new java.awt.Dimension(25, 25));
        jComboBoxConnectionType.setPreferredSize(new java.awt.Dimension(25, 25));
        jComboBoxConnectionType.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                jComboBoxConnectionTypeActionPerformed(evt);
            }
        });

        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = java.awt.GridBagConstraints.REMAINDER;
        gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.NORTHWEST;
        gridBagConstraints.insets = new java.awt.Insets(0, 5, 5, 5);
        jPanelConnectionType.add(jComboBoxConnectionType, gridBagConstraints);

        jLabel1.setFont(new java.awt.Font("Dialog", 0, 11));
        jLabel1.setText("Name");
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = java.awt.GridBagConstraints.BOTH;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.NORTHWEST;
        gridBagConstraints.insets = new java.awt.Insets(0, 5, 5, 3);
        jPanelConnectionType.add(jLabel1, gridBagConstraints);

        jTextFieldName.setFont(new java.awt.Font("Dialog", 0, 11));
        jTextFieldName.setMinimumSize(new java.awt.Dimension(6, 23));
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.gridwidth = java.awt.GridBagConstraints.REMAINDER;
        gridBagConstraints.fill = java.awt.GridBagConstraints.BOTH;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.NORTHWEST;
        gridBagConstraints.insets = new java.awt.Insets(0, 3, 5, 5);
        jPanelConnectionType.add(jTextFieldName, gridBagConstraints);

        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        jPanelConnectionType.add(jSeparator2, gridBagConstraints);

        jPanel1.add(jPanelConnectionType, java.awt.BorderLayout.NORTH);

        jPanelConnectionRoot.setLayout(new java.awt.BorderLayout());

        jPanelXML.setLayout(new java.awt.GridBagLayout());

        jPanelXML.setPreferredSize(new java.awt.Dimension(1, 30));
        jLabel9.setFont(new java.awt.Font("Dialog", 0, 11));
        jLabel9.setText("XML file");
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.ipadx = 24;
        gridBagConstraints.insets = new java.awt.Insets(3, 3, 3, 3);
        jPanelXML.add(jLabel9, gridBagConstraints);

        jTextFieldXMLFile.setFont(new java.awt.Font("Dialog", 0, 11));
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
        gridBagConstraints.ipadx = 232;
        gridBagConstraints.ipady = 1;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.SOUTHWEST;
        gridBagConstraints.insets = new java.awt.Insets(3, 3, 3, 3);
        jPanelXML.add(jTextFieldXMLFile, gridBagConstraints);

        jButton2.setFont(new java.awt.Font("Dialog", 0, 11));
        jButton2.setText("Browse");
        jButton2.setPreferredSize(new java.awt.Dimension(70, 25));
        jButton2.setMaximumSize(new java.awt.Dimension(100, 25));
        jButton2.setMinimumSize(new java.awt.Dimension(70, 25));
        jButton2.setMargin(new java.awt.Insets(2, 4, 2, 4));
        jButton2.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                jButton2ActionPerformed(evt);
            }
        });

        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = java.awt.GridBagConstraints.BOTH;
        gridBagConstraints.ipadx = 21;
        gridBagConstraints.ipady = -3;
        gridBagConstraints.insets = new java.awt.Insets(3, 3, 3, 7);
        jPanelXML.add(jButton2, gridBagConstraints);

        jLabel16.setFont(new java.awt.Font("Dialog", 0, 11));
        jLabel16.setText("Select Expression");
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.ipadx = 24;
        gridBagConstraints.insets = new java.awt.Insets(3, 3, 3, 3);
        jPanelXML.add(jLabel16, gridBagConstraints);

        jTextFieldRecordPath.setFont(new java.awt.Font("Dialog", 0, 11));
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
        gridBagConstraints.ipadx = 232;
        gridBagConstraints.ipady = 1;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.SOUTHWEST;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new java.awt.Insets(3, 3, 3, 7);
        jPanelXML.add(jTextFieldRecordPath, gridBagConstraints);

        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.gridwidth = 3;
        gridBagConstraints.fill = java.awt.GridBagConstraints.BOTH;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        jPanelXML.add(jPanel3, gridBagConstraints);

        jPanelConnectionRoot.add(jPanelXML, java.awt.BorderLayout.CENTER);

        jPanelBeansSet.setLayout(null);

        jLabel12.setFont(new java.awt.Font("Dialog", 0, 11));
        jLabel12.setText("Factory class (the class that will produce the set)");
        jPanelBeansSet.add(jLabel12);
        jLabel12.setBounds(8, 2, 296, 15);

        jTextFieldJBSetFactoryClass.setFont(new java.awt.Font("Dialog", 0, 11));
        jTextFieldJBSetFactoryClass.setText("it.businesslogic.ireport.connection.SampleJRDataSourceFactory");
        jPanelBeansSet.add(jTextFieldJBSetFactoryClass);
        jTextFieldJBSetFactoryClass.setBounds(8, 18, 354, 22);

        buttonGroupBeansSetType.add(jRadioButtonJBSetCollection);
        jRadioButtonJBSetCollection.setFont(new java.awt.Font("Dialog", 0, 11));
        jRadioButtonJBSetCollection.setText(" Collection of javaBeans");
        jPanelBeansSet.add(jRadioButtonJBSetCollection);
        jRadioButtonJBSetCollection.setBounds(10, 82, 288, 23);

        buttonGroupBeansSetType.add(jRadioButtonJBSetArray);
        jRadioButtonJBSetArray.setFont(new java.awt.Font("Dialog", 0, 11));
        jRadioButtonJBSetArray.setSelected(true);
        jRadioButtonJBSetArray.setText("Array of javaBeans");
        jRadioButtonJBSetArray.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                jRadioButtonJBSetArrayActionPerformed(evt);
            }
        });

        jPanelBeansSet.add(jRadioButtonJBSetArray);
        jRadioButtonJBSetArray.setBounds(10, 100, 288, 23);

        jLabel13.setFont(new java.awt.Font("Dialog", 0, 11));
        jLabel13.setText("The static method to call to retrive the array or the the collection of javaBeans");
        jPanelBeansSet.add(jLabel13);
        jLabel13.setBounds(10, 42, 382, 15);

        jTextFieldJBSetMethodToCall.setFont(new java.awt.Font("Dialog", 0, 11));
        jTextFieldJBSetMethodToCall.setText("createDatasource");
        jPanelBeansSet.add(jTextFieldJBSetMethodToCall);
        jTextFieldJBSetMethodToCall.setBounds(8, 58, 354, 22);

        jPanelConnectionRoot.add(jPanelBeansSet, java.awt.BorderLayout.CENTER);

        jPanelJDBC.setLayout(new java.awt.GridBagLayout());

        jLabel2.setFont(new java.awt.Font("Dialog", 0, 11));
        jLabel2.setText("JDBC Driver");
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.WEST;
        gridBagConstraints.insets = new java.awt.Insets(2, 6, 0, 0);
        jPanelJDBC.add(jLabel2, gridBagConstraints);

        jLabel3.setFont(new java.awt.Font("Dialog", 0, 11));
        jLabel3.setText("JDBC URL");
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.WEST;
        gridBagConstraints.insets = new java.awt.Insets(2, 6, 0, 0);
        jPanelJDBC.add(jLabel3, gridBagConstraints);

        jComboBoxJDBCDriver.setEditable(true);
        jComboBoxJDBCDriver.setFont(new java.awt.Font("Dialog", 0, 11));
        jComboBoxJDBCDriver.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                jComboBoxJDBCDriverActionPerformed(evt);
            }
        });

        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
        gridBagConstraints.insets = new java.awt.Insets(2, 6, 0, 6);
        jPanelJDBC.add(jComboBoxJDBCDriver, gridBagConstraints);

        jTextFieldJDBCUrl.setFont(new java.awt.Font("Dialog", 0, 11));
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
        gridBagConstraints.insets = new java.awt.Insets(2, 6, 0, 6);
        jPanelJDBC.add(jTextFieldJDBCUrl, gridBagConstraints);

        jPanel2.setLayout(new java.awt.GridBagLayout());

        jPanel2.setBorder(new javax.swing.border.TitledBorder(null, "JDBC URL Wizard", javax.swing.border.TitledBorder.DEFAULT_JUSTIFICATION, javax.swing.border.TitledBorder.DEFAULT_POSITION, new java.awt.Font("Dialog", 0, 11)));
        jPanel2.setMinimumSize(new java.awt.Dimension(300, 100));
        jLabel14.setFont(new java.awt.Font("Dialog", 0, 11));
        jLabel14.setText("Server Address");
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.WEST;
        gridBagConstraints.insets = new java.awt.Insets(2, 6, 0, 0);
        jPanel2.add(jLabel14, gridBagConstraints);

        jLabel5.setFont(new java.awt.Font("Dialog", 0, 11));
        jLabel5.setText("Database");
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.WEST;
        gridBagConstraints.insets = new java.awt.Insets(2, 6, 0, 0);
        jPanel2.add(jLabel5, gridBagConstraints);

        jTextFieldDBName.setFont(new java.awt.Font("Dialog", 0, 11));
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new java.awt.Insets(2, 6, 0, 0);
        jPanel2.add(jTextFieldDBName, gridBagConstraints);

        jTextFieldServerAddress.setFont(new java.awt.Font("Dialog", 0, 11));
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new java.awt.Insets(2, 6, 0, 0);
        jPanel2.add(jTextFieldServerAddress, gridBagConstraints);

        jButtonWizard.setFont(new java.awt.Font("Dialog", 0, 11));
        jButtonWizard.setText("Wizard");
        jButtonWizard.setMargin(new java.awt.Insets(2, 2, 2, 2));
        jButtonWizard.setMaximumSize(new java.awt.Dimension(60, 23));
        jButtonWizard.setMinimumSize(new java.awt.Dimension(60, 23));
        jButtonWizard.setPreferredSize(new java.awt.Dimension(60, 23));
        jButtonWizard.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                jButtonWizardActionPerformed(evt);
            }
        });

        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.WEST;
        gridBagConstraints.insets = new java.awt.Insets(2, 6, 2, 0);
        jPanel2.add(jButtonWizard, gridBagConstraints);

        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.gridwidth = 3;
        gridBagConstraints.fill = java.awt.GridBagConstraints.BOTH;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.WEST;
        gridBagConstraints.weightx = 1.0;
        jPanelJDBC.add(jPanel2, gridBagConstraints);

        jLabel6.setFont(new java.awt.Font("Dialog", 0, 11));
        jLabel6.setText("Username");
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.WEST;
        gridBagConstraints.insets = new java.awt.Insets(2, 6, 0, 0);
        jPanelJDBC.add(jLabel6, gridBagConstraints);

        jLabel7.setFont(new java.awt.Font("Dialog", 0, 11));
        jLabel7.setText("Password");
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 6;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.WEST;
        gridBagConstraints.insets = new java.awt.Insets(2, 6, 0, 0);
        jPanelJDBC.add(jLabel7, gridBagConstraints);

        jTextArea1.setBackground(new java.awt.Color(204, 204, 204));
        jTextArea1.setEditable(false);
        jTextArea1.setFont(new java.awt.Font("Dialog", 0, 10));
        jTextArea1.setLineWrap(true);
        jTextArea1.setRows(3);
        jTextArea1.setText("ATTENTION! Passwords are stored in clear text. If you dont specify a password now, iReport will ask you for one only when required and will not save it.");
        jTextArea1.setWrapStyleWord(true);
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 7;
        gridBagConstraints.gridwidth = 3;
        gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new java.awt.Insets(4, 6, 6, 6);
        jPanelJDBC.add(jTextArea1, gridBagConstraints);

        jTextFieldPassword.setFont(new java.awt.Font("Dialog", 0, 11));
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 6;
        gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new java.awt.Insets(2, 6, 0, 0);
        jPanelJDBC.add(jTextFieldPassword, gridBagConstraints);

        jTextFieldUsername.setFont(new java.awt.Font("Dialog", 0, 11));
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new java.awt.Insets(2, 6, 0, 0);
        jPanelJDBC.add(jTextFieldUsername, gridBagConstraints);

        jCheckBoxSavePassword.setFont(new java.awt.Font("Dialog", 0, 11));
        jCheckBoxSavePassword.setText("Save password");
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 6;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.WEST;
        gridBagConstraints.insets = new java.awt.Insets(2, 6, 0, 6);
        jPanelJDBC.add(jCheckBoxSavePassword, gridBagConstraints);

        jPanelConnectionRoot.add(jPanelJDBC, java.awt.BorderLayout.CENTER);

        jPanelCustomDataSourceFactory.setLayout(new java.awt.GridBagLayout());

        jLabel10.setFont(new java.awt.Font("Dialog", 0, 11));
        jLabel10.setText("Factory class");
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.NORTHWEST;
        gridBagConstraints.insets = new java.awt.Insets(3, 5, 3, 3);
        jPanelCustomDataSourceFactory.add(jLabel10, gridBagConstraints);

        jTextFieldJRCustomDataSourceFactoryClass.setFont(new java.awt.Font("Dialog", 0, 11));
        jTextFieldJRCustomDataSourceFactoryClass.setText("it.businesslogic.ireport.connection.SampleJRDataSourceFactory");
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.NORTHWEST;
        gridBagConstraints.insets = new java.awt.Insets(3, 5, 3, 3);
        jPanelCustomDataSourceFactory.add(jTextFieldJRCustomDataSourceFactoryClass, gridBagConstraints);

        jLabel11.setFont(new java.awt.Font("Dialog", 0, 11));
        jLabel11.setText("The static method to call to retrive the JRDataSource");
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.NORTHWEST;
        gridBagConstraints.insets = new java.awt.Insets(3, 5, 3, 3);
        jPanelCustomDataSourceFactory.add(jLabel11, gridBagConstraints);

        jTextFieldJRCustomDataSourceMethod.setFont(new java.awt.Font("Dialog", 0, 11));
        jTextFieldJRCustomDataSourceMethod.setText("createDatasource");
        jTextFieldJRCustomDataSourceMethod.setPreferredSize(new java.awt.Dimension(314, 21));
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.NORTHWEST;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new java.awt.Insets(3, 5, 3, 3);
        jPanelCustomDataSourceFactory.add(jTextFieldJRCustomDataSourceMethod, gridBagConstraints);

        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.SOUTH;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new java.awt.Insets(3, 3, 3, 3);
        jPanelCustomDataSourceFactory.add(jSeparator1, gridBagConstraints);

        jPanelConnectionRoot.add(jPanelCustomDataSourceFactory, java.awt.BorderLayout.CENTER);

        jPanelCSV.setLayout(null);

        jPanelCSV.setPreferredSize(new java.awt.Dimension(1, 30));
        jLabel15.setFont(new java.awt.Font("Dialog", 0, 11));
        jLabel15.setText("CSV file");
        jPanelCSV.add(jLabel15);
        jLabel15.setBounds(6, 10, 62, 15);

        jTextFieldCSVFilename.setFont(new java.awt.Font("Dialog", 0, 11));
        jPanelCSV.add(jTextFieldCSVFilename);
        jTextFieldCSVFilename.setBounds(68, 6, 238, 22);

        jButtonCSVFilename.setFont(new java.awt.Font("Dialog", 0, 11));
        jButtonCSVFilename.setText("Browse");
        jButtonCSVFilename.setMargin(new java.awt.Insets(2, 4, 2, 4));
        jButtonCSVFilename.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                jButtonCSVFilenameActionPerformed(evt);
            }
        });

        jPanelCSV.add(jButtonCSVFilename);
        jButtonCSVFilename.setBounds(310, 6, 74, 22);

        jPanelConnectionRoot.add(jPanelCSV, java.awt.BorderLayout.CENTER);

        jPanelDatasourceProvider.setLayout(new java.awt.GridBagLayout());

        jLabel17.setFont(new java.awt.Font("Dialog", 0, 11));
        jLabel17.setText("JasperReports DataSource Provider class");
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.NORTHWEST;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new java.awt.Insets(3, 5, 1, 3);
        jPanelDatasourceProvider.add(jLabel17, gridBagConstraints);

        jTextFieldJRDataSourceProvider.setFont(new java.awt.Font("Dialog", 0, 11));
        jTextFieldJRDataSourceProvider.setText("it.businesslogic.ireport.examples.PersonBeansDataSource");
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.NORTHWEST;
        gridBagConstraints.insets = new java.awt.Insets(3, 5, 3, 3);
        jPanelDatasourceProvider.add(jTextFieldJRDataSourceProvider, gridBagConstraints);

        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.SOUTH;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new java.awt.Insets(3, 3, 3, 3);
        jPanelDatasourceProvider.add(jSeparator3, gridBagConstraints);

        jPanelConnectionRoot.add(jPanelDatasourceProvider, java.awt.BorderLayout.CENTER);

        jPanel1.add(jPanelConnectionRoot, java.awt.BorderLayout.CENTER);

        jPanelButtons.setLayout(new java.awt.FlowLayout(java.awt.FlowLayout.RIGHT));

        jButtonOK.setFont(new java.awt.Font("Dialog", 0, 11));
        jButtonOK.setText("Save");
        jButtonOK.setMnemonic('s');
        jButtonOK.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                jButtonOKActionPerformed(evt);
            }
        });

        jPanelButtons.add(jButtonOK);

        jButtonCancel.setFont(new java.awt.Font("Dialog", 0, 11));
        jButtonCancel.setMnemonic('c');
        jButtonCancel.setText("Cancel");
        jButtonCancel.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                jButtonCancelActionPerformed(evt);
            }
        });

        jPanelButtons.add(jButtonCancel);

        jButtonOK1.setFont(new java.awt.Font("Dialog", 0, 11));
        jButtonOK1.setMnemonic('t');
        jButtonOK1.setText("Test");
        jButtonOK1.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                jButtonOK1ActionPerformed(evt);
            }
        });

        jPanelButtons.add(jButtonOK1);

        jPanel1.add(jPanelButtons, java.awt.BorderLayout.SOUTH);

        getContentPane().add(jPanel1, java.awt.BorderLayout.CENTER);

        java.awt.Dimension screenSize = java.awt.Toolkit.getDefaultToolkit().getScreenSize();
        setBounds((screenSize.width-403)/2, (screenSize.height-415)/2, 403, 415);
    }//GEN-END:initComponents

    private void jButton2ActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_jButton2ActionPerformed
        String fileName = "";
	    javax.swing.JFileChooser jfc = new javax.swing.JFileChooser( MainFrame.getMainInstance().getCurrentDirectory());
	    
	    jfc.setDialogTitle("Select XML file....");
	    
	    jfc.addChoosableFileFilter( new javax.swing.filechooser.FileFilter() {
		    public boolean accept(java.io.File file) {
			    String filename = file.getName();
			    return (filename.toLowerCase().endsWith(".xml") || file.isDirectory()) ;
		    }
		    public String getDescription() {
			    return "XML *.xml";
		    }
	    });
	    
	    jfc.setMultiSelectionEnabled(false);
	    jfc.setDialogType( javax.swing.JFileChooser.OPEN_DIALOG);
	    if  (jfc.showOpenDialog( this) == javax.swing.JOptionPane.OK_OPTION) {
		    java.io.File file = jfc.getSelectedFile();		
                    try {
                        jTextFieldXMLFile.setText( file.getAbsolutePath() );
                    } catch (Exception ex){}
	    }        
        
        
    }//GEN-LAST:event_jButton2ActionPerformed

    private void jButtonCSVFilenameActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_jButtonCSVFilenameActionPerformed
            String fileName = "";
	    javax.swing.JFileChooser jfc = new javax.swing.JFileChooser( MainFrame.getMainInstance().getCurrentDirectory());
	    
	    jfc.setDialogTitle("Select CSV file....");
	    
	    jfc.addChoosableFileFilter( new javax.swing.filechooser.FileFilter() {
		    public boolean accept(java.io.File file) {
			    String filename = file.getName();
			    return (filename.toLowerCase().endsWith(".csv") || file.isDirectory()) ;
		    }
		    public String getDescription() {
			    return "CSV *.csv";
		    }
	    });
	    
	    jfc.setMultiSelectionEnabled(false);
	    jfc.setDialogType( javax.swing.JFileChooser.OPEN_DIALOG);
	    if  (jfc.showOpenDialog( this) == javax.swing.JOptionPane.OK_OPTION) {
		    java.io.File file = jfc.getSelectedFile();		
                    try {
                        jTextFieldCSVFilename.setText( file.getAbsolutePath() );
                    } catch (Exception ex){}
	    }        
        
        
        
    }//GEN-LAST:event_jButtonCSVFilenameActionPerformed

    private void jComboBoxJDBCDriverActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_jComboBoxJDBCDriverActionPerformed
        // Run the wizard to populate Connection URL
        jButtonWizardActionPerformed(null);
    }//GEN-LAST:event_jComboBoxJDBCDriverActionPerformed

    private void jRadioButtonJBSetArrayActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_jRadioButtonJBSetArrayActionPerformed
        // Add your handling code here:
    }//GEN-LAST:event_jRadioButtonJBSetArrayActionPerformed

    private void jButtonOK1ActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_jButtonOK1ActionPerformed
        //java.awt.Frame parent = Misc.frameFromComponent(this);
        // 
        MainFrame.getMainInstance().getReportClassLoader().rescanLibDirectory();
        
        
        if (jComboBoxConnectionType.getSelectedIndex() == 0)
        {
            
            // Try the java connection...
            Connection conn = null;
            Statement stmt = null;
            try {
		    try {
                    	DriverPool.registerDriver( (String)jComboBoxJDBCDriver.getSelectedItem(), MainFrame.getMainInstance().getReportClassLoader() );
                    } catch (Exception ex)
                    {
                    	DriverPool.registerDriver( (String)jComboBoxJDBCDriver.getSelectedItem(), this.getClass().getClassLoader() );
                    }
                    
                    java.sql.Driver driver = DriverPool.getDriver( this.jTextFieldJDBCUrl.getText() );
                    
                    java.util.Properties connectProps = new java.util.Properties();
                    connectProps.setProperty("user", this.jTextFieldUsername.getText());
                    connectProps.setProperty("password", this.jTextFieldPassword.getText());
                    
                    conn = driver.connect( this.jTextFieldJDBCUrl.getText(), connectProps); 
				stmt = conn.createStatement();
			}catch (NoClassDefFoundError ex)
			{
				JOptionPane.showMessageDialog((Component)getParent(),"NoClassDefFoundError!!\nCheck your classpath!\nIf not present put your JDBC driver in lib directory of iReport and try again.","Error",JOptionPane.ERROR_MESSAGE);
				return;					
			} 
			catch (ClassNotFoundException ex)
			{
				JOptionPane.showMessageDialog((Component)getParent(),"ClassNotFoundError:\n"+ ex.getMessage() +"\n\nCheck your classpath!","Error",JOptionPane.ERROR_MESSAGE);
				return;					
			} 
			catch (java.sql.SQLException ex)
			{
				JOptionPane.showMessageDialog((Component)getParent(),"SQL problems:\n"+ex.getMessage()+"\n"+this.jTextFieldJDBCUrl.getText() ,"Error",JOptionPane.ERROR_MESSAGE);
				return;					
			} 
			catch (Exception ex)
			{
				JOptionPane.showMessageDialog((Component)getParent(),"General problem:\n"+ex.getMessage()+"\n\nPlease chack your username and password. The DBMS is running?!","Error",JOptionPane.ERROR_MESSAGE);
				return;					
			} finally {
                // Clean up
                if( stmt!=null ) try{ stmt.close(); } catch(Exception e) { /* anyone really care? */ }
                if( conn!=null ) try{ conn.close(); } catch(Exception e) { /* anyone really care? */ }
            }
			JOptionPane.showMessageDialog((Component)getParent(),"Connection test successful!","",JOptionPane.INFORMATION_MESSAGE);
			return;
        }
        else if (jComboBoxConnectionType.getSelectedIndex() == 3)
        {
            try {
                Object obj = Class.forName((String)jTextFieldJRCustomDataSourceFactoryClass.getText().trim(), true, MainFrame.getMainInstance().getReportClassLoader()).newInstance();
                obj.getClass().getMethod( (String)jTextFieldJRCustomDataSourceMethod.getText().trim(), new Class[0]).invoke(obj,new Object[0]);                
            } catch (NoClassDefFoundError ex)
	    {
		JOptionPane.showMessageDialog((Component)getParent(),"NoClassDefFoundError!!\nCheck your classpath!","Error",JOptionPane.ERROR_MESSAGE);
		return;					
	    } 
	    catch (ClassNotFoundException ex)
	    {
		JOptionPane.showMessageDialog((Component)getParent(),"ClassNotFoundError:\n"+ ex.getMessage() +"\n\nCheck your classpath!","Error",JOptionPane.ERROR_MESSAGE);
		return;					
	    } 
            catch (Exception ex)
            {
                JOptionPane.showMessageDialog((Component)getParent(),"Exception:\n"+ ex.getMessage() +"\n","Error",JOptionPane.ERROR_MESSAGE);
		ex.printStackTrace();

                return;	
            }
            JOptionPane.showMessageDialog((Component)getParent(),"Connection test successful!","",JOptionPane.INFORMATION_MESSAGE);
	    return;
        }
        else if (jComboBoxConnectionType.getSelectedIndex() == 2)
        {
            try {
                Object obj = Class.forName((String)jTextFieldJBSetFactoryClass.getText().trim(), true, MainFrame.getMainInstance().getReportClassLoader()).newInstance();
                Object ret_obj = obj.getClass().getMethod( (String)jTextFieldJBSetMethodToCall.getText().trim(), new Class[0]).invoke(null,new Object[0]);                
            
                if (ret_obj != null && !jRadioButtonJBSetArray.isSelected() && (ret_obj instanceof  java.util.Collection))
                {
                    JOptionPane.showMessageDialog((Component)getParent(),"Connection test successful!","",JOptionPane.INFORMATION_MESSAGE);
                }
                else if (ret_obj != null  && jRadioButtonJBSetArray.isSelected() && (ret_obj instanceof  Object[]))
                {
                    JOptionPane.showMessageDialog((Component)getParent(),"Connection test successful!","",JOptionPane.INFORMATION_MESSAGE);
                }
                else
                {
                    JOptionPane.showMessageDialog((Component)getParent(),"The method don't return a valid Array or java.util.Collection!\n","Error",JOptionPane.ERROR_MESSAGE);
                }
                
            } catch (NoClassDefFoundError ex)
	    {
		JOptionPane.showMessageDialog((Component)getParent(),"NoClassDefFoundError!!\nCheck your classpath!","Error",JOptionPane.ERROR_MESSAGE);
		return;					
	    } 
	    catch (ClassNotFoundException ex)
	    {
		JOptionPane.showMessageDialog((Component)getParent(),"ClassNotFoundError:\n"+ ex.getMessage() +"\n\nCheck your classpath!","Error",JOptionPane.ERROR_MESSAGE);
		return;					
	    } 
            catch (Exception ex)
            {
                JOptionPane.showMessageDialog((Component)getParent(),"Exception:\n"+ ex.getMessage() +"\n","Error",JOptionPane.ERROR_MESSAGE);
		ex.printStackTrace();
                return;	
            }
            
	    return;
        }
        else if (jComboBoxConnectionType.getSelectedIndex() == 4)
        {
            String csv_file = jTextFieldCSVFilename.getText().trim();
            
            try {
                
                JRCSVDataSourceConnection con = new JRCSVDataSourceConnection();
                java.io.File f = new java.io.File(csv_file);
                if (!f.exists())
                {
                    JOptionPane.showMessageDialog((Component)getParent(),"File " + csv_file + " not found","Error",JOptionPane.ERROR_MESSAGE);
                    return;	
                }
                
                con.setFilename( csv_file );
                if (con.getJRDataSource() != null)
                {
                    JOptionPane.showMessageDialog((Component)getParent(),"Connection test successful!","",JOptionPane.INFORMATION_MESSAGE);
                    return;
                }
                
            }
            catch (Exception ex)
            {
                JOptionPane.showMessageDialog((Component)getParent(),"Exception:\n"+ ex.getMessage() +"\n","Error",JOptionPane.ERROR_MESSAGE);
		ex.printStackTrace();
                return;	
            }
            
	    return;
        }
        else if (jComboBoxConnectionType.getSelectedIndex() == 5)
        {
            try {
                
                Object obj = Class.forName((String)jTextFieldJRDataSourceProvider.getText().trim(), true, MainFrame.getMainInstance().getReportClassLoader()).newInstance();
                if (!(obj instanceof net.sf.jasperreports.engine.JRDataSourceProvider))
                {
                    JOptionPane.showMessageDialog((Component)getParent(),"\"" + jTextFieldJRDataSourceProvider.getText() + "\" is not a subclass of\nnet.sf.jasperreports.engine.JRDataSourceProvider.","Error",JOptionPane.ERROR_MESSAGE);
                    return;	
                }
                else
                {
                    JOptionPane.showMessageDialog((Component)getParent(),"Connection test successful!","",JOptionPane.INFORMATION_MESSAGE);
                    return;
                }
                
            } catch (NoClassDefFoundError ex)
	    {
		JOptionPane.showMessageDialog((Component)getParent(),"NoClassDefFoundError!!\nCheck your classpath!","Error",JOptionPane.ERROR_MESSAGE);
		return;					
	    } 
	    catch (ClassNotFoundException ex)
	    {
		JOptionPane.showMessageDialog((Component)getParent(),"ClassNotFoundError:\n"+ ex.getMessage() +"\n\nCheck your classpath!","Error",JOptionPane.ERROR_MESSAGE);
		return;					
	    } 
            catch (Exception ex)
            {
                JOptionPane.showMessageDialog((Component)getParent(),"Exception:\n"+ ex.getMessage() +"\n","Error",JOptionPane.ERROR_MESSAGE);
		ex.printStackTrace();
                return;	
            }
        }
    }//GEN-LAST:event_jButtonOK1ActionPerformed

    private void jButtonWizardActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_jButtonWizardActionPerformed
          
        if (jComboBoxJDBCDriver.getSelectedIndex() < 0) return;
        String driver = ""+jComboBoxJDBCDriver.getSelectedItem();
        driver = driver.trim();
        if (driver.equals("")) return;
        
        String server = jTextFieldServerAddress.getText().trim();
        if( server.length()==0 ) {
            server = "localhost";
        }
        
        String databaseName = jTextFieldDBName.getText().trim();
        
        if (driver.equalsIgnoreCase("org.gjt.mm.mysql.Driver")) {
            String url = "jdbc:mysql://" + server + "/";
            if ( databaseName.length()>0 )
                url += databaseName;
            else
                url += "MYDATABASE";
            jTextFieldJDBCUrl.setText(url);
        }
        else if (driver.equalsIgnoreCase("com.mysql.jdbc.Driver")) {
            String url = "jdbc:mysql://" + server + "/";
            if (databaseName.length()>0)
                url += databaseName;
            else
                url += "MYDATABASE";
            jTextFieldJDBCUrl.setText(url);
        }
        else if (driver.equalsIgnoreCase("com.internetcds.jdbc.tds.Driver")) {
            String url = "jdbc:freetds:sqlserver://localhost/";
            if (databaseName.length()>0)
                url += databaseName;
            else
                url += "MYDATABASE";
            jTextFieldJDBCUrl.setText(url);
        }
        else if (driver.equalsIgnoreCase("com.microsoft.jdbc.sqlserver.SQLServerDriver")) {
            String url = "jdbc:microsoft:sqlserver://" + server + ":1433;DatabaseName=";
            if (databaseName.length()>0)
                url += databaseName;
            else
                url += "MYDATABASE";
            jTextFieldJDBCUrl.setText(url);
        }
        else if (driver.equalsIgnoreCase("sun.jdbc.odbc.JdbcOdbcDriver")) {
            String url = "jdbc:odbc:";
            if (databaseName.length()>0)
                url += jTextFieldDBName.getText();
            else
                url += "DSNAME";
            jTextFieldJDBCUrl.setText(url);
        }
        else if (driver.equalsIgnoreCase("com.ms.jdbc.odbc.JdbcOdbcDriver")) {
            String url = "jdbc:odbc:";
            if (databaseName.length()>0)
                url += databaseName;
            else
                url += "DSNAME";
            jTextFieldJDBCUrl.setText(url);
        }
        else if (driver.equalsIgnoreCase("oracle.jdbc.driver.OracleDriver")) {
            String url = "jdbc:oracle:thin:@" + server + ":1521:";
            if (databaseName.length()>0)
                url += databaseName;
            else
                url += "MYDATABASE";
            jTextFieldJDBCUrl.setText(url);
        }
        else if (driver.equalsIgnoreCase("COM.ibm.db2.jdbc.app.DB2Driver")) {
            String url = "jdbc:db2:";
            if (databaseName.length()>0)
                url += databaseName;
            else
                url += "MYDATABASE";
            jTextFieldJDBCUrl.setText(url);
        }
        else if (driver.equalsIgnoreCase("com.informix.jdbc.IfxDriver")) {
            String url = "jdbc:informix-sqli://" + server + ":port/";
            if (databaseName.length()>0)
                url += databaseName;
            else
                url += "MYDATABASE";
            
            url += ":informixserver=SERVERNAME";
            jTextFieldJDBCUrl.setText(url);
        }
        else if (driver.equalsIgnoreCase("com.sybase.jdbc2.jdbc.SybDriver")) {
            String url = "jdbc:sybase:Tds:" + server + ":2638/";
            if (databaseName.length()>0)
                url += databaseName;
            else
                url += "MYDATABASE";
            jTextFieldJDBCUrl.setText(url);
        }
        else if (driver.equalsIgnoreCase("com.mysql.jdbc.Driver")) {
            String url = "jdbc:mysql://"+server+"/";
            if (databaseName.length()>0)
                url += databaseName;
            else
                url += "MYDATABASE";
            jTextFieldJDBCUrl.setText(url);
        }
        else if (driver.equalsIgnoreCase("com.merant.datadirect.jdbc.sqlserver.SQLServerDriver")) {
            String url = "jdbc:sqlserver://" + server + ":1433/";
            if (databaseName.length()>0)
                url += databaseName;
            else
                url += "MYDATABASE";
            jTextFieldJDBCUrl.setText(url);
        }
        else if (driver.equalsIgnoreCase("com.inet.tds.TdsDriver")) {
            String url = "jdbc:inetdae7:"+server+":1433/";
            if (databaseName.length()>0)
                url += jTextFieldDBName.getText();
            else
                url += "MYDATABASE";
            jTextFieldJDBCUrl.setText(url);
        }
        else if (driver.equalsIgnoreCase("org.postgresql.Driver")) {
            String url = "jdbc:postgresql://" + server + ":5432/";
            if (databaseName.length()>0)
                url += databaseName;
            else
                url += "MYDATABASE";
            jTextFieldJDBCUrl.setText(url);
        }
        else if (driver.equalsIgnoreCase("org.hsqldb.jdbcDriver")) {
            String url = "jdbc:hsqldb:[PATH_TO_DB_FILES]/";
            if (databaseName.length()>0)
                url += databaseName;
            else
                url += "MYDATABASE";
            jTextFieldJDBCUrl.setText(url);
        }
        else if (driver.equalsIgnoreCase("COM.cloudscape.JDBCDriver ")) {
            String url = "jdbc:cloudscape:/cloudscape/";
            if (databaseName.length()>0)
                url += databaseName;
            else
                url += "MYDATABASE";
            jTextFieldJDBCUrl.setText(url);
        } 
        else if (driver.equalsIgnoreCase("net.sourceforge.jtds.jdbc.Driver"))
        {
            String url = "jdbc:jtds:sqlserver://" +
            server + "/";
            if (databaseName.length()>0)
                url += databaseName;
            else
                url += "MYDATABASE";
            url += ";instance=";
            jTextFieldJDBCUrl.setText(url);
        }

    }//GEN-LAST:event_jButtonWizardActionPerformed

    private void jComboBoxConnectionTypeActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_jComboBoxConnectionTypeActionPerformed
        if (init) return;
        jPanelConnectionRoot.removeAll();
        if (jComboBoxConnectionType.getSelectedIndex() == 0)
        {
            jPanelConnectionRoot.add("Center", jPanelJDBC);
        }
        else if (jComboBoxConnectionType.getSelectedIndex() == 1)
        {
            jPanelConnectionRoot.add("Center", jPanelXML);
        }
        else if (jComboBoxConnectionType.getSelectedIndex() == 2)
        {
            jPanelConnectionRoot.add("Center", jPanelBeansSet);
        }
        else if (jComboBoxConnectionType.getSelectedIndex() == 3)
        {
            jPanelConnectionRoot.add("Center", jPanelCustomDataSourceFactory);
        }
        else if (jComboBoxConnectionType.getSelectedIndex() == 4)
        {
            jPanelConnectionRoot.add("Center", jPanelCSV);
        }
        else if (jComboBoxConnectionType.getSelectedIndex() == 5)
        {
            jPanelConnectionRoot.add("Center", jPanelDatasourceProvider);
        }
        
        jPanelConnectionRoot.updateUI();
    }//GEN-LAST:event_jComboBoxConnectionTypeActionPerformed

    private void jButtonCancelActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_jButtonCancelActionPerformed
        setVisible(false);
        this.setDialogResult( javax.swing.JOptionPane.CANCEL_OPTION);
        dispose();
    }//GEN-LAST:event_jButtonCancelActionPerformed

    private void jButtonOKActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_jButtonOKActionPerformed
        if (this.jTextFieldName.getText().trim().length() <= 0) {
            javax.swing.JOptionPane.showMessageDialog(this,"Please insert a valid connection name!","Invalid parameter!",javax.swing.JOptionPane.WARNING_MESSAGE );
            return;
        }
        
        if (jComboBoxConnectionType.getSelectedIndex() == 0) {
            iReportConnection = new JDBCConnection();
            iReportConnection.setName( this.jTextFieldName.getText().trim() );
            ((JDBCConnection)iReportConnection).setServerAddress( this.jTextFieldServerAddress.getText().trim() );
            ((JDBCConnection)iReportConnection).setDatabase( this.jTextFieldDBName.getText().trim() );
            ((JDBCConnection)iReportConnection).setUsername( this.jTextFieldUsername.getText().trim() );
            if (jCheckBoxSavePassword.isSelected())
                ((JDBCConnection)iReportConnection).setPassword( this.jTextFieldPassword.getText());
            else
                ((JDBCConnection)iReportConnection).setPassword("");
            ((JDBCConnection)iReportConnection).setSavePassword( jCheckBoxSavePassword.isSelected() );
            ((JDBCConnection)iReportConnection).setJDBCDriver( (this.jComboBoxJDBCDriver.getSelectedItem()+"").trim() );
            if ((this.jComboBoxJDBCDriver.getSelectedItem()+"").trim().length() == 0) {
                javax.swing.JOptionPane.showMessageDialog(this,"Please insert a valid JDBC driver!","Invalid driver!",javax.swing.JOptionPane.WARNING_MESSAGE );
                return;
            }
            
            if (this.jTextFieldJDBCUrl.getText().trim().length() == 0) {
                javax.swing.JOptionPane.showMessageDialog(this,"Please insert a valid JDBC URL!","Invalid url!",javax.swing.JOptionPane.WARNING_MESSAGE );
                return;
            }
            ((JDBCConnection)iReportConnection).setUrl(this.jTextFieldJDBCUrl.getText().trim());
        }
        else if (jComboBoxConnectionType.getSelectedIndex() == 2) {
            iReportConnection = new JavaBeanDataSourceConnection();
            iReportConnection.setName( this.jTextFieldName.getText().trim() );
            ((JavaBeanDataSourceConnection)iReportConnection).setFactoryClass( this.jTextFieldJBSetFactoryClass.getText().trim() );
            ((JavaBeanDataSourceConnection)iReportConnection).setMethodToCall( this.jTextFieldJBSetMethodToCall.getText().trim() );
            if (jRadioButtonJBSetArray.isSelected())
            {
                ((JavaBeanDataSourceConnection)iReportConnection).setType( JavaBeanDataSourceConnection.BEAN_ARRAY );
            }
            else
            {
               ((JavaBeanDataSourceConnection)iReportConnection).setType( JavaBeanDataSourceConnection.BEAN_COLLECTION );
            }
        }
        else if (jComboBoxConnectionType.getSelectedIndex() == 3) {
            iReportConnection = new JRCustomDataSourceConnection();
            iReportConnection.setName( this.jTextFieldName.getText().trim() );
            ((JRCustomDataSourceConnection)iReportConnection).setFactoryClass( this.jTextFieldJRCustomDataSourceFactoryClass.getText().trim() );
            ((JRCustomDataSourceConnection)iReportConnection).setMethodToCall( this.jTextFieldJRCustomDataSourceMethod.getText().trim() );
        }
        else if (jComboBoxConnectionType.getSelectedIndex() == 4) {
            iReportConnection = new JRCSVDataSourceConnection();
            iReportConnection.setName( this.jTextFieldName.getText().trim() );
            ((JRCSVDataSourceConnection)iReportConnection).setFilename( this.jTextFieldCSVFilename.getText().trim() );
        }
        else if (jComboBoxConnectionType.getSelectedIndex() == 1) {
            iReportConnection = new JRXMLDataSourceConnection();
            iReportConnection.setName( this.jTextFieldName.getText().trim() );
            ((JRXMLDataSourceConnection)iReportConnection).setFilename( this.jTextFieldXMLFile.getText().trim() );
            ((JRXMLDataSourceConnection)iReportConnection).setSelectExpression( this.jTextFieldRecordPath.getText().trim() );
        }
        else if (jComboBoxConnectionType.getSelectedIndex() == 5) {
            iReportConnection = new JRDataSourceProviderConnection();
            iReportConnection.setName( this.jTextFieldName.getText().trim() );
            ((JRDataSourceProviderConnection)iReportConnection).getProperties().put("JRDataSourceProvider", this.jTextFieldJRDataSourceProvider.getText().trim() );
        }
        
        setVisible(false);
        this.setDialogResult( javax.swing.JOptionPane.OK_OPTION);
        dispose();
    }//GEN-LAST:event_jButtonOKActionPerformed
    
    /** Closes the dialog */
    private void closeDialog(java.awt.event.WindowEvent evt) {//GEN-FIRST:event_closeDialog
        setVisible(false);
        this.setDialogResult( javax.swing.JOptionPane.CLOSED_OPTION);
        dispose();
    }//GEN-LAST:event_closeDialog
    
    /**
     * @param args the command line arguments
     */
    public static void main(String args[]) {
        new JRParameterDialog(new javax.swing.JFrame(), true).show();
    }
    
    /** Getter for property tmpParameter.
     * @return Value of property tmpParameter.
     *
     */
    public it.businesslogic.ireport.JRParameter getParameter() {
        return tmpParameter;
    }    
    
    /** Setter for property tmpParameter.
     * @param tmpParameter New value of property tmpParameter.
     *
     */
    public void setParameter(it.businesslogic.ireport.JRParameter tmpParameter) {
       }
    
    /** Getter for property dialogResult.
     * @return Value of property dialogResult.
     *
     */
    public int getDialogResult() {
        return dialogResult;
    }
    
    /** Setter for property dialogResult.
     * @param dialogResult New value of property dialogResult.
     *
     */
    public void setDialogResult(int dialogResult) {
        this.dialogResult = dialogResult;
    }
    
    /** Getter for property iReportConnection.
     * @return Value of property iReportConnection.
     *
     */
    public it.businesslogic.ireport.IReportConnection getIReportConnection() {
        return iReportConnection;
    }
    
    /** Setter for property iReportConnection.
     * @param iReportConnection New value of property iReportConnection.
     *
     */
    public void setIReportConnection(it.businesslogic.ireport.IReportConnection iReportConnection) {
        this.iReportConnection = iReportConnection;
        
        this.jTextFieldName.setText( iReportConnection.getName());
        if (iReportConnection instanceof JDBCConnection)
        {
            JDBCConnection con = (JDBCConnection)iReportConnection;
            this.jComboBoxConnectionType.setSelectedIndex(0);
            this.jComboBoxJDBCDriver.setSelectedItem(con.getJDBCDriver());
            this.jTextFieldJDBCUrl.setText( con.getUrl());
            this.jTextFieldServerAddress.setText( con.getServerAddress() );
            this.jTextFieldDBName.setText( con.getDatabase() );
            this.jTextFieldUsername.setText( con.getUsername());
            if (con.isSavePassword())
                this.jTextFieldPassword.setText( con.getPassword());
            else 
                this.jTextFieldPassword.setText( "");
            this.jCheckBoxSavePassword.setSelected( con.isSavePassword());
        }
        else if (iReportConnection instanceof JRCustomDataSourceConnection)
        {
            JRCustomDataSourceConnection con = (JRCustomDataSourceConnection)iReportConnection;
            this.jComboBoxConnectionType.setSelectedIndex(3);
            this.jTextFieldJRCustomDataSourceFactoryClass.setText( con.getFactoryClass());
            this.jTextFieldJRCustomDataSourceMethod.setText(con.getMethodToCall());
        }
        else if (iReportConnection instanceof JavaBeanDataSourceConnection)
        {
            JavaBeanDataSourceConnection con = (JavaBeanDataSourceConnection)iReportConnection;
            this.jComboBoxConnectionType.setSelectedIndex(2);
            this.jTextFieldJBSetFactoryClass.setText( con.getFactoryClass());
            this.jTextFieldJBSetMethodToCall.setText(con.getMethodToCall());
            if (con.getType().equals(con.BEAN_ARRAY)  )
            {
                jRadioButtonJBSetArray.setSelected(true);
                jRadioButtonJBSetCollection.setSelected(false);
            }
            else
            {
                jRadioButtonJBSetArray.setSelected(false);
                jRadioButtonJBSetCollection.setSelected(true);
            }
        }
        else if (iReportConnection instanceof JRCSVDataSourceConnection)
        {
            JRCSVDataSourceConnection con = (JRCSVDataSourceConnection)iReportConnection;
            this.jComboBoxConnectionType.setSelectedIndex(4);
            this.jTextFieldCSVFilename.setText( con.getFilename() );
            
        }
        else if (iReportConnection instanceof JRXMLDataSourceConnection)
        {
            JRXMLDataSourceConnection con = (JRXMLDataSourceConnection)iReportConnection;
            this.jComboBoxConnectionType.setSelectedIndex(1);
            this.jTextFieldXMLFile.setText( con.getFilename() );
            this.jTextFieldRecordPath.setText( con.getSelectExpression() );            
        }
         else if (iReportConnection instanceof JRDataSourceProviderConnection)
        {
            JRDataSourceProviderConnection con = (JRDataSourceProviderConnection)iReportConnection;
            this.jComboBoxConnectionType.setSelectedIndex(5);
            this.jTextFieldJRDataSourceProvider.setText( it.businesslogic.ireport.util.Misc.nvl(con.getProperties().get("JRDataSourceProvider"), "") );            
        }
    }
    
    // Variables declaration - do not modify//GEN-BEGIN:variables
    private javax.swing.ButtonGroup buttonGroupBeansSetType;
    private javax.swing.JButton jButton2;
    private javax.swing.JButton jButtonCSVFilename;
    private javax.swing.JButton jButtonCancel;
    private javax.swing.JButton jButtonOK;
    private javax.swing.JButton jButtonOK1;
    private javax.swing.JButton jButtonWizard;
    private javax.swing.JCheckBox jCheckBoxSavePassword;
    private javax.swing.JComboBox jComboBoxConnectionType;
    private javax.swing.JComboBox jComboBoxJDBCDriver;
    private javax.swing.JLabel jLabel1;
    private javax.swing.JLabel jLabel10;
    private javax.swing.JLabel jLabel11;
    private javax.swing.JLabel jLabel12;
    private javax.swing.JLabel jLabel13;
    private javax.swing.JLabel jLabel14;
    private javax.swing.JLabel jLabel15;
    private javax.swing.JLabel jLabel16;
    private javax.swing.JLabel jLabel17;
    private javax.swing.JLabel jLabel2;
    private javax.swing.JLabel jLabel3;
    private javax.swing.JLabel jLabel4;
    private javax.swing.JLabel jLabel5;
    private javax.swing.JLabel jLabel6;
    private javax.swing.JLabel jLabel7;
    private javax.swing.JLabel jLabel9;
    private javax.swing.JPanel jPanel1;
    private javax.swing.JPanel jPanel2;
    private javax.swing.JPanel jPanel3;
    private javax.swing.JPanel jPanelBeansSet;
    private javax.swing.JPanel jPanelButtons;
    private javax.swing.JPanel jPanelCSV;
    private javax.swing.JPanel jPanelConnectionRoot;
    private javax.swing.JPanel jPanelConnectionType;
    private javax.swing.JPanel jPanelCustomDataSourceFactory;
    private javax.swing.JPanel jPanelDatasourceProvider;
    private javax.swing.JPanel jPanelJDBC;
    private javax.swing.JPanel jPanelXML;
    private javax.swing.JRadioButton jRadioButtonJBSetArray;
    private javax.swing.JRadioButton jRadioButtonJBSetCollection;
    private javax.swing.JSeparator jSeparator1;
    private javax.swing.JSeparator jSeparator2;
    private javax.swing.JSeparator jSeparator3;
    private javax.swing.JTextArea jTextArea1;
    private javax.swing.JTextField jTextFieldCSVFilename;
    private javax.swing.JTextField jTextFieldDBName;
    private javax.swing.JTextField jTextFieldJBSetFactoryClass;
    private javax.swing.JTextField jTextFieldJBSetMethodToCall;
    private javax.swing.JTextField jTextFieldJDBCUrl;
    private javax.swing.JTextField jTextFieldJRCustomDataSourceFactoryClass;
    private javax.swing.JTextField jTextFieldJRCustomDataSourceMethod;
    private javax.swing.JTextField jTextFieldJRDataSourceProvider;
    private javax.swing.JTextField jTextFieldName;
    private javax.swing.JPasswordField jTextFieldPassword;
    private javax.swing.JTextField jTextFieldRecordPath;
    private javax.swing.JTextField jTextFieldServerAddress;
    private javax.swing.JTextField jTextFieldUsername;
    private javax.swing.JTextField jTextFieldXMLFile;
    // End of variables declaration//GEN-END:variables

    private int dialogResult;    
    
    private IReportConnection iReportConnection;
    
}
