/*
 * JRParameterDialog.java
 *
 *  iReport  --  Visual designer for generating JasperReports Documents
 *  Copyright (C) 2002-2003  Giulio Toffoli gt@businesslogic.it
 *
 *  This program is free software; you can redistribute  and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 *  Giulio Toffoli
 *  Via T.Aspetti, 233
 *  35100 Padova ITALY
 *  gt@businesslogic.it
 *
 *
 * Created on 9 maggio 2003, 17.25
 */

package it.businesslogic.ireport.gui;

import it.businesslogic.ireport.util.*;
import it.businesslogic.ireport.*;

import java.util.*;
import javax.swing.JComboBox;
/**
 *
 * @author  Administrator
 */
public class JRFontDialog extends javax.swing.JDialog {
    /** Creates new form JRParameterDialog */
    private IReportFont iReportFont = null;
    private boolean init = false;
    private boolean reportFontMode = true;
    
    public JRFontDialog(java.awt.Frame parent, boolean modal) {
        
        super(parent, modal);
        initComponents();
        this.setSize(420, 344);
        Misc.centerFrame(this);
        
        jNumberComboBoxSize.addEntry("3",3);
        jNumberComboBoxSize.addEntry("5",5);
        jNumberComboBoxSize.addEntry("8",8);
        jNumberComboBoxSize.addEntry("10",10);
        jNumberComboBoxSize.addEntry("12",12);
        jNumberComboBoxSize.addEntry("14",14);
        jNumberComboBoxSize.addEntry("18",18);
        jNumberComboBoxSize.addEntry("24",24);
        jNumberComboBoxSize.addEntry("36",36);
        jNumberComboBoxSize.addEntry("48",48);
        
        jNumberComboBoxSize.setSelectedIndex(3);
        
        // Image Horizontal Alignments...
        jComboBoxPDFFontName.addItem("Helvetica");
        jComboBoxPDFFontName.addItem("Helvetica-Bold");
        jComboBoxPDFFontName.addItem("Helvetica-BoldOblique");
        jComboBoxPDFFontName.addItem("Helvetica-Oblique");
        jComboBoxPDFFontName.addItem("Courier");
        jComboBoxPDFFontName.addItem("Courier-Bold");
        jComboBoxPDFFontName.addItem("Courier-BoldOblique");
        jComboBoxPDFFontName.addItem("Courier-Oblique");
        jComboBoxPDFFontName.addItem("Symbol");
        jComboBoxPDFFontName.addItem("Times-Roman");
        jComboBoxPDFFontName.addItem("Times-Bold");
        jComboBoxPDFFontName.addItem("Times-BoldItalic");
        jComboBoxPDFFontName.addItem("Times-Italic");
        jComboBoxPDFFontName.addItem("ZapfDingbats");
        jComboBoxPDFFontName.addItem("STSong-Light");
        jComboBoxPDFFontName.addItem("MHei-Medium");
        jComboBoxPDFFontName.addItem("MSung-Light");
        jComboBoxPDFFontName.addItem("HeiseiKakuGo-W5");
        jComboBoxPDFFontName.addItem("HeiseiMin-W3");
        jComboBoxPDFFontName.addItem("HYGoThic-Medium");
        jComboBoxPDFFontName.addItem("HYSMyeongJo-Medium");
        jComboBoxPDFFontName.addItem("External TTF font...");
        
        jComboBoxPdfEncoding.addItem(new PdfEncoding("Cp1250","CP1250 (Central European)"));
        jComboBoxPdfEncoding.addItem(new PdfEncoding("Cp1251","CP1251 (Cyrillic)"));
        jComboBoxPdfEncoding.addItem(new PdfEncoding("Cp1252","CP1252 (Western European ANSI aka WinAnsi)"));
        jComboBoxPdfEncoding.addItem(new PdfEncoding("Cp1253","CP1253 (Greek)"));
        jComboBoxPdfEncoding.addItem(new PdfEncoding("Cp1254","CP1254 (Turkish)"));
        jComboBoxPdfEncoding.addItem(new PdfEncoding("Cp1255","CP1255 (Hebrew)"));
        jComboBoxPdfEncoding.addItem(new PdfEncoding("Cp1256","CP1256 (Arabic)"));
        jComboBoxPdfEncoding.addItem(new PdfEncoding("Cp1257","CP1257 (Baltic)"));
        jComboBoxPdfEncoding.addItem(new PdfEncoding("Cp1258","CP1258 (Vietnamese)"));
        jComboBoxPdfEncoding.addItem(new PdfEncoding("UniGB-UCS2-H","UniGB-UCS2-H (Chinese Simplified)"));
        jComboBoxPdfEncoding.addItem(new PdfEncoding("UniGB-UCS2-V","UniGB-UCS2-V (Chinese Simplified)"));
        jComboBoxPdfEncoding.addItem(new PdfEncoding("UniCNS-UCS2-H","UniCNS-UCS2-H (Chinese traditional)"));
        jComboBoxPdfEncoding.addItem(new PdfEncoding("UniCNS-UCS2-V","UniCNS-UCS2-V (Chinese traditional)"));
        jComboBoxPdfEncoding.addItem(new PdfEncoding("UniJIS-UCS2-H","UniJIS-UCS2-H (Japanese)"));
        jComboBoxPdfEncoding.addItem(new PdfEncoding("UniJIS-UCS2-V","UniJIS-UCS2-V (Japanese)"));
        jComboBoxPdfEncoding.addItem(new PdfEncoding("UniJIS-UCS2-HW-H","UniJIS-UCS2-HW-H (Japanese)"));
        jComboBoxPdfEncoding.addItem(new PdfEncoding("UniJIS-UCS2-HW-V","UniJIS-UCS2-HW-V (Japanese)"));
        jComboBoxPdfEncoding.addItem(new PdfEncoding("UniKS-UCS2-H","UniKS-UCS2-H (Korean)"));
        jComboBoxPdfEncoding.addItem(new PdfEncoding("UniKS-UCS2-V","UniKS-UCS2-V (Korean)"));
        jComboBoxPdfEncoding.addItem(new PdfEncoding("Identity-H","Identity-H (Unicode with horizontal writing)"));
        jComboBoxPdfEncoding.addItem(new PdfEncoding("Identity-V","Identity-V (Unicode with vertical writing)"));
        
        // Load Fonts...
        String[] fontFamilies = java.awt.GraphicsEnvironment.getLocalGraphicsEnvironment().getAvailableFontFamilyNames();
        for (int i=0; i<fontFamilies.length; ++i)
        {
            jComboBoxFontName.addItem(fontFamilies[i]); 
        }
        
        jComboBoxReportFonts.setVisible(false);
        
    }
        
    /** This method is called from within the constructor to
     * initialize the form.
     * WARNING: Do NOT modify this code. The content of this method is
     * always regenerated by the Form Editor.
     */
    // <editor-fold defaultstate="collapsed" desc=" Generated Code ">//GEN-BEGIN:initComponents
    private void initComponents() {
        java.awt.GridBagConstraints gridBagConstraints;

        jPanelFont = new javax.swing.JPanel();
        jLabel23 = new javax.swing.JLabel();
        jTextFieldReportFont = new javax.swing.JTextField();
        jLabel24 = new javax.swing.JLabel();
        jLabel27 = new javax.swing.JLabel();
        jComboBoxFontName = new javax.swing.JComboBox();
        jNumberComboBoxSize = new it.businesslogic.ireport.gui.JNumberComboBox();
        jLabel25 = new javax.swing.JLabel();
        jComboBoxPDFFontName = new javax.swing.JComboBox();
        jLabelTTF = new javax.swing.JLabel();
        jComboBoxTTFFont = new javax.swing.JComboBox();
        jPanel2 = new javax.swing.JPanel();
        jCheckBoxBold = new javax.swing.JCheckBox();
        jCheckBoxUnderline = new javax.swing.JCheckBox();
        jCheckBoxItalic = new javax.swing.JCheckBox();
        jCheckBoxStrokeTrough = new javax.swing.JCheckBox();
        jSeparator2 = new javax.swing.JSeparator();
        jPanel3 = new javax.swing.JPanel();
        jPanel4 = new javax.swing.JPanel();
        jCheckBoxPDFEmbedded = new javax.swing.JCheckBox();
        jCheckBoxDefaultFont = new javax.swing.JCheckBox();
        jPanel5 = new javax.swing.JPanel();
        jLabel32 = new javax.swing.JLabel();
        jComboBoxPdfEncoding = new javax.swing.JComboBox();
        jSeparator3 = new javax.swing.JSeparator();
        jPanel6 = new javax.swing.JPanel();
        jPanel7 = new javax.swing.JPanel();
        jButtonOK = new javax.swing.JButton();
        jButtonCancel = new javax.swing.JButton();
        jComboBoxReportFonts = new javax.swing.JComboBox();

        getContentPane().setLayout(new java.awt.GridBagLayout());

        setTitle("Add/modify parameter");
        setModal(true);
        setResizable(false);
        addWindowListener(new java.awt.event.WindowAdapter() {
            public void windowClosing(java.awt.event.WindowEvent evt) {
                closeDialog(evt);
            }
        });

        jPanelFont.setLayout(new java.awt.GridBagLayout());

        jLabel23.setFont(new java.awt.Font("Dialog", 0, 11));
        jLabel23.setText("Report font");
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
        gridBagConstraints.weightx = 1.0;
        jPanelFont.add(jLabel23, gridBagConstraints);

        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
        gridBagConstraints.weightx = 1.0;
        jPanelFont.add(jTextFieldReportFont, gridBagConstraints);

        jLabel24.setFont(new java.awt.Font("Dialog", 0, 11));
        jLabel24.setText("Font name");
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new java.awt.Insets(4, 0, 0, 0);
        jPanelFont.add(jLabel24, gridBagConstraints);

        jLabel27.setFont(new java.awt.Font("Dialog", 0, 11));
        jLabel27.setText("Size");
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
        gridBagConstraints.insets = new java.awt.Insets(4, 4, 0, 0);
        jPanelFont.add(jLabel27, gridBagConstraints);

        jComboBoxFontName.setFont(new java.awt.Font("Dialog", 0, 11));
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
        jPanelFont.add(jComboBoxFontName, gridBagConstraints);

        jNumberComboBoxSize.setFont(new java.awt.Font("Dialog", 0, 12));
        jNumberComboBoxSize.setMinimumSize(new java.awt.Dimension(70, 22));
        jNumberComboBoxSize.setPreferredSize(new java.awt.Dimension(70, 22));
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
        gridBagConstraints.insets = new java.awt.Insets(0, 4, 0, 0);
        jPanelFont.add(jNumberComboBoxSize, gridBagConstraints);

        jLabel25.setFont(new java.awt.Font("Dialog", 0, 11));
        jLabel25.setText("PDF font name");
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
        gridBagConstraints.insets = new java.awt.Insets(4, 0, 0, 0);
        jPanelFont.add(jLabel25, gridBagConstraints);

        jComboBoxPDFFontName.setFont(new java.awt.Font("Dialog", 0, 11));
        jComboBoxPDFFontName.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                jComboBoxPDFFontNameActionPerformed(evt);
            }
        });

        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
        gridBagConstraints.weightx = 1.0;
        jPanelFont.add(jComboBoxPDFFontName, gridBagConstraints);

        jLabelTTF.setFont(new java.awt.Font("Dialog", 0, 11));
        jLabelTTF.setText("TrueType font");
        jLabelTTF.setEnabled(false);
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 6;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
        gridBagConstraints.insets = new java.awt.Insets(4, 0, 0, 0);
        jPanelFont.add(jLabelTTF, gridBagConstraints);

        jComboBoxTTFFont.setFont(new java.awt.Font("Dialog", 0, 11));
        jComboBoxTTFFont.setEnabled(false);
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 7;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
        gridBagConstraints.weightx = 1.0;
        jPanelFont.add(jComboBoxTTFFont, gridBagConstraints);

        jPanel2.setLayout(new java.awt.GridBagLayout());

        jCheckBoxBold.setFont(new java.awt.Font("Dialog", 0, 11));
        jCheckBoxBold.setText("Bold");
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new java.awt.Insets(4, 0, 0, 0);
        jPanel2.add(jCheckBoxBold, gridBagConstraints);

        jCheckBoxUnderline.setFont(new java.awt.Font("Dialog", 0, 11));
        jCheckBoxUnderline.setText("Underline");
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new java.awt.Insets(4, 0, 0, 0);
        jPanel2.add(jCheckBoxUnderline, gridBagConstraints);

        jCheckBoxItalic.setFont(new java.awt.Font("Dialog", 0, 11));
        jCheckBoxItalic.setText("Italic");
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
        gridBagConstraints.weightx = 1.0;
        jPanel2.add(jCheckBoxItalic, gridBagConstraints);

        jCheckBoxStrokeTrough.setFont(new java.awt.Font("Dialog", 0, 11));
        jCheckBoxStrokeTrough.setText("Strike Trough");
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
        gridBagConstraints.weightx = 1.0;
        jPanel2.add(jCheckBoxStrokeTrough, gridBagConstraints);

        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 8;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = java.awt.GridBagConstraints.BOTH;
        gridBagConstraints.weightx = 1.0;
        jPanelFont.add(jPanel2, gridBagConstraints);

        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 9;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
        jPanelFont.add(jSeparator2, gridBagConstraints);

        jPanel3.setLayout(new java.awt.GridBagLayout());

        jPanel4.setLayout(new java.awt.GridBagLayout());

        jCheckBoxPDFEmbedded.setFont(new java.awt.Font("Dialog", 0, 11));
        jCheckBoxPDFEmbedded.setText("PDF Embedded");
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 10;
        gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
        jPanel4.add(jCheckBoxPDFEmbedded, gridBagConstraints);

        jCheckBoxDefaultFont.setFont(new java.awt.Font("Dialog", 0, 11));
        jCheckBoxDefaultFont.setLabel("Default");
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
        jPanel4.add(jCheckBoxDefaultFont, gridBagConstraints);

        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
        gridBagConstraints.weighty = 1.0;
        jPanel3.add(jPanel4, gridBagConstraints);

        jPanel5.setLayout(new java.awt.GridBagLayout());

        jLabel32.setFont(new java.awt.Font("Dialog", 0, 11));
        jLabel32.setText("PDF Encoding");
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
        gridBagConstraints.weightx = 1.0;
        jPanel5.add(jLabel32, gridBagConstraints);

        jComboBoxPdfEncoding.setEditable(true);
        jComboBoxPdfEncoding.setFont(new java.awt.Font("Dialog", 0, 11));
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
        gridBagConstraints.weightx = 1.0;
        jPanel5.add(jComboBoxPdfEncoding, gridBagConstraints);

        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.fill = java.awt.GridBagConstraints.BOTH;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new java.awt.Insets(0, 8, 0, 0);
        jPanel3.add(jPanel5, gridBagConstraints);

        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 10;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
        gridBagConstraints.insets = new java.awt.Insets(4, 0, 0, 0);
        jPanelFont.add(jPanel3, gridBagConstraints);

        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridy = 11;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
        jPanelFont.add(jSeparator3, gridBagConstraints);

        jPanel6.setLayout(new java.awt.GridBagLayout());

        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridheight = 2;
        gridBagConstraints.fill = java.awt.GridBagConstraints.BOTH;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        jPanel6.add(jPanel7, gridBagConstraints);

        jButtonOK.setFont(new java.awt.Font("Dialog", 0, 11));
        jButtonOK.setMnemonic('o');
        jButtonOK.setText("OK");
        jButtonOK.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                jButtonOKActionPerformed(evt);
            }
        });

        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
        gridBagConstraints.insets = new java.awt.Insets(4, 4, 4, 4);
        jPanel6.add(jButtonOK, gridBagConstraints);

        jButtonCancel.setFont(new java.awt.Font("Dialog", 0, 11));
        jButtonCancel.setMnemonic('c');
        jButtonCancel.setText("Cancel");
        jButtonCancel.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                jButtonCancelActionPerformed(evt);
            }
        });

        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
        gridBagConstraints.insets = new java.awt.Insets(4, 0, 4, 0);
        jPanel6.add(jButtonCancel, gridBagConstraints);

        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 12;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = java.awt.GridBagConstraints.BOTH;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        jPanelFont.add(jPanel6, gridBagConstraints);

        jComboBoxReportFonts.setFont(new java.awt.Font("Dialog", 0, 11));
        jComboBoxReportFonts.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                jComboBoxReportFontsActionPerformed(evt);
            }
        });

        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
        gridBagConstraints.weightx = 1.0;
        jPanelFont.add(jComboBoxReportFonts, gridBagConstraints);

        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.fill = java.awt.GridBagConstraints.BOTH;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new java.awt.Insets(4, 4, 4, 4);
        getContentPane().add(jPanelFont, gridBagConstraints);

        pack();
    }
    // </editor-fold>//GEN-END:initComponents

    private void jComboBoxReportFontsActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_jComboBoxReportFontsActionPerformed

        
        if (init) return;
        if (jComboBoxReportFonts.getSelectedItem() != null && jComboBoxReportFonts.getSelectedItem() instanceof IReportFont)
        {
            // Set all fields to the value of the report font...
            IReportFont ifont = (IReportFont)jComboBoxReportFonts.getSelectedItem();
            setIReportFont(ifont, false);
        }
 
    }//GEN-LAST:event_jComboBoxReportFontsActionPerformed

    private void jComboBoxPDFFontNameActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_jComboBoxPDFFontNameActionPerformed
        
        if (init) return;
        // Set band to all....
        if (jComboBoxPDFFontName.getSelectedItem() == null || (jComboBoxPDFFontName.getSelectedItem()+"").equals("")) return;
        // Set the new value for all selected elements...
        String fontName = ""+ jComboBoxPDFFontName.getSelectedItem();
        
        if (fontName != null && fontName.equals("External TTF font..."))
        {
             this.jComboBoxTTFFont.setEnabled(true);
             this.jLabelTTF.setEnabled(true);
        }          
        else
        {
             this.jComboBoxTTFFont.setEnabled(false);
             this.jLabelTTF.setEnabled(false);
        }
    }//GEN-LAST:event_jComboBoxPDFFontNameActionPerformed

    private void jButtonCancelActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_jButtonCancelActionPerformed
        setVisible(false);
        this.setDialogResult( javax.swing.JOptionPane.CANCEL_OPTION);
        dispose();
    }//GEN-LAST:event_jButtonCancelActionPerformed

    private void jButtonOKActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_jButtonOKActionPerformed
        
        if (this.jTextFieldReportFont.getText().trim().length() <= 0 && isReportFontMode())
        {
            javax.swing.JOptionPane.showMessageDialog(this,"Please insert a valid report font name!","Invalid report font name!",javax.swing.JOptionPane.WARNING_MESSAGE );
            return;
        }
        
        iReportFont = new IReportFont();
        if (isReportFontMode())
        {
            iReportFont.setReportFont( this.jTextFieldReportFont.getText() );
        }
        else if (this.jComboBoxReportFonts.getSelectedItem() != null)
        {
            iReportFont.setReportFont( this.jComboBoxReportFonts.getSelectedItem() +"");
        }
        
        iReportFont.setBold( this.jCheckBoxBold.isSelected());
        iReportFont.setDefaultFont( jCheckBoxDefaultFont.isSelected());
        iReportFont.setFontName(""+ this.jComboBoxFontName.getSelectedItem());
        iReportFont.setFontSize( (int)jNumberComboBoxSize.getValue());
        iReportFont.setItalic( this.jCheckBoxItalic.isSelected());        
        iReportFont.setPDFFontName( this.jComboBoxFontName.getSelectedItem()+"");
        
        //if (Misc.nvl( this.jComboBoxFontName.getSelectedItem(),"").indexOf("TTF") != 0)
        //{
        //    iReportFont.setPDFFontName( this.jComboBoxTTFFont.getSelectedItem()+"");
        //}
        iReportFont.setPDFFontName(this.jComboBoxPDFFontName.getSelectedItem()+"");
        if (iReportFont.getPDFFontName().equals("External TTF font..."))
        {
            if (this.jComboBoxTTFFont.getSelectedItem() != null &&
                this.jComboBoxTTFFont.getSelectedItem() instanceof IRFont)
                iReportFont.setPDFFontName( ((IRFont) this.jComboBoxTTFFont.getSelectedItem()).getFile().getName() +"");   
        }
        
        
        iReportFont.setPdfEmbedded( this.jCheckBoxPDFEmbedded.isSelected());
        if (this.jComboBoxPdfEncoding.getSelectedItem() instanceof PdfEncoding)
            iReportFont.setPdfEncoding( ((PdfEncoding)this.jComboBoxPdfEncoding.getSelectedItem()).getEncoding());
        else
            iReportFont.setPdfEncoding( Misc.nvl(this.jComboBoxPdfEncoding.getSelectedItem(),"CP1251"));
        
        iReportFont.setStrikeTrought( this.jCheckBoxStrokeTrough.isSelected());
        iReportFont.setTTFFont( Misc.nvl(this.jComboBoxTTFFont.getSelectedItem(),"") );
        iReportFont.setUnderline( this.jCheckBoxUnderline.isSelected());
        /*
        tmpParameter = new JRParameter( this.jTextFieldName.getText(), "java.lang.String",
                                        this.jCheckBoxIsForPrompting.isSelected(),
                                        this.jTextAreaDescription.getText());
        if (this.jComboBoxType.getSelectedItem().toString().trim().length() != 0)
        {
            tmpParameter.setClassType( this.jComboBoxType.getSelectedItem().toString().trim() );
        }
        tmpParameter.setDefaultValueExpression( jRTextExpressionAreaDefaultExpression.getText());
*/
        setVisible(false);
        this.setDialogResult( javax.swing.JOptionPane.OK_OPTION);
        dispose();
    }//GEN-LAST:event_jButtonOKActionPerformed
    
    /** Closes the dialog */
    private void closeDialog(java.awt.event.WindowEvent evt) {//GEN-FIRST:event_closeDialog
        setVisible(false);
        this.setDialogResult( javax.swing.JOptionPane.CLOSED_OPTION);
        dispose();
    }//GEN-LAST:event_closeDialog
          
    /** Getter for property dialogResult.
     * @return Value of property dialogResult.
     *
     */
    public int getDialogResult() {
        return dialogResult;
    }
    
    /** Setter for property dialogResult.
     * @param dialogResult New value of property dialogResult.
     *
     */
    public void setDialogResult(int dialogResult) {
        this.dialogResult = dialogResult;
    }
    
    /** Getter for property iReportFont.
     * @return Value of property iReportFont.
     *
     */
    public it.businesslogic.ireport.IReportFont getIReportFont() {
        return iReportFont;
    }
    
    
    public void setIReportFont(it.businesslogic.ireport.IReportFont iReportFont)
    {
       setIReportFont(iReportFont, true);
    }
    /** Setter for property iReportFont.
     * @param iReportFont New value of property iReportFont.
     *
     */
    public void setIReportFont(it.businesslogic.ireport.IReportFont iReportFont, boolean reportFontToo) {
       
        init = true;
        
        if (iReportFont == null) iReportFont = new it.businesslogic.ireport.IReportFont();
        
        if (reportFontToo)
        {
            this.jTextFieldReportFont.setText( new String(iReportFont.getReportFont()) );
            if (iReportFont.getReportFont() != null && iReportFont.getReportFont().length()>0)
            {
                for (int i=0; i<jComboBoxReportFonts.getItemCount(); ++i)
                {
                    if ((jComboBoxReportFonts.getItemAt(i) + "").equals(iReportFont.getReportFont()))
                    {
                        jComboBoxReportFonts.setSelectedIndex(i);
                        break;
                    }
                }
            }
        }
        
        this.jCheckBoxBold.setSelected( iReportFont.isBold());
        this.jCheckBoxItalic.setSelected( iReportFont.isItalic());
        this.jCheckBoxStrokeTrough.setSelected( iReportFont.isStrikeTrought());
        this.jCheckBoxPDFEmbedded.setSelected( iReportFont.isPdfEmbedded() );
        this.jCheckBoxUnderline.setSelected( iReportFont.isUnderline());
        this.jCheckBoxDefaultFont.setSelected( iReportFont.isDefaultFont());

        setComboBoxText(true, iReportFont.getFontName() , jComboBoxFontName);
        
        if (iReportFont.getPDFFontName().toUpperCase().endsWith(".TTF"))
        {
            this.setComboBoxText(true, "External TTF font..." , jComboBoxPDFFontName );
            this.jComboBoxTTFFont.setEnabled(true);
            this.jLabelTTF.setEnabled(true);
        }
        else
            this.setComboBoxText(true, iReportFont.getPDFFontName() , jComboBoxPDFFontName );
        
        
        if (iReportFont.getPDFFontName().toUpperCase().endsWith(".TTF"))
        {
            jComboBoxTTFFont.setEnabled(true);
            jLabelTTF.setEnabled(true);
            this.setFontComboBox(true, iReportFont.getPDFFontName() , jComboBoxTTFFont );
        }
        else
        {
            jComboBoxTTFFont.setEnabled(false);
            jLabelTTF.setEnabled(false);
        }
                
        this.setElementComboNumber(true, iReportFont.getFontSize() , jNumberComboBoxSize );
        this.setPdfEncodingComboBox(true, iReportFont.getPdfEncoding() , jComboBoxPdfEncoding );
        
        init = false;
    }
    
     public void updateFonts(Vector iRFonts)
    {
        Misc.updateComboBox( jComboBoxTTFFont, iRFonts, false);
    } 
    
    // Variables declaration - do not modify//GEN-BEGIN:variables
    private javax.swing.JButton jButtonCancel;
    private javax.swing.JButton jButtonOK;
    private javax.swing.JCheckBox jCheckBoxBold;
    private javax.swing.JCheckBox jCheckBoxDefaultFont;
    private javax.swing.JCheckBox jCheckBoxItalic;
    private javax.swing.JCheckBox jCheckBoxPDFEmbedded;
    private javax.swing.JCheckBox jCheckBoxStrokeTrough;
    private javax.swing.JCheckBox jCheckBoxUnderline;
    private javax.swing.JComboBox jComboBoxFontName;
    private javax.swing.JComboBox jComboBoxPDFFontName;
    private javax.swing.JComboBox jComboBoxPdfEncoding;
    private javax.swing.JComboBox jComboBoxReportFonts;
    private javax.swing.JComboBox jComboBoxTTFFont;
    private javax.swing.JLabel jLabel23;
    private javax.swing.JLabel jLabel24;
    private javax.swing.JLabel jLabel25;
    private javax.swing.JLabel jLabel27;
    private javax.swing.JLabel jLabel32;
    private javax.swing.JLabel jLabelTTF;
    private it.businesslogic.ireport.gui.JNumberComboBox jNumberComboBoxSize;
    private javax.swing.JPanel jPanel2;
    private javax.swing.JPanel jPanel3;
    private javax.swing.JPanel jPanel4;
    private javax.swing.JPanel jPanel5;
    private javax.swing.JPanel jPanel6;
    private javax.swing.JPanel jPanel7;
    private javax.swing.JPanel jPanelFont;
    private javax.swing.JSeparator jSeparator2;
    private javax.swing.JSeparator jSeparator3;
    private javax.swing.JTextField jTextFieldReportFont;
    // End of variables declaration//GEN-END:variables

    private int dialogResult;    
    
    protected boolean setComboBoxText( boolean firstTime, String value, javax.swing.JComboBox comboField )
    {       
      if (( ! firstTime ) && (!( Misc.nvl(comboField.getSelectedItem(),"").equalsIgnoreCase(value))))
      {
        comboField.setSelectedIndex(0);
        return false;
      }
      else
      {
          try {
            comboField.setSelectedItem( value );		 
          } catch (Exception ex){
            ex.printStackTrace();
          }
      }
      return true;
    }
    
    
    protected boolean setFontComboBox( boolean firstTime, String value, javax.swing.JComboBox comboField )
    {       
      if (( ! firstTime ) && (!(comboField.getSelectedItem()!=null && comboField.getSelectedItem() instanceof IRFont && ((IRFont)comboField.getSelectedItem()).getFile().equals(value))))
      {
        if (comboField.getItemCount() > 0)
            comboField.setSelectedIndex(0);
        return false;
      }
      else
      {
          try {
              for (int i=0; i<comboField.getItemCount(); ++i)
              {
                  if (comboField.getItemAt(i) instanceof IRFont && ((IRFont)comboField.getItemAt(i)).getFile().getName().equals(value) )
                  {
                      comboField.setSelectedIndex(i);
                      return true;
                   }
              }	 
              if (comboField.getItemCount() > 0)
                comboField.setSelectedIndex(0);
          } catch (Exception ex){
            ex.printStackTrace();
          }
      }
      return true;
    }
    
    protected boolean setPdfEncodingComboBox( boolean firstTime, String value, javax.swing.JComboBox comboField )
    {       
      if (( ! firstTime ) && (!(comboField.getSelectedItem()!=null && ( (comboField.getSelectedItem() instanceof PdfEncoding && ((PdfEncoding)comboField.getSelectedItem()).getEncoding().equalsIgnoreCase(value)) || (comboField.getSelectedItem()+"").equals(value) ))))
      {
        if (comboField.getItemCount() > 0)
            comboField.setSelectedIndex(0);
        return false;
      }
      else
      {
          try {
              for (int i=0; i<comboField.getItemCount(); ++i)
              {
                  if (comboField.getItemAt(i) instanceof PdfEncoding && ((PdfEncoding)comboField.getItemAt(i)).getEncoding().equals(value) )
                  {
                      comboField.setSelectedIndex(i);
                      return true;
                   }
              }	 
              comboField.setSelectedItem(value);   
          } catch (Exception ex){
            ex.printStackTrace();
          }
      }
      return true;
    }
    
     protected boolean setElementComboNumber( boolean firstTime, double value, JNumberComboBox numberField )
    {
      if (( ! firstTime ) && (!(numberField.getValue() == value)))
      {
        numberField.setSelectedItem("");
        return false;
      }
      else
      {
          try {
            numberField.setValue( value );		 
          } catch (Exception ex){
            ex.printStackTrace();
          }
      }
      return true;
    }

    public boolean isReportFontMode() {
        return reportFontMode;
    }

    public void setReportFontMode(boolean reportFontMode) {
        setReportFontMode( reportFontMode ? 1 : 0);
    }
    
    public void setReportFontMode(int reportFontMode) {
        this.reportFontMode = reportFontMode == 1;
        
        jComboBoxReportFonts.setVisible( reportFontMode == 0 );
        jTextFieldReportFont.setVisible( reportFontMode == 1 );
        jCheckBoxDefaultFont.setEnabled( reportFontMode == 1 );
    
        jLabel23.setVisible(reportFontMode != 3);
        
        if (jComboBoxReportFonts.getItemCount() == 0)
        {
            // We have to populate the combobox...
            Misc.updateComboBox( jComboBoxReportFonts, MainFrame.getMainInstance().getActiveReportFrame().getReport().getFonts(), true);
        }
    }
    
}
