/*
 * FormatCommandDecreaseSpaceH.java
 *
 * Created on 9 mei 2005, 21:36
 * Original code: Giulio
 * Redesigned code: Robert Lamping
 */

package it.businesslogic.ireport.gui.command;

import it.businesslogic.ireport.Band;
import it.businesslogic.ireport.OperationType;
import it.businesslogic.ireport.ReportElement;
import java.awt.Point;
import java.util.Iterator;
import java.util.Vector;


/**
 *
 *
 */
public class FormatCommandDecreaseSpaceH extends FormatCommand {
    Vector bandElements = null;
    
    {
        operationType = OperationType.DECREASE_SPACE_H;
    }
    
    boolean preCondition(){
        return ( jrf.getSelectedElements().size() > 1);
    }
    
    void executeDeeper(){
        Vector bands = getBands();  // bands with selected elements
        Band b = null;
        for (Iterator h = bands.iterator(); h.hasNext(); ) {
            b = (Band) h.next();
            bandElements = getBandElements( b );
            bandElements = sortXY( bandElements.elements());
            // first element in each band will not be moved.
            //bandElements.remove(0);
            processElements(bandElements.elements());
        }
    }
    
    public void modify() {
        
        if (getCurrentElementPosition() > 0 ) {
            re.setPosition( new Point(
                    Math.max( re.getPosition().x - (5 * (getCurrentElementPosition())),
                    ((ReportElement) bandElements.elementAt(getCurrentElementPosition()-1)).getPosition().x ) , re.getPosition().y ));
        }
        // Remark of rl: referring to the bandElements variable straight away is perhaps not very nice
    }
    
    
}
