/*
 * ComboBoxSheetProperty.java
 *
 * Created on 16 febbraio 2005, 19.13
 */

package it.businesslogic.ireport.gui.sheet;

import java.util.*;
import javax.swing.*;
import it.businesslogic.ireport.util.*;
import it.businesslogic.ireport.gui.*;

public class DoubleSheetProperty extends SheetProperty {
    
    private JNumberField editor = null;
    
    public DoubleSheetProperty(String key, String name) {
        super( key, name, SheetProperty.STRING, "");
    }
    
    public JComponent getEditor()
    {
        if (editor != null) return editor;
        editor = new JNumberField();
        try {
        editor.setDecimals(-1);
        editor.setGrouping(false);
        editor.setInteger(false);
        } catch (Exception ex) {}
        editor.addActionListener( this );
        editor.setBorder(null);
        return editor;
    }
    
    public Object getEditorValue(JComponent component)
    {
        return new Double(editor.getValue());
    }
    
    public void setEditorValue(JComponent component, Object str)
    {
        
        try {
            getEditor(); // In this way we are sure that editor is not null.
            
            if (str != null && str instanceof Double )
            {
                editor.setValue(((Double)str).doubleValue() );
            }
            else
            {
                editor.setValue( Double.parseDouble(""+str));
            }
        } catch (Exception ex) {}
    }
}