/*
 * RemoveMarginsOperation.java
 *
 *  iReport  --  Visual designer for generating JasperReports Documents
 *  Copyright (C) 2002-2003  Giulio Toffoli gt@businesslogic.it
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 *  Giulio Toffoli
 *  Via T.Aspetti, 233
 *  35100 Padova ITALY
 *  gt@businesslogic.it
 *
 *
 *
 * Created on 19 giugno 2003, 23.23
 */

package it.businesslogic.ireport.undo;
import it.businesslogic.ireport.gui.event.*;
import it.businesslogic.ireport.*;
import it.businesslogic.ireport.gui.*;
import it.businesslogic.ireport.util.*;
import java.util.*;


/**
 *
 * @author  Administrator
 */
public class RemoveMarginsOperation implements it.businesslogic.ireport.UndoOperation {
    
    
    private int oldTop = 0;
    private int oldLeft = 0;
    private int oldBottom = 0;
    private int oldRight = 0;
    
    private JReportFrame jrf = null;
    
    
    /** Creates a new instance of RemoveMarginsOperation */
    public RemoveMarginsOperation(JReportFrame jrf, int oldTop, int oldBottom, int oldLeft, int oldRight ) {
        
        this.oldTop = oldTop;
        this.oldBottom = oldBottom;
        this.oldLeft = oldLeft;
        this.oldRight = oldRight;
                
        this.jrf = jrf;
    }
        
     public void redo()
    {
        if (jrf == null) return;

        jrf.getReport().setTopMargin( 0 );
        jrf.getReport().setBottomMargin( 0 );
        jrf.getReport().setLeftMargin( 0 );
        jrf.getReport().setRightMargin( 0 );
        
        jrf.getReport().setWidth( jrf.getReport().getWidth() - oldLeft - oldRight );
        
        if (oldTop != 0 || oldLeft != 0) {
                    Enumeration e = jrf.getReport().getElements().elements();
                    while (e.hasMoreElements()) {
                        ReportElement re = (ReportElement)e.nextElement();
                        re.trasform(new java.awt.Point(-oldLeft,-oldTop), TransformationType.TRANSFORMATION_MOVE);
                    }
                }
                
        jrf.setIsDocDirty(true);
        jrf.getReportPanel().repaint();
    }
    
    public void undo()
    {
        if (jrf == null) return;

        jrf.getReport().setTopMargin( oldTop );
        jrf.getReport().setBottomMargin( oldBottom );
        jrf.getReport().setLeftMargin( oldLeft );
        jrf.getReport().setRightMargin( oldRight );
        
        jrf.getReport().setWidth( jrf.getReport().getWidth() + oldLeft + oldRight );
        
        if (oldTop != 0 || oldLeft != 0) {
                    Enumeration e = jrf.getReport().getElements().elements();
                    while (e.hasMoreElements()) {
                        ReportElement re = (ReportElement)e.nextElement();
                        re.trasform(new java.awt.Point(oldLeft,oldTop), TransformationType.TRANSFORMATION_MOVE);
                    }
                }
                
        jrf.setIsDocDirty(true);
        jrf.getReportPanel().repaint();
    }   
    
    public String toString()
    {
        return "remove margins";
    }
}
