/*
 * InsertElementOperation.java
 *
 *  iReport  --  Visual designer for generating JasperReports Documents
 *  Copyright (C) 2002-2003  Giulio Toffoli gt@businesslogic.it
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 *  Giulio Toffoli
 *  Via T.Aspetti, 233
 *  35100 Padova ITALY
 *  gt@businesslogic.it
 *
 *
 *
 * Created on 19 giugno 2003, 23.23
 */

package it.businesslogic.ireport.undo;
import it.businesslogic.ireport.gui.event.*;
import it.businesslogic.ireport.*;
import it.businesslogic.ireport.gui.*;

import java.util.*;

/**
 *  This class handle the Insert operation.
 *  As all operations, the costructor take the JReportFrame (owner of the element)
 *  The ReportElement is not cloned, this can be a problem if not all undo operations
 *  are correctly logged and handled.
 *  @author  Giulio Toffoli
 *  Modified by Robert Lamping, June 3, 2005
 *  // Also other Transformation can now be included
 *  // Once this works it should be redesigned again.
 *  // E.g. make a factory to retrieve the required transformation class.
 *  //
 */
public class TransformElementsOperation implements it.businesslogic.ireport.UndoOperation
{
    
    /*
     *  The report elements that was inserted.
     */
    private Vector transformations = null;
    
    private JReportFrame jrf = null;
    private CrosstabReportElement crosstabReportElement = null;
    
    /** Creates a new instance of InsertElementOperation */
    public TransformElementsOperation(JReportFrame jrf)
    {
        this.transformations = new Vector();
        this.jrf = jrf;
    }
    
    /** Creates a new instance of InsertElementOperation */
    public TransformElementsOperation(JReportFrame jrf, CrosstabReportElement crosstabReportElement)
    {
        this.transformations = new Vector();
        this.crosstabReportElement = crosstabReportElement;
        this.jrf = jrf;
    }
    
    public void redo()
    {
        if (jrf == null) return;
        
        if (crosstabReportElement != null)
        {
            jrf.getCrosstabEditor(crosstabReportElement).getPanelEditor().setSelectedElement(null);
        }
        else
        {
            jrf.setSelectedElement(null);
        }
        
        Vector changed_elements = new Vector();
        
        for (int i= 0; i < this.getTransformations().size(); ++i)
        {
            ( (UndoOperation) (getTransformations().get(i))).redo();
            
            if ( getTransformations().get(i) instanceof ElementTransformation )
            {
                ElementTransformation pe = (ElementTransformation) getTransformations().get(i);
                ReportElement element = pe.element;
                // Add element....]
                if (crosstabReportElement != null)
                {
                    jrf.getCrosstabEditor(crosstabReportElement).getPanelEditor().addSelectedElement( element, false );
                }
                else
                {
                    jrf.addSelectedElement( element, false );
                }
                
                changed_elements.add( element ) ;
            }
            
        }
        
        
        jrf.fireReportListenerReportElementsChanged(new ReportElementChangedEvent(jrf, crosstabReportElement, changed_elements , ReportElementChangedEvent.CHANGED));
        jrf.getMainFrame().getElementPropertiesDialog().updateSelection();
        
        jrf.getReportPanel().repaint();
    }
    
    public void undo()
    {
        if (jrf == null) return;
        
        if (crosstabReportElement != null)
        {
            jrf.getCrosstabEditor(crosstabReportElement).getPanelEditor().setSelectedElement(null);
        }
        else
        {
            jrf.setSelectedElement(null);
        }
        Vector changed_elements = new Vector();
        
        for (int i= 0; i < this.getTransformations().size(); ++i)
        {
            // no matter what kind of transformation is used: element, page whatever
            // the undo operation should simply do its work.
            // By typecasting to UndoOperation this is achieved.
            // do not typecast to ElementTransformation
            // Reason: also the Page resize transformation should be able to be called here
            // Shrink command.
            
            
            ( (UndoOperation) (getTransformations().get(i))).undo();
            
            if ( getTransformations().get(i) instanceof ElementTransformation )
            {
                ElementTransformation pe = (ElementTransformation)getTransformations().get(i);
                ReportElement element = pe.element;
                // Add element....
                
                if (crosstabReportElement != null)
                {
                    jrf.getCrosstabEditor(crosstabReportElement).getPanelEditor().addSelectedElement( element, false );
                }
                else
                {
                    jrf.addSelectedElement( element, false );
                }
                
                changed_elements.add( element ) ;
            }
            
        }
        
        jrf.fireReportListenerReportElementsChanged(new ReportElementChangedEvent(jrf, crosstabReportElement, changed_elements , ReportElementChangedEvent.CHANGED));
        jrf.getMainFrame().getElementPropertiesDialog().updateSelection();
        
        jrf.getReportPanel().repaint();
    }
    
    public String toString()
    {
        return "transformation";
    }
    
    /** Getter for property elements.
     * @return Value of property elements.
     *
     *  To add an element, use the addElement method. Don't access directly
     *  addElement from the vector elements
     *
     */
    public java.util.Vector getTransformations()
    {
        return transformations;
    }
    
    /** Setter for property elements.
     * @param elements New value of property elements.
     *
     */
    public void setTransformations(java.util.Vector transformations)
    {
        this.transformations = transformations;
    }
    
    /*
     *  Add an element to the list of elements handled by this
     *  undo operation.
     *  You must supply the old and the new bound of you report.
     *  This make more simple the undo/redo operation...
     *
     */
    
    public void addElement(Object object)
    {
        ITransformation et = null;
        
        // Kind of factorylike structure.
        // you might wish to pass this to a superclass of ElementTransformation and PageTransformation
        // e.g. Transformation.java and use something like:  getFactoryTransformation( object );
        // for now (10 june 2005) this will suffice.

        if (object instanceof ReportElement)
        {
            et = new ElementTransformation();
        }
        else if (object instanceof JReportFrame)
        {
            et = new PageTransformation();
        }
        
        // ITransformation et = Transformation.getTransformation( object );
        try
        {
            this.getTransformations().add(et);
            et.captureCurrent( object );
        }
        catch (Exception ex)
        {
            // if not registered, then the object
            // can't be undone.
            // TODO: see whether you wish to raise a special exception
        }
    }
    
    public void captureUniqueModified(Object obj)
    {
        int pos = findTransformationElement( obj );
        try
        {
            ((ITransformation) getTransformations().elementAt( pos ) ).captureModified( obj);
        }
        catch ( Exception e )
        {
            
        }
    }
    
    private int findTransformationElement( Object object)
    {
        int pos = -1; // force exception when used in array
        
        for (int i= 0; i < this.getTransformations().size(); ++i)
        {
            if ( ((ITransformation) getTransformations().get(i)).equals(object) )
            {
                pos = i;
                break;
            }
        }
        return pos;
    }
    
}

