/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.engine.util;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.net.MalformedURLException;
import java.net.URL;
import net.sf.jasperreports.engine.JRException;

public class JRLoader {
    static /* synthetic */ Class class$net$sf$jasperreports$engine$util$JRLoader;
    static /* synthetic */ Class class$net$sf$jasperreports$engine$util$JRProperties;

    public static Object loadObject(String fileName) throws JRException {
        return JRLoader.loadObject(new File(fileName));
    }

    /*
     * Loose catch block
     */
    public static Object loadObject(File file) throws JRException {
        Object obj;
        block16: {
            IOException e22;
            ObjectInputStream ois;
            FileInputStream fis;
            block15: {
                if (!file.exists() || !file.isFile()) {
                    throw new JRException(new FileNotFoundException(String.valueOf(file)));
                }
                obj = null;
                fis = null;
                ois = null;
                fis = new FileInputStream(file);
                ois = new ObjectInputStream(fis);
                obj = ois.readObject();
                Object var6_4 = null;
                if (ois == null) break block15;
                try {
                    ois.close();
                }
                catch (IOException e22) {
                    // empty catch block
                }
            }
            if (fis != null) {
                try {
                    fis.close();
                }
                catch (IOException e22) {}
            }
            break block16;
            {
                catch (IOException e3) {
                    throw new JRException("Error loading object from file : " + file, e3);
                }
                catch (ClassNotFoundException e4) {
                    throw new JRException("Class not found when loading object from file : " + file, e4);
                }
            }
            catch (Throwable throwable) {
                IOException e22;
                Object var6_5 = null;
                if (ois != null) {
                    try {
                        ois.close();
                    }
                    catch (IOException e22) {
                        // empty catch block
                    }
                }
                if (fis != null) {
                    try {
                        fis.close();
                    }
                    catch (IOException e22) {
                        // empty catch block
                    }
                }
                throw throwable;
            }
        }
        return obj;
    }

    /*
     * Loose catch block
     */
    public static Object loadObject(URL url) throws JRException {
        Object obj;
        block15: {
            IOException e22;
            ObjectInputStream ois;
            InputStream is;
            block14: {
                obj = null;
                is = null;
                ois = null;
                is = url.openStream();
                ois = new ObjectInputStream(is);
                obj = ois.readObject();
                Object var6_4 = null;
                if (ois == null) break block14;
                try {
                    ois.close();
                }
                catch (IOException e22) {
                    // empty catch block
                }
            }
            if (is != null) {
                try {
                    is.close();
                }
                catch (IOException e22) {}
            }
            break block15;
            {
                catch (IOException e3) {
                    throw new JRException("Error loading object from URL : " + url, e3);
                }
                catch (ClassNotFoundException e4) {
                    throw new JRException("Class not found when loading object from URL : " + url, e4);
                }
            }
            catch (Throwable throwable) {
                IOException e22;
                Object var6_5 = null;
                if (ois != null) {
                    try {
                        ois.close();
                    }
                    catch (IOException e22) {
                        // empty catch block
                    }
                }
                if (is != null) {
                    try {
                        is.close();
                    }
                    catch (IOException e22) {
                        // empty catch block
                    }
                }
                throw throwable;
            }
        }
        return obj;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static Object loadObject(InputStream is) throws JRException {
        Object obj = null;
        ObjectInputStream ois = null;
        try {
            try {
                ois = new ObjectInputStream(is);
                obj = ois.readObject();
            }
            catch (IOException e) {
                throw new JRException("Error loading object from InputStream", e);
            }
            catch (ClassNotFoundException e) {
                throw new JRException("Class not found when loading object from InputStream", e);
            }
            Object var5_3 = null;
            if (ois == null) return obj;
        }
        catch (Throwable throwable) {
            Object var5_4 = null;
            if (ois == null) throw throwable;
            try {
                ois.close();
                throw throwable;
            }
            catch (IOException e) {
                // empty catch block
            }
            throw throwable;
        }
        try {}
        catch (IOException e) {}
        ois.close();
        return obj;
    }

    public static Object loadObjectFromLocation(String location) throws JRException {
        return JRLoader.loadObjectFromLocation(location, null);
    }

    public static Object loadObjectFromLocation(String location, ClassLoader classLoader) throws JRException {
        try {
            URL url = new URL(location);
            return JRLoader.loadObject(url);
        }
        catch (MalformedURLException e) {
            File file = new File(location);
            if (file.exists() && file.isFile()) {
                return JRLoader.loadObject(file);
            }
            URL url = null;
            if (classLoader != null) {
                url = classLoader.getResource(location);
            }
            if (url == null) {
                classLoader = Thread.currentThread().getContextClassLoader();
                if (classLoader != null) {
                    url = classLoader.getResource(location);
                }
                if (url == null) {
                    classLoader = (class$net$sf$jasperreports$engine$util$JRLoader == null ? (class$net$sf$jasperreports$engine$util$JRLoader = JRLoader.class$("net.sf.jasperreports.engine.util.JRLoader")) : class$net$sf$jasperreports$engine$util$JRLoader).getClassLoader();
                    url = classLoader == null ? (class$net$sf$jasperreports$engine$util$JRLoader == null ? (class$net$sf$jasperreports$engine$util$JRLoader = JRLoader.class$("net.sf.jasperreports.engine.util.JRLoader")) : class$net$sf$jasperreports$engine$util$JRLoader).getResource("/" + location) : classLoader.getResource(location);
                }
            }
            if (url != null) {
                return JRLoader.loadObject(url);
            }
            throw new JRException("Could not load object from location : " + location);
        }
    }

    /*
     * Loose catch block
     */
    public static byte[] loadBytes(File file) throws JRException {
        ByteArrayOutputStream baos;
        block15: {
            IOException e22;
            FileInputStream fis;
            block14: {
                baos = null;
                fis = null;
                fis = new FileInputStream(file);
                baos = new ByteArrayOutputStream();
                byte[] bytes = new byte[10000];
                int ln = 0;
                while ((ln = fis.read(bytes)) > 0) {
                    baos.write(bytes, 0, ln);
                }
                baos.flush();
                Object var6_6 = null;
                if (baos == null) break block14;
                try {
                    baos.close();
                }
                catch (IOException e22) {
                    // empty catch block
                }
            }
            if (fis != null) {
                try {
                    fis.close();
                }
                catch (IOException e22) {}
            }
            break block15;
            {
                catch (IOException e3) {
                    throw new JRException("Error loading byte data : " + file, e3);
                }
            }
            catch (Throwable throwable) {
                IOException e22;
                Object var6_7 = null;
                if (baos != null) {
                    try {
                        baos.close();
                    }
                    catch (IOException e22) {
                        // empty catch block
                    }
                }
                if (fis != null) {
                    try {
                        fis.close();
                    }
                    catch (IOException e22) {
                        // empty catch block
                    }
                }
                throw throwable;
            }
        }
        return baos.toByteArray();
    }

    /*
     * Loose catch block
     */
    public static byte[] loadBytes(URL url) throws JRException {
        ByteArrayOutputStream baos;
        block15: {
            IOException e22;
            InputStream is;
            block14: {
                baos = null;
                is = null;
                is = url.openStream();
                baos = new ByteArrayOutputStream();
                byte[] bytes = new byte[10000];
                int ln = 0;
                while ((ln = is.read(bytes)) > 0) {
                    baos.write(bytes, 0, ln);
                }
                baos.flush();
                Object var6_6 = null;
                if (baos == null) break block14;
                try {
                    baos.close();
                }
                catch (IOException e22) {
                    // empty catch block
                }
            }
            if (is != null) {
                try {
                    is.close();
                }
                catch (IOException e22) {}
            }
            break block15;
            {
                catch (IOException e3) {
                    throw new JRException("Error loading byte data : " + url, e3);
                }
            }
            catch (Throwable throwable) {
                IOException e22;
                Object var6_7 = null;
                if (baos != null) {
                    try {
                        baos.close();
                    }
                    catch (IOException e22) {
                        // empty catch block
                    }
                }
                if (is != null) {
                    try {
                        is.close();
                    }
                    catch (IOException e22) {
                        // empty catch block
                    }
                }
                throw throwable;
            }
        }
        return baos.toByteArray();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static byte[] loadBytes(InputStream is) throws JRException {
        ByteArrayOutputStream baos = null;
        try {
            try {
                baos = new ByteArrayOutputStream();
                byte[] bytes = new byte[10000];
                int ln = 0;
                while ((ln = is.read(bytes)) > 0) {
                    baos.write(bytes, 0, ln);
                }
                baos.flush();
            }
            catch (IOException e) {
                throw new JRException("Error loading byte data from input stream.", e);
            }
            Object var5_5 = null;
            if (baos == null) return baos.toByteArray();
        }
        catch (Throwable throwable) {
            Object var5_6 = null;
            if (baos == null) throw throwable;
            try {
                baos.close();
                throw throwable;
            }
            catch (IOException e) {
                // empty catch block
            }
            throw throwable;
        }
        try {}
        catch (IOException e) {}
        baos.close();
        return baos.toByteArray();
    }

    public static byte[] loadBytesFromLocation(String location) throws JRException {
        return JRLoader.loadBytesFromLocation(location, null);
    }

    public static byte[] loadBytesFromLocation(String location, ClassLoader classLoader) throws JRException {
        try {
            URL url = new URL(location);
            return JRLoader.loadBytes(url);
        }
        catch (MalformedURLException e) {
            File file = new File(location);
            if (file.exists() && file.isFile()) {
                return JRLoader.loadBytes(file);
            }
            URL url = null;
            if (classLoader != null) {
                url = classLoader.getResource(location);
            }
            if (url == null) {
                classLoader = Thread.currentThread().getContextClassLoader();
                if (classLoader != null) {
                    url = classLoader.getResource(location);
                }
                if (url == null) {
                    classLoader = (class$net$sf$jasperreports$engine$util$JRLoader == null ? (class$net$sf$jasperreports$engine$util$JRLoader = JRLoader.class$("net.sf.jasperreports.engine.util.JRLoader")) : class$net$sf$jasperreports$engine$util$JRLoader).getClassLoader();
                    url = classLoader == null ? (class$net$sf$jasperreports$engine$util$JRLoader == null ? (class$net$sf$jasperreports$engine$util$JRLoader = JRLoader.class$("net.sf.jasperreports.engine.util.JRLoader")) : class$net$sf$jasperreports$engine$util$JRLoader).getResource("/" + location) : classLoader.getResource(location);
                }
            }
            if (url != null) {
                return JRLoader.loadBytes(url);
            }
            throw new JRException("Byte data not found at location : " + location);
        }
    }

    public static InputStream getLocationInputStream(String location) throws JRException {
        InputStream is = null;
        is = JRLoader.getFileInputStream(location);
        if (is == null) {
            is = JRLoader.getResourceInputStream(location);
        }
        if (is == null) {
            is = JRLoader.getURLInputStream(location);
        }
        return is;
    }

    public static InputStream getFileInputStream(String filename) throws JRException {
        FileInputStream is = null;
        File file = new File(filename);
        if (file.exists() && file.isFile()) {
            try {
                is = new FileInputStream(file);
            }
            catch (FileNotFoundException e) {
                throw new JRException("Error opening file " + filename);
            }
        }
        return is;
    }

    public static InputStream getResourceInputStream(String resource) {
        InputStream is = null;
        ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
        if (classLoader != null) {
            is = classLoader.getResourceAsStream(resource);
        }
        if (is == null) {
            classLoader = (class$net$sf$jasperreports$engine$util$JRLoader == null ? (class$net$sf$jasperreports$engine$util$JRLoader = JRLoader.class$("net.sf.jasperreports.engine.util.JRLoader")) : class$net$sf$jasperreports$engine$util$JRLoader).getClassLoader();
            if (classLoader != null) {
                is = classLoader.getResourceAsStream(resource);
            }
            if (is == null) {
                is = (class$net$sf$jasperreports$engine$util$JRProperties == null ? (class$net$sf$jasperreports$engine$util$JRProperties = JRLoader.class$("net.sf.jasperreports.engine.util.JRProperties")) : class$net$sf$jasperreports$engine$util$JRProperties).getResourceAsStream("/" + resource);
            }
        }
        return is;
    }

    public static InputStream getURLInputStream(String spec) throws JRException {
        InputStream is = null;
        try {
            URL url = new URL(spec);
            is = url.openStream();
        }
        catch (MalformedURLException e) {
        }
        catch (IOException e) {
            throw new JRException("Error opening URL " + spec);
        }
        return is;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

