/*
 * Decompiled with CFR 0.152.
 */
package it.businesslogic.ireport;

import java.awt.Font;
import java.awt.font.TextAttribute;
import java.util.Map;

public class IReportFont
implements Cloneable {
    private boolean defaultFont = false;
    private String reportFont = "";
    private String fontName = "Arial";
    private String PDFFontName = "Helvetica";
    private int fontSize = 10;
    private String TTFFont = "";
    private boolean bold = false;
    private boolean underline = false;
    private boolean italic = false;
    private boolean strikeTrought = false;
    private boolean pdfEmbedded = false;
    private String pdfEncoding = "Cp1252";

    public Object clone() {
        IReportFont newFont = new IReportFont();
        newFont.defaultFont = this.defaultFont;
        newFont.reportFont = this.reportFont;
        newFont.PDFFontName = this.PDFFontName;
        newFont.fontName = this.fontName;
        newFont.fontSize = this.fontSize;
        newFont.TTFFont = this.TTFFont;
        newFont.bold = this.bold;
        newFont.underline = this.underline;
        newFont.italic = this.italic;
        newFont.strikeTrought = this.strikeTrought;
        newFont.pdfEmbedded = this.pdfEmbedded;
        newFont.pdfEncoding = this.pdfEncoding;
        return newFont;
    }

    public boolean isBold() {
        return this.bold;
    }

    public void setBold(boolean bold) {
        this.bold = bold;
    }

    public String getFontName() {
        return this.fontName;
    }

    public void setFontName(String fontName) {
        this.fontName = fontName;
    }

    public int getFontSize() {
        return this.fontSize;
    }

    public void setFontSize(int fontSize) {
        this.fontSize = fontSize;
    }

    public boolean isItalic() {
        return this.italic;
    }

    public void setItalic(boolean italic) {
        this.italic = italic;
    }

    public boolean isPdfEmbedded() {
        return this.pdfEmbedded;
    }

    public void setPdfEmbedded(boolean pdfEmbedded) {
        this.pdfEmbedded = pdfEmbedded;
    }

    public String getPdfEncoding() {
        return this.pdfEncoding;
    }

    public void setPdfEncoding(String pdfEncoding) {
        this.pdfEncoding = pdfEncoding;
    }

    public String getPDFFontName() {
        return this.PDFFontName;
    }

    public void setPDFFontName(String PDFFontName) {
        this.PDFFontName = PDFFontName;
        if (PDFFontName != null && PDFFontName.toUpperCase().endsWith(".TTF")) {
            this.TTFFont = PDFFontName;
        }
    }

    public String getReportFont() {
        return this.reportFont;
    }

    public void setReportFont(String reportFont) {
        this.reportFont = reportFont;
    }

    public boolean isStrikeTrought() {
        return this.strikeTrought;
    }

    public void setStrikeTrought(boolean strikeTrought) {
        this.strikeTrought = strikeTrought;
    }

    public String getTTFFont() {
        return this.TTFFont;
    }

    public void setTTFFont(String TTFFont) {
        this.TTFFont = TTFFont;
    }

    public boolean isUnderline() {
        return this.underline;
    }

    public void setUnderline(boolean underline) {
        this.underline = underline;
    }

    public String toString() {
        return this.getReportFont();
    }

    public String getDescription() {
        return this.getFontName() + " " + this.getFontSize();
    }

    public boolean isDefaultFont() {
        return this.defaultFont;
    }

    public void setDefaultFont(boolean defaultFont) {
        this.defaultFont = defaultFont;
    }

    public Font getJavaAWTFont() {
        int style = 0;
        style &= this.isBold() ? 1 : 0;
        Font font = new Font(this.fontName, style &= this.isItalic() ? 2 : 0, this.fontSize);
        Map<TextAttribute, ?> fontAttributes = font.getAttributes();
        if (this.isUnderline()) {
            fontAttributes.put(TextAttribute.UNDERLINE, TextAttribute.UNDERLINE_ON);
        }
        if (this.isStrikeTrought()) {
            fontAttributes.put(TextAttribute.STRIKETHROUGH, TextAttribute.STRIKETHROUGH_ON);
        }
        return new Font(fontAttributes);
    }

    public void setJavaAWTFont(Font font) {
        this.fontName = font.getFontName();
        this.fontSize = font.getSize();
        int style = font.getStyle();
        this.bold = (style & 1) > 0;
        this.italic = (style & 2) > 0;
        Map<TextAttribute, ?> fontAttributes = font.getAttributes();
        this.underline = fontAttributes.containsKey(TextAttribute.UNDERLINE) && fontAttributes.get(TextAttribute.UNDERLINE).equals(TextAttribute.UNDERLINE_ON);
        this.strikeTrought = fontAttributes.containsKey(TextAttribute.STRIKETHROUGH) && fontAttributes.get(TextAttribute.STRIKETHROUGH).equals(TextAttribute.STRIKETHROUGH_ON);
    }

    public boolean isTTFFont(String fontName) {
        if (fontName.equals("Helvetica")) {
            return false;
        }
        if (fontName.equals("Helvetica-Bold")) {
            return false;
        }
        if (fontName.equals("Helvetica-BoldOblique")) {
            return false;
        }
        if (fontName.equals("Helvetica-Oblique")) {
            return false;
        }
        if (fontName.equals("Courier")) {
            return false;
        }
        if (fontName.equals("Courier-Bold")) {
            return false;
        }
        if (fontName.equals("Courier-BoldOblique")) {
            return false;
        }
        if (fontName.equals("Courier-Oblique")) {
            return false;
        }
        if (fontName.equals("Symbol")) {
            return false;
        }
        if (fontName.equals("Times-Roman")) {
            return false;
        }
        if (fontName.equals("Times-Bold")) {
            return false;
        }
        if (fontName.equals("Times-BoldItalic")) {
            return false;
        }
        if (fontName.equals("Times-Italic")) {
            return false;
        }
        if (fontName.equals("ZapfDingbats")) {
            return false;
        }
        if (fontName.equals("STSong-Light")) {
            return false;
        }
        if (fontName.equals("MHei-Medium")) {
            return false;
        }
        if (fontName.equals("MSung-Light")) {
            return false;
        }
        if (fontName.equals("HeiseiKakuGo-W5")) {
            return false;
        }
        if (fontName.equals("HeiseiMin-W3")) {
            return false;
        }
        if (fontName.equals("HYGoThic-Medium")) {
            return false;
        }
        return !fontName.equals("HYSMyeongJo-Medium");
    }
}

