/*
 * Decompiled with CFR 0.152.
 */
package it.businesslogic.ireport.crosstab.gui;

import it.businesslogic.ireport.SubDataset;
import it.businesslogic.ireport.crosstab.Measure;
import it.businesslogic.ireport.gui.JRParameterDialog;
import it.businesslogic.ireport.gui.JRTextExpressionArea;
import it.businesslogic.ireport.gui.sheet.Tag;
import it.businesslogic.ireport.util.Misc;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTextField;

public class MeasureDialog
extends JDialog {
    Measure tmpVariable = null;
    private SubDataset subDataset = null;
    private JButton jButtonCancel;
    private JButton jButtonOK;
    private JComboBox jComboBoxCalculationType;
    private JComboBox jComboBoxClassType;
    private JComboBox jComboBoxPercentageOf;
    private JLabel jLabel1;
    private JLabel jLabel10;
    private JLabel jLabel2;
    private JLabel jLabel3;
    private JLabel jLabel5;
    private JLabel jLabel8;
    private JLabel jLabel9;
    private JPanel jPanel1;
    private JRTextExpressionArea jRTextExpressionAreaExpression;
    private JTextField jTextFieldName;
    private JTextField jTextFieldNameIncrementerFactoryClass;
    private JTextField jTextFieldNamePercentageCalculatorClass;
    private int dialogResult;

    public MeasureDialog(SubDataset report, Frame parent, boolean modal) {
        super(parent, modal);
        this.initAll(report);
    }

    public MeasureDialog(SubDataset report, Dialog parent, boolean modal) {
        super(parent, modal);
        this.initAll(report);
    }

    public void initAll(SubDataset report) {
        this.initComponents();
        this.setSubDataset(report);
        this.setTypes();
        this.jComboBoxClassType.setSelectedItem("java.lang.String");
        this.jComboBoxCalculationType.setSelectedItem("Nothing");
        this.jComboBoxPercentageOf.setSelectedIndex(0);
        this.pack();
        Misc.centerFrame(this);
    }

    public void setTypes() {
        this.jComboBoxClassType.addItem("java.lang.String");
        this.jComboBoxClassType.addItem("java.lang.Object");
        this.jComboBoxClassType.addItem("java.lang.Boolean");
        this.jComboBoxClassType.addItem("java.lang.Byte");
        this.jComboBoxClassType.addItem("java.util.Date");
        this.jComboBoxClassType.addItem("java.sql.Timestamp");
        this.jComboBoxClassType.addItem("java.sql.Time");
        this.jComboBoxClassType.addItem("java.lang.Double");
        this.jComboBoxClassType.addItem("java.lang.Float");
        this.jComboBoxClassType.addItem("java.lang.Integer");
        this.jComboBoxClassType.addItem("java.io.InputStream");
        this.jComboBoxClassType.addItem("java.lang.Long");
        this.jComboBoxClassType.addItem("java.lang.Short");
        this.jComboBoxClassType.addItem("java.math.BigDecimal");
        this.jComboBoxClassType.addItem("net.sf.jasperreports.engine.JREmptyDataSource");
        this.jComboBoxPercentageOf.addItem(new Tag("None", "None"));
        this.jComboBoxPercentageOf.addItem(new Tag("GrandTotal", "Grand total"));
        this.jComboBoxCalculationType.addItem(new Tag("Nothing", "Nothing"));
        this.jComboBoxCalculationType.addItem(new Tag("Count", "Count"));
        this.jComboBoxCalculationType.addItem(new Tag("Sum", "Sum"));
        this.jComboBoxCalculationType.addItem(new Tag("Average", "Average"));
        this.jComboBoxCalculationType.addItem(new Tag("Lowest", "Lowest"));
        this.jComboBoxCalculationType.addItem(new Tag("Highest", "Highest"));
        this.jComboBoxCalculationType.addItem(new Tag("StandardDeviation", "Standard deviation"));
        this.jComboBoxCalculationType.addItem(new Tag("Variance", "Variance"));
        this.jComboBoxCalculationType.addItem(new Tag("First", "First"));
    }

    private void initComponents() {
        this.jLabel1 = new JLabel();
        this.jTextFieldName = new JTextField();
        this.jLabel2 = new JLabel();
        this.jLabel3 = new JLabel();
        this.jLabel5 = new JLabel();
        this.jComboBoxCalculationType = new JComboBox();
        this.jComboBoxClassType = new JComboBox();
        this.jRTextExpressionAreaExpression = new JRTextExpressionArea();
        this.jLabel8 = new JLabel();
        this.jTextFieldNameIncrementerFactoryClass = new JTextField();
        this.jPanel1 = new JPanel();
        this.jButtonOK = new JButton();
        this.jButtonCancel = new JButton();
        this.jLabel9 = new JLabel();
        this.jComboBoxPercentageOf = new JComboBox();
        this.jLabel10 = new JLabel();
        this.jTextFieldNamePercentageCalculatorClass = new JTextField();
        this.getContentPane().setLayout(new GridBagLayout());
        this.setTitle("Add/modify measure");
        this.setModal(true);
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent evt) {
                MeasureDialog.this.closeDialog(evt);
            }
        });
        this.jLabel1.setFont(new Font("Dialog", 0, 11));
        this.jLabel1.setText("Measure name");
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.getContentPane().add((Component)this.jLabel1, gridBagConstraints);
        this.jTextFieldName.setFont(new Font("Dialog", 0, 11));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 3;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.getContentPane().add((Component)this.jTextFieldName, gridBagConstraints);
        this.jLabel2.setFont(new Font("Dialog", 0, 11));
        this.jLabel2.setText("Calculation type");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.getContentPane().add((Component)this.jLabel2, gridBagConstraints);
        this.jLabel3.setFont(new Font("Dialog", 0, 11));
        this.jLabel3.setText("Measure expression");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 14;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.getContentPane().add((Component)this.jLabel3, gridBagConstraints);
        this.jLabel5.setFont(new Font("Dialog", 0, 11));
        this.jLabel5.setText("Measure class type");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.getContentPane().add((Component)this.jLabel5, gridBagConstraints);
        this.jComboBoxCalculationType.setFont(new Font("Dialog", 0, 11));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.getContentPane().add((Component)this.jComboBoxCalculationType, gridBagConstraints);
        this.jComboBoxClassType.setEditable(true);
        this.jComboBoxClassType.setFont(new Font("Dialog", 0, 11));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.getContentPane().add((Component)this.jComboBoxClassType, gridBagConstraints);
        this.jRTextExpressionAreaExpression.setBorder(BorderFactory.createEtchedBorder());
        this.jRTextExpressionAreaExpression.setCaretVisible(false);
        this.jRTextExpressionAreaExpression.setElectricScroll(0);
        this.jRTextExpressionAreaExpression.setMinimumSize(new Dimension(657, 100));
        this.jRTextExpressionAreaExpression.setPreferredSize(new Dimension(325, 70));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 15;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.getContentPane().add((Component)this.jRTextExpressionAreaExpression, gridBagConstraints);
        this.jLabel8.setFont(new Font("Dialog", 0, 11));
        this.jLabel8.setText("Custom Incrementer Factory Class");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.getContentPane().add((Component)this.jLabel8, gridBagConstraints);
        this.jTextFieldNameIncrementerFactoryClass.setFont(new Font("Dialog", 0, 11));
        this.jTextFieldNameIncrementerFactoryClass.setNextFocusableComponent(this.jRTextExpressionAreaExpression);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 6;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.getContentPane().add((Component)this.jTextFieldNameIncrementerFactoryClass, gridBagConstraints);
        this.jPanel1.setLayout(new FlowLayout(2));
        this.jButtonOK.setFont(new Font("Dialog", 0, 11));
        this.jButtonOK.setMnemonic('o');
        this.jButtonOK.setText("OK");
        this.jButtonOK.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                MeasureDialog.this.jButtonOKActionPerformed(evt);
            }
        });
        this.jPanel1.add(this.jButtonOK);
        this.jButtonCancel.setFont(new Font("Dialog", 0, 11));
        this.jButtonCancel.setText("Cancel");
        this.jButtonCancel.setMnemonic('c');
        this.jButtonCancel.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                MeasureDialog.this.jButtonCancelActionPerformed(evt);
            }
        });
        this.jPanel1.add(this.jButtonCancel);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 99;
        gridBagConstraints.gridwidth = 3;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.getContentPane().add((Component)this.jPanel1, gridBagConstraints);
        this.jLabel9.setFont(new Font("Dialog", 0, 11));
        this.jLabel9.setText("Percentage of");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 7;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.getContentPane().add((Component)this.jLabel9, gridBagConstraints);
        this.jComboBoxPercentageOf.setFont(new Font("Dialog", 0, 11));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 8;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.getContentPane().add((Component)this.jComboBoxPercentageOf, gridBagConstraints);
        this.jLabel10.setFont(new Font("Dialog", 0, 11));
        this.jLabel10.setText("Custom Percentage Calculator Class");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 10;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.getContentPane().add((Component)this.jLabel10, gridBagConstraints);
        this.jTextFieldNamePercentageCalculatorClass.setFont(new Font("Dialog", 0, 11));
        this.jTextFieldNamePercentageCalculatorClass.setNextFocusableComponent(this.jRTextExpressionAreaExpression);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 11;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.getContentPane().add((Component)this.jTextFieldNamePercentageCalculatorClass, gridBagConstraints);
        this.pack();
        Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();
        Dimension dialogSize = this.getSize();
        this.setLocation((screenSize.width - dialogSize.width) / 2, (screenSize.height - dialogSize.height) / 2);
    }

    private void jButtonCancelActionPerformed(ActionEvent evt) {
        this.setVisible(false);
        this.setDialogResult(2);
        this.dispose();
    }

    private void jButtonOKActionPerformed(ActionEvent evt) {
        if (this.jTextFieldName.getText().trim().length() <= 0) {
            JOptionPane.showMessageDialog(this, "Please insert a valid measure name!", "Invalid measure!", 2);
            return;
        }
        if (this.jComboBoxClassType.getSelectedIndex() < 0 || ("" + this.jComboBoxClassType.getSelectedItem()).trim().length() <= 0) {
            JOptionPane.showMessageDialog(this, "Please insert a valid class name!", "Invalid class!", 2);
            return;
        }
        this.tmpVariable = new Measure(this.jTextFieldName.getText());
        this.tmpVariable.setClassType(this.jComboBoxClassType.getSelectedItem() + "");
        this.tmpVariable.setCalculation(((Tag)this.jComboBoxCalculationType.getSelectedItem()).getValue() + "");
        this.tmpVariable.setPercentageOf(((Tag)this.jComboBoxPercentageOf.getSelectedItem()).getValue() + "");
        this.tmpVariable.setIncrementerFactoryClass(this.jTextFieldNameIncrementerFactoryClass.getText());
        this.tmpVariable.setPercentageCalculatorClass(this.jTextFieldNamePercentageCalculatorClass.getText());
        this.tmpVariable.setExpression(this.jRTextExpressionAreaExpression.getText());
        this.setVisible(false);
        this.setDialogResult(0);
        this.dispose();
    }

    private void closeDialog(WindowEvent evt) {
        this.setVisible(false);
        this.setDialogResult(-1);
        this.dispose();
    }

    public static void main(String[] args) {
        new JRParameterDialog((Frame)new JFrame(), true).show();
    }

    public Measure getMeasure() {
        return this.tmpVariable;
    }

    public void setMeasure(Measure tmpVariable) {
        this.jTextFieldName.setText(new String(tmpVariable.getName()));
        this.jComboBoxClassType.setSelectedItem(new String(tmpVariable.getClassType()));
        this.jRTextExpressionAreaExpression.setText(new String(tmpVariable.getExpression()));
        this.jTextFieldNameIncrementerFactoryClass.setText(new String(tmpVariable.getIncrementerFactoryClass()));
        Misc.setComboboxSelectedTagValue(this.jComboBoxCalculationType, tmpVariable.getCalculation());
        Misc.setComboboxSelectedTagValue(this.jComboBoxPercentageOf, tmpVariable.getPercentageOf());
        this.jTextFieldNamePercentageCalculatorClass.setText(new String(tmpVariable.getPercentageCalculatorClass()));
    }

    public int getDialogResult() {
        return this.dialogResult;
    }

    public void setDialogResult(int dialogResult) {
        this.dialogResult = dialogResult;
    }

    public void setExpressionContext(SubDataset sds) {
        if (sds == null) {
            sds = new SubDataset();
            sds.getParameters().removeAllElements();
            sds.getVariables().removeAllElements();
        }
        this.jRTextExpressionAreaExpression.setSubDataset(sds);
        this.jRTextExpressionAreaExpression.getCrosstabElements().removeAllElements();
    }

    public SubDataset getSubDataset() {
        return this.subDataset;
    }

    public void setSubDataset(SubDataset subDataset) {
        this.subDataset = subDataset;
        if (subDataset == null) {
            return;
        }
        this.jRTextExpressionAreaExpression.setSubDataset(subDataset);
        this.jRTextExpressionAreaExpression.getTokenMarker().setKeywordLookup(subDataset.getKeywordLookup());
    }
}

