/*
 * Decompiled with CFR 0.152.
 */
package it.businesslogic.ireport.gui;

import it.businesslogic.ireport.CrosstabReportElement;
import it.businesslogic.ireport.SubDataset;
import it.businesslogic.ireport.gui.ExpressionEditor;
import it.businesslogic.ireport.gui.MainFrame;
import it.businesslogic.ireport.util.I18n;
import java.awt.Color;
import java.awt.Font;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseWheelEvent;
import java.awt.event.MouseWheelListener;
import java.util.Vector;
import javax.swing.ImageIcon;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.JSeparator;
import javax.swing.event.UndoableEditEvent;
import javax.swing.event.UndoableEditListener;
import org.syntax.jedit.JEditTextArea;
import org.syntax.jedit.SyntaxDocument;
import org.syntax.jedit.tokenmarker.JavaTokenMarker;

public class JRTextExpressionArea
extends JEditTextArea {
    private int spessore = 0;
    protected boolean viewScrollbars = true;
    private JPopupMenu jPopupMenuTextField;
    private JMenuItem jMenuItemTextEditor;
    private JSeparator jSeparator8;
    private JMenuItem jMenuItemCut;
    private JMenuItem jMenuItemCopy;
    private JMenuItem jMenuItemPaste;
    private JMenuItem jMenuItemSelectAll;
    private JSeparator jSeparator9;
    private JMenu jMenuFields;
    private JMenu jMenuVariables;
    private JMenu jMenuParameters;
    private SubDataset subDataset = null;
    private Vector crosstabElements = new Vector();

    public JRTextExpressionArea() {
        this.painter.setEOLMarkersPainted(false);
        this.painter.setInvalidLinesPainted(false);
        this.painter.setLineHighlightEnabled(false);
        this.spessore = this.vertical.getWidth();
        this.painter.setLineHighlightColor(Color.WHITE);
        this.setDocument(new SyntaxDocument());
        this.setTokenMarker(new JavaTokenMarker());
        this.getDocument().addUndoableEditListener(new SimpleUndoableEditListener());
        this.addMouseWheelListener(new SimpleMouseWheelListener());
        this.initPopupMenu();
        this.setToolTipText("TIP: open the text editor to edit your expression:\npress right mouse button and choose <b>Expression editor</b>");
    }

    public void initPopupMenu() {
        this.jPopupMenuTextField = new JPopupMenu();
        this.jMenuItemTextEditor = new JMenuItem();
        this.jSeparator8 = new JSeparator();
        this.jMenuItemCut = new JMenuItem();
        this.jMenuItemCopy = new JMenuItem();
        this.jMenuItemPaste = new JMenuItem();
        this.jMenuItemSelectAll = new JMenuItem();
        this.jSeparator9 = new JSeparator();
        this.jMenuFields = new JMenu();
        this.jMenuVariables = new JMenu();
        this.jMenuParameters = new JMenu();
        this.jMenuItemTextEditor.setText("Use texteditor");
        this.jMenuItemTextEditor.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                JRTextExpressionArea.this.jMenuItemTextEditorActionPerformed(evt);
            }
        });
        this.jPopupMenuTextField.add(this.jMenuItemTextEditor);
        this.jPopupMenuTextField.add(this.jSeparator8);
        this.jMenuItemCut.setFont(new Font("Dialog", 0, 11));
        this.jMenuItemCut.setIcon(new ImageIcon(this.getClass().getResource("/it/businesslogic/ireport/icons/menu/cut.gif")));
        this.jMenuItemCut.setText(I18n.getString("cut", "Cut"));
        this.jPopupMenuTextField.add(this.jMenuItemCut);
        this.jMenuItemCut.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                JRTextExpressionArea.this.jMenuItemCutActionPerformed(evt);
            }
        });
        this.jMenuItemCopy.setFont(new Font("Dialog", 0, 11));
        this.jMenuItemCopy.setIcon(new ImageIcon(this.getClass().getResource("/it/businesslogic/ireport/icons/menu/copy.gif")));
        this.jMenuItemCopy.setText(I18n.getString("copy", "Copy"));
        this.jPopupMenuTextField.add(this.jMenuItemCopy);
        this.jMenuItemCopy.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                JRTextExpressionArea.this.jMenuItemCopyActionPerformed(evt);
            }
        });
        this.jMenuItemPaste.setFont(new Font("Dialog", 0, 11));
        this.jMenuItemPaste.setIcon(new ImageIcon(this.getClass().getResource("/it/businesslogic/ireport/icons/menu/paste.gif")));
        this.jMenuItemPaste.setText(I18n.getString("paste", "Paste"));
        this.jPopupMenuTextField.add(this.jMenuItemPaste);
        this.jMenuItemPaste.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                JRTextExpressionArea.this.jMenuItemPasteActionPerformed(evt);
            }
        });
        this.jMenuItemSelectAll.setFont(new Font("Dialog", 0, 11));
        this.jMenuItemSelectAll.setText("Select all");
        this.jPopupMenuTextField.add(this.jMenuItemSelectAll);
        this.jMenuItemSelectAll.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                JRTextExpressionArea.this.jMenuItemSelectAllActionPerformed(evt);
            }
        });
        this.setRightClickPopup(this.jPopupMenuTextField);
    }

    private void jMenuItemTextEditorActionPerformed(ActionEvent evt) {
        if (MainFrame.getMainInstance().getActiveReportFrame() == null) {
            return;
        }
        ExpressionEditor ed = new ExpressionEditor();
        if (this.getSubDataset() == null && this.getCrosstabElements().size() == 0) {
            if (MainFrame.getMainInstance().getActiveReportFrame().getSelectedCrosstabEditorPanel() == null) {
                this.setSubDataset(MainFrame.getMainInstance().getActiveReportFrame().getReport());
            } else {
                this.addCrosstab(MainFrame.getMainInstance().getActiveReportFrame().getSelectedCrosstabEditorPanel().getCrosstabElement());
            }
        }
        if (this.getSubDataset() != null) {
            ed.setSubDataset(this.getSubDataset());
        }
        ed.setCrosstabElements(this.getCrosstabElements());
        ed.setExpression(this.getText());
        ed.updateTreeEntries();
        ed.show();
        if (ed.getDialogResult() == 0) {
            this.setText(ed.getExpression());
        }
    }

    private void jMenuItemCutActionPerformed(ActionEvent evt) {
        this.cut();
    }

    private void jMenuItemCopyActionPerformed(ActionEvent evt) {
        this.copy();
    }

    private void jMenuItemPasteActionPerformed(ActionEvent evt) {
        this.paste();
    }

    private void jMenuItemSelectAllActionPerformed(ActionEvent evt) {
        this.setSelectionStart(0);
        this.setSelectionEnd(this.getText().length());
    }

    public boolean isViewScrollbars() {
        return this.viewScrollbars;
    }

    public void setViewScrollbars(boolean viewScrollbars) {
        if (!viewScrollbars) {
            // empty if block
        }
        this.viewScrollbars = viewScrollbars;
    }

    public void setEnabled(boolean enabled) {
        if (super.isEnabled() == enabled) {
            return;
        }
        super.setEnabled(enabled);
        if (!super.isEnabled()) {
            for (int i = 0; i < this.getComponentCount(); ++i) {
                this.getComponent(i).setBackground(Color.GRAY);
            }
            this.setCaretVisible(false);
            this.getPainter().setLineHighlightEnabled(false);
        } else {
            for (int i = 0; i < this.getComponentCount(); ++i) {
                this.getComponent(i).setBackground(Color.WHITE);
            }
            this.setCaretVisible(true);
            this.getPainter().setLineHighlightEnabled(true);
        }
    }

    public void addEdit(UndoableEditEvent e) {
        this.getDocument().getUM().addEdit(e.getEdit());
    }

    public SubDataset getSubDataset() {
        return this.subDataset;
    }

    public void setSubDataset(SubDataset subDataset) {
        this.subDataset = subDataset;
    }

    public Vector getCrosstabElements() {
        return this.crosstabElements;
    }

    public void setCrosstabElements(Vector crosstabElements) {
        this.crosstabElements = crosstabElements;
    }

    public void addCrosstab(CrosstabReportElement cr) {
        this.getCrosstabElements().add(cr);
    }

    class SimpleMouseWheelListener
    implements MouseWheelListener {
        public void mouseWheelMoved(MouseWheelEvent e) {
            if (e.getScrollType() == 0 && JRTextExpressionArea.this.getFirstLine() + JRTextExpressionArea.this.getVisibleLines() - 1 + e.getWheelRotation() < JRTextExpressionArea.this.getLineCount() && JRTextExpressionArea.this.getFirstLine() + e.getWheelRotation() >= 0) {
                JRTextExpressionArea.this.setFirstLine(JRTextExpressionArea.this.getFirstLine() + e.getWheelRotation());
            }
        }

        protected SimpleMouseWheelListener() {
        }
    }

    class SimpleUndoableEditListener
    implements UndoableEditListener {
        public void undoableEditHappened(UndoableEditEvent e) {
            JRTextExpressionArea.this.addEdit(e);
        }

        protected SimpleUndoableEditListener() {
        }
    }
}

