/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.compiler.ast;

import org.eclipse.jdt.core.compiler.CharOperation;
import org.eclipse.jdt.internal.compiler.ASTVisitor;
import org.eclipse.jdt.internal.compiler.ast.ASTNode;
import org.eclipse.jdt.internal.compiler.ast.Expression;
import org.eclipse.jdt.internal.compiler.ast.OperatorExpression;
import org.eclipse.jdt.internal.compiler.ast.TypeReference;
import org.eclipse.jdt.internal.compiler.codegen.CodeStream;
import org.eclipse.jdt.internal.compiler.flow.FlowContext;
import org.eclipse.jdt.internal.compiler.flow.FlowInfo;
import org.eclipse.jdt.internal.compiler.lookup.ArrayBinding;
import org.eclipse.jdt.internal.compiler.lookup.BaseTypes;
import org.eclipse.jdt.internal.compiler.lookup.BlockScope;
import org.eclipse.jdt.internal.compiler.lookup.MethodBinding;
import org.eclipse.jdt.internal.compiler.lookup.ReferenceBinding;
import org.eclipse.jdt.internal.compiler.lookup.TypeBinding;

public class InstanceOfExpression
extends OperatorExpression {
    public Expression expression;
    public TypeReference type;

    public InstanceOfExpression(Expression expression, TypeReference type, int operator) {
        this.expression = expression;
        this.type = type;
        this.bits |= operator << 6;
        this.sourceStart = expression.sourceStart;
        this.sourceEnd = type.sourceEnd;
    }

    public FlowInfo analyseCode(BlockScope currentScope, FlowContext flowContext, FlowInfo flowInfo) {
        return this.expression.analyseCode(currentScope, flowContext, flowInfo).unconditionalInits();
    }

    public final boolean checkCastTypesCompatibility(BlockScope scope, TypeBinding castType, TypeBinding expressionType) {
        if (castType == expressionType) {
            return false;
        }
        if (castType == null || expressionType == null) {
            return true;
        }
        if (expressionType == BaseTypes.NullBinding) {
            return false;
        }
        if (expressionType.isBaseType()) {
            scope.problemReporter().notCompatibleTypesError(this, expressionType, castType);
            return true;
        }
        if (expressionType.isArrayType()) {
            if (castType == expressionType) {
                return false;
            }
            if (castType.isArrayType()) {
                TypeBinding exprElementType = ((ArrayBinding)expressionType).elementsType(scope);
                if (exprElementType.isBaseType()) {
                    if (((ArrayBinding)castType).elementsType(scope) != exprElementType) {
                        scope.problemReporter().notCompatibleTypesError(this, expressionType, castType);
                    }
                    return true;
                }
                return this.checkCastTypesCompatibility(scope, ((ArrayBinding)castType).elementsType(scope), exprElementType);
            }
            if (castType.isClass()) {
                if (castType.id == 1) {
                    return false;
                }
            } else if (castType.id == 36 || castType.id == 37) {
                return true;
            }
            scope.problemReporter().notCompatibleTypesError(this, expressionType, castType);
            return true;
        }
        if (expressionType.isClass()) {
            if (castType.isArrayType()) {
                if (expressionType.id == 1) {
                    return true;
                }
            } else if (castType.isClass()) {
                if (expressionType.isCompatibleWith(castType)) {
                    return false;
                }
                if (castType.isCompatibleWith(expressionType)) {
                    return true;
                }
            } else {
                if (expressionType.isCompatibleWith(castType)) {
                    return false;
                }
                if (!((ReferenceBinding)expressionType).isFinal()) {
                    return true;
                }
            }
            scope.problemReporter().notCompatibleTypesError(this, expressionType, castType);
            return true;
        }
        if (castType.isArrayType()) {
            if (expressionType.id != 36 && expressionType.id != 37) {
                scope.problemReporter().notCompatibleTypesError(this, expressionType, castType);
            }
            return true;
        }
        if (castType.isClass()) {
            if (castType.id == 1) {
                return false;
            }
            if (((ReferenceBinding)castType).isFinal() && !castType.isCompatibleWith(expressionType)) {
                scope.problemReporter().notCompatibleTypesError(this, expressionType, castType);
                return true;
            }
        } else {
            if (expressionType.isCompatibleWith(castType)) {
                return false;
            }
            if (!castType.isCompatibleWith(expressionType)) {
                MethodBinding[] castTypeMethods = ((ReferenceBinding)castType).methods();
                MethodBinding[] expressionTypeMethods = ((ReferenceBinding)expressionType).methods();
                int exprMethodsLength = expressionTypeMethods.length;
                int i = 0;
                int castMethodsLength = castTypeMethods.length;
                while (i < castMethodsLength) {
                    int j = 0;
                    while (j < exprMethodsLength) {
                        if (castTypeMethods[i].returnType != expressionTypeMethods[j].returnType && CharOperation.equals(castTypeMethods[i].selector, expressionTypeMethods[j].selector) && castTypeMethods[i].areParametersEqual(expressionTypeMethods[j])) {
                            scope.problemReporter().notCompatibleTypesError(this, expressionType, castType);
                        }
                        ++j;
                    }
                    ++i;
                }
            }
        }
        return true;
    }

    public void generateCode(BlockScope currentScope, CodeStream codeStream, boolean valueRequired) {
        int pc = codeStream.position;
        this.expression.generateCode(currentScope, codeStream, true);
        codeStream.instance_of(this.type.resolvedType);
        if (!valueRequired) {
            codeStream.pop();
        }
        codeStream.recordPositionsFrom(pc, this.sourceStart);
    }

    public StringBuffer printExpressionNoParenthesis(int indent, StringBuffer output) {
        this.expression.printExpression(indent, output).append(" instanceof ");
        return this.type.print(0, output);
    }

    public TypeBinding resolveType(BlockScope scope) {
        this.constant = ASTNode.NotAConstant;
        TypeBinding expressionType = this.expression.resolveType(scope);
        TypeBinding checkType = this.type.resolveType(scope);
        if (expressionType == null || checkType == null) {
            return null;
        }
        boolean necessary = this.checkCastTypesCompatibility(scope, checkType, expressionType);
        if (!necessary) {
            scope.problemReporter().unnecessaryInstanceof(this, checkType);
        }
        this.resolvedType = BaseTypes.BooleanBinding;
        return this.resolvedType;
    }

    public void traverse(ASTVisitor visitor, BlockScope scope) {
        if (visitor.visit(this, scope)) {
            this.expression.traverse(visitor, scope);
            this.type.traverse(visitor, scope);
        }
        visitor.endVisit(this, scope);
    }
}

