/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.groovy.ast.expr;

import groovy.lang.MetaMethod;
import org.codehaus.groovy.ast.GroovyCodeVisitor;
import org.codehaus.groovy.ast.expr.Expression;
import org.codehaus.groovy.ast.expr.ExpressionTransformer;
import org.codehaus.groovy.classgen.AsmClassGenerator;

public class StaticMethodCallExpression
extends Expression {
    String ownerType;
    private String method;
    private Expression arguments;
    private MetaMethod metaMethod = null;

    public StaticMethodCallExpression(String type, String method, Expression arguments) {
        this.ownerType = type;
        this.method = method;
        this.arguments = arguments;
    }

    public void visit(GroovyCodeVisitor visitor) {
        visitor.visitStaticMethodCallExpression(this);
    }

    public Expression transformExpression(ExpressionTransformer transformer) {
        return new StaticMethodCallExpression(this.type, this.method, transformer.transform(this.arguments));
    }

    protected void resolveType(AsmClassGenerator resolver) {
        this.arguments.resolve(resolver);
        resolver.resolve(this);
    }

    public Expression getArguments() {
        return this.arguments;
    }

    public String getMethod() {
        return this.method;
    }

    public String getText() {
        return this.type + "." + this.method + this.arguments.getText();
    }

    public String toString() {
        return super.toString() + "[type: " + this.type + " method: " + this.method + " arguments: " + this.arguments + "]";
    }

    public String getOwnerType() {
        return this.ownerType;
    }

    public void setOwnerType(String ownerType) {
        this.ownerType = ownerType;
    }

    public void setMetaMethod(MetaMethod metaMethod) {
        this.metaMethod = metaMethod;
    }

    public MetaMethod getMetaMethod() {
        return this.metaMethod;
    }
}

