/*
 * Dataset.java
 *
 * Created on 8 luglio 2005, 17.49
 *
 * To change this template, choose Tools | Options and locate the template under
 * the Source Creation and Management node. Right-click the template and choose
 * Open. You can then make changes to the template in the Source Editor.
 */

package it.businesslogic.ireport.chart;

import it.businesslogic.ireport.JRSubreportParameter;
import it.businesslogic.ireport.SubDataset;
import java.util.Vector;

/**
 *
 * @author Administrator
 */
public class Dataset {
    
    
    private String resetType="Report";
    private String resetGroup="";
    private String incrementType="None";
    private String incrementGroup="";
    private String connectionExpression="";
    private String dataSourceExpression="";
    private String parametersMapExpression="";
    private boolean useConnection = false;
    private Vector subreportParameters =  new Vector();
    
    private SubDataset subDataset = null;
        
    /** Creates a new instance of Dataset */
    public Dataset() {
    }

    public String getResetType() {
        return resetType;
    }

    public void setResetType(String resetType) {
        this.resetType = resetType;
    }

    public String getResetGroup() {
        return resetGroup;
    }

    public void setResetGroup(String resetGroup) {
        this.resetGroup = resetGroup;
    }

    public String getIncrementType() {
        return incrementType;
    }

    public void setIncrementType(String incrementType) {
        this.incrementType = incrementType;
    }

    public String getIncrementGroup() {
        return incrementGroup;
    }

    public void setIncrementGroup(String incrementGroup) {
        this.incrementGroup = incrementGroup;
    }
    
    public Dataset cloneMe()
    {   
        Dataset ds = new Dataset();
        copyBaseDataset(ds);
        return ds;
    }
    
    public void copyBaseDataset(Dataset ds)
    {
        ds.setIncrementType( getIncrementType());
        ds.setIncrementGroup( getIncrementGroup());
        ds.setResetType( getResetType());
        ds.setResetGroup( getResetGroup());
        ds.setUseConnection( isUseConnection());
        ds.setSubDataset( this.getSubDataset());
        ds.setParametersMapExpression( getParametersMapExpression());
        ds.setConnectionExpression( getConnectionExpression());
        ds.setDataSourceExpression( getDataSourceExpression());
        for (int i=0; i< getSubreportParameters().size(); ++i)
        {
            ds.getSubreportParameters().add( ((JRSubreportParameter)getSubreportParameters().elementAt(i)).cloneMe() );
        }
    }
    
        public String getConnectionExpression() {
        return connectionExpression;
    }

    public void setConnectionExpression(String connectionExpression) {
        this.connectionExpression = connectionExpression;
    }

    public String getDataSourceExpression() {
        return dataSourceExpression;
    }

    public void setDataSourceExpression(String dataSourceExpression) {
        this.dataSourceExpression = dataSourceExpression;
    }

    public String getParametersMapExpression() {
        return parametersMapExpression;
    }

    public void setParametersMapExpression(String parametersMapExpression) {
        this.parametersMapExpression = parametersMapExpression;
    }

    public boolean isUseConnection() {
        return useConnection;
    }

    public void setUseConnection(boolean useConnection) {
        this.useConnection = useConnection;
    }

    public Vector getSubreportParameters() {
        return subreportParameters;
    }

    public void setSubreportParameters(Vector subreportParameters) {
        this.subreportParameters = subreportParameters;
    }

    public SubDataset getSubDataset() {
        return subDataset;
    }

    public void setSubDataset(SubDataset subDataset) {
        this.subDataset = subDataset;
    }
}
