/*
 * FormatCommandSameHeightMax.java
 *
 * Created on 9 mei 2005, 21:36
 */

package it.businesslogic.ireport.gui.command;

import it.businesslogic.ireport.OperationType;
import it.businesslogic.ireport.ReportElement;
import it.businesslogic.ireport.TransformationType;

import java.awt.Point;
import java.util.Enumeration;

/**
 *
 */
public class FormatCommandSameHeightMax extends FormatCommand {
    {
        operationType = OperationType.SAME_HEIGHT_MAX;
    }
    int height;
    
    
    public void preparation() {
        height = 0;
        ReportElement re = null;
        Enumeration enum2 = this.getSelectedElements().elements();
        while (enum2.hasMoreElements()) {
            re = (ReportElement)enum2.nextElement();
            if (height <= re.getHeight()) {
                height = re.getHeight();
            }
        }
    }
    
    public void modify() {
        re.trasform(new Point(0,height-re.height), TransformationType.TRANSFORMATION_RESIZE_SE);
    }
    
}
