/*
 * Prompter.java
 *
 * Created on 4 maggio 2005, 0.02
 */
package it.businesslogic.ireport.gui.prompt;

import it.businesslogic.ireport.*;

import java.util.*;


/**
 * @author Administrator
 */
public class Prompter
{

    /**
     * DOCUMENT ME!
     * 
     * @param report DOCUMENT ME!
     * @return DOCUMENT ME!
     */
    public static HashMap promptForParameters(Report report)
    {

        HashMap hm = new HashMap();

        for (int i = 0; i < report.getParameters().size(); ++i)
        {

            JRParameter param = (JRParameter) (report.getParameters().elementAt(
                                        i));

            if (param.isIsForPrompting() && param.getClassType() != null && 
                !param.isBuiltin())
            {

                PromptDialog pd = new PromptDialog(it.businesslogic.ireport.gui.MainFrame.getMainInstance(), 
                                                   true);
                pd.setParameter(param);
                pd.setVisible(true);
                
                boolean isCollection = false;

                if (pd.getDialogResult() == javax.swing.JOptionPane.OK_OPTION)
                {

                    Object value = pd.getValue();

                    if (param.getClassType().equals("java.lang.String"))
                    {
                        hm.put(param.getName(), value);
                    }
                    else if (param.getClassType().equals("java.lang.Integer"))
                    {

                        try
                        {
                            hm.put(param.getName(), new Integer("" + value));
                        }
                        catch (Exception ex)
                        {
                            System.out.println(ex.getMessage());
                        }
                    }
                    else if (param.getClassType().equals("java.lang.Long"))
                    {

                        try
                        {
                            hm.put(param.getName(), new Long("" + value));
                        }
                        catch (Exception ex)
                        {
                            System.out.println(ex.getMessage());
                        }
                    }
                    else if (param.getClassType().equals("java.lang.Double"))
                    {

                        try
                        {
                            hm.put(param.getName(), new Double("" + value));
                        }
                        catch (Exception ex)
                        {
                            System.out.println(ex.getMessage());
                        }
                    }
                    else if (param.getClassType().equals("java.lang.Float"))
                    {

                        try
                        {
                            hm.put(param.getName(), new Float("" + value));
                        }
                        catch (Exception ex)
                        {
                            System.out.println(ex.getMessage());
                        }
                    }
                    else if (param.getClassType().equals("java.lang.Boolean"))
                    {

                        try
                        {
                            hm.put(param.getName(), new Boolean("" + value));
                        }
                        catch (Exception ex)
                        {
                            System.out.println(ex.getMessage());
                        }
                    }
                    else if (param.getClassType().equals("java.util.Date"))
                    {

                        try
                        {

                            java.text.SimpleDateFormat sdf = 
                                    new java.text.SimpleDateFormat(it.businesslogic.ireport.gui.MainFrame.getMainInstance().getProperties().getProperty(
                                                                           "dateformat", 
                                                                           "d/M/y"));
                            hm.put(param.getName(), sdf.parse("" + value));
                        }
                        catch (Exception ex)
                        {
                            System.out.println(ex.getMessage());
                        }
                    }
                    else if (param.getClassType().equals("java.sql.Time"))
                    {

                        try
                        {

                            java.text.SimpleDateFormat sdf = 
                                    new java.text.SimpleDateFormat(it.businesslogic.ireport.gui.MainFrame.getMainInstance().getProperties().getProperty(
                                                                           "timeformat", 
                                                                           "d/M/y H:m:s"));
                            java.util.Date d = sdf.parse("" + value);
                            java.sql.Time time = new java.sql.Time(d.getTime());
                            hm.put(param.getName(), time);
                        }
                        catch (Exception ex)
                        {
                            System.out.println(ex.getMessage());
                        }
                    }
                    else if (param.getClassType().equals("java.sql.Timestamp"))
                    {

                        try
                        {

                            java.text.SimpleDateFormat sdf = 
                                    new java.text.SimpleDateFormat(it.businesslogic.ireport.gui.MainFrame.getMainInstance().getProperties().getProperty(
                                                                           "timeformat", 
                                                                           "d/M/y H:m:s"));
                            java.util.Date d = sdf.parse("" + value);
                            java.sql.Timestamp time = new java.sql.Timestamp(d.getTime());
                            hm.put(param.getName(), time);
                        }
                        catch (Exception ex)
                        {
                            System.out.println(ex.getMessage());
                        }
                    }
                    else 
                    {
                        try {
                            Class clazz = Class.forName(param.getClassType());
                            
                            if ( java.util.Collection.class.isAssignableFrom(clazz) )
                            {
                                    isCollection = true;
                                    java.util.Collection collection = null;
                                    collection = new java.util.ArrayList();
                                    
                                    if (value != null)
                                    {
                                        fillCollection( collection, ""+value);
                                        
                                        param.setLastDefaultValue("" + value);
                                        value = collection;
                                        
                                        try
                                        {
                                            hm.put(param.getName(), collection);
                                        }
                                        catch (Exception ex)
                                        {
                                            System.out.println(ex.getMessage());
                                        }
                                    }
                            }

                        } catch (Exception ex)
                        {
                              ex.printStackTrace();
                        }
                        
                        
                    }

                    if (value != null && !isCollection)
                    {
                        param.setLastDefaultValue("" + value);
                    }
                }
            }
        }

        return hm;
    }
    
    public static void  fillCollection( java.util.Collection collection, String str)
    {
        if (str == null || str.length() == 0) return;
        
        StringTokenizer st = new StringTokenizer(str,",",false);
        
        while (st.hasMoreTokens())
        {
            String s = st.nextToken();
            
            s = s.trim();
            //if (s.startsWith("\"")) s= s.substring(1);
            //if (s.endsWith("\"")) s = s.substring(0,s.length()-1);
            collection.add(s);
        }
        
        
        
    }
}
