/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.loader.collection;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.hibernate.FetchMode;
import org.hibernate.HibernateException;
import org.hibernate.LockMode;
import org.hibernate.MappingException;
import org.hibernate.engine.SessionFactoryImplementor;
import org.hibernate.engine.SessionImplementor;
import org.hibernate.loader.OuterJoinLoader;
import org.hibernate.loader.OuterJoinableAssociation;
import org.hibernate.loader.collection.CollectionInitializer;
import org.hibernate.persister.collection.QueryableCollection;
import org.hibernate.sql.JoinFragment;
import org.hibernate.sql.Select;
import org.hibernate.type.AssociationType;
import org.hibernate.type.Type;
import org.hibernate.util.CollectionHelper;
import org.hibernate.util.StringHelper;

public class CollectionLoader
extends OuterJoinLoader
implements CollectionInitializer {
    private static final Log log = LogFactory.getLog((Class)(class$org$hibernate$loader$collection$CollectionLoader == null ? (class$org$hibernate$loader$collection$CollectionLoader = CollectionLoader.class$("org.hibernate.loader.collection.CollectionLoader")) : class$org$hibernate$loader$collection$CollectionLoader));
    private final QueryableCollection collectionPersister;
    static /* synthetic */ Class class$org$hibernate$loader$collection$CollectionLoader;

    public CollectionLoader(QueryableCollection collectionPersister, SessionFactoryImplementor session, Map enabledFilters) throws MappingException {
        this(collectionPersister, 1, session, enabledFilters);
    }

    public CollectionLoader(QueryableCollection collectionPersister, int batchSize, SessionFactoryImplementor factory, Map enabledFilters) throws MappingException {
        this(collectionPersister, batchSize, null, factory, enabledFilters);
    }

    public CollectionLoader(QueryableCollection collectionPersister, int batchSize, String subquery, SessionFactoryImplementor factory, Map enabledFilters) throws MappingException {
        super(factory, enabledFilters);
        this.collectionPersister = collectionPersister;
        String alias = this.generateRootAlias(collectionPersister.getRole());
        List associations = this.walkCollectionTree(collectionPersister, alias);
        ArrayList<OuterJoinableAssociation> allAssociations = new ArrayList<OuterJoinableAssociation>();
        allAssociations.addAll(associations);
        allAssociations.add(new OuterJoinableAssociation(collectionPersister.getCollectionType(), null, null, alias, 1, this.getFactory(), CollectionHelper.EMPTY_MAP));
        this.initPersisters(allAssociations, LockMode.NONE);
        this.initStatementString(alias, associations, batchSize, subquery);
        this.postInstantiate();
        log.debug((Object)("Static select for collection " + collectionPersister.getRole() + ": " + this.getSQLString()));
    }

    public void initialize(Serializable id, SessionImplementor session) throws HibernateException {
        this.loadCollection(session, id, this.getKeyType());
    }

    private void initStatementString(String alias, List associations, int batchSize, String subquery) throws MappingException {
        int joins = CollectionLoader.countEntityPersisters(associations);
        int collectionJoins = CollectionLoader.countCollectionPersisters(associations) + 1;
        this.suffixes = CollectionLoader.generateSuffixes(joins);
        this.collectionSuffixes = CollectionLoader.generateSuffixes(joins, collectionJoins);
        StringBuffer whereString = this.whereString(alias, this.collectionPersister.getKeyColumnNames(), batchSize, subquery);
        String filter = this.collectionPersister.filterFragment(alias, this.getEnabledFilters());
        if (this.collectionPersister.isManyToMany()) {
            Iterator itr = associations.iterator();
            AssociationType associationType = (AssociationType)this.collectionPersister.getElementType();
            while (itr.hasNext()) {
                OuterJoinableAssociation oja = (OuterJoinableAssociation)itr.next();
                if (oja.getJoinableType() != associationType) continue;
                filter = filter + this.collectionPersister.getManyToManyFilterFragment(oja.getRHSAlias(), this.getEnabledFilters());
            }
        }
        whereString.insert(0, StringHelper.moveAndToBeginning(filter));
        JoinFragment ojf = this.mergeOuterJoins(associations);
        Select select = new Select(this.getDialect()).setSelectClause(this.collectionPersister.selectFragment(alias, this.collectionSuffixes[0]) + this.selectString(associations)).setFromClause(this.collectionPersister.getTableName(), alias).setWhereClause(whereString.toString()).setOuterJoins(ojf.toFromFragmentString(), ojf.toWhereFragmentString());
        select.setOrderByClause(this.orderBy(associations, this.collectionPersister.getSQLOrderByString(alias)));
        if (this.getFactory().getSettings().isCommentsEnabled()) {
            select.setComment("load collection " + this.collectionPersister.getRole());
        }
        this.sql = select.toStatementString();
    }

    protected int getJoinType(AssociationType type, FetchMode config, String path, Set visitedAssociations, String lhsTable, String[] lhsColumns, boolean nullable, int currentDepth) throws MappingException {
        int joinType = super.getJoinType(type, config, path, visitedAssociations, lhsTable, lhsColumns, nullable, currentDepth);
        if (joinType == 1 && "".equals(path)) {
            joinType = 0;
        }
        return joinType;
    }

    protected Type getKeyType() {
        return this.collectionPersister.getKeyType();
    }

    public String toString() {
        return this.getClass().getName() + '(' + this.collectionPersister.getRole() + ')';
    }

    protected boolean isSubselectLoadingEnabled() {
        return this.hasSubselectLoadableCollections();
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

