/*
 * Decompiled with CFR 0.152.
 */
package it.businesslogic.ireport.util;

public class Unit {
    public static final double PIXEL = 1.0;
    public static final double INCHES = 72.0;
    public static final double CENTIMETERS = 28.3464;
    public static final double MILLIMETERS = 2.83464;
    private String unitName;
    private double conversionValue;

    public Unit(String unitName, double conversionValue) {
        this.unitName = unitName;
        this.conversionValue = conversionValue;
    }

    public String getUnitName() {
        return this.unitName;
    }

    public void setUnitName(String unitName) {
        this.unitName = unitName;
    }

    public double getConversionValue() {
        return this.conversionValue;
    }

    public void setConversionValue(double conversionValue) {
        this.conversionValue = conversionValue;
    }

    public static Unit[] getStandardUnits() {
        Unit[] units = new Unit[]{new Unit("pixels", 1.0), new Unit("inches", 72.0), new Unit("cm", 28.3464), new Unit("mm", 2.83464)};
        return units;
    }

    public static int getUnitIndex(String unitName) {
        Unit[] units = Unit.getStandardUnits();
        for (int i = 0; i < units.length; ++i) {
            if (!units[i].getUnitName().equalsIgnoreCase(unitName)) continue;
            return i;
        }
        return -1;
    }

    public String toString() {
        return this.getUnitName();
    }

    public static double convertPixelsToInches(long pixels) {
        return (double)pixels / 72.0;
    }

    public static long convertInchesToPixels(double inches) {
        return (long)(inches * 72.0);
    }

    public static double convertPixelsToCentimeters(long pixels) {
        return (double)pixels / 28.3464;
    }

    public static long convertCentimetersToPixels(double centimeters) {
        return (long)(centimeters * 28.3464);
    }

    public static double convertPixelsToMillimeters(long pixels) {
        return (double)pixels / 2.83464;
    }

    public static long convertMillimetersToPixels(double millimeters) {
        return (long)(millimeters * 28.3464);
    }

    public static long convertToPixels(double value, double convert) {
        return (long)(value * convert);
    }
}

