/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.groovy.ast.expr;

import org.codehaus.groovy.ast.GroovyCodeVisitor;
import org.codehaus.groovy.ast.expr.Expression;
import org.codehaus.groovy.ast.expr.ExpressionTransformer;
import org.codehaus.groovy.classgen.AsmClassGenerator;
import org.codehaus.groovy.classgen.BytecodeHelper;

public class VariableExpression
extends Expression {
    public static final VariableExpression THIS_EXPRESSION = new VariableExpression("this", null);
    public static final VariableExpression SUPER_EXPRESSION = new VariableExpression("super", null);
    private String variable;
    boolean isDynamic = true;

    public VariableExpression(String variable, String type) {
        this.variable = variable;
        if (type == null || type.length() == 0) {
            this.isDynamic = true;
        } else {
            String boxedType = BytecodeHelper.getObjectTypeForPrimitive(type);
            super.setType(boxedType);
            this.isDynamic = false;
        }
    }

    public VariableExpression(String variable) {
        this.variable = variable;
    }

    public void visit(GroovyCodeVisitor visitor) {
        visitor.visitVariableExpression(this);
    }

    public Expression transformExpression(ExpressionTransformer transformer) {
        return this;
    }

    protected void resolveType(AsmClassGenerator resolver) {
        resolver.resolve(this);
    }

    public String getVariable() {
        return this.variable;
    }

    public String getText() {
        return this.variable;
    }

    public String getType() {
        if (this.type == null) {
            return "java.lang.Object";
        }
        return this.type;
    }

    public boolean isDynamic() {
        return this.isDynamic;
    }

    public String toString() {
        return super.toString() + "[variable: " + this.variable + (this.isDynamic() ? "" : " type: " + this.type) + "]";
    }

    public void setDynamic(boolean dynamic) {
        this.isDynamic = dynamic;
    }
}

