/*
 * Decompiled with CFR 0.152.
 */
package groovy.sql;

import groovy.lang.Closure;
import groovy.lang.GString;
import groovy.sql.DataSet;
import groovy.sql.GroovyResultSet;
import groovy.sql.GroovyRowResult;
import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.sql.CallableStatement;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.sql.DataSource;

public class Sql {
    protected Logger log = Logger.getLogger(this.getClass().getName());
    private DataSource dataSource;
    private Connection useConnection;
    private boolean warned;
    int updateCount = 0;
    private Closure configureStatement;

    public static Sql newInstance(String url) throws SQLException {
        Connection connection = DriverManager.getConnection(url);
        return new Sql(connection);
    }

    public static Sql newInstance(String url, Properties properties) throws SQLException {
        Connection connection = DriverManager.getConnection(url, properties);
        return new Sql(connection);
    }

    public static Sql newInstance(String url, Properties properties, String driverClassName) throws SQLException, ClassNotFoundException {
        Sql.loadDriver(driverClassName);
        return Sql.newInstance(url, properties);
    }

    public static Sql newInstance(String url, String user, String password) throws SQLException {
        Connection connection = DriverManager.getConnection(url, user, password);
        return new Sql(connection);
    }

    public static Sql newInstance(String url, String user, String password, String driverClassName) throws SQLException, ClassNotFoundException {
        Sql.loadDriver(driverClassName);
        return Sql.newInstance(url, user, password);
    }

    public static Sql newInstance(String url, String driverClassName) throws SQLException, ClassNotFoundException {
        Sql.loadDriver(driverClassName);
        return Sql.newInstance(url);
    }

    public static void loadDriver(String driverClassName) throws ClassNotFoundException {
        try {
            Class.forName(driverClassName);
        }
        catch (ClassNotFoundException e) {
            try {
                Thread.currentThread().getContextClassLoader().loadClass(driverClassName);
            }
            catch (ClassNotFoundException e2) {
                try {
                    Sql.class.getClassLoader().loadClass(driverClassName);
                }
                catch (ClassNotFoundException e3) {
                    throw e;
                }
            }
        }
    }

    public Sql(DataSource dataSource) {
        this.dataSource = dataSource;
    }

    public Sql(Connection connection) {
        if (connection == null) {
            throw new NullPointerException("Must specify a non-null Connection");
        }
        this.useConnection = connection;
    }

    public Sql(Sql parent) {
        this.dataSource = parent.dataSource;
        this.useConnection = parent.useConnection;
    }

    public DataSet dataSet(String table) {
        return new DataSet(this, table);
    }

    public DataSet dataSet(Class type) {
        return new DataSet(this, type);
    }

    public void query(String sql, Closure closure) throws SQLException {
        Connection connection = this.createConnection();
        Statement statement = connection.createStatement();
        this.configure(statement);
        ResultSet results = null;
        try {
            this.log.fine(sql);
            results = statement.executeQuery(sql);
            closure.call(results);
            this.closeResources(connection, statement, results);
        }
        catch (SQLException e) {
            try {
                this.log.log(Level.FINE, "Failed to execute: " + sql, e);
                throw e;
            }
            catch (Throwable throwable) {
                this.closeResources(connection, statement, results);
                throw throwable;
            }
        }
    }

    public void query(String sql, List params, Closure closure) throws SQLException {
        Connection connection = this.createConnection();
        PreparedStatement statement = null;
        ResultSet results = null;
        try {
            this.log.fine(sql);
            statement = connection.prepareStatement(sql);
            this.setParameters(params, statement);
            this.configure(statement);
            results = statement.executeQuery();
            closure.call(results);
            this.closeResources(connection, statement, results);
        }
        catch (SQLException e) {
            try {
                this.log.log(Level.FINE, "Failed to execute: " + sql, e);
                throw e;
            }
            catch (Throwable throwable) {
                this.closeResources(connection, statement, results);
                throw throwable;
            }
        }
    }

    public void query(GString gstring, Closure closure) throws SQLException {
        List params = this.getParameters(gstring);
        String sql = this.asSql(gstring, params);
        this.query(sql, params, closure);
    }

    public void queryEach(String sql, Closure closure) throws SQLException {
        this.warnDeprecated();
        this.eachRow(sql, closure);
    }

    public void eachRow(String sql, Closure closure) throws SQLException {
        Connection connection = this.createConnection();
        Statement statement = connection.createStatement();
        this.configure(statement);
        ResultSet results = null;
        try {
            this.log.fine(sql);
            results = statement.executeQuery(sql);
            GroovyResultSet groovyRS = new GroovyResultSet(results);
            while (groovyRS.next()) {
                closure.call(groovyRS);
            }
            this.closeResources(connection, statement, results);
        }
        catch (SQLException e) {
            try {
                this.log.log(Level.FINE, "Failed to execute: " + sql, e);
                throw e;
            }
            catch (Throwable throwable) {
                this.closeResources(connection, statement, results);
                throw throwable;
            }
        }
    }

    public void queryEach(String sql, List params, Closure closure) throws SQLException {
        this.warnDeprecated();
        this.eachRow(sql, params, closure);
    }

    public void eachRow(String sql, List params, Closure closure) throws SQLException {
        Connection connection = this.createConnection();
        PreparedStatement statement = null;
        ResultSet results = null;
        try {
            this.log.fine(sql);
            statement = connection.prepareStatement(sql);
            this.setParameters(params, statement);
            this.configure(statement);
            results = statement.executeQuery();
            GroovyResultSet groovyRS = new GroovyResultSet(results);
            while (groovyRS.next()) {
                closure.call(groovyRS);
            }
            this.closeResources(connection, statement, results);
        }
        catch (SQLException e) {
            try {
                this.log.log(Level.FINE, "Failed to execute: " + sql, e);
                throw e;
            }
            catch (Throwable throwable) {
                this.closeResources(connection, statement, results);
                throw throwable;
            }
        }
    }

    public void eachRow(GString gstring, Closure closure) throws SQLException {
        List params = this.getParameters(gstring);
        String sql = this.asSql(gstring, params);
        this.eachRow(sql, params, closure);
    }

    public void queryEach(GString gstring, Closure closure) throws SQLException {
        this.warnDeprecated();
        this.eachRow(gstring, closure);
    }

    public List rows(String sql) throws SQLException {
        ArrayList<GroovyRowResult> results = new ArrayList<GroovyRowResult>();
        Connection connection = this.createConnection();
        Statement statement = connection.createStatement();
        this.configure(statement);
        ResultSet rs = null;
        try {
            Object metadata;
            this.log.fine(sql);
            rs = statement.executeQuery(sql);
            while (rs.next()) {
                metadata = rs.getMetaData();
                LinkedHashMap<String, Object> lhm = new LinkedHashMap<String, Object>(metadata.getColumnCount(), 1.0f, true);
                for (int i = 1; i <= metadata.getColumnCount(); ++i) {
                    lhm.put(metadata.getColumnName(i), rs.getObject(i));
                }
                GroovyRowResult row = new GroovyRowResult(lhm);
                results.add(row);
            }
            metadata = results;
            this.closeResources(connection, statement, rs);
            return metadata;
        }
        catch (SQLException e) {
            try {
                this.log.log(Level.FINE, "Failed to execute: " + sql, e);
                throw e;
            }
            catch (Throwable throwable) {
                this.closeResources(connection, statement, rs);
                throw throwable;
            }
        }
    }

    public Object firstRow(String sql) throws SQLException {
        return this.rows(sql).get(0);
    }

    public List rows(String sql, List params) throws SQLException {
        ArrayList<GroovyRowResult> results = new ArrayList<GroovyRowResult>();
        Connection connection = this.createConnection();
        PreparedStatement statement = null;
        ResultSet rs = null;
        try {
            Object metadata;
            this.log.fine(sql);
            statement = connection.prepareStatement(sql);
            this.setParameters(params, statement);
            this.configure(statement);
            rs = statement.executeQuery();
            while (rs.next()) {
                metadata = rs.getMetaData();
                LinkedHashMap<String, Object> lhm = new LinkedHashMap<String, Object>(metadata.getColumnCount(), 1.0f, true);
                for (int i = 1; i <= metadata.getColumnCount(); ++i) {
                    lhm.put(metadata.getColumnName(i), rs.getObject(i));
                }
                GroovyRowResult row = new GroovyRowResult(lhm);
                results.add(row);
            }
            metadata = results;
            this.closeResources(connection, statement, rs);
            return metadata;
        }
        catch (SQLException e) {
            try {
                this.log.log(Level.FINE, "Failed to execute: " + sql, e);
                throw e;
            }
            catch (Throwable throwable) {
                this.closeResources(connection, statement, rs);
                throw throwable;
            }
        }
    }

    public Object firstRow(String sql, List params) throws SQLException {
        return this.rows(sql, params).get(0);
    }

    public boolean execute(String sql) throws SQLException {
        Connection connection = this.createConnection();
        Statement statement = null;
        try {
            this.log.fine(sql);
            statement = connection.createStatement();
            this.configure(statement);
            boolean isResultSet = statement.execute(sql);
            this.updateCount = statement.getUpdateCount();
            boolean bl = isResultSet;
            this.closeResources(connection, statement);
            return bl;
        }
        catch (SQLException e) {
            try {
                this.log.log(Level.FINE, "Failed to execute: " + sql, e);
                throw e;
            }
            catch (Throwable throwable) {
                this.closeResources(connection, statement);
                throw throwable;
            }
        }
    }

    public int executeUpdate(String sql) throws SQLException {
        Connection connection = this.createConnection();
        Statement statement = null;
        try {
            this.log.fine(sql);
            statement = connection.createStatement();
            this.configure(statement);
            int n = this.updateCount = statement.executeUpdate(sql);
            this.closeResources(connection, statement);
            return n;
        }
        catch (SQLException e) {
            try {
                this.log.log(Level.FINE, "Failed to execute: " + sql, e);
                throw e;
            }
            catch (Throwable throwable) {
                this.closeResources(connection, statement);
                throw throwable;
            }
        }
    }

    public boolean execute(String sql, List params) throws SQLException {
        Connection connection = this.createConnection();
        PreparedStatement statement = null;
        try {
            this.log.fine(sql);
            statement = connection.prepareStatement(sql);
            this.setParameters(params, statement);
            this.configure(statement);
            boolean isResultSet = statement.execute();
            this.updateCount = statement.getUpdateCount();
            boolean bl = isResultSet;
            this.closeResources(connection, statement);
            return bl;
        }
        catch (SQLException e) {
            try {
                this.log.log(Level.FINE, "Failed to execute: " + sql, e);
                throw e;
            }
            catch (Throwable throwable) {
                this.closeResources(connection, statement);
                throw throwable;
            }
        }
    }

    public int executeUpdate(String sql, List params) throws SQLException {
        Connection connection = this.createConnection();
        PreparedStatement statement = null;
        try {
            this.log.fine(sql);
            statement = connection.prepareStatement(sql);
            this.setParameters(params, statement);
            this.configure(statement);
            int n = this.updateCount = statement.executeUpdate();
            this.closeResources(connection, statement);
            return n;
        }
        catch (SQLException e) {
            try {
                this.log.log(Level.FINE, "Failed to execute: " + sql, e);
                throw e;
            }
            catch (Throwable throwable) {
                this.closeResources(connection, statement);
                throw throwable;
            }
        }
    }

    public boolean execute(GString gstring) throws SQLException {
        List params = this.getParameters(gstring);
        String sql = this.asSql(gstring, params);
        return this.execute(sql, params);
    }

    public int executeUpdate(GString gstring) throws SQLException {
        List params = this.getParameters(gstring);
        String sql = this.asSql(gstring, params);
        return this.executeUpdate(sql, params);
    }

    public int call(String sql) throws Exception {
        return this.call(sql, Collections.EMPTY_LIST);
    }

    public int call(String sql, List params) throws Exception {
        Connection connection = this.createConnection();
        CallableStatement statement = connection.prepareCall(sql);
        try {
            this.log.fine(sql);
            this.setParameters(params, statement);
            this.configure(statement);
            int n = statement.executeUpdate();
            return n;
        }
        catch (SQLException e) {
            this.log.log(Level.FINE, "Failed to execute: " + sql, e);
            throw e;
        }
        finally {
            this.closeResources(connection, statement);
        }
    }

    public int call(GString gstring) throws Exception {
        List params = this.getParameters(gstring);
        String sql = this.asSql(gstring, params);
        return this.call(sql, params);
    }

    public void close() throws SQLException {
        if (this.useConnection != null) {
            this.useConnection.close();
        }
    }

    public DataSource getDataSource() {
        return this.dataSource;
    }

    public void commit() {
        try {
            this.useConnection.commit();
        }
        catch (SQLException e) {
            this.log.log(Level.SEVERE, "Caught exception commiting connection: " + e, e);
        }
    }

    public void rollback() {
        try {
            this.useConnection.rollback();
        }
        catch (SQLException e) {
            this.log.log(Level.SEVERE, "Caught exception rollbacking connection: " + e, e);
        }
    }

    public int getUpdateCount() {
        return this.updateCount;
    }

    public Connection getConnection() {
        return this.useConnection;
    }

    public void withStatement(Closure configureStatement) {
        this.configureStatement = configureStatement;
    }

    protected String asSql(GString gstring, List values) {
        boolean nulls = false;
        String[] strings = gstring.getStrings();
        if (strings.length <= 0) {
            throw new IllegalArgumentException("No SQL specified in GString: " + gstring);
        }
        StringBuffer buffer = new StringBuffer();
        boolean warned = false;
        Iterator iter = values.iterator();
        for (int i = 0; i < strings.length; ++i) {
            String text = strings[i];
            if (text != null) {
                buffer.append(text);
            }
            if (!iter.hasNext()) continue;
            Object value = iter.next();
            if (value != null) {
                boolean validBinding = true;
                if (i < strings.length - 1) {
                    String nextText = strings[i + 1];
                    if ((text.endsWith("\"") || text.endsWith("'")) && (nextText.startsWith("'") || nextText.startsWith("\""))) {
                        if (!warned) {
                            this.log.warning("In Groovy SQL please do not use quotes around dynamic expressions (which start with $) as this means we cannot use a JDBC PreparedStatement and so is a security hole. Groovy has worked around your mistake but the security hole is still there. The expression so far is: " + buffer.toString() + "?" + nextText);
                            warned = true;
                        }
                        buffer.append(value);
                        iter.remove();
                        validBinding = false;
                    }
                }
                if (!validBinding) continue;
                buffer.append("?");
                continue;
            }
            nulls = true;
            buffer.append("?'\"?");
        }
        String sql = buffer.toString();
        if (nulls) {
            sql = this.nullify(sql);
        }
        return sql;
    }

    protected String nullify(String sql) {
        int firstWhere = this.findWhereKeyword(sql);
        if (firstWhere >= 0) {
            Pattern[] patterns = new Pattern[]{Pattern.compile("(?is)^(.{" + firstWhere + "}.*?)!=\\s{0,1}(\\s*)\\?'\"\\?(.*)"), Pattern.compile("(?is)^(.{" + firstWhere + "}.*?)<>\\s{0,1}(\\s*)\\?'\"\\?(.*)"), Pattern.compile("(?is)^(.{" + firstWhere + "}.*?[^<>])=\\s{0,1}(\\s*)\\?'\"\\?(.*)")};
            String[] replacements = new String[]{"$1 is not $2null$3", "$1 is not $2null$3", "$1 is $2null$3"};
            for (int i = 0; i < patterns.length; ++i) {
                Matcher matcher = patterns[i].matcher(sql);
                while (matcher.matches()) {
                    sql = matcher.replaceAll(replacements[i]);
                    matcher = patterns[i].matcher(sql);
                }
            }
        }
        return sql.replaceAll("\\?'\"\\?", "null");
    }

    protected int findWhereKeyword(String sql) {
        char[] chars = sql.toLowerCase().toCharArray();
        char[] whereChars = "where".toCharArray();
        boolean inString = false;
        boolean noWhere = true;
        int inWhere = 0;
        block3: for (int i = 0; i < chars.length && noWhere; ++i) {
            switch (chars[i]) {
                case '\'': {
                    if (inString) {
                        inString = false;
                        continue block3;
                    }
                    inString = true;
                    continue block3;
                }
                default: {
                    if (inString || chars[i] != whereChars[inWhere] || ++inWhere != whereChars.length) continue block3;
                    return i;
                }
            }
        }
        return -1;
    }

    protected List getParameters(GString gstring) {
        Object[] values = gstring.getValues();
        ArrayList<Object> answer = new ArrayList<Object>(values.length);
        for (int i = 0; i < values.length; ++i) {
            if (values[i] == null) continue;
            answer.add(values[i]);
        }
        return answer;
    }

    protected void setParameters(List params, PreparedStatement statement) throws SQLException {
        int i = 1;
        Iterator iter = params.iterator();
        while (iter.hasNext()) {
            Object value = iter.next();
            this.setObject(statement, i++, value);
        }
    }

    protected void setObject(PreparedStatement statement, int i, Object value) throws SQLException {
        statement.setObject(i, value);
    }

    protected Connection createConnection() throws SQLException {
        if (this.dataSource != null) {
            Connection con = null;
            try {
                con = (Connection)AccessController.doPrivileged(new PrivilegedExceptionAction(){

                    public Object run() throws SQLException {
                        return Sql.this.dataSource.getConnection();
                    }
                });
            }
            catch (PrivilegedActionException pae) {
                Exception e = pae.getException();
                if (e instanceof SQLException) {
                    throw (SQLException)e;
                }
                throw (RuntimeException)e;
            }
            return con;
        }
        return this.useConnection;
    }

    protected void closeResources(Connection connection, Statement statement, ResultSet results) {
        if (results != null) {
            try {
                results.close();
            }
            catch (SQLException e) {
                this.log.log(Level.SEVERE, "Caught exception closing resultSet: " + e, e);
            }
        }
        this.closeResources(connection, statement);
    }

    protected void closeResources(Connection connection, Statement statement) {
        if (statement != null) {
            try {
                statement.close();
            }
            catch (SQLException e) {
                this.log.log(Level.SEVERE, "Caught exception closing statement: " + e, e);
            }
        }
        if (this.dataSource != null) {
            try {
                connection.close();
            }
            catch (SQLException e) {
                this.log.log(Level.SEVERE, "Caught exception closing connection: " + e, e);
            }
        }
    }

    private void warnDeprecated() {
        if (!this.warned) {
            this.warned = true;
            this.log.warning("queryEach() is deprecated, please use eachRow() instead");
        }
    }

    protected void configure(Statement statement) {
        if (this.configureStatement != null) {
            this.configureStatement.call(statement);
        }
    }
}

