/*
 * Decompiled with CFR 0.152.
 */
package it.businesslogic.ireport.gui;

import it.businesslogic.ireport.IReportFont;
import it.businesslogic.ireport.ReportElement;
import it.businesslogic.ireport.TextReportElement;
import it.businesslogic.ireport.gui.JRFontDialog;
import it.businesslogic.ireport.gui.JReportFrame;
import it.businesslogic.ireport.gui.MainFrame;
import it.businesslogic.ireport.gui.ValuesDialog;
import it.businesslogic.ireport.util.Misc;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.Enumeration;
import javax.swing.DefaultListSelectionModel;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.DefaultTableModel;

public class FontsDialog
extends JDialog {
    private JButton jButtonDeleteParameter;
    private JButton jButtonModifyParameter;
    private JButton jButtonNewParameter;
    private JPanel jPanelButtons;
    private JPanel jPanelParameters;
    private JScrollPane jScrollPane1;
    private JTable jTableParameters;
    private JReportFrame jReportFrame;

    public FontsDialog(Frame parent, boolean modal) {
        super(parent, modal);
        this.initComponents();
        this.setSize(490, 250);
        DefaultListSelectionModel dlsm = (DefaultListSelectionModel)this.jTableParameters.getSelectionModel();
        dlsm.addListSelectionListener(new ListSelectionListener(){

            public void valueChanged(ListSelectionEvent e) {
                FontsDialog.this.jTableParametersListSelectionValueChanged(e);
            }
        });
        Misc.centerFrame(this);
    }

    public void jTableParametersListSelectionValueChanged(ListSelectionEvent e) {
        if (this.jTableParameters.getSelectedRowCount() > 0) {
            this.jButtonModifyParameter.setEnabled(true);
            this.jButtonDeleteParameter.setEnabled(true);
        } else {
            this.jButtonModifyParameter.setEnabled(false);
            this.jButtonDeleteParameter.setEnabled(false);
        }
    }

    private void initComponents() {
        this.jPanelParameters = new JPanel();
        this.jScrollPane1 = new JScrollPane();
        this.jTableParameters = new JTable();
        this.jPanelButtons = new JPanel();
        this.jButtonNewParameter = new JButton();
        this.jButtonModifyParameter = new JButton();
        this.jButtonDeleteParameter = new JButton();
        this.setDefaultCloseOperation(2);
        this.setTitle("Report fonts");
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent evt) {
                FontsDialog.this.closeDialog(evt);
            }
        });
        this.jPanelParameters.setLayout(new BorderLayout(2, 2));
        this.jScrollPane1.setBackground(new Color(255, 255, 255));
        this.jTableParameters.setModel(new DefaultTableModel(new Object[0][], new String[]{"Report font name", "Font", "Default"}){
            boolean[] canEdit;
            {
                this.canEdit = new boolean[]{false, false, false};
            }

            public boolean isCellEditable(int rowIndex, int columnIndex) {
                return this.canEdit[columnIndex];
            }
        });
        this.jScrollPane1.setViewportView(this.jTableParameters);
        this.jPanelParameters.add((Component)this.jScrollPane1, "Center");
        this.jPanelButtons.setLayout(new GridBagLayout());
        this.jPanelButtons.setPreferredSize(new Dimension(100, 10));
        this.jPanelButtons.setMinimumSize(new Dimension(100, 10));
        this.jButtonNewParameter.setText("New");
        this.jButtonNewParameter.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                FontsDialog.this.jButtonNewParameterActionPerformed(evt);
            }
        });
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(3, 3, 5, 3);
        this.jPanelButtons.add((Component)this.jButtonNewParameter, gridBagConstraints);
        this.jButtonModifyParameter.setText("Modify");
        this.jButtonModifyParameter.setEnabled(false);
        this.jButtonModifyParameter.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                FontsDialog.this.jButtonModifyParameterActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(0, 3, 5, 3);
        this.jPanelButtons.add((Component)this.jButtonModifyParameter, gridBagConstraints);
        this.jButtonDeleteParameter.setText("Delete");
        this.jButtonDeleteParameter.setEnabled(false);
        this.jButtonDeleteParameter.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                FontsDialog.this.jButtonDeleteParameterActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(0, 3, 5, 3);
        this.jPanelButtons.add((Component)this.jButtonDeleteParameter, gridBagConstraints);
        this.jPanelParameters.add((Component)this.jPanelButtons, "East");
        this.getContentPane().add((Component)this.jPanelParameters, "Center");
        this.pack();
    }

    private void jButtonDeleteParameterActionPerformed(ActionEvent evt) {
        this.jTableParameters.getSelectedRows();
        while (this.jTableParameters.getSelectedRow() >= 0) {
            int row = this.jTableParameters.getSelectedRow();
            IReportFont font = (IReportFont)this.jTableParameters.getValueAt(row, 0);
            Enumeration e = this.getJReportFrame().getReport().getElements().elements();
            while (e.hasMoreElements()) {
                ReportElement re = (ReportElement)e.nextElement();
                if (!(re instanceof TextReportElement) || !((TextReportElement)re).getReportFont().equals(font.getReportFont())) continue;
                ((TextReportElement)re).setReportFont("");
            }
            this.getJReportFrame().getReport().getFonts().remove(font);
            this.jTableParameters.removeRowSelectionInterval(row, row);
        }
        this.updateReportFonts();
        ((MainFrame)this.getParent()).getElementPropertiesDialog().updateReportFonts();
        ((MainFrame)this.getParent()).getElementPropertiesDialog().updateSelection();
    }

    private void jButtonModifyParameterActionPerformed(ActionEvent evt) {
        JRFontDialog fd = new JRFontDialog(null, true);
        fd.updateFonts(this.getJReportFrame().getMainFrame().getTtfFonts());
        DefaultTableModel dtm = (DefaultTableModel)this.jTableParameters.getModel();
        IReportFont font = (IReportFont)dtm.getValueAt(this.jTableParameters.getSelectedRow(), 0);
        fd.setIReportFont(font);
        fd.setVisible(true);
        if (fd.getDialogResult() == 0) {
            IReportFont new_font = fd.getIReportFont();
            String oldName = font.getReportFont();
            font.setReportFont(new_font.getReportFont());
            if (!Misc.nvl(oldName, "").equals(Misc.nvl(new_font.getReportFont(), "")) && new_font.getReportFont() != null) {
                Enumeration e = this.getJReportFrame().getReport().getElements().elements();
                while (e.hasMoreElements()) {
                    ReportElement re = (ReportElement)e.nextElement();
                    if (!(re instanceof TextReportElement) || !((TextReportElement)re).getReportFont().equals(oldName)) continue;
                    ((TextReportElement)re).setReportFont(new_font.getReportFont());
                }
            }
            font.setFontName(new_font.getFontName());
            font.setFontSize(new_font.getFontSize());
            font.setBold(new_font.isBold());
            font.setItalic(new_font.isItalic());
            font.setPDFFontName(new_font.getPDFFontName());
            font.setPdfEmbedded(new_font.isPdfEmbedded());
            font.setPdfEncoding(new_font.getPdfEncoding());
            font.setStrikeTrought(new_font.isStrikeTrought());
            font.setUnderline(new_font.isUnderline());
            font.setDefaultFont(new_font.isDefaultFont());
            this.jTableParameters.setValueAt(font, this.jTableParameters.getSelectedRow(), 0);
            this.jTableParameters.setValueAt(font.getDescription(), this.jTableParameters.getSelectedRow(), 1);
            this.jTableParameters.setValueAt(font.isDefaultFont() + "", this.jTableParameters.getSelectedRow(), 2);
            this.jTableParameters.updateUI();
            ((MainFrame)this.getParent()).getElementPropertiesDialog().updateReportFonts();
            ((MainFrame)this.getParent()).getElementPropertiesDialog().updateSelection();
            this.getJReportFrame().setIsDocDirty(true);
            this.getJReportFrame().repaint();
        }
    }

    private void jButtonNewParameterActionPerformed(ActionEvent evt) {
        JRFontDialog fd = new JRFontDialog(null, true);
        fd.updateFonts(this.getJReportFrame().getMainFrame().getTtfFonts());
        fd.setVisible(true);
        if (fd.getDialogResult() == 0) {
            IReportFont font = fd.getIReportFont();
            DefaultTableModel dtm = (DefaultTableModel)this.jTableParameters.getModel();
            this.revertDefaultFontProperties();
            dtm.addRow(new Object[]{font, font.getDescription(), font.isDefaultFont() + ""});
            this.getJReportFrame().getReport().getFonts().addElement(font);
            this.getJReportFrame().getMainFrame().getElementPropertiesDialog().updateReportFonts();
        }
    }

    private void revertDefaultFontProperties() {
        DefaultTableModel dtm = (DefaultTableModel)this.jTableParameters.getModel();
        for (int i = 0; i < dtm.getRowCount(); ++i) {
            IReportFont font = (IReportFont)dtm.getValueAt(i, 0);
            font.setDefaultFont(false);
            this.jTableParameters.setValueAt(font.isDefaultFont() + "", i, 2);
        }
        this.jTableParameters.updateUI();
        ((MainFrame)this.getParent()).getElementPropertiesDialog().updateReportFonts();
        ((MainFrame)this.getParent()).getElementPropertiesDialog().updateSelection();
    }

    private void closeDialog(WindowEvent evt) {
        this.setVisible(false);
    }

    public static void main(String[] args) {
        new ValuesDialog((Frame)new JFrame(), true).setVisible(true);
    }

    public JReportFrame getJReportFrame() {
        return this.jReportFrame;
    }

    public void setJReportFrame(JReportFrame jReportFrame) {
        this.jReportFrame = jReportFrame;
        if (jReportFrame == null) {
            this.setVisible(false);
            return;
        }
        this.setTitle(jReportFrame.getReport().getName() + " fonts...");
        if (this.isVisible()) {
            this.updateReportFonts();
        }
    }

    public void updateReportFonts() {
        DefaultTableModel dtm = (DefaultTableModel)this.jTableParameters.getModel();
        dtm.setRowCount(0);
        if (this.jReportFrame != null) {
            Enumeration e = this.jReportFrame.getReport().getFonts().elements();
            while (e.hasMoreElements()) {
                IReportFont font = (IReportFont)e.nextElement();
                dtm.addRow(new Object[]{font, font.getDescription(), font.isDefaultFont() + ""});
            }
        }
    }

    public void setVisible(boolean visible) {
        if (visible == this.isVisible()) {
            return;
        }
        super.setVisible(visible);
        if (visible) {
            this.setJReportFrame(this.jReportFrame);
        }
    }
}

