/*
 * Decompiled with CFR 0.152.
 */
package mondrian.rolap;

import java.lang.reflect.Constructor;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import mondrian.olap.CellFormatter;
import mondrian.olap.Cube;
import mondrian.olap.CubeBase;
import mondrian.olap.Dimension;
import mondrian.olap.DimensionBase;
import mondrian.olap.DimensionType;
import mondrian.olap.Formula;
import mondrian.olap.Hierarchy;
import mondrian.olap.Level;
import mondrian.olap.Member;
import mondrian.olap.MemberProperty;
import mondrian.olap.MondrianDef;
import mondrian.olap.MondrianException;
import mondrian.olap.NamedSet;
import mondrian.olap.OlapElement;
import mondrian.olap.Property;
import mondrian.olap.Query;
import mondrian.olap.Role;
import mondrian.olap.Schema;
import mondrian.olap.SchemaReader;
import mondrian.olap.Util;
import mondrian.resource.MondrianResource;
import mondrian.rolap.CacheMemberReader;
import mondrian.rolap.CellReader;
import mondrian.rolap.HierarchyUsage;
import mondrian.rolap.MeasureMemberSource;
import mondrian.rolap.RolapCalculatedMember;
import mondrian.rolap.RolapConnection;
import mondrian.rolap.RolapDimension;
import mondrian.rolap.RolapHierarchy;
import mondrian.rolap.RolapLevel;
import mondrian.rolap.RolapMeasure;
import mondrian.rolap.RolapMember;
import mondrian.rolap.RolapSchema;
import mondrian.rolap.RolapSchemaReader;
import mondrian.rolap.RolapStar;
import mondrian.rolap.RolapStoredMeasure;
import mondrian.rolap.RolapUtil;
import mondrian.rolap.agg.AggregationManager;
import mondrian.rolap.aggmatcher.ExplicitRules;
import org.apache.log4j.Logger;
import org.eigenbase.xom.DOMWrapper;
import org.eigenbase.xom.Parser;
import org.eigenbase.xom.XOMException;
import org.eigenbase.xom.XOMUtil;

public class RolapCube
extends CubeBase {
    private static final Logger LOGGER;
    private final RolapSchema schema;
    private final RolapHierarchy measuresHierarchy;
    final MondrianDef.Relation fact;
    private final CellReader cellReader;
    private int[] localDimensionOrdinals;
    private SchemaReader schemaReader;
    private Formula[] calculatedMembers;
    private Formula[] namedSets;
    private final List hierarchyUsages;
    private RolapStar star;
    private ExplicitRules.Group aggGroup;
    static final /* synthetic */ boolean $assertionsDisabled;

    private RolapCube(RolapSchema schema, MondrianDef.Schema xmlSchema, String name, boolean cache, MondrianDef.Relation fact, MondrianDef.CubeDimension[] dimensions) {
        super(name, new RolapDimension[dimensions.length + 1]);
        this.schema = schema;
        this.fact = fact;
        this.hierarchyUsages = new ArrayList();
        this.cellReader = AggregationManager.instance();
        this.calculatedMembers = new Formula[0];
        this.namedSets = new Formula[0];
        if (!this.isVirtual()) {
            this.star = schema.getRolapStarRegistry().getOrCreateStar(fact);
            if (!cache) {
                this.star.setCacheAggregations(cache);
            }
        }
        if (this.getLogger().isDebugEnabled()) {
            if (this.isVirtual()) {
                this.getLogger().debug((Object)("RolapCube<init>: virtual cube=" + this.name));
            } else {
                this.getLogger().debug((Object)("RolapCube<init>: cube=" + this.name));
            }
        }
        RolapDimension measuresDimension = new RolapDimension((Schema)schema, "Measures", 0, DimensionType.StandardDimension);
        this.dimensions[0] = measuresDimension;
        this.measuresHierarchy = measuresDimension.newHierarchy(null, false);
        if (!Util.isEmpty(xmlSchema.measuresCaption)) {
            measuresDimension.setCaption(xmlSchema.measuresCaption);
            this.measuresHierarchy.setCaption(xmlSchema.measuresCaption);
        }
        for (int i = 0; i < dimensions.length; ++i) {
            MondrianDef.CubeDimension xmlCubeDimension = dimensions[i];
            RolapDimension dimension = this.getOrCreateDimension(xmlCubeDimension, schema, xmlSchema);
            if (this.getLogger().isDebugEnabled()) {
                this.getLogger().debug((Object)("RolapCube<init>: dimension=" + dimension.getName()));
            }
            this.dimensions[i + 1] = dimension;
            if (this.isVirtual()) continue;
            this.createUsages(dimension, xmlCubeDimension);
        }
        schema.addCube(this);
    }

    RolapCube(RolapSchema schema, MondrianDef.Schema xmlSchema, MondrianDef.Cube xmlCube) {
        this(schema, xmlSchema, xmlCube.name, xmlCube.cache, xmlCube.fact, xmlCube.dimensions);
        if (this.fact.getAlias() == null) {
            throw Util.newError("Must specify alias for fact table of cube " + this.getUniqueName());
        }
        RolapLevel measuresLevel = this.measuresHierarchy.newLevel("MeasuresLevel", 0);
        RolapMember[] measures = new RolapStoredMeasure[xmlCube.measures.length];
        for (int i = 0; i < xmlCube.measures.length; ++i) {
            Boolean visible;
            MondrianDef.Measure xmlMeasure = xmlCube.measures[i];
            MondrianDef.Column column = new MondrianDef.Column(this.fact.getAlias(), xmlMeasure.column);
            RolapStoredMeasure measure = new RolapStoredMeasure(this, null, measuresLevel, xmlMeasure.name, xmlMeasure.formatString, column, xmlMeasure.aggregator, xmlMeasure.datatype);
            measures[i] = measure;
            if (!Util.isEmpty(xmlMeasure.formatter)) {
                try {
                    Class<?> clazz = Class.forName(xmlMeasure.formatter);
                    Constructor<?> ctor = clazz.getConstructor(new Class[0]);
                    CellFormatter cellFormatter = (CellFormatter)ctor.newInstance(new Object[0]);
                    measure.setFormatter(cellFormatter);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
            if (!Util.isEmpty(xmlMeasure.caption)) {
                measure.setProperty(Property.CAPTION.name, xmlMeasure.caption);
            }
            if ((visible = xmlMeasure.visible) == null) {
                visible = Boolean.TRUE;
            }
            measure.setProperty(Property.VISIBLE.name, visible);
            ArrayList propNames = new ArrayList();
            ArrayList propExprs = new ArrayList();
            this.validateMemberProps(xmlMeasure.memberProperties, propNames, propExprs, xmlMeasure.name);
            for (int j = 0; j < propNames.size(); ++j) {
                String propName = (String)propNames.get(j);
                Object propExpr = propExprs.get(j);
                measure.setProperty(propName, propExpr);
            }
        }
        this.measuresHierarchy.memberReader = new CacheMemberReader(new MeasureMemberSource(this.measuresHierarchy, measures));
        this.init(xmlCube.dimensions);
        this.init(xmlCube);
        this.loadAggGroup(xmlCube);
    }

    RolapCube(RolapSchema schema, MondrianDef.Schema xmlSchema, MondrianDef.VirtualCube xmlVirtualCube) {
        this(schema, xmlSchema, xmlVirtualCube.name, true, null, xmlVirtualCube.dimensions);
        this.measuresHierarchy.newLevel("MeasuresLevel", 0);
        ArrayList<MondrianDef.CalculatedMember> calculatedMemberList = new ArrayList<MondrianDef.CalculatedMember>();
        ArrayList<Member> measureList = new ArrayList<Member>();
        for (int i = 0; i < xmlVirtualCube.measures.length; ++i) {
            MondrianDef.VirtualCubeMeasure xmlMeasure = xmlVirtualCube.measures[i];
            RolapCube cube = (RolapCube)schema.lookupCube(xmlMeasure.cubeName);
            Member[] cubeMeasures = cube.getMeasures();
            boolean found = false;
            for (int j = 0; j < cubeMeasures.length; ++j) {
                if (!cubeMeasures[j].getUniqueName().equals(xmlMeasure.name)) continue;
                found = true;
                if (cubeMeasures[j] instanceof RolapCalculatedMember) {
                    MondrianDef.CalculatedMember calcMember = schema.lookupXmlCalculatedMember(xmlMeasure.name, xmlMeasure.cubeName);
                    if (calcMember == null) {
                        throw Util.newInternal("Could not find XML Calculated Member '" + xmlMeasure.name + "' in XML cube '" + xmlMeasure.cubeName + "'");
                    }
                    calculatedMemberList.add(calcMember);
                    break;
                }
                measureList.add(cubeMeasures[j]);
                break;
            }
            if (found) continue;
            throw Util.newInternal("could not find measure '" + xmlMeasure.name + "' in cube '" + xmlMeasure.cubeName + "'");
        }
        RolapMember[] measures = measureList.size() > 0 ? measureList.toArray(new RolapMeasure[measureList.size()]) : new RolapMeasure[]{};
        this.measuresHierarchy.memberReader = new CacheMemberReader(new MeasureMemberSource(this.measuresHierarchy, measures));
        this.init(xmlVirtualCube.dimensions);
        calculatedMemberList.addAll(Arrays.asList(xmlVirtualCube.calculatedMembers));
        if (calculatedMemberList.size() > 0) {
            this.createCalcMembersAndNamedSets(calculatedMemberList.toArray(new MondrianDef.CalculatedMember[calculatedMemberList.size()]), new MondrianDef.NamedSet[0], new ArrayList(), new ArrayList());
        }
    }

    protected Logger getLogger() {
        return LOGGER;
    }

    public boolean hasAggGroup() {
        return this.aggGroup != null;
    }

    public ExplicitRules.Group getAggGroup() {
        return this.aggGroup;
    }

    void loadAggGroup(MondrianDef.Cube xmlCube) {
        this.aggGroup = ExplicitRules.Group.make(this, xmlCube);
    }

    private RolapDimension getOrCreateDimension(MondrianDef.CubeDimension xmlCubeDimension, RolapSchema schema, MondrianDef.Schema xmlSchema) {
        if (xmlCubeDimension instanceof MondrianDef.DimensionUsage) {
            MondrianDef.DimensionUsage usage = (MondrianDef.DimensionUsage)xmlCubeDimension;
            RolapHierarchy sharedHierarchy = schema.getSharedHierarchy(usage.source);
            if (sharedHierarchy != null) {
                return (RolapDimension)sharedHierarchy.getDimension();
            }
        }
        MondrianDef.Dimension xmlDimension = xmlCubeDimension.getDimension(xmlSchema);
        return new RolapDimension(schema, this, xmlDimension, xmlCubeDimension);
    }

    private void init(MondrianDef.Cube xmlCube) {
        ArrayList memberList = new ArrayList();
        ArrayList formulaList = new ArrayList();
        this.createCalcMembersAndNamedSets(xmlCube.calculatedMembers, xmlCube.namedSets, memberList, formulaList);
    }

    private void createCalcMembersAndNamedSets(MondrianDef.CalculatedMember[] xmlCalcMembers, MondrianDef.NamedSet[] xmlNamedSets, List memberList, List formulaList) {
        int i;
        Query queryExp;
        int i2;
        if (xmlCalcMembers.length == 0 && xmlNamedSets.length == 0) {
            return;
        }
        StringBuffer buf = new StringBuffer(256);
        buf.append("WITH").append(Util.nl);
        for (int i3 = 0; i3 < xmlCalcMembers.length; ++i3) {
            this.preCalcMember(xmlCalcMembers, i3, buf);
        }
        HashSet<String> nameSet = new HashSet<String>();
        for (i2 = 0; i2 < this.namedSets.length; ++i2) {
            Formula namedSet = this.namedSets[i2];
            nameSet.add(namedSet.getName());
        }
        for (i2 = 0; i2 < xmlNamedSets.length; ++i2) {
            this.preNamedSet(xmlNamedSets[i2], nameSet, buf);
        }
        buf.append("SELECT FROM ").append(Util.quoteMdxIdentifier(this.getUniqueName()));
        String queryString = buf.toString();
        try {
            RolapConnection conn = this.schema.getInternalConnection();
            queryExp = conn.parseQuery(queryString);
        }
        catch (Exception e) {
            throw MondrianResource.instance().UnknownNamedSetHasBadFormula.ex(this.getUniqueName(), e);
        }
        queryExp.resolve();
        Util.assertTrue(queryExp.formulas.length == xmlCalcMembers.length + xmlNamedSets.length);
        for (i = 0; i < xmlCalcMembers.length; ++i) {
            this.postCalcMember(xmlCalcMembers, i, queryExp, memberList);
        }
        for (i = 0; i < xmlNamedSets.length; ++i) {
            this.postNamedSet(xmlNamedSets, xmlCalcMembers.length, i, queryExp, formulaList);
        }
    }

    private void postNamedSet(MondrianDef.NamedSet[] xmlNamedSets, int offset, int i, Query queryExp, List formulaList) {
        MondrianDef.NamedSet xmlNamedSet = xmlNamedSets[i];
        Util.discard((Object)((Object)xmlNamedSet));
        Formula formula = queryExp.formulas[offset + i];
        this.namedSets = (Formula[])RolapUtil.addElement(this.namedSets, formula);
        formulaList.add(formula);
    }

    private void preNamedSet(MondrianDef.NamedSet xmlNamedSet, Set nameSet, StringBuffer buf) {
        if (!nameSet.add(xmlNamedSet.name)) {
            throw MondrianResource.instance().NamedSetNotUnique.ex(xmlNamedSet.name, this.getUniqueName());
        }
        buf.append("SET ").append(Util.makeFqName(xmlNamedSet.name)).append(Util.nl).append(" AS '").append(xmlNamedSet.getFormula()).append("'").append(Util.nl);
    }

    private void postCalcMember(MondrianDef.CalculatedMember[] xmlCalcMembers, int i, Query queryExp, List memberList) {
        MondrianDef.CalculatedMember xmlCalcMember = xmlCalcMembers[i];
        Formula formula = queryExp.formulas[i];
        this.calculatedMembers = (Formula[])RolapUtil.addElement(this.calculatedMembers, formula);
        Member member = formula.getMdxMember();
        Boolean visible = xmlCalcMember.visible;
        if (visible == null) {
            visible = Boolean.TRUE;
        }
        member.setProperty(Property.VISIBLE.name, visible);
        if (xmlCalcMember.caption != null && xmlCalcMember.caption.length() > 0) {
            member.setProperty(Property.CAPTION.name, xmlCalcMember.caption);
        }
        memberList.add(formula.getMdxMember());
    }

    private void preCalcMember(MondrianDef.CalculatedMember[] xmlCalcMembers, int j, StringBuffer buf) {
        MondrianDef.CalculatedMember xmlCalcMember = xmlCalcMembers[j];
        Dimension dimension = (Dimension)this.lookupDimension(xmlCalcMember.dimension);
        if (dimension == null) {
            throw MondrianResource.instance().CalcMemberHasBadDimension.ex(xmlCalcMember.dimension, xmlCalcMember.name, this.getUniqueName());
        }
        for (int i = 0; i < this.calculatedMembers.length; ++i) {
            Formula formula = this.calculatedMembers[i];
            if (!formula.getName().equals(xmlCalcMember.name) || formula.getMdxMember().getDimension().getName() != dimension.getName()) continue;
            throw MondrianResource.instance().CalcMemberNotUnique.ex(Util.makeFqName(dimension, xmlCalcMember.name), this.getUniqueName());
        }
        for (int k = 0; k < j; ++k) {
            MondrianDef.CalculatedMember xmlCalcMember2 = xmlCalcMembers[k];
            if (!xmlCalcMember2.name.equals(xmlCalcMember.name) || !xmlCalcMember2.dimension.equals(xmlCalcMember.dimension)) continue;
            throw MondrianResource.instance().CalcMemberNotUnique.ex(Util.makeFqName(dimension, xmlCalcMember.name), this.getUniqueName());
        }
        String memberUniqueName = Util.makeFqName(dimension.getUniqueName(), xmlCalcMember.name);
        MondrianDef.CalculatedMemberProperty[] xmlProperties = xmlCalcMember.memberProperties;
        ArrayList propNames = new ArrayList();
        ArrayList propExprs = new ArrayList();
        this.validateMemberProps(xmlProperties, propNames, propExprs, xmlCalcMember.name);
        if (!$assertionsDisabled && !memberUniqueName.startsWith("[")) {
            throw new AssertionError();
        }
        buf.append("MEMBER ").append(memberUniqueName).append(Util.nl).append("  AS ").append(xmlCalcMember.getFormula());
        if (!$assertionsDisabled && propNames.size() != propExprs.size()) {
            throw new AssertionError();
        }
        for (int i = 0; i < propNames.size(); ++i) {
            String name = (String)propNames.get(i);
            String expr = (String)propExprs.get(i);
            buf.append(",").append(Util.nl).append(name).append(" = ").append(expr);
        }
        buf.append(Util.nl);
    }

    private void validateMemberProps(MondrianDef.CalculatedMemberProperty[] xmlProperties, List propNames, List propExprs, String memberName) {
        MemberProperty[] properties = new MemberProperty[xmlProperties.length];
        for (int i = 0; i < properties.length; ++i) {
            MondrianDef.CalculatedMemberProperty xmlProperty = xmlProperties[i];
            if (xmlProperty.expression == null && xmlProperty.value == null) {
                throw MondrianResource.instance().NeitherExprNorValueForCalcMemberProperty.ex(xmlProperty.name, memberName, this.getUniqueName());
            }
            if (xmlProperty.expression != null && xmlProperty.value != null) {
                throw MondrianResource.instance().ExprAndValueForMemberProperty.ex(xmlProperty.name, memberName, this.getUniqueName());
            }
            propNames.add(xmlProperty.name);
            if (xmlProperty.expression != null) {
                propExprs.add(xmlProperty.expression);
                continue;
            }
            propExprs.add(Util.quoteForMdx(xmlProperty.value));
        }
    }

    public Schema getSchema() {
        return this.schema;
    }

    public synchronized SchemaReader getSchemaReader() {
        if (this.schemaReader == null) {
            this.schemaReader = this.getSchemaReader(null);
        }
        return this.schemaReader;
    }

    public SchemaReader getSchemaReader(Role role) {
        if (role == null) {
            role = this.schema.getDefaultRole().makeMutableClone();
            role.grant(this, 4);
        }
        return new RolapCubeSchemaReader(role);
    }

    MondrianDef.CubeDimension lookup(MondrianDef.CubeDimension[] xmlDimensions, String name) {
        for (int i = 0; i < xmlDimensions.length; ++i) {
            MondrianDef.CubeDimension cd = xmlDimensions[i];
            if (!name.equals(cd.name)) continue;
            return cd;
        }
        return null;
    }

    private void init(MondrianDef.CubeDimension[] xmlDimensions) {
        RolapDimension dimension;
        int i;
        int max = -1;
        for (i = 0; i < this.dimensions.length; ++i) {
            dimension = (RolapDimension)this.dimensions[i];
            dimension.init(this, this.lookup(xmlDimensions, dimension.getName()));
            max = Math.max(max, dimension.getGlobalOrdinal());
        }
        this.localDimensionOrdinals = new int[max + 1];
        Arrays.fill(this.localDimensionOrdinals, -1);
        i = 0;
        while (i < this.dimensions.length) {
            dimension = (RolapDimension)this.dimensions[i];
            int globalOrdinal = dimension.getGlobalOrdinal();
            this.localDimensionOrdinals[globalOrdinal] = i++;
        }
        this.register();
    }

    private void register() {
        if (this.isVirtual()) {
            return;
        }
        ArrayList<Member> list = new ArrayList<Member>();
        Member[] measures = this.getMeasures();
        for (int i = 0; i < measures.length; ++i) {
            if (!(measures[i] instanceof RolapStoredMeasure)) continue;
            list.add(measures[i]);
        }
        RolapStoredMeasure[] storedMeasures = list.toArray(new RolapStoredMeasure[list.size()]);
        RolapStar star = this.getStar();
        RolapStar.Table table = star.getFactTable();
        for (int i = 0; i < storedMeasures.length; ++i) {
            RolapStoredMeasure storedMeasure = storedMeasures[i];
            table.makeMeasure(storedMeasure);
        }
        Dimension[] dimensions = this.getDimensions();
        for (int j = 0; j < dimensions.length; ++j) {
            this.registerDimension(dimensions[j]);
        }
    }

    int getOrdinal(int globalOrdinal) {
        return this.localDimensionOrdinals[globalOrdinal];
    }

    CellReader getCellReader() {
        return this.cellReader;
    }

    public boolean isCache() {
        return this.isVirtual() ? true : this.star.isCacheAggregations();
    }

    public void setCache(boolean cache) {
        if (!this.isVirtual()) {
            this.star.setCacheAggregations(cache);
        }
    }

    public void clearCache() {
        if (this.isVirtual()) {
            this.schema.flushRolapStarCaches();
        } else {
            this.star.clearCache();
        }
    }

    public RolapStar getStar() {
        return this.star;
    }

    private void createUsages(RolapDimension dimension, MondrianDef.CubeDimension xmlCubeDimension) {
        RolapHierarchy[] hierarchies = (RolapHierarchy[])dimension.getHierarchies();
        if (hierarchies.length == 1) {
            this.createUsage(hierarchies[0], xmlCubeDimension);
        } else if (xmlCubeDimension instanceof MondrianDef.DimensionUsage && ((MondrianDef.DimensionUsage)xmlCubeDimension).level != null) {
            MondrianDef.DimensionUsage du = (MondrianDef.DimensionUsage)xmlCubeDimension;
            int cnt = 0;
            for (int j = 0; j < hierarchies.length; ++j) {
                RolapLevel joinLevel;
                RolapHierarchy hierarchy = hierarchies[j];
                if (this.getLogger().isDebugEnabled()) {
                    this.getLogger().debug((Object)("RolapCube<init>: hierarchy=" + hierarchy.getName()));
                }
                if ((joinLevel = (RolapLevel)Util.lookupHierarchyLevel(hierarchy, du.level)) == null) continue;
                this.createUsage(hierarchy, xmlCubeDimension);
                ++cnt;
            }
            if (cnt == 0) {
                this.createUsage(hierarchies[0], xmlCubeDimension);
            }
        } else {
            for (int j = 0; j < hierarchies.length; ++j) {
                RolapHierarchy hierarchy = hierarchies[j];
                if (this.getLogger().isDebugEnabled()) {
                    this.getLogger().debug((Object)("RolapCube<init>: hierarchy=" + hierarchy.getName()));
                }
                this.createUsage(hierarchy, xmlCubeDimension);
            }
        }
    }

    synchronized void createUsage(RolapHierarchy hierarchy, MondrianDef.CubeDimension cubeDim) {
        HierarchyUsage usage = new HierarchyUsage(this, hierarchy, cubeDim);
        Iterator it = this.hierarchyUsages.iterator();
        while (it.hasNext()) {
            HierarchyUsage hierUsage = (HierarchyUsage)it.next();
            if (!hierUsage.equals(usage)) continue;
            this.getLogger().warn((Object)("RolapCube.createUsage: duplicate " + hierUsage));
            return;
        }
        if (this.getLogger().isDebugEnabled()) {
            this.getLogger().debug((Object)("RolapCube.createUsage: register " + usage));
        }
        this.hierarchyUsages.add(usage);
    }

    private synchronized HierarchyUsage getUsageByName(String name) {
        Iterator it = this.hierarchyUsages.iterator();
        while (it.hasNext()) {
            HierarchyUsage hierUsage = (HierarchyUsage)it.next();
            if (!hierUsage.getFullName().equals(name)) continue;
            return hierUsage;
        }
        return null;
    }

    public synchronized HierarchyUsage[] getUsages(Hierarchy hierarchy) {
        String name = hierarchy.getName();
        if (this.getLogger().isDebugEnabled()) {
            this.getLogger().debug((Object)("RolapCube.getUsages: name=" + name));
        }
        HierarchyUsage hierUsage = null;
        ArrayList<HierarchyUsage> list = null;
        Iterator it = this.hierarchyUsages.iterator();
        while (it.hasNext()) {
            HierarchyUsage hu = (HierarchyUsage)it.next();
            if (!hu.getHierarchyName().equals(name)) continue;
            if (list != null) {
                if (this.getLogger().isDebugEnabled()) {
                    this.getLogger().debug((Object)("RolapCube.getUsages: add list HierarchyUsage.name=" + hu.getName()));
                }
                list.add(hu);
                continue;
            }
            if (hierUsage == null) {
                hierUsage = hu;
                continue;
            }
            list = new ArrayList<HierarchyUsage>();
            if (this.getLogger().isDebugEnabled()) {
                this.getLogger().debug((Object)("RolapCube.getUsages: add list hierUsage.name=" + hierUsage.getName() + ", hu.name=" + hu.getName()));
            }
            list.add(hierUsage);
            list.add(hu);
            hierUsage = null;
        }
        if (hierUsage != null) {
            return new HierarchyUsage[]{hierUsage};
        }
        if (list != null) {
            if (this.getLogger().isDebugEnabled()) {
                this.getLogger().debug((Object)"RolapCube.getUsages: return list");
            }
            return list.toArray(new HierarchyUsage[list.size()]);
        }
        return new HierarchyUsage[0];
    }

    synchronized HierarchyUsage[] getUsagesBySource(String source) {
        if (this.getLogger().isDebugEnabled()) {
            this.getLogger().debug((Object)("RolapCube.getUsagesBySource: source=" + source));
        }
        HierarchyUsage hierUsage = null;
        ArrayList<HierarchyUsage> list = null;
        Iterator it = this.hierarchyUsages.iterator();
        while (it.hasNext()) {
            HierarchyUsage hu = (HierarchyUsage)it.next();
            String s = hu.getSource();
            if (s == null || !s.equals(source)) continue;
            if (list != null) {
                if (this.getLogger().isDebugEnabled()) {
                    this.getLogger().debug((Object)("RolapCube.getUsagesBySource: add list HierarchyUsage.name=" + hu.getName()));
                }
                list.add(hu);
                continue;
            }
            if (hierUsage == null) {
                hierUsage = hu;
                continue;
            }
            list = new ArrayList<HierarchyUsage>();
            if (this.getLogger().isDebugEnabled()) {
                this.getLogger().debug((Object)("RolapCube.getUsagesBySource: add list hierUsage.name=" + hierUsage.getName() + ", hu.name=" + hu.getName()));
            }
            list.add(hierUsage);
            list.add(hu);
            hierUsage = null;
        }
        if (hierUsage != null) {
            return new HierarchyUsage[]{hierUsage};
        }
        if (list != null) {
            if (this.getLogger().isDebugEnabled()) {
                this.getLogger().debug((Object)"RolapCube.getUsagesBySource: return list");
            }
            return list.toArray(new HierarchyUsage[list.size()]);
        }
        return new HierarchyUsage[0];
    }

    void registerDimension(Dimension dimension) {
        RolapStar star = this.getStar();
        Hierarchy[] hierarchies = dimension.getHierarchies();
        for (int k = 0; k < hierarchies.length; ++k) {
            RolapHierarchy hierarchy = (RolapHierarchy)hierarchies[k];
            MondrianDef.Relation relation = hierarchy.getRelation();
            if (relation == null) continue;
            RolapLevel[] levels = (RolapLevel[])hierarchy.getLevels();
            HierarchyUsage[] hierarchyUsages = this.getUsages(hierarchy);
            if (hierarchyUsages.length == 0) {
                if (!this.getLogger().isDebugEnabled()) continue;
                StringBuffer buf = new StringBuffer(64);
                buf.append("RolapCube.registerDimension: ");
                buf.append("hierarchyUsages == null for cube=\"");
                buf.append(this.name);
                buf.append("\", hierarchy=\"");
                buf.append(hierarchy.getName());
                buf.append("\"");
                this.getLogger().debug((Object)buf.toString());
                continue;
            }
            block1: for (int j = 0; j < hierarchyUsages.length; ++j) {
                RolapLevel level;
                int l;
                HierarchyUsage hierarchyUsage = hierarchyUsages[j];
                String usagePrefix = hierarchyUsage.getUsagePrefix();
                RolapStar.Table table = star.getFactTable();
                String levelName = hierarchyUsage.getLevelName();
                if (relation instanceof MondrianDef.Join) {
                    MondrianDef.Relation relationTmp1 = relation;
                    if ((relation = RolapCube.reorder(relation, levels)) == null && this.getLogger().isDebugEnabled()) {
                        this.getLogger().debug((Object)"RolapCube.registerDimension: after reorder relation==null");
                        this.getLogger().debug((Object)("RolapCube.registerDimension: reorder relationTmp1=" + RolapCube.format(relationTmp1)));
                    }
                }
                MondrianDef.Relation relationTmp2 = relation;
                if (levelName != null) {
                    String tableName;
                    RolapLevel childLevel;
                    RolapLevel level2 = RolapLevel.lookupLevel(levels, levelName);
                    if (level2 == null) {
                        StringBuffer buf = new StringBuffer(64);
                        buf.append("For cube \"");
                        buf.append(this.getName());
                        buf.append("\" and HierarchyUsage [");
                        buf.append(hierarchyUsage);
                        buf.append("], there is no level with given");
                        buf.append(" level name \"");
                        buf.append(levelName);
                        buf.append("\"");
                        throw Util.newInternal(buf.toString());
                    }
                    if (relation instanceof MondrianDef.Join && (childLevel = (RolapLevel)level2.getChildLevel()) != null && (tableName = childLevel.getTableName()) != null && (relation = RolapCube.snip(relation, tableName)) == null && this.getLogger().isDebugEnabled()) {
                        this.getLogger().debug((Object)"RolapCube.registerDimension: after snip relation==null");
                        this.getLogger().debug((Object)("RolapCube.registerDimension: snip relationTmp2=" + RolapCube.format(relationTmp2)));
                    }
                }
                if (!relation.equals((Object)table.getRelation())) {
                    if (hierarchyUsage.getForeignKey() == null) {
                        throw MondrianResource.instance().HierarchyMustHaveForeignKey.ex(hierarchy.getName(), this.getName());
                    }
                    MondrianDef.Column column = new MondrianDef.Column(table.getAlias(), hierarchyUsage.getForeignKey());
                    RolapStar.Condition joinCondition = new RolapStar.Condition(column, hierarchyUsage.getJoinExp());
                    table = table.addJoin(relation, joinCondition);
                }
                RolapStar.Column parentColumn = null;
                if (levelName != null) {
                    for (l = 0; l < levels.length; ++l) {
                        level = levels[l];
                        if (level.getKeyExp() != null) {
                            parentColumn = this.makeColumns(table, level, parentColumn, usagePrefix);
                        }
                        if (levelName.equals(level.getName())) continue block1;
                    }
                    continue;
                }
                for (l = 0; l < levels.length; ++l) {
                    level = levels[l];
                    if (level.getKeyExp() == null) continue;
                    parentColumn = this.makeColumns(table, level, parentColumn, usagePrefix);
                }
            }
        }
    }

    protected RolapStar.Column makeColumns(RolapStar.Table table, RolapLevel level, RolapStar.Column parentColumn, String usagePrefix) {
        String tableName = level.getTableName();
        if (tableName != null) {
            if (table.getAlias().equals(tableName)) {
                parentColumn = table.makeColumns(this, level, parentColumn, usagePrefix);
            } else if (table.equalsTableName(tableName)) {
                parentColumn = table.makeColumns(this, level, parentColumn, usagePrefix);
            } else {
                RolapStar.Table t = table.findAncestor(tableName);
                if (t != null) {
                    parentColumn = t.makeColumns(this, level, parentColumn, usagePrefix);
                } else {
                    StringBuffer buf = new StringBuffer(64);
                    buf.append("RolapCube.makeColumns: for cube \"");
                    buf.append(this.getName());
                    buf.append("\" the Level \"");
                    buf.append(level.getName());
                    buf.append("\" has a table name attribute \"");
                    buf.append(tableName);
                    buf.append("\" but the associated RolapStar does not");
                    buf.append(" have a table with that name.");
                    this.getLogger().warn((Object)buf.toString());
                    parentColumn = table.makeColumns(this, level, parentColumn, usagePrefix);
                }
            }
        } else {
            parentColumn = table.makeColumns(this, level, parentColumn, usagePrefix);
        }
        return parentColumn;
    }

    private static String format(MondrianDef.Relation relation) {
        StringBuffer buf = new StringBuffer();
        RolapCube.format(relation, buf, "");
        return buf.toString();
    }

    private static void format(MondrianDef.Relation relation, StringBuffer buf, String indent) {
        if (relation instanceof MondrianDef.Table) {
            MondrianDef.Table table = (MondrianDef.Table)relation;
            buf.append(indent);
            buf.append(table.name);
            if (table.alias != null) {
                buf.append('(');
                buf.append(table.alias);
                buf.append(')');
            }
            buf.append(Util.nl);
        } else {
            MondrianDef.Join join = (MondrianDef.Join)relation;
            String subindent = indent + "  ";
            buf.append(indent);
            buf.append(join.getLeftAlias());
            buf.append('.');
            buf.append(join.leftKey);
            buf.append('=');
            buf.append(join.getRightAlias());
            buf.append('.');
            buf.append(join.rightKey);
            buf.append(Util.nl);
            RolapCube.format(join.left, buf, subindent);
            RolapCube.format(join.right, buf, indent);
        }
    }

    private static MondrianDef.Relation reorder(MondrianDef.Relation relation, RolapLevel[] levels) {
        if (levels.length < 2) {
            return relation;
        }
        HashMap<String, RelNode> nodeMap = new HashMap<String, RelNode>();
        for (int i = 0; i < levels.length; ++i) {
            RolapLevel level = levels[i];
            if (level.isAll()) continue;
            String tableName = level.getTableName();
            if (tableName == null) {
                return relation;
            }
            RelNode rnode = new RelNode(tableName, i);
            nodeMap.put(tableName, rnode);
        }
        if (!RolapCube.validateNodes(relation, nodeMap)) {
            return relation;
        }
        relation = RolapCube.copy(relation);
        RolapCube.leftToRight(relation, nodeMap);
        RolapCube.topToBottom(relation);
        return relation;
    }

    private static boolean validateNodes(MondrianDef.Relation relation, Map map) {
        if (relation instanceof MondrianDef.Table) {
            MondrianDef.Table table = (MondrianDef.Table)relation;
            RelNode relNode = RelNode.lookup(table, map);
            return relNode != null;
        }
        if (relation instanceof MondrianDef.Join) {
            MondrianDef.Join join = (MondrianDef.Join)relation;
            return RolapCube.validateNodes(join.left, map) && RolapCube.validateNodes(join.right, map);
        }
        throw Util.newInternal("bad relation type " + (Object)((Object)relation));
    }

    private static int leftToRight(MondrianDef.Relation relation, Map map) {
        if (relation instanceof MondrianDef.Table) {
            MondrianDef.Table table = (MondrianDef.Table)relation;
            RelNode relNode = RelNode.lookup(table, map);
            relNode.table = table;
            return relNode.depth;
        }
        if (relation instanceof MondrianDef.Join) {
            MondrianDef.Join join = (MondrianDef.Join)relation;
            int leftDepth = RolapCube.leftToRight(join.left, map);
            int rightDepth = RolapCube.leftToRight(join.right, map);
            if (rightDepth > leftDepth) {
                String leftAlias = join.leftAlias;
                String leftKey = join.leftKey;
                MondrianDef.Relation left = join.left;
                join.leftAlias = join.rightAlias;
                join.leftKey = join.rightKey;
                join.left = join.right;
                join.rightAlias = leftAlias;
                join.rightKey = leftKey;
                join.right = left;
            }
            return leftDepth;
        }
        throw Util.newInternal("bad relation type " + (Object)((Object)relation));
    }

    private static void topToBottom(MondrianDef.Relation relation) {
        if (relation instanceof MondrianDef.Table) {
            MondrianDef.Table table = (MondrianDef.Table)relation;
        } else if (relation instanceof MondrianDef.Join) {
            MondrianDef.Join join = (MondrianDef.Join)relation;
            while (join.left instanceof MondrianDef.Join) {
                MondrianDef.Join jleft = (MondrianDef.Join)join.left;
                MondrianDef.Relation right = join.right;
                join.right = new MondrianDef.Join(join.leftAlias, join.leftKey, jleft.right, join.rightAlias, join.rightKey, join.right);
                join.left = jleft.left;
                join.rightAlias = jleft.rightAlias;
                join.rightKey = jleft.rightKey;
                join.leftAlias = jleft.leftAlias;
                join.leftKey = jleft.leftKey;
            }
        }
    }

    private static MondrianDef.Relation copy(MondrianDef.Relation relation) {
        if (relation instanceof MondrianDef.Table) {
            MondrianDef.Table table = (MondrianDef.Table)relation;
            return new MondrianDef.Table(table);
        }
        if (relation instanceof MondrianDef.Join) {
            MondrianDef.Join join = (MondrianDef.Join)relation;
            MondrianDef.Relation left = RolapCube.copy(join.left);
            MondrianDef.Relation right = RolapCube.copy(join.right);
            return new MondrianDef.Join(join.leftAlias, join.leftKey, left, join.rightAlias, join.rightKey, right);
        }
        throw Util.newInternal("bad relation type " + (Object)((Object)relation));
    }

    private static MondrianDef.Relation snip(MondrianDef.Relation relation, String tableName) {
        if (relation instanceof MondrianDef.Table) {
            MondrianDef.Table table = (MondrianDef.Table)relation;
            return table.alias != null && table.alias.equals(tableName) ? null : (table.name.equals(tableName) ? null : table);
        }
        if (relation instanceof MondrianDef.Join) {
            MondrianDef.Join join = (MondrianDef.Join)relation;
            MondrianDef.Relation left = RolapCube.snip(join.left, tableName);
            if (left == null) {
                return join.right;
            }
            join.left = left;
            MondrianDef.Relation right = RolapCube.snip(join.right, tableName);
            if (right == null) {
                return join.left;
            }
            join.right = right;
            return join;
        }
        throw Util.newInternal("bad relation type " + (Object)((Object)relation));
    }

    public Member[] getMembersForQuery(String query, List calcMembers) {
        throw new UnsupportedOperationException();
    }

    Member[] getMeasures() {
        Level measuresLevel = this.dimensions[0].getHierarchies()[0].getLevels()[0];
        return this.getSchemaReader().getLevelMembers(measuresLevel);
    }

    MondrianDef.Relation getFact() {
        return this.fact;
    }

    public boolean isVirtual() {
        return this.fact == null;
    }

    /*
     * WARNING - void declaration
     */
    RolapDimension createDimension(MondrianDef.CubeDimension xmlCubeDimension) {
        void var3_3;
        RolapDimension dimension;
        MondrianDef.Dimension xmlDimension = null;
        if (xmlCubeDimension instanceof MondrianDef.Dimension) {
            xmlDimension = (MondrianDef.Dimension)xmlCubeDimension;
            dimension = new RolapDimension(this.schema, this, xmlDimension, xmlCubeDimension);
        } else if (xmlCubeDimension instanceof MondrianDef.DimensionUsage) {
            MondrianDef.DimensionUsage usage = (MondrianDef.DimensionUsage)xmlCubeDimension;
            RolapHierarchy sharedHierarchy = this.schema.getSharedHierarchy(usage.source);
            if (sharedHierarchy == null) {
                throw Util.newInternal("todo: Shared hierarchy '" + usage.source + "' not found");
            }
            RolapDimension sharedDimension = (RolapDimension)sharedHierarchy.getDimension();
            dimension = sharedDimension.copy(this, usage.name, xmlCubeDimension);
        } else {
            throw Util.newInternal("Unexpected subtype, " + (Object)((Object)xmlCubeDimension));
        }
        var3_3.init(this, xmlCubeDimension);
        int localOrdinal = this.dimensions.length;
        this.dimensions = (DimensionBase[])RolapUtil.addElement(this.dimensions, var3_3);
        RolapHierarchy hierarchy = (RolapHierarchy)var3_3.getHierarchy();
        this.createUsage(hierarchy, xmlCubeDimension);
        int globalOrdinal = var3_3.getGlobalOrdinal();
        if (globalOrdinal >= this.localDimensionOrdinals.length) {
            int[] newLocalDimensionOrdinals = new int[globalOrdinal + 1];
            System.arraycopy(this.localDimensionOrdinals, 0, newLocalDimensionOrdinals, 0, this.localDimensionOrdinals.length);
            Arrays.fill(newLocalDimensionOrdinals, this.localDimensionOrdinals.length, newLocalDimensionOrdinals.length, -1);
            this.localDimensionOrdinals = newLocalDimensionOrdinals;
        }
        Util.assertTrue(this.localDimensionOrdinals[globalOrdinal] == -1);
        this.localDimensionOrdinals[globalOrdinal] = localOrdinal;
        this.registerDimension((Dimension)var3_3);
        return var3_3;
    }

    public OlapElement lookupChild(SchemaReader schemaReader, String s) {
        OlapElement oe = null;
        String status = null;
        if (s.equals("Measures")) {
            oe = super.lookupChild(schemaReader, s);
        } else {
            HierarchyUsage hierUsage = this.getUsageByName(s);
            if (hierUsage == null) {
                HierarchyUsage[] usages;
                oe = super.lookupChild(schemaReader, s);
                status = "hierUsage == null";
                if (oe instanceof RolapDimension && (usages = this.getUsagesBySource(s)).length > 0) {
                    StringBuffer buf = new StringBuffer(64);
                    buf.append("RolapCube.lookupChild: ");
                    buf.append("In cube \"");
                    buf.append(this.getName());
                    buf.append("\" use of unaliased Dimension name \"");
                    buf.append(s);
                    if (usages.length == 1) {
                        buf.append("\" rather than the alias name ");
                        buf.append("\"");
                        buf.append(usages[0].getName());
                        buf.append("\" ");
                        this.getLogger().error((Object)buf.toString());
                        throw new MondrianException(buf.toString());
                    }
                    buf.append("\" rather than one of the alias names ");
                    for (int i = 0; i < usages.length; ++i) {
                        buf.append("\"");
                        buf.append(usages[i].getName());
                        buf.append("\" ");
                    }
                    this.getLogger().error((Object)buf.toString());
                    throw new MondrianException(buf.toString());
                }
            } else if (hierUsage.isShared()) {
                status = "hierUsage == shared";
                String source = hierUsage.getSource();
                oe = super.lookupChild(schemaReader, source);
            } else {
                status = "hierUsage == not shared";
                oe = super.lookupChild(schemaReader, s);
            }
        }
        if (this.getLogger().isDebugEnabled()) {
            StringBuffer buf = new StringBuffer(64);
            buf.append("RolapCube.lookupChild: ");
            buf.append("name=");
            buf.append(this.getName());
            buf.append(", childname=");
            buf.append(s);
            if (status != null) {
                buf.append(", status=");
                buf.append(status);
            }
            if (oe == null) {
                buf.append(" returning null");
            } else {
                buf.append(" returning elementname=" + oe.getName());
            }
            this.getLogger().debug((Object)buf.toString());
        }
        return oe;
    }

    public Hierarchy getMeasuresHierarchy() {
        return this.measuresHierarchy;
    }

    public Member createCalculatedMember(String xml) {
        MondrianDef.CalculatedMember xmlCalcMember;
        try {
            Parser xmlParser = XOMUtil.createDefaultParser();
            DOMWrapper def = xmlParser.parse(xml);
            String tagName = def.getTagName();
            if (!tagName.equals("CalculatedMember")) {
                throw new XOMException("Got <" + tagName + "> when expecting <CalculatedMember>");
            }
            xmlCalcMember = new MondrianDef.CalculatedMember(def);
        }
        catch (XOMException e) {
            throw Util.newError(e, "Error while creating calculated member from XML [" + xml + "]");
        }
        ArrayList memberList = new ArrayList();
        this.createCalcMembersAndNamedSets(new MondrianDef.CalculatedMember[]{xmlCalcMember}, new MondrianDef.NamedSet[0], memberList, new ArrayList());
        if (!$assertionsDisabled && memberList.size() != 1) {
            throw new AssertionError();
        }
        return (Member)memberList.get(0);
    }

    static {
        $assertionsDisabled = !RolapCube.class.desiredAssertionStatus();
        LOGGER = Logger.getLogger((Class)RolapCube.class);
    }

    private class RolapCubeSchemaReader
    extends RolapSchemaReader {
        static final /* synthetic */ boolean $assertionsDisabled;

        public RolapCubeSchemaReader(Role role) {
            super(role, RolapCube.this.schema);
            if (!$assertionsDisabled && role == null) {
                throw new AssertionError((Object)"precondition: role != null");
            }
        }

        public Member[] getLevelMembers(Level level) {
            Object[] members = super.getLevelMembers(level);
            List calcMembers = this.getCalculatedMembers(level.getHierarchy());
            for (int i = 0; i < calcMembers.size(); ++i) {
                Member member = (Member)calcMembers.get(i);
                if (!member.getLevel().equals(level)) continue;
                members = (Member[])RolapUtil.addElement(members, member);
            }
            return members;
        }

        public Member getCalculatedMember(String[] nameParts) {
            String uniqueName = Util.implode(nameParts);
            for (int i = 0; i < RolapCube.this.calculatedMembers.length; ++i) {
                Formula formula = RolapCube.this.calculatedMembers[i];
                String formulaUniqueName = formula.getMdxMember().getUniqueName();
                if (!formulaUniqueName.equals(uniqueName) || !this.getRole().canAccess(formula.getMdxMember())) continue;
                return formula.getMdxMember();
            }
            return null;
        }

        public NamedSet getNamedSet(String[] nameParts) {
            if (nameParts.length == 1) {
                String name = nameParts[0];
                for (int i = 0; i < RolapCube.this.namedSets.length; ++i) {
                    Formula namedSet = RolapCube.this.namedSets[i];
                    if (!namedSet.getName().equals(name)) continue;
                    return namedSet.getNamedSet();
                }
            }
            return super.getNamedSet(nameParts);
        }

        public List getCalculatedMembers(Hierarchy hierarchy) {
            ArrayList<Member> list = new ArrayList<Member>();
            if (this.getRole().getAccess(hierarchy) == 1) {
                return list;
            }
            for (int i = 0; i < RolapCube.this.calculatedMembers.length; ++i) {
                Formula formula = RolapCube.this.calculatedMembers[i];
                Member member = formula.getMdxMember();
                if (!member.getHierarchy().equals(hierarchy) || !this.getRole().canAccess(member)) continue;
                list.add(member);
            }
            return list;
        }

        public List getCalculatedMembers(Level level) {
            ArrayList<Member> list = new ArrayList<Member>();
            if (this.getRole().getAccess(level) == 1) {
                return list;
            }
            List hierarchyList = this.getCalculatedMembers(level.getHierarchy());
            Iterator it = hierarchyList.iterator();
            while (it.hasNext()) {
                Member member = (Member)it.next();
                if (!member.getLevel().equals(level) || !this.getRole().canAccess(member)) continue;
                list.add(member);
            }
            return list;
        }

        public List getCalculatedMembers() {
            ArrayList<Member> list = new ArrayList<Member>();
            for (int i = 0; i < RolapCube.this.calculatedMembers.length; ++i) {
                Formula formula = RolapCube.this.calculatedMembers[i];
                Member member = formula.getMdxMember();
                if (!this.getRole().canAccess(member)) continue;
                list.add(member);
            }
            return list;
        }

        public Member getMemberByUniqueName(String[] uniqueNameParts, boolean failIfNotFound) {
            Member member = (Member)this.lookupCompound(RolapCube.this, uniqueNameParts, failIfNotFound, 6);
            if (this.getRole().canAccess(member)) {
                return member;
            }
            return null;
        }

        public Cube getCube() {
            return RolapCube.this;
        }

        static {
            $assertionsDisabled = !(class$mondrian$rolap$RolapCube == null ? (class$mondrian$rolap$RolapCube = RolapCube.class$("mondrian.rolap.RolapCube")) : class$mondrian$rolap$RolapCube).desiredAssertionStatus();
        }
    }

    private static class RelNode {
        private int depth;
        private String alias;
        private MondrianDef.Table table;

        private static RelNode lookup(MondrianDef.Table table, Map map) {
            RelNode relNode = (RelNode)map.get(table.name);
            if (relNode == null && table.alias != null) {
                relNode = (RelNode)map.get(table.alias);
            }
            return relNode;
        }

        RelNode(String alias, int depth) {
            this.alias = alias;
            this.depth = depth;
        }
    }
}

