/*
 * Decompiled with CFR 0.152.
 */
package mondrian.rolap.agg;

import java.util.Collection;
import java.util.Iterator;
import java.util.Set;
import mondrian.olap.MondrianProperties;
import mondrian.olap.Util;
import mondrian.rolap.BitKey;
import mondrian.rolap.RolapAggregationManager;
import mondrian.rolap.RolapStar;
import mondrian.rolap.agg.AggQuerySpec;
import mondrian.rolap.agg.Aggregation;
import mondrian.rolap.agg.CellRequest;
import mondrian.rolap.agg.ColumnConstraint;
import mondrian.rolap.agg.DrillThroughQuerySpec;
import mondrian.rolap.agg.Segment;
import mondrian.rolap.agg.SegmentArrayQuerySpec;
import mondrian.rolap.aggmatcher.AggStar;
import org.apache.log4j.Logger;

public class AggregationManager
extends RolapAggregationManager {
    private static final Logger LOGGER = Logger.getLogger((Class)AggregationManager.class);
    private static AggregationManager instance;

    public static synchronized AggregationManager instance() {
        if (instance == null) {
            instance = new AggregationManager();
        }
        return instance;
    }

    AggregationManager() {
    }

    public Logger getLogger() {
        return LOGGER;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void loadAggregation(RolapStar.Measure[] measures, RolapStar.Column[] columns, BitKey bitKey, ColumnConstraint[][] constraintses, Collection pinnedSegments) {
        Aggregation aggregation;
        RolapStar star = measures[0].getStar();
        Aggregation aggregation2 = aggregation = star.lookupOrCreateAggregation(bitKey);
        synchronized (aggregation2) {
            constraintses = aggregation.optimizeConstraints(columns, constraintses);
            aggregation.load(columns, measures, constraintses, pinnedSegments);
        }
    }

    public Object getCellFromCache(CellRequest request) {
        RolapStar.Measure measure = request.getMeasure();
        Aggregation aggregation = measure.getStar().lookupAggregation(request.getBatchKey());
        if (aggregation == null) {
            return null;
        }
        Object o = aggregation.get(measure, request.getSingleValues(), null);
        if (o != null) {
            return o;
        }
        throw Util.newInternal("not found");
    }

    public Object getCellFromCache(CellRequest request, Set pinSet) {
        Util.assertPrecondition(pinSet != null);
        RolapStar.Measure measure = request.getMeasure();
        Aggregation aggregation = measure.getStar().lookupAggregation(request.getBatchKey());
        if (aggregation == null) {
            return null;
        }
        return aggregation.get(measure, request.getSingleValues(), pinSet);
    }

    public String getDrillThroughSQL(CellRequest request) {
        DrillThroughQuerySpec spec = new DrillThroughQuerySpec(request);
        String sql = spec.generateSqlQuery();
        if (this.getLogger().isDebugEnabled()) {
            StringBuffer buf = new StringBuffer(256);
            buf.append("DrillThroughSQL: ");
            buf.append(sql);
            buf.append(Util.nl);
            this.getLogger().debug((Object)buf.toString());
        }
        return sql;
    }

    public String generateSQL(Segment[] segments, BitKey fkBK, BitKey measureBK, boolean isDistinct) {
        RolapStar star;
        if (MondrianProperties.instance().UseAggregates.get()) {
            star = segments[0].aggregation.getStar();
            AggStar aggStar = null;
            if (isDistinct) {
                Iterator it = star.getAggStars();
                while (it.hasNext()) {
                    AggStar as = (AggStar)it.next();
                    if (as.hasForeignKeys() || !as.select(fkBK, measureBK)) continue;
                    aggStar = as;
                    break;
                }
            } else {
                BitKey fullBK = fkBK.or(measureBK);
                aggStar = star.superSetMatch(fullBK);
            }
            if (aggStar != null) {
                if (this.getLogger().isDebugEnabled()) {
                    StringBuffer buf = new StringBuffer(256);
                    buf.append("MATCH: ");
                    buf.append(star.getFactTable().getAlias());
                    buf.append(" isDistinct=");
                    buf.append(isDistinct);
                    buf.append(Util.nl);
                    buf.append("   foreign=");
                    buf.append(fkBK);
                    buf.append(Util.nl);
                    buf.append("   measure=");
                    buf.append(measureBK);
                    buf.append(Util.nl);
                    buf.append("   aggstar=");
                    buf.append(aggStar.getBitKey());
                    buf.append(Util.nl);
                    buf.append("AggStar=");
                    buf.append(aggStar.getFactTable().getName());
                    buf.append(Util.nl);
                    Iterator it = aggStar.getFactTable().getColumns();
                    while (it.hasNext()) {
                        AggStar.Table.Column column = (AggStar.Table.Column)it.next();
                        buf.append("   ");
                        buf.append(column);
                        buf.append(Util.nl);
                    }
                    this.getLogger().debug((Object)buf.toString());
                }
                AggQuerySpec aggQuerySpec = new AggQuerySpec(aggStar, segments, isDistinct);
                String sql = aggQuerySpec.generateSqlQuery();
                return sql;
            }
        }
        if (this.getLogger().isDebugEnabled()) {
            star = segments[0].aggregation.getStar();
            StringBuffer buf = new StringBuffer(256);
            buf.append("NO MATCH: ");
            buf.append(star.getFactTable().getAlias());
            buf.append(" isDistinct=");
            buf.append(isDistinct);
            buf.append(Util.nl);
            buf.append("   foreign=");
            buf.append(fkBK);
            buf.append(Util.nl);
            buf.append("   measure=");
            buf.append(measureBK);
            buf.append(Util.nl);
            this.getLogger().debug((Object)buf.toString());
        }
        SegmentArrayQuerySpec spec = new SegmentArrayQuerySpec(segments, isDistinct);
        String sql = spec.generateSqlQuery();
        return sql;
    }
}

