/*
 * Decompiled with CFR 0.152.
 */
package mondrian.rolap.aggmatcher;

import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import mondrian.olap.Hierarchy;
import mondrian.olap.Member;
import mondrian.olap.MondrianDef;
import mondrian.olap.SchemaReader;
import mondrian.olap.Util;
import mondrian.recorder.MessageRecorder;
import mondrian.resource.MondrianResource;
import mondrian.rolap.RolapCube;
import mondrian.rolap.RolapLevel;
import mondrian.rolap.RolapStar;
import mondrian.rolap.aggmatcher.ExplicitRecognizer;
import mondrian.rolap.aggmatcher.JdbcSchema;
import mondrian.rolap.aggmatcher.Recognizer;
import org.apache.log4j.Logger;

public class ExplicitRules {
    private static final Logger LOGGER = Logger.getLogger((Class)ExplicitRules.class);
    private static final MondrianResource mres = MondrianResource.instance();

    public static boolean excludeTable(String tableName, List aggGroups) {
        Iterator it = aggGroups.iterator();
        while (it.hasNext()) {
            Group group = (Group)it.next();
            if (!group.excludeTable(tableName)) continue;
            return true;
        }
        return false;
    }

    public static TableDef getIncludeByTableDef(String tableName, List aggGroups) {
        Iterator it = aggGroups.iterator();
        while (it.hasNext()) {
            Group group = (Group)it.next();
            TableDef tableDef = group.getIncludeByTableDef(tableName);
            if (tableDef == null) continue;
            return tableDef;
        }
        return null;
    }

    private static Exclude make(MondrianDef.AggExclude aggExclude) {
        return aggExclude.getNameAttribute() != null ? new ExcludeName(aggExclude.getNameAttribute(), aggExclude.isIgnoreCase()) : new ExcludePattern(aggExclude.getPattern(), aggExclude.isIgnoreCase());
    }

    private static void checkAttributeString(MessageRecorder msgRecorder, String attrValue, String attrName) {
        if (attrValue == null) {
            msgRecorder.reportError(ExplicitRules.mres.NullAttributeString.str(msgRecorder.getContext(), attrName));
        } else if (attrValue.length() == 0) {
            msgRecorder.reportError(ExplicitRules.mres.EmptyAttributeString.str(msgRecorder.getContext(), attrName));
        }
    }

    private ExplicitRules() {
    }

    public static class PatternTableDef
    extends TableDef {
        private final Pattern pattern;
        private List excludes;

        static PatternTableDef make(MondrianDef.AggPattern aggPattern, Group group) {
            PatternTableDef pattern = new PatternTableDef(aggPattern.getPattern(), aggPattern.isIgnoreCase(), group);
            MondrianDef.AggExclude[] excludes = aggPattern.getAggExcludes();
            if (excludes != null) {
                for (int i = 0; i < excludes.length; ++i) {
                    Exclude exclude = ExplicitRules.make(excludes[i]);
                    pattern.add(exclude);
                }
            }
            TableDef.add((TableDef)pattern, aggPattern);
            return pattern;
        }

        public PatternTableDef(String pattern, boolean ignoreCase, Group group) {
            super(ignoreCase, group);
            this.pattern = this.ignoreCase ? Pattern.compile(pattern, 2) : Pattern.compile(pattern);
            this.excludes = Collections.EMPTY_LIST;
        }

        public Pattern getPattern() {
            return this.pattern;
        }

        public Iterator getExcludes() {
            return this.excludes.iterator();
        }

        private void add(Exclude exclude) {
            if (this.excludes == Collections.EMPTY_LIST) {
                this.excludes = new ArrayList();
            }
            this.excludes.add(exclude);
        }

        public boolean matches(String tableName) {
            if (!this.pattern.matcher(tableName).matches()) {
                return false;
            }
            Iterator it = this.getExcludes();
            while (it.hasNext()) {
                Exclude exclude = (Exclude)it.next();
                if (!exclude.isExcluded(tableName)) continue;
                return false;
            }
            return true;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void validate(MessageRecorder msgRecorder) {
            msgRecorder.pushContextName("PatternTableDef");
            try {
                ExplicitRules.checkAttributeString(msgRecorder, this.pattern.pattern(), "pattern");
                Iterator it = this.getExcludes();
                while (it.hasNext()) {
                    Exclude exclude = (Exclude)it.next();
                    exclude.validate(msgRecorder);
                }
                super.validate(msgRecorder);
            }
            finally {
                msgRecorder.popContextName();
            }
        }

        public void print(PrintWriter pw, String prefix) {
            pw.print(prefix);
            pw.println("ExplicitRules.PatternTableDef:");
            super.print(pw, prefix);
            String subprefix = prefix + "  ";
            String subsubprefix = subprefix + "  ";
            pw.print(subprefix);
            pw.print("pattern=");
            pw.print(this.pattern.pattern());
            pw.print(":");
            pw.println(this.pattern.flags());
            pw.print(subprefix);
            pw.println("Excludes: [");
            Iterator it = this.excludes.iterator();
            while (it.hasNext()) {
                Exclude exclude = (Exclude)it.next();
                exclude.print(pw, subsubprefix);
            }
            pw.print(subprefix);
            pw.println("]");
        }
    }

    static class NameTableDef
    extends TableDef {
        private final String name;

        static NameTableDef make(MondrianDef.AggName aggName, Group group) {
            NameTableDef name = new NameTableDef(aggName.getNameAttribute(), aggName.isIgnoreCase(), group);
            TableDef.add((TableDef)name, aggName);
            return name;
        }

        public NameTableDef(String name, boolean ignoreCase, Group group) {
            super(ignoreCase, group);
            this.name = name;
        }

        public boolean matches(String tableName) {
            return this.ignoreCase ? this.name.equals(tableName) : this.name.equalsIgnoreCase(tableName);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void validate(MessageRecorder msgRecorder) {
            msgRecorder.pushContextName("NameTableDef");
            try {
                ExplicitRules.checkAttributeString(msgRecorder, this.name, "name");
                super.validate(msgRecorder);
            }
            finally {
                msgRecorder.popContextName();
            }
        }

        public void print(PrintWriter pw, String prefix) {
            pw.print(prefix);
            pw.println("ExplicitRules.NameTableDef:");
            super.print(pw, prefix);
            String subprefix = prefix + "  ";
            pw.print(subprefix);
            pw.print("name=");
            pw.println(this.name);
        }
    }

    public static abstract class TableDef {
        private static int idCount = 0;
        protected final int id = TableDef.nextId();
        protected final boolean ignoreCase;
        protected final Group aggGroup;
        protected String factCountName;
        protected List ignoreColumnNames;
        private Map foreignKeyMap;
        private List levels;
        private List measures;

        static TableDef make(MondrianDef.AggTable aggTable, Group group) {
            return aggTable instanceof MondrianDef.AggName ? NameTableDef.make((MondrianDef.AggName)aggTable, group) : PatternTableDef.make((MondrianDef.AggPattern)aggTable, group);
        }

        private static void add(TableDef tableDef, MondrianDef.AggTable aggTable) {
            MondrianDef.AggLevel[] levels;
            MondrianDef.AggMeasure[] measures;
            MondrianDef.AggForeignKey[] fks;
            tableDef.setFactCountName(aggTable.getAggFactCount().getColumnName());
            MondrianDef.AggIgnoreColumn[] ignores = aggTable.getAggIgnoreColumns();
            if (ignores != null) {
                for (int i = 0; i < ignores.length; ++i) {
                    tableDef.addIgnoreColumnName(ignores[i].getColumnName());
                }
            }
            if ((fks = aggTable.getAggForeignKeys()) != null) {
                for (int i = 0; i < fks.length; ++i) {
                    tableDef.addFK(fks[i]);
                }
            }
            if ((measures = aggTable.getAggMeasures()) != null) {
                for (int i = 0; i < measures.length; ++i) {
                    TableDef.addTo(tableDef, measures[i]);
                }
            }
            if ((levels = aggTable.getAggLevels()) != null) {
                for (int i = 0; i < levels.length; ++i) {
                    TableDef.addTo(tableDef, levels[i]);
                }
            }
        }

        private static void addTo(TableDef tableDef, MondrianDef.AggLevel aggLevel) {
            TableDef.addLevelTo(tableDef, aggLevel.getNameAttribute(), aggLevel.getColumnName());
        }

        private static void addTo(TableDef tableDef, MondrianDef.AggMeasure aggMeasure) {
            TableDef.addMeasureTo(tableDef, aggMeasure.getNameAttribute(), aggMeasure.getColumn());
        }

        public static void addLevelTo(TableDef tableDef, String name, String columnName) {
            TableDef tableDef2 = tableDef;
            tableDef2.getClass();
            Level level = tableDef2.new Level(name, columnName);
            tableDef.add(level);
        }

        public static void addMeasureTo(TableDef tableDef, String name, String column) {
            TableDef tableDef2 = tableDef;
            tableDef2.getClass();
            Measure measure = tableDef2.new Measure(name, column);
            tableDef.add(measure);
        }

        private static int nextId() {
            return idCount++;
        }

        protected TableDef(boolean ignoreCase, Group aggGroup) {
            this.ignoreCase = ignoreCase;
            this.aggGroup = aggGroup;
            this.foreignKeyMap = Collections.EMPTY_MAP;
            this.levels = Collections.EMPTY_LIST;
            this.measures = Collections.EMPTY_LIST;
            this.ignoreColumnNames = Collections.EMPTY_LIST;
        }

        public int getId() {
            return this.id;
        }

        public boolean isIgnoreCase() {
            return this.ignoreCase;
        }

        public RolapStar getStar() {
            return this.getAggGroup().getStar();
        }

        public Group getAggGroup() {
            return this.aggGroup;
        }

        protected String getFactCountName() {
            return this.factCountName;
        }

        protected void setFactCountName(String factCountName) {
            this.factCountName = factCountName;
        }

        protected Iterator getIgnoreColumnNames() {
            return this.ignoreColumnNames.iterator();
        }

        public Iterator getLevels() {
            return this.levels.iterator();
        }

        public Iterator getMeasures() {
            return this.measures.iterator();
        }

        protected Recognizer.Matcher getIgnoreMatcher() {
            return new Recognizer.Matcher(){

                public boolean matches(String name) {
                    Iterator it = this.getIgnoreColumnNames();
                    while (it.hasNext()) {
                        String ignoreName = (String)it.next();
                        if (!ignoreName.equals(name)) continue;
                        return true;
                    }
                    return false;
                }
            };
        }

        protected Recognizer.Matcher getFactCountMatcher() {
            return new Recognizer.Matcher(this){
                private final /* synthetic */ TableDef this$0;
                {
                    this.this$0 = this$0;
                }

                public boolean matches(String name) {
                    return this.this$0.factCountName.equalsIgnoreCase(name);
                }
            };
        }

        RolapCube getCube() {
            return this.aggGroup.getCube();
        }

        public boolean columnsOK(RolapStar star, JdbcSchema.Table dbFactTable, JdbcSchema.Table dbTable, MessageRecorder msgRecorder) {
            ExplicitRecognizer cb = new ExplicitRecognizer(this, star, dbFactTable, dbTable, msgRecorder);
            return cb.check();
        }

        protected void addIgnoreColumnName(String ignoreName) {
            if (this.ignoreColumnNames == Collections.EMPTY_LIST) {
                this.ignoreColumnNames = new ArrayList();
            }
            this.ignoreColumnNames.add(ignoreName);
        }

        protected void addFK(MondrianDef.AggForeignKey fk) {
            if (this.foreignKeyMap == Collections.EMPTY_MAP) {
                this.foreignKeyMap = new HashMap();
            }
            this.foreignKeyMap.put(fk.getFactFKColumnName(), fk.getAggregateFKColumnName());
        }

        protected String getAggregateFK(String baseFK) {
            return (String)this.foreignKeyMap.get(baseFK);
        }

        protected Iterator getFKEntries() {
            return this.foreignKeyMap.entrySet().iterator();
        }

        protected void add(Level level) {
            if (this.levels == Collections.EMPTY_LIST) {
                this.levels = new ArrayList();
            }
            this.levels.add(level);
        }

        protected void add(Measure measure) {
            if (this.measures == Collections.EMPTY_LIST) {
                this.measures = new ArrayList();
            }
            this.measures.add(measure);
        }

        public abstract boolean matches(String var1);

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void validate(MessageRecorder msgRecorder) {
            msgRecorder.pushContextName("TableDef");
            try {
                HashMap<String, Object> namesToObjects = new HashMap<String, Object>();
                HashMap<String, Object> columnsToObjects = new HashMap<String, Object>();
                Iterator it = this.levels.iterator();
                while (it.hasNext()) {
                    Level level = (Level)it.next();
                    level.validate(msgRecorder);
                    if (namesToObjects.containsKey(level.getName())) {
                        msgRecorder.reportError(mres.DuplicateLevelNames.str(msgRecorder.getContext(), level.getName()));
                    } else {
                        namesToObjects.put(level.getName(), level);
                    }
                    if (columnsToObjects.containsKey(level.getColumnName())) {
                        Level l = (Level)columnsToObjects.get(level.getColumnName());
                        msgRecorder.reportError(mres.DuplicateLevelColumnNames.str(msgRecorder.getContext(), level.getName(), l.getName(), level.getColumnName()));
                        continue;
                    }
                    columnsToObjects.put(level.getColumnName(), level);
                }
                namesToObjects.clear();
                it = this.measures.iterator();
                while (it.hasNext()) {
                    Measure measure = (Measure)it.next();
                    measure.validate(msgRecorder);
                    if (namesToObjects.containsKey(measure.getName())) {
                        msgRecorder.reportError(mres.DuplicateMeasureNames.str(msgRecorder.getContext(), measure.getName()));
                        continue;
                    }
                    namesToObjects.put(measure.getName(), measure);
                    if (columnsToObjects.containsKey(measure.getColumnName())) {
                        Object o = columnsToObjects.get(measure.getColumnName());
                        if (o instanceof Measure) {
                            Measure m = (Measure)o;
                            msgRecorder.reportError(mres.DuplicateMeasureColumnNames.str(msgRecorder.getContext(), measure.getName(), m.getName(), measure.getColumnName()));
                            continue;
                        }
                        Level l = (Level)o;
                        msgRecorder.reportError(mres.DuplicateLevelMeasureColumnNames.str(msgRecorder.getContext(), l.getName(), measure.getName(), measure.getColumnName()));
                        continue;
                    }
                    columnsToObjects.put(measure.getColumnName(), measure);
                }
                namesToObjects.clear();
                columnsToObjects.clear();
                RolapStar star = this.getStar();
                RolapStar.Table factTable = star.getFactTable();
                String tableName = factTable.getAlias();
                Iterator it2 = this.getFKEntries();
                while (it2.hasNext()) {
                    MondrianDef.Column c;
                    Map.Entry e = (Map.Entry)it2.next();
                    String baseFKName = (String)e.getKey();
                    String aggFKName = (String)e.getValue();
                    if (namesToObjects.containsKey(baseFKName)) {
                        msgRecorder.reportError(mres.DuplicateFactForeignKey.str(msgRecorder.getContext(), baseFKName, aggFKName));
                    } else {
                        namesToObjects.put(baseFKName, aggFKName);
                    }
                    if (columnsToObjects.containsKey(aggFKName)) {
                        msgRecorder.reportError(mres.DuplicateFactForeignKey.str(msgRecorder.getContext(), baseFKName, aggFKName));
                    } else {
                        columnsToObjects.put(aggFKName, baseFKName);
                    }
                    if (factTable.findTableWithLeftCondition(c = new MondrianDef.Column(tableName, baseFKName)) != null) continue;
                    msgRecorder.reportError(mres.UnknownLeftJoinCondition.str(msgRecorder.getContext(), tableName, baseFKName));
                }
            }
            finally {
                msgRecorder.popContextName();
            }
        }

        public String toString() {
            StringWriter sw = new StringWriter(256);
            PrintWriter pw = new PrintWriter(sw);
            this.print(pw, "");
            pw.flush();
            return sw.toString();
        }

        public void print(PrintWriter pw, String prefix) {
            String subprefix = prefix + "  ";
            String subsubprefix = subprefix + "  ";
            pw.print(subprefix);
            pw.print("id=");
            pw.println(this.id);
            pw.print(subprefix);
            pw.print("ignoreCase=");
            pw.println(this.ignoreCase);
            pw.print(subprefix);
            pw.println("Levels: [");
            Iterator it = this.levels.iterator();
            while (it.hasNext()) {
                Level level = (Level)it.next();
                level.print(pw, subsubprefix);
            }
            pw.print(subprefix);
            pw.println("]");
            pw.print(subprefix);
            pw.println("Measures: [");
            it = this.measures.iterator();
            while (it.hasNext()) {
                Measure measure = (Measure)it.next();
                measure.print(pw, subsubprefix);
            }
            pw.print(subprefix);
            pw.println("]");
        }

        class Measure {
            private final String name;
            private String symbolicName;
            private final String columnName;
            private RolapStar.Measure rolapMeasure;

            Measure(String name, String columnName) {
                this.name = name;
                this.columnName = columnName;
            }

            public String getName() {
                return this.name;
            }

            public String getSymbolicName() {
                return this.symbolicName;
            }

            public String getColumnName() {
                return this.columnName;
            }

            public RolapStar.Measure getRolapStarMeasure() {
                return this.rolapMeasure;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void validate(MessageRecorder msgRecorder) {
                msgRecorder.pushContextName("Measure");
                try {
                    String name = this.getName();
                    String column = this.getColumnName();
                    ExplicitRules.checkAttributeString(msgRecorder, name, "name");
                    ExplicitRules.checkAttributeString(msgRecorder, column, "column");
                    String[] names = Util.explode(name);
                    if (names.length != 2) {
                        msgRecorder.reportError(mres.BadMeasureNameFormat.str(msgRecorder.getContext(), name));
                    } else {
                        RolapCube cube = TableDef.this.getCube();
                        SchemaReader schemaReader = cube.getSchemaReader();
                        Member member = (Member)schemaReader.lookupCompound(cube, names, false, 6);
                        if (member == null) {
                            if (!names[0].equals("Measures")) {
                                msgRecorder.reportError(mres.BadMeasures.str(msgRecorder.getContext(), names[0]));
                            } else {
                                msgRecorder.reportError(mres.UnknownMeasureName.str(msgRecorder.getContext(), names[1]));
                            }
                        }
                        RolapStar star = cube.getStar();
                        this.rolapMeasure = star.getFactTable().lookupMeasureByName(names[1]);
                        if (this.rolapMeasure == null) {
                            msgRecorder.reportError(mres.BadMeasureName.str(msgRecorder.getContext(), names[1], cube.getName()));
                        }
                        this.symbolicName = names[1];
                    }
                }
                finally {
                    msgRecorder.popContextName();
                }
            }

            public String toString() {
                StringWriter sw = new StringWriter(256);
                PrintWriter pw = new PrintWriter(sw);
                this.print(pw, "");
                pw.flush();
                return sw.toString();
            }

            public void print(PrintWriter pw, String prefix) {
                pw.print(prefix);
                pw.println("Measure:");
                String subprefix = prefix + "  ";
                pw.print(subprefix);
                pw.print("name=");
                pw.println(this.name);
                pw.print(subprefix);
                pw.print("column=");
                pw.println(this.columnName);
            }
        }

        class Level {
            private final String name;
            private final String columnName;
            private RolapLevel rlevel;

            Level(String name, String columnName) {
                this.name = name;
                this.columnName = columnName;
            }

            public String getName() {
                return this.name;
            }

            public String getColumnName() {
                return this.columnName;
            }

            public RolapLevel getRolapLevel() {
                return this.rlevel;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void validate(MessageRecorder msgRecorder) {
                msgRecorder.pushContextName("Level");
                try {
                    String name = this.getName();
                    String columnName = this.getColumnName();
                    ExplicitRules.checkAttributeString(msgRecorder, name, "name");
                    ExplicitRules.checkAttributeString(msgRecorder, columnName, "column");
                    String[] names = Util.explode(name);
                    if (names.length != 2) {
                        msgRecorder.reportError(mres.BadLevelNameFormat.str(msgRecorder.getContext(), name));
                    } else {
                        RolapCube cube = TableDef.this.getCube();
                        SchemaReader schemaReader = cube.getSchemaReader();
                        RolapLevel level = (RolapLevel)schemaReader.lookupCompound(cube, names, false, 4);
                        if (level == null) {
                            Hierarchy hierarchy = (Hierarchy)schemaReader.lookupCompound(cube, new String[]{names[0]}, false, 3);
                            if (hierarchy == null) {
                                msgRecorder.reportError(mres.UnknownHierarchyName.str(msgRecorder.getContext(), names[0]));
                            } else {
                                msgRecorder.reportError(mres.UnknownLevelName.str(msgRecorder.getContext(), names[0], names[1]));
                            }
                        }
                        this.rlevel = level;
                    }
                }
                finally {
                    msgRecorder.popContextName();
                }
            }

            public String toString() {
                StringWriter sw = new StringWriter(256);
                PrintWriter pw = new PrintWriter(sw);
                this.print(pw, "");
                pw.flush();
                return sw.toString();
            }

            public void print(PrintWriter pw, String prefix) {
                pw.print(prefix);
                pw.println("Level:");
                String subprefix = prefix + "  ";
                pw.print(subprefix);
                pw.print("name=");
                pw.println(this.name);
                pw.print(subprefix);
                pw.print("columnName=");
                pw.println(this.columnName);
            }
        }
    }

    private static class ExcludePattern
    implements Exclude {
        private final Pattern pattern;

        private ExcludePattern(String pattern, boolean ignoreCase) {
            this.pattern = ignoreCase ? Pattern.compile(pattern, 2) : Pattern.compile(pattern);
        }

        public boolean isExcluded(String tableName) {
            return this.pattern.matcher(tableName).matches();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void validate(MessageRecorder msgRecorder) {
            msgRecorder.pushContextName("ExcludePattern");
            try {
                ExplicitRules.checkAttributeString(msgRecorder, this.pattern.pattern(), "pattern");
            }
            finally {
                msgRecorder.popContextName();
            }
        }

        public void print(PrintWriter pw, String prefix) {
            pw.print(prefix);
            pw.println("ExplicitRules.PatternTableDef.ExcludePattern:");
            String subprefix = prefix + "  ";
            pw.print(subprefix);
            pw.print("pattern=");
            pw.print(this.pattern.pattern());
            pw.print(":");
            pw.println(this.pattern.flags());
        }
    }

    private static class ExcludeName
    implements Exclude {
        private final String name;
        private final boolean ignoreCase;

        private ExcludeName(String name, boolean ignoreCase) {
            this.name = name;
            this.ignoreCase = ignoreCase;
        }

        public String getName() {
            return this.name;
        }

        public boolean isIgnoreCase() {
            return this.ignoreCase;
        }

        public boolean isExcluded(String tableName) {
            return this.ignoreCase ? this.name.equals(tableName) : this.name.equalsIgnoreCase(tableName);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void validate(MessageRecorder msgRecorder) {
            msgRecorder.pushContextName("ExcludeName");
            try {
                String name = this.getName();
                ExplicitRules.checkAttributeString(msgRecorder, name, "name");
            }
            finally {
                msgRecorder.popContextName();
            }
        }

        public void print(PrintWriter pw, String prefix) {
            pw.print(prefix);
            pw.println("ExplicitRules.PatternTableDef.ExcludeName:");
            String subprefix = prefix + "  ";
            pw.print(subprefix);
            pw.print("name=");
            pw.println(this.name);
            pw.print(subprefix);
            pw.print("ignoreCase=");
            pw.println(this.ignoreCase);
        }
    }

    private static interface Exclude {
        public boolean isExcluded(String var1);

        public void validate(MessageRecorder var1);

        public void print(PrintWriter var1, String var2);
    }

    public static class Group {
        private final RolapCube cube;
        private List tableDefs;
        private List excludes;

        public static Group make(RolapCube cube, MondrianDef.Cube xmlCube) {
            Group group = new Group(cube);
            MondrianDef.Relation relation = xmlCube.fact;
            if (relation instanceof MondrianDef.Table) {
                MondrianDef.AggTable[] aggTables;
                MondrianDef.AggExclude[] aggExcludes = ((MondrianDef.Table)relation).getAggExcludes();
                if (aggExcludes != null) {
                    for (int i = 0; i < aggExcludes.length; ++i) {
                        Exclude exclude = ExplicitRules.make(aggExcludes[i]);
                        group.addExclude(exclude);
                    }
                }
                if ((aggTables = ((MondrianDef.Table)relation).getAggTables()) != null) {
                    for (int i = 0; i < aggTables.length; ++i) {
                        TableDef tableDef = TableDef.make(aggTables[i], group);
                        group.addTableDef(tableDef);
                    }
                }
            } else {
                String msg = mres.CubeRelationNotTable.str(cube.getName(), ((Object)((Object)relation)).getClass().getName());
                LOGGER.warn((Object)msg);
            }
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug((Object)(Util.nl + group));
            }
            return group;
        }

        public Group(RolapCube cube) {
            this.cube = cube;
            this.excludes = Collections.EMPTY_LIST;
            this.tableDefs = Collections.EMPTY_LIST;
        }

        public RolapCube getCube() {
            return this.cube;
        }

        public RolapStar getStar() {
            return this.getCube().getStar();
        }

        public String getName() {
            return this.getCube().getName();
        }

        public boolean hasRules() {
            return this.excludes != Collections.EMPTY_LIST || this.tableDefs != Collections.EMPTY_LIST;
        }

        public void addExclude(Exclude exclude) {
            if (this.excludes == Collections.EMPTY_LIST) {
                this.excludes = new ArrayList();
            }
            this.excludes.add(exclude);
        }

        public void addTableDef(TableDef tableDef) {
            if (this.tableDefs == Collections.EMPTY_LIST) {
                this.tableDefs = new ArrayList();
            }
            this.tableDefs.add(tableDef);
        }

        public boolean excludeTable(String tableName) {
            Iterator it = this.excludes.iterator();
            while (it.hasNext()) {
                Exclude exclude = (Exclude)it.next();
                if (!exclude.isExcluded(tableName)) continue;
                return true;
            }
            return false;
        }

        public TableDef getIncludeByTableDef(String tableName) {
            TableDef tableDef;
            Iterator it = this.tableDefs.iterator();
            while (it.hasNext()) {
                tableDef = (TableDef)it.next();
                if (!(tableDef instanceof NameTableDef) || !tableDef.matches(tableName)) continue;
                return tableDef;
            }
            it = this.tableDefs.iterator();
            while (it.hasNext()) {
                tableDef = (TableDef)it.next();
                if (!(tableDef instanceof PatternTableDef) || !tableDef.matches(tableName)) continue;
                return tableDef;
            }
            return null;
        }

        public String getTableName() {
            RolapStar.Table table = this.getStar().getFactTable();
            MondrianDef.Relation relation = table.getRelation();
            return relation.getAlias();
        }

        public String getSchemaName() {
            String schema = null;
            RolapStar.Table table = this.getStar().getFactTable();
            MondrianDef.Relation relation = table.getRelation();
            if (relation instanceof MondrianDef.Table) {
                MondrianDef.Table mtable = (MondrianDef.Table)relation;
                schema = mtable.schema;
            }
            return schema;
        }

        public String getCatalogName() {
            return null;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void validate(MessageRecorder msgRecorder) {
            msgRecorder.pushContextName(this.getName());
            try {
                Iterator it = this.tableDefs.iterator();
                while (it.hasNext()) {
                    TableDef tableDef = (TableDef)it.next();
                    tableDef.validate(msgRecorder);
                }
            }
            finally {
                msgRecorder.popContextName();
            }
        }

        public String toString() {
            StringWriter sw = new StringWriter(256);
            PrintWriter pw = new PrintWriter(sw);
            this.print(pw, "");
            pw.flush();
            return sw.toString();
        }

        public void print(PrintWriter pw, String prefix) {
            pw.print(prefix);
            pw.println("ExplicitRules.Group:");
            String subprefix = prefix + "  ";
            String subsubprefix = subprefix + "  ";
            pw.print(subprefix);
            pw.print("name=");
            pw.println((Object)this.getStar().getFactTable().getRelation());
            pw.print(subprefix);
            pw.println("TableDefs: [");
            Iterator it = this.tableDefs.iterator();
            while (it.hasNext()) {
                TableDef tableDef = (TableDef)it.next();
                tableDef.print(pw, subsubprefix);
            }
            pw.print(subprefix);
            pw.println("]");
        }

        public class Table {
            private final String tableName;
            private final TableDef tableDef;

            private Table(String tableName, TableDef tableDef) {
                this.tableName = tableName;
                this.tableDef = tableDef;
            }

            public String getTableName() {
                return this.tableName;
            }

            public TableDef getTableDef() {
                return this.tableDef;
            }

            public String toString() {
                StringWriter sw = new StringWriter(256);
                PrintWriter pw = new PrintWriter(sw);
                this.print(pw, "");
                pw.flush();
                return sw.toString();
            }

            public void validate(MessageRecorder msgRecorder) {
                msgRecorder.pushContextName(this.tableName);
                msgRecorder.popContextName();
            }

            public void print(PrintWriter pw, String prefix) {
                pw.print(prefix);
                pw.println("ExplicitRules.Table:");
                String subprefix = prefix + "  ";
                pw.print(subprefix);
                pw.print("TableName=");
                pw.println(this.tableName);
                pw.print(subprefix);
                pw.print("TableDef.id=");
                pw.println(this.tableDef.getId());
            }
        }
    }
}

