/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.engine.data;

import java.util.Iterator;
import java.util.List;
import net.sf.jasperreports.engine.JRException;
import net.sf.jasperreports.engine.JRField;
import net.sf.jasperreports.engine.JRRewindableDataSource;
import net.sf.jasperreports.engine.data.JRAbstractBeanDataSource;
import net.sf.jasperreports.engine.query.JRJpaQueryExecuter;

public class JRJpaDataSource
extends JRAbstractBeanDataSource
implements JRRewindableDataSource {
    private final JRJpaQueryExecuter queryExecuter;
    private final int pageSize;
    private int pageCount;
    private boolean nextPage;
    private List returnValues;
    private Iterator iterator;
    private Object currentBean;

    public JRJpaDataSource(JRJpaQueryExecuter queryExecuter, int pageSize) {
        super(true);
        this.queryExecuter = queryExecuter;
        this.pageSize = pageSize;
        this.pageCount = 0;
        this.fetchPage();
    }

    protected void fetchPage() {
        if (this.pageSize <= 0) {
            this.returnValues = this.queryExecuter.getResultList();
            this.nextPage = false;
        } else {
            this.returnValues = this.queryExecuter.getResultList(this.pageCount * this.pageSize, this.pageSize);
            this.nextPage = this.returnValues.size() == this.pageSize;
        }
        ++this.pageCount;
        this.initIterator();
    }

    public boolean next() {
        if (this.iterator == null) {
            return false;
        }
        boolean hasNext = this.iterator.hasNext();
        if (!hasNext && this.nextPage) {
            this.fetchPage();
            boolean bl = hasNext = this.iterator != null && this.iterator.hasNext();
        }
        if (hasNext) {
            this.currentBean = this.iterator.next();
        }
        return hasNext;
    }

    public void moveFirst() {
        if (this.pageCount == 1) {
            this.initIterator();
        } else {
            this.pageCount = 0;
            this.fetchPage();
        }
    }

    private void initIterator() {
        this.iterator = this.returnValues == null ? null : this.returnValues.iterator();
    }

    public Object getFieldValue(JRField field) throws JRException {
        return this.getFieldValue(this.currentBean, field);
    }
}

