/*
 * Decompiled with CFR 0.152.
 */
package it.businesslogic.ireport.gui;

import it.businesslogic.ireport.gui.JReportFrame;
import it.businesslogic.ireport.gui.MainFrame;
import it.businesslogic.ireport.util.Unit;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Stroke;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionAdapter;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import java.util.ArrayList;
import java.util.List;
import javax.swing.ImageIcon;
import javax.swing.JPanel;

public class JRulePanel
extends JPanel {
    public static int TYPE_HORIZONTAL = 0;
    public static int TYPE_VERTICAL = 1;
    private boolean fontSet = false;
    private JReportFrame jReportFrame = null;
    private int type = TYPE_HORIZONTAL;
    private int cursorPosition;
    private boolean dragging = false;
    private BufferedImage savedImage = null;
    private ImageIcon horizontalRuleStopIcon = null;
    private List guideLines = new ArrayList();
    private int lastTempGuidePosition = -1;
    private Stroke dottedStroke = null;

    public JRulePanel() {
        this.setCursorPosition(-1);
        Font f = this.getFont();
        this.setFont(new Font(f.getName(), 0, 10));
        this.setDottedStroke(new BasicStroke(1.0f, 0, 2, 0.0f, new float[]{1.0f, 1.0f}, 0.0f));
        this.horizontalRuleStopIcon = new ImageIcon(this.getClass().getResource("/it/businesslogic/ireport/icons/toolbars/rulestop.png"));
        this.addMouseMotionListener(new MouseMotionAdapter(){

            public void mouseDragged(MouseEvent evt) {
                JRulePanel.this.panelMouseDragged(evt);
            }

            public void mouseMoved(MouseEvent evt) {
                JRulePanel.this.panelMouseMoved(evt);
            }
        });
        this.addMouseListener(new MouseAdapter(){

            public void mousePressed(MouseEvent evt) {
                JRulePanel.this.panelMousePressed(evt);
            }

            public void mouseReleased(MouseEvent evt) {
                JRulePanel.this.panelMouseReleased(evt);
            }
        });
    }

    public void setRightFont(Graphics g) {
        if (this.fontSet) {
            return;
        }
        if (g == null) {
            return;
        }
    }

    public void paint(Graphics g) {
        boolean isMillimeters;
        if (this.getJReportFrame() == null) {
            return;
        }
        this.setRightFont(g);
        g.setFont(this.getFont());
        this.setCursorPosition(-1);
        g.setColor(this.getBackground());
        g.fillRect(0, 0, this.getWidth(), this.getHeight());
        String unitName = MainFrame.getMainInstance().getProperties().getProperty("DefaultUnit", "cm");
        double unit = 28.3464;
        if (unitName.equals("cm")) {
            unit = 28.3464;
        } else if (unitName.equals("pixels")) {
            unit = 1.0;
        } else if (unitName.equals("mm")) {
            unit = 2.83464;
        } else if (unitName.equals("inches")) {
            unit = 72.0;
        }
        g.setColor(new Color(255, 255, 255));
        double k = 0.0;
        double zoomfactor = this.getJReportFrame().getZoomFactor();
        int line = 0;
        int i = 0;
        int oldi = -100;
        double module = 2.0;
        boolean bl = isMillimeters = unit == 2.83464;
        if (isMillimeters) {
            unit = 28.3464;
        }
        boolean isPixel = false;
        int tick_space = 50;
        if (unit == 1.0) {
            isPixel = true;
            unit = 50.0;
            tick_space = 100;
        }
        if ((int)((double)this.convertUnitToPixel(1.0, unit) * zoomfactor) >= tick_space) {
            module = 10.0;
        }
        if (this.getType() == TYPE_HORIZONTAL) {
            int w;
            String s;
            int x1 = 10 + this.getJReportFrame().getZoomedDim(this.getJReportFrame().getReport().getLeftMargin()) - this.getJReportFrame().getHScroll();
            int x2 = 10 + this.getJReportFrame().getZoomedDim(this.getJReportFrame().getReport().getWidth() - this.getJReportFrame().getReport().getRightMargin()) - this.getJReportFrame().getHScroll();
            int x3 = 10 + this.getJReportFrame().getZoomedDim(this.getJReportFrame().getReport().getWidth()) - this.getJReportFrame().getHScroll() - 1;
            g.fillRect(Math.max(x1, 0), 0, Math.min(x2, this.getWidth()) - Math.max(x1, 0), this.getHeight());
            Color c = this.getBackground().darker();
            if (x1 > 0) {
                g.setColor(c);
                g.fillRect(Math.max(10 - this.getJReportFrame().getHScroll(), 0), 0, x1 - Math.max(10 - this.getJReportFrame().getHScroll(), 0), this.getHeight());
                g.setColor(c.darker());
                g.drawRect(Math.max(10 - this.getJReportFrame().getHScroll(), 0), 0, x1 - Math.max(10 - this.getJReportFrame().getHScroll(), 0), this.getHeight());
            }
            if (x2 < this.getWidth()) {
                g.setColor(c);
                g.fillRect(x2, 0, Math.min(this.getWidth(), x3) - x2, this.getHeight());
                g.setColor(c.darker());
                g.drawRect(x2, 0, Math.min(this.getWidth(), x3) - x2, this.getHeight());
            }
            g.setColor(new Color(0, 0, 0));
            g.drawLine(0, this.getHeight() - 1, this.getWidth(), this.getHeight() - 1);
            i = x1;
            while (i < this.getWidth()) {
                if (i >= 0) {
                    if ((double)line % module == 0.0) {
                        if (i - oldi > 20) {
                            s = "" + (int)k;
                            if (isMillimeters) {
                                s = s + "0";
                            }
                            if (isPixel) {
                                s = "" + (int)k * 50;
                            }
                            w = g.getFontMetrics().stringWidth(s);
                            g.drawString(s, i - w / 2, g.getFontMetrics().getHeight() / 2 + 3);
                            oldi = i;
                            g.drawLine(i, 16, i, 12);
                        } else {
                            g.drawLine(i, 5, i, 10);
                        }
                    } else if (module == 10.0 && line % 5 != 0) {
                        g.drawLine(i, 7, i, 8);
                    } else {
                        g.drawLine(i, 6, i, 9);
                    }
                }
                k = (double)(++line) * (1.0 / module);
                i = x1 + (int)((double)this.convertUnitToPixel(k, unit) * zoomfactor);
            }
            line = 1;
            k = 1.0 / module;
            oldi = x1;
            i = x1 - (int)((double)this.convertUnitToPixel(k, unit) * zoomfactor);
            while (x1 > 0 && i > -10) {
                if (i >= 0) {
                    if ((double)line % module == 0.0) {
                        if (oldi - i > 20) {
                            s = "" + (int)k;
                            if (isMillimeters) {
                                s = s + "0";
                            }
                            if (isPixel) {
                                s = "" + (int)k * 50;
                            }
                            w = g.getFontMetrics().stringWidth(s);
                            g.drawString(s, i - w / 2, g.getFontMetrics().getHeight() / 2 + 3);
                            oldi = i;
                            g.drawLine(i, 16, i, 12);
                        } else {
                            g.drawLine(i, 5, i, 10);
                        }
                    } else if (module == 10.0 && line % 5 != 0) {
                        g.drawLine(i, 7, i, 8);
                    } else {
                        g.drawLine(i, 6, i, 9);
                    }
                }
                k = (double)(++line) * (1.0 / module);
                i = x1 - (int)((double)this.convertUnitToPixel(k, unit) * zoomfactor);
            }
            for (i = 0; i < this.getGuideLines().size(); ++i) {
                Integer pos = (Integer)this.getGuideLines().get(i);
                int posI = pos;
                posI = 10 + (int)((double)posI * zoomfactor) - this.getJReportFrame().getHScroll();
                g.drawImage(this.horizontalRuleStopIcon.getImage(), posI - 4, 7, this);
            }
        } else {
            String s;
            int y1 = 10 + this.getJReportFrame().getZoomedDim(this.getJReportFrame().getReport().getTopMargin()) - this.getJReportFrame().getVScroll();
            int y2 = 10 + this.getJReportFrame().getZoomedDim(this.getJReportFrame().getReport().getDesignHeight() - this.getJReportFrame().getReport().getBottomMargin()) - this.getJReportFrame().getVScroll();
            int y3 = 10 + this.getJReportFrame().getZoomedDim(this.getJReportFrame().getReport().getDesignHeight()) - this.getJReportFrame().getVScroll() - 1;
            g.fillRect(0, Math.max(y1, 0), this.getWidth(), Math.min(y2, this.getHeight()) - Math.max(y1, 0));
            Color c = this.getBackground().darker();
            if (y1 > 0) {
                g.setColor(c);
                g.fillRect(0, Math.max(10 - this.getJReportFrame().getVScroll(), 0), this.getWidth(), y1 - Math.max(10 - this.getJReportFrame().getVScroll(), 0));
                g.setColor(c.darker());
                g.drawRect(0, Math.max(10 - this.getJReportFrame().getVScroll(), 0), this.getWidth(), y1 - Math.max(10 - this.getJReportFrame().getVScroll(), 0));
            }
            if (y2 < this.getHeight()) {
                g.setColor(c);
                g.fillRect(0, y2, this.getWidth(), Math.min(this.getHeight(), y3) - y2);
                g.setColor(c.darker());
                g.drawRect(0, y2, this.getWidth(), Math.min(this.getHeight(), y3) - y2);
            }
            g.setColor(new Color(0, 0, 0));
            g.drawLine(this.getWidth() - 1, 0, this.getWidth() - 1, this.getHeight());
            i = y1;
            while (i < this.getHeight()) {
                if (i >= 0) {
                    if ((double)line % module == 0.0) {
                        if (i - oldi > 20) {
                            s = "" + (int)k;
                            if (isMillimeters) {
                                s = s + "0";
                            }
                            if (isPixel) {
                                s = "" + (int)k * 50;
                            }
                            this.writeRotateString((Graphics2D)g, 4, i, s);
                            oldi = i;
                            g.drawLine(16, i, 12, i);
                        } else {
                            g.drawLine(5, i, 10, i);
                        }
                    } else if (module == 10.0 && line % 5 != 0) {
                        g.drawLine(7, i, 8, i);
                    } else {
                        g.drawLine(6, i, 9, i);
                    }
                }
                k = (double)(++line) * (1.0 / module);
                i = y1 + (int)((double)this.convertUnitToPixel(k, unit) * zoomfactor);
            }
            line = 1;
            k = 1.0 / module;
            oldi = y1;
            i = y1 - (int)((double)this.convertUnitToPixel(k, unit) * zoomfactor);
            while (y1 > 0 && i > -10) {
                if (i >= 0) {
                    if ((double)line % module == 0.0) {
                        if (i - oldi > 20) {
                            s = "" + (int)k;
                            if (isMillimeters) {
                                s = s + "0";
                            }
                            if (isPixel) {
                                s = "" + (int)k * 50;
                            }
                            int w = g.getFontMetrics().stringWidth(s);
                            this.writeRotateString((Graphics2D)g, 4, i, s);
                            oldi = i;
                            g.drawLine(16, i, 12, i);
                        } else {
                            g.drawLine(5, i, 10, i);
                        }
                    } else if (module == 10.0 && line % 5 != 0) {
                        g.drawLine(7, i, 8, i);
                    } else {
                        g.drawLine(6, i, 9, i);
                    }
                }
                k = (double)(++line) * (1.0 / module);
                i = y1 - (int)((double)this.convertUnitToPixel(k, unit) * zoomfactor);
            }
            for (i = 0; i < this.getGuideLines().size(); ++i) {
                Integer pos = (Integer)this.getGuideLines().get(i);
                int posI = pos;
                posI = 10 + (int)((double)posI * zoomfactor) - this.getJReportFrame().getHScroll();
                g.drawImage(this.horizontalRuleStopIcon.getImage(), 7, posI - 4, this);
            }
        }
    }

    public void writeRotateString(Graphics2D g2, int x, int yCenter, String s) {
        Rectangle2D sb = g2.getFontMetrics().getStringBounds(s, g2);
        int sw = (int)sb.getWidth();
        int sh = (int)(sb.getHeight() / 2.0);
        g2.drawString(s, x - sw / 3, yCenter + sh / 2);
    }

    public int getCursorPosition() {
        return this.cursorPosition;
    }

    public void setCursorPosition(int cursorPosition) {
        Graphics g = this.getGraphics();
        if (g == null) {
            return;
        }
        g.setXORMode(Color.WHITE);
        if (this.getType() == TYPE_HORIZONTAL) {
            g.drawLine(this.cursorPosition, 0, this.cursorPosition, this.getHeight());
            this.cursorPosition = cursorPosition;
            g.drawLine(this.cursorPosition, 0, this.cursorPosition, this.getHeight());
        } else {
            g.drawLine(0, this.cursorPosition, this.getWidth(), this.cursorPosition);
            this.cursorPosition = cursorPosition;
            g.drawLine(0, this.cursorPosition, this.getWidth(), this.cursorPosition);
        }
        g.setPaintMode();
    }

    public JReportFrame getJReportFrame() {
        return this.jReportFrame;
    }

    public void setJReportFrame(JReportFrame jReportFrame) {
        this.jReportFrame = jReportFrame;
    }

    public int convertUnitToPixel(double value, double unit) {
        if (unit == 1.0) {
            return (int)value;
        }
        return (int)Unit.convertToPixels(value, unit);
    }

    public int getType() {
        return this.type;
    }

    public void setType(int type) {
        if (type != this.type) {
            this.horizontalRuleStopIcon = new ImageIcon(this.getClass().getResource("/it/businesslogic/ireport/icons/toolbars/rulestop" + (type == TYPE_VERTICAL ? "v" : "") + ".png"));
            this.type = type;
        }
    }

    public void panelMousePressed(MouseEvent evt) {
        int currentLine = -1;
        for (int i = 0; i < this.getGuideLines().size(); ++i) {
            int mousePos;
            Integer pos = (Integer)this.getGuideLines().get(i);
            int posI = pos;
            int scroll = this.getType() == TYPE_HORIZONTAL ? this.getJReportFrame().getHScroll() : this.getJReportFrame().getVScroll();
            posI = 10 + (int)((double)posI * this.getJReportFrame().getZoomFactor()) - scroll;
            int n = mousePos = this.getType() == TYPE_HORIZONTAL ? evt.getX() : evt.getY();
            if (mousePos <= posI - 3 || mousePos >= posI + 3) continue;
            currentLine = posI;
            this.getGuideLines().remove(i);
            break;
        }
        this.savedImage = (BufferedImage)this.createImage(this.getWidth(), this.getHeight());
        Graphics2D savedGraphics = this.savedImage.createGraphics();
        this.paint(savedGraphics);
        if (this.getType() == TYPE_HORIZONTAL) {
            this.getGraphics().drawImage(this.horizontalRuleStopIcon.getImage(), evt.getX() - 4, 7, this);
        } else {
            this.getGraphics().drawImage(this.horizontalRuleStopIcon.getImage(), 7, evt.getY() - 4, this);
        }
        this.lastTempGuidePosition = this.getType() == TYPE_HORIZONTAL ? evt.getX() : evt.getY();
        Graphics2D jrfGraphics = (Graphics2D)this.getJReportFrame().getReportPanel().getGraphics();
        Stroke oldStroke = jrfGraphics.getStroke();
        jrfGraphics.setXORMode(Color.YELLOW);
        jrfGraphics.setStroke(this.getDottedStroke());
        if (this.lastTempGuidePosition >= 0) {
            if (this.getType() == TYPE_HORIZONTAL) {
                jrfGraphics.drawLine(currentLine, 0, currentLine, this.getJReportFrame().getHeight());
            } else {
                jrfGraphics.drawLine(0, currentLine, this.getJReportFrame().getWidth(), currentLine);
            }
        }
        if (this.getType() == TYPE_HORIZONTAL) {
            jrfGraphics.drawLine(this.lastTempGuidePosition, 0, this.lastTempGuidePosition, this.getJReportFrame().getHeight());
        } else {
            jrfGraphics.drawLine(0, this.lastTempGuidePosition, this.getJReportFrame().getWidth(), this.lastTempGuidePosition);
        }
        jrfGraphics.setPaintMode();
        jrfGraphics.setStroke(oldStroke);
    }

    public void panelMouseReleased(MouseEvent evt) {
        this.getGraphics().drawImage(this.savedImage, 0, 0, this);
        if (this.getType() == TYPE_HORIZONTAL) {
            if (evt.getX() > 0 && evt.getX() < this.getWidth()) {
                int newPosition = this.getJReportFrame().getLogicalDim(evt.getX() + this.getJReportFrame().getHScroll() - 10);
                this.getGuideLines().add(new Integer(newPosition));
                this.repaint();
                this.getJReportFrame().repaint();
            }
        } else if (evt.getY() > 0 && evt.getY() < this.getHeight()) {
            int newPosition = this.getJReportFrame().getLogicalDim(evt.getY() + this.getJReportFrame().getVScroll() - 10);
            this.getGuideLines().add(new Integer(newPosition));
            this.repaint();
            this.getJReportFrame().repaint();
        }
    }

    public void panelMouseDragged(MouseEvent e) {
        this.getGraphics().drawImage(this.savedImage, 0, 0, this);
        if (this.getType() == TYPE_HORIZONTAL) {
            this.getGraphics().drawImage(this.horizontalRuleStopIcon.getImage(), e.getX() - 4, 7, this);
        } else {
            this.getGraphics().drawImage(this.horizontalRuleStopIcon.getImage(), 7, e.getY() - 4, this);
        }
        Graphics2D jrfGraphics = (Graphics2D)this.getJReportFrame().getReportPanel().getGraphics();
        Stroke oldStroke = jrfGraphics.getStroke();
        jrfGraphics.setXORMode(Color.YELLOW);
        jrfGraphics.setStroke(this.getDottedStroke());
        if (this.lastTempGuidePosition >= 0) {
            if (this.getType() == TYPE_HORIZONTAL) {
                jrfGraphics.drawLine(this.lastTempGuidePosition, 0, this.lastTempGuidePosition, this.getJReportFrame().getHeight());
            } else {
                jrfGraphics.drawLine(0, this.lastTempGuidePosition, this.getJReportFrame().getWidth(), this.lastTempGuidePosition);
            }
        }
        int n = this.lastTempGuidePosition = this.getType() == TYPE_HORIZONTAL ? e.getX() : e.getY();
        if (this.getType() == TYPE_HORIZONTAL) {
            jrfGraphics.drawLine(this.lastTempGuidePosition, 0, this.lastTempGuidePosition, this.getJReportFrame().getHeight());
        } else {
            jrfGraphics.drawLine(0, this.lastTempGuidePosition, this.getJReportFrame().getWidth(), this.lastTempGuidePosition);
        }
        jrfGraphics.setPaintMode();
        jrfGraphics.setStroke(oldStroke);
    }

    public void panelMouseMoved(MouseEvent e) {
        this.setCursorPosition(this.getType() == TYPE_HORIZONTAL ? e.getX() : e.getY());
    }

    public boolean isDragging() {
        return this.dragging;
    }

    public void setDragging(boolean dragging) {
        this.dragging = dragging;
    }

    public List getGuideLines() {
        return this.guideLines;
    }

    public void setGuideLines(List guideLines) {
        this.guideLines = guideLines;
    }

    public Stroke getDottedStroke() {
        return this.dottedStroke;
    }

    public void setDottedStroke(Stroke dottedStroke) {
        this.dottedStroke = dottedStroke;
    }
}

