/*
 * Decompiled with CFR 0.152.
 */
package groovy.servlet;

import groovy.lang.Binding;
import groovy.servlet.ServletBinding;
import groovy.text.SimpleTemplateEngine;
import groovy.text.Template;
import groovy.text.TemplateEngine;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.Writer;
import java.net.URL;
import javax.servlet.ServletConfig;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class TemplateServlet
extends HttpServlet {
    public static final String DEFAULT_CONTENT_TYPE = "text/html";
    private ServletContext servletContext;
    protected TemplateEngine templateEngine;

    public void init(ServletConfig config) {
        this.servletContext = config.getServletContext();
        String className = ((Object)((Object)this)).getClass().getName();
        this.servletContext.log("Initializing on " + className + "...");
        this.templateEngine = this.createTemplateEngine(config);
        if (this.templateEngine == null) {
            throw new RuntimeException("Template engine not instantiated.");
        }
        String engineName = this.templateEngine.getClass().getName();
        this.servletContext.log(className + " initialized on " + engineName + ".");
    }

    protected boolean init(ServletConfig config, String param, boolean value) {
        String string = config.getInitParameter(param);
        if (string == null) {
            return value;
        }
        return Boolean.valueOf(string);
    }

    protected TemplateEngine createTemplateEngine(ServletConfig config) {
        String templateEngineClassName = config.getInitParameter("templateEngine");
        if (templateEngineClassName == null) {
            return new SimpleTemplateEngine();
        }
        try {
            return (TemplateEngine)Class.forName(templateEngineClassName).newInstance();
        }
        catch (InstantiationException e) {
            this.servletContext.log("Could not instantiate template engine: " + templateEngineClassName, (Throwable)e);
        }
        catch (IllegalAccessException e) {
            this.servletContext.log("Could not access template engine class: " + templateEngineClassName, (Throwable)e);
        }
        catch (ClassNotFoundException e) {
            this.servletContext.log("Could not find template engine class: " + templateEngineClassName, (Throwable)e);
        }
        return null;
    }

    public void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        this.doRequest(request, response);
    }

    public void doPost(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        this.doRequest(request, response);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doRequest(HttpServletRequest request, HttpServletResponse response) throws ServletException {
        ServletBinding binding = null;
        try {
            binding = new ServletBinding(request, (ServletResponse)response, this.servletContext);
            this.setContentType(request, response);
            Template template = this.handleRequest(request, response, binding);
            this.merge(template, binding, response);
            this.requestDone(request, response, binding);
        }
        catch (Exception exception) {
            try {
                this.error(request, response, exception);
                this.requestDone(request, response, binding);
            }
            catch (Throwable throwable) {
                this.requestDone(request, response, binding);
                throw throwable;
            }
        }
    }

    protected void setContentType(HttpServletRequest request, HttpServletResponse response) {
        response.setContentType(DEFAULT_CONTENT_TYPE);
    }

    protected Template handleRequest(HttpServletRequest request, HttpServletResponse response, Binding binding) throws Exception {
        return this.getTemplate(request);
    }

    protected Template getTemplate(HttpServletRequest request) throws Exception {
        URL url;
        String path = (String)request.getAttribute("javax.servlet.include.servlet_path");
        if (path == null) {
            path = request.getServletPath();
        }
        if ((url = this.resolveTemplateName(path)) == null) {
            url = this.resolveTemplateName(request.getRequestURI());
        }
        if (url == null) {
            String uri = request.getRequestURI();
            this.servletContext.log("Resource \"" + uri + "\" not found.");
            throw new FileNotFoundException(uri);
        }
        return this.getTemplate(url);
    }

    protected URL resolveTemplateName(String templateName) throws Exception {
        URL url = this.servletContext.getResource(templateName);
        if (url != null) {
            return url;
        }
        ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
        url = classLoader.getResource(templateName);
        if (url != null) {
            return url;
        }
        url = ((Object)((Object)this)).getClass().getResource(templateName);
        if (url != null) {
            return url;
        }
        return null;
    }

    protected Template getTemplate(URL templateURL) throws Exception {
        return this.templateEngine.createTemplate(templateURL);
    }

    protected void merge(Template template, Binding binding, HttpServletResponse response) throws Exception {
        template.make(binding.getVariables()).writeTo((Writer)binding.getVariable("out"));
    }

    protected void error(HttpServletRequest request, HttpServletResponse response, Exception exception) {
        try {
            response.sendError(500, exception.getMessage());
        }
        catch (IOException ioException) {
            this.servletContext.log("Should not happen.", (Throwable)ioException);
        }
    }

    protected void requestDone(HttpServletRequest request, HttpServletResponse response, Binding binding) {
    }
}

