/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.groovy.control;

import java.io.PrintWriter;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import org.codehaus.groovy.control.CompilationFailedException;
import org.codehaus.groovy.control.CompilerClassLoader;
import org.codehaus.groovy.control.CompilerConfiguration;
import org.codehaus.groovy.control.Janitor;
import org.codehaus.groovy.control.Phases;
import org.codehaus.groovy.control.messages.ExceptionMessage;
import org.codehaus.groovy.control.messages.Message;
import org.codehaus.groovy.control.messages.SyntaxErrorMessage;
import org.codehaus.groovy.control.messages.WarningMessage;
import org.codehaus.groovy.syntax.SyntaxException;

public abstract class ProcessingUnit {
    protected LinkedList warnings = null;
    protected LinkedList errors = null;
    protected boolean fatal = false;
    protected int phase = 1;
    protected boolean phaseComplete;
    protected CompilerConfiguration configuration;
    protected int warningLevel;
    protected PrintWriter output;
    protected int tolerance;
    protected ClassLoader classLoader;

    public ProcessingUnit(CompilerConfiguration configuration, ClassLoader classLoader) {
        this.classLoader = classLoader == null ? new CompilerClassLoader() : classLoader;
        this.configure(configuration == null ? new CompilerConfiguration() : configuration);
    }

    public void configure(CompilerConfiguration configuration) {
        this.configuration = configuration;
        this.warningLevel = configuration.getWarningLevel();
        this.output = configuration.getOutput();
        this.tolerance = configuration.getTolerance();
    }

    public CompilerConfiguration getConfiguration() {
        return this.configuration;
    }

    public void setConfiguration(CompilerConfiguration configuration) {
        this.configuration = configuration;
    }

    public ClassLoader getClassLoader() {
        return this.classLoader;
    }

    public void setClassLoader(ClassLoader loader) {
        this.classLoader = loader;
    }

    public int getPhase() {
        return this.phase;
    }

    public String getPhaseDescription() {
        return Phases.getDescription(this.phase);
    }

    public List getWarnings() {
        return this.warnings;
    }

    public List getErrors() {
        return this.errors;
    }

    public int getWarningCount() {
        return this.warnings == null ? 0 : this.warnings.size();
    }

    public int getErrorCount() {
        return this.errors == null ? 0 : this.errors.size();
    }

    public WarningMessage getWarning(int index) {
        if (index < this.getWarningCount()) {
            return (WarningMessage)this.warnings.get(index);
        }
        return null;
    }

    public Message getError(int index) {
        if (index < this.getErrorCount()) {
            return (Message)this.errors.get(index);
        }
        return null;
    }

    public SyntaxException getSyntaxError(int index) {
        SyntaxException exception = null;
        Message message = this.getError(index);
        if (message != null && message instanceof SyntaxErrorMessage) {
            exception = ((SyntaxErrorMessage)message).getCause();
        }
        return exception;
    }

    public Exception getException(int index) {
        Exception exception = null;
        Message message = this.getError(index);
        if (message != null) {
            if (message instanceof ExceptionMessage) {
                exception = ((ExceptionMessage)message).getCause();
            } else if (message instanceof SyntaxErrorMessage) {
                exception = ((SyntaxErrorMessage)message).getCause();
            }
        }
        return exception;
    }

    public void addWarning(WarningMessage message) {
        if (message.isRelevant(this.warningLevel)) {
            if (this.warnings == null) {
                this.warnings = new LinkedList();
            }
            this.warnings.add(message);
        }
    }

    public void addError(Message message) throws CompilationFailedException {
        if (this.errors == null) {
            this.errors = new LinkedList();
        }
        this.errors.add(message);
        if (this.errors.size() >= this.tolerance) {
            this.fail();
        }
    }

    public void addError(Message message, boolean fatal) throws CompilationFailedException {
        if (fatal) {
            this.addFatalError(message);
        } else {
            this.addError(message);
        }
    }

    public void addFatalError(Message message) throws CompilationFailedException {
        this.addError(message);
        this.fail();
    }

    public void addException(Exception cause) throws CompilationFailedException {
        this.addError(new ExceptionMessage(cause));
        this.fail();
    }

    public boolean hasErrors() {
        return this.errors != null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void completePhase() throws CompilationFailedException {
        if (this.warnings != null) {
            Janitor janitor = new Janitor();
            try {
                Iterator iterator = this.warnings.iterator();
                while (iterator.hasNext()) {
                    WarningMessage warning = (WarningMessage)iterator.next();
                    warning.write(this.output, this, janitor);
                }
                this.warnings = null;
            }
            finally {
                janitor.cleanup();
            }
        }
        if (this.hasErrors()) {
            this.fail();
        } else {
            this.phaseComplete = true;
        }
    }

    public void nextPhase() throws CompilationFailedException {
        this.gotoPhase(this.phase + 1);
    }

    public void gotoPhase(int phase) throws CompilationFailedException {
        if (!this.phaseComplete) {
            this.completePhase();
        }
        this.phase = phase;
        this.phaseComplete = false;
    }

    protected void fail() throws CompilationFailedException {
        Message exceptionMessage;
        Message message;
        Exception firstException = null;
        Iterator iter = this.errors.iterator();
        while (!(!iter.hasNext() || (message = (Message)iter.next()) instanceof ExceptionMessage && (firstException = ((ExceptionMessage)(exceptionMessage = (ExceptionMessage)message)).getCause()) != null || message instanceof SyntaxErrorMessage && (firstException = ((SyntaxErrorMessage)(exceptionMessage = (SyntaxErrorMessage)message)).getCause()) != null)) {
        }
        if (firstException != null) {
            throw new CompilationFailedException(this.phase, this, firstException);
        }
        throw new CompilationFailedException(this.phase, this);
    }

    public void write(PrintWriter writer, Janitor janitor) {
        Iterator iterator;
        if (this.warnings != null) {
            iterator = this.warnings.iterator();
            while (iterator.hasNext()) {
                WarningMessage warning = (WarningMessage)iterator.next();
                warning.write(writer, this, janitor);
            }
            this.warnings = null;
        }
        if (this.errors != null) {
            iterator = this.errors.iterator();
            while (iterator.hasNext()) {
                Message message = (Message)iterator.next();
                message.write(writer, this, janitor);
            }
        }
    }
}

