/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.event.def;

import org.hibernate.HibernateException;
import org.hibernate.collection.PersistentCollection;
import org.hibernate.engine.SessionImplementor;
import org.hibernate.event.def.AbstractVisitor;
import org.hibernate.type.CollectionType;

public class DirtyCollectionSearchVisitor
extends AbstractVisitor {
    private boolean dirty = false;
    private boolean[] propertyVersionability;

    DirtyCollectionSearchVisitor(SessionImplementor session, boolean[] propertyVersionability) {
        super(session);
        this.propertyVersionability = propertyVersionability;
    }

    boolean wasDirtyCollectionFound() {
        return this.dirty;
    }

    Object processCollection(Object collection, CollectionType type) throws HibernateException {
        if (collection != null) {
            SessionImplementor session = this.getSession();
            PersistentCollection coll = type.isArrayType() ? session.getPersistenceContext().getCollectionHolder(collection) : (PersistentCollection)collection;
            if (session.getPersistenceContext().getCollectionEntry(coll).isInitializedAndDirty()) {
                this.dirty = true;
                return null;
            }
        }
        return null;
    }

    boolean includeEntityProperty(Object[] values, int i) {
        return this.propertyVersionability[i] && super.includeEntityProperty(values, i);
    }
}

