/*
 * Decompiled with CFR 0.152.
 */
package mondrian.olap;

import java.io.PrintWriter;
import mondrian.olap.Axis;
import mondrian.olap.Cell;
import mondrian.olap.Dimension;
import mondrian.olap.Member;
import mondrian.olap.Position;
import mondrian.olap.Query;
import mondrian.olap.Result;
import org.apache.log4j.Logger;

public abstract class ResultBase
implements Result {
    protected final Query query;
    protected final Axis[] axes;
    protected Axis slicerAxis;

    protected ResultBase(Query query, Axis[] axes) {
        this.query = query;
        this.axes = axes;
    }

    protected abstract Logger getLogger();

    public Query getQuery() {
        return this.query;
    }

    public Axis[] getAxes() {
        return this.axes;
    }

    public Axis getSlicerAxis() {
        return this.slicerAxis;
    }

    public void print(PrintWriter pw) {
        for (int i = -1; i < this.axes.length; ++i) {
            pw.println("Axis #" + (i + 1) + ":");
            this.printAxis(pw, i < 0 ? this.slicerAxis : this.axes[i]);
        }
        int[] pos = new int[this.axes.length];
        this.printRows(pw, this.axes.length - 1, pos);
    }

    private void printRows(PrintWriter pw, int axis, int[] pos) {
        Axis _axis = axis < 0 ? this.slicerAxis : this.axes[axis];
        int count = _axis.positions.length;
        for (int i = 0; i < count; ++i) {
            if (axis < 0) {
                if (i > 0) {
                    pw.print(", ");
                }
                this.printCell(pw, pos);
                continue;
            }
            pos[axis] = i;
            if (axis == 0) {
                int row = axis + 1 < pos.length ? pos[axis + 1] : 0;
                pw.print("Row #" + row + ": ");
            }
            this.printRows(pw, axis - 1, pos);
            if (axis != 0) continue;
            pw.println();
        }
    }

    private void printAxis(PrintWriter pw, Axis axis) {
        for (int i = 0; i < axis.positions.length; ++i) {
            Position position = axis.positions[i];
            pw.print("{");
            for (int j = 0; j < position.members.length; ++j) {
                Member member = position.members[j];
                if (j > 0) {
                    pw.print(", ");
                }
                pw.print(member.getUniqueName());
            }
            pw.println("}");
        }
    }

    private void printCell(PrintWriter pw, int[] pos) {
        Cell cell = this.getCell(pos);
        pw.print(cell.getFormattedValue());
    }

    public Member getMember(int[] pos, Dimension dimension) {
        for (int i = -1; i < this.axes.length; ++i) {
            Axis axis = this.slicerAxis;
            int index = 0;
            if (i >= 0) {
                axis = this.axes[i];
                index = pos[i];
            }
            Position position = axis.positions[index];
            for (int j = 0; j < position.members.length; ++j) {
                Member member = position.members[j];
                if (member.getDimension() != dimension) continue;
                return member;
            }
        }
        return dimension.getHierarchy().getDefaultMember();
    }

    public void close() {
    }
}

