/*
 * Decompiled with CFR 0.152.
 */
package mondrian.olap;

import mondrian.olap.Dimension;
import mondrian.olap.Evaluator;
import mondrian.olap.Exp;
import mondrian.olap.Hierarchy;
import mondrian.olap.NamedSet;
import mondrian.olap.OlapElement;
import mondrian.olap.OlapElementBase;
import mondrian.olap.SchemaReader;
import mondrian.olap.Validator;
import mondrian.olap.Visitor;
import mondrian.olap.type.SetType;
import mondrian.olap.type.Type;
import org.apache.log4j.Logger;

class SetBase
extends OlapElementBase
implements NamedSet {
    private static final Logger LOGGER = Logger.getLogger((Class)SetBase.class);
    private String name;
    private final Exp exp;

    SetBase(String name, Exp exp) {
        this.name = name;
        this.exp = exp;
    }

    public Object clone() {
        return new SetBase(this.name, (Exp)this.exp.clone());
    }

    protected Logger getLogger() {
        return LOGGER;
    }

    public Object getObject() {
        return null;
    }

    public String getUniqueName() {
        return "[" + this.name + "]";
    }

    public String getName() {
        return this.name;
    }

    public String getQualifiedName() {
        return null;
    }

    public String getDescription() {
        return null;
    }

    public int getCategory() {
        return 8;
    }

    public Type getTypeX() {
        return new SetType(this.exp.getTypeX());
    }

    public Hierarchy getHierarchy() {
        return this.exp.getTypeX().getHierarchy();
    }

    public Dimension getDimension() {
        return this.getHierarchy().getDimension();
    }

    public OlapElement lookupChild(SchemaReader schemaReader, String s) {
        return null;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void accept(Visitor visitor) {
        visitor.visit(this);
    }

    public Exp accept(Validator validator) {
        Exp clonedExp = (Exp)this.exp.clone();
        Exp exp3 = clonedExp.accept(validator);
        return new SetBase(this.name, exp3);
    }

    public void childrenAccept(Visitor visitor) {
    }

    public boolean dependsOn(Dimension dimension) {
        return this.exp.dependsOn(dimension);
    }

    public Object evaluate(Evaluator evaluator) {
        return evaluator.evaluateNamedSet(this.name, this.exp);
    }
}

