/*
 * Decompiled with CFR 0.152.
 */
package mondrian.rolap;

import java.io.PrintWriter;
import java.io.StringWriter;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import javax.sql.DataSource;
import mondrian.olap.Axis;
import mondrian.olap.Cell;
import mondrian.olap.ConnectionBase;
import mondrian.olap.Cube;
import mondrian.olap.MondrianProperties;
import mondrian.olap.Position;
import mondrian.olap.Query;
import mondrian.olap.QueryAxis;
import mondrian.olap.Result;
import mondrian.olap.ResultBase;
import mondrian.olap.Role;
import mondrian.olap.Schema;
import mondrian.olap.SchemaReader;
import mondrian.olap.Util;
import mondrian.rolap.RolapAxis;
import mondrian.rolap.RolapCell;
import mondrian.rolap.RolapConnectionPool;
import mondrian.rolap.RolapResult;
import mondrian.rolap.RolapSchema;
import mondrian.rolap.RolapSchemaReader;
import mondrian.rolap.RolapUtil;
import org.apache.commons.dbcp.ConnectionFactory;
import org.apache.commons.dbcp.DataSourceConnectionFactory;
import org.apache.commons.dbcp.DelegatingConnection;
import org.apache.commons.dbcp.DriverManagerConnectionFactory;
import org.apache.log4j.Logger;

public class RolapConnection
extends ConnectionBase {
    private static final Logger LOGGER = Logger.getLogger((Class)RolapConnection.class);
    private final Util.PropertyList connectInfo;
    private final DataSource dataSource;
    private final String catalogName;
    private final RolapSchema schema;
    private SchemaReader schemaReader;
    protected Role role;
    private Locale locale = Locale.US;

    public RolapConnection(Util.PropertyList connectInfo) {
        this(connectInfo, null, null);
    }

    public RolapConnection(Util.PropertyList connectInfo, DataSource datasource) {
        this(connectInfo, null, datasource);
    }

    RolapConnection(Util.PropertyList connectInfo, RolapSchema schema) {
        this(connectInfo, schema, null);
    }

    RolapConnection(Util.PropertyList connectInfo, RolapSchema schema, DataSource dataSource) {
        String provider = connectInfo.get("Provider");
        Util.assertTrue(provider.equalsIgnoreCase("mondrian"));
        this.connectInfo = connectInfo;
        this.catalogName = connectInfo.get("Catalog");
        this.dataSource = dataSource != null ? dataSource : RolapConnection.createDataSource(connectInfo);
        Role role = null;
        if (schema == null) {
            if (dataSource == null) {
                String jdbcConnectString = connectInfo.get("Jdbc");
                String jdbcUser = connectInfo.get("JdbcUser");
                String strDataSource = connectInfo.get("DataSource");
                String connectionKey = jdbcConnectString + RolapConnection.getJDBCProperties(connectInfo).toString();
                schema = RolapSchema.Pool.instance().get(this.catalogName, connectionKey, jdbcUser, strDataSource, connectInfo);
            } else {
                schema = RolapSchema.Pool.instance().get(this.catalogName, dataSource, connectInfo);
            }
            String roleName = connectInfo.get("Role");
            if (roleName != null && (role = schema.lookupRole(roleName)) == null) {
                throw Util.newError("Role '" + roleName + "' not found");
            }
        }
        if (role == null) {
            role = schema.getDefaultRole();
        }
        this.schema = schema;
        this.setRole(role);
    }

    protected Logger getLogger() {
        return LOGGER;
    }

    static DataSource createDataSource(Util.PropertyList connectInfo) {
        DataSource dataSource;
        String jdbcConnectString = connectInfo.get("Jdbc");
        String poolNeededString = connectInfo.get("PoolNeeded");
        Properties jdbcProperties = RolapConnection.getJDBCProperties(connectInfo);
        String propertyString = jdbcProperties.toString();
        if (jdbcConnectString != null) {
            String jdbcDrivers = connectInfo.get("JdbcDrivers");
            if (jdbcDrivers != null) {
                RolapUtil.loadDrivers(jdbcDrivers);
            }
            String jdbcDriversProp = MondrianProperties.instance().JdbcDrivers.get();
            RolapUtil.loadDrivers(jdbcDriversProp);
            boolean poolNeeded = poolNeededString == null ? true : poolNeededString.equalsIgnoreCase("true");
            String jdbcUser = connectInfo.get("JdbcUser");
            String jdbcPassword = connectInfo.get("JdbcPassword");
            if (jdbcUser != null) {
                jdbcProperties.put("user", jdbcUser);
            }
            if (jdbcPassword != null) {
                jdbcProperties.put("password", jdbcPassword);
            }
            if (!poolNeeded) {
                return new DriverManagerDataSource(jdbcConnectString, jdbcProperties);
            }
            if (jdbcConnectString.toLowerCase().indexOf("mysql") > -1) {
                jdbcProperties.setProperty("autoReconnect", "true");
            }
            DriverManagerConnectionFactory connectionFactory = new DriverManagerConnectionFactory(jdbcConnectString, jdbcProperties);
            try {
                return RolapConnectionPool.instance().getPoolingDataSource(jdbcConnectString + propertyString, (ConnectionFactory)connectionFactory);
            }
            catch (Throwable e) {
                throw Util.newInternal(e, "Error while creating connection pool (with URI " + jdbcConnectString + ")");
            }
        }
        String dataSourceName = connectInfo.get("DataSource");
        if (dataSourceName == null) {
            throw Util.newInternal("Connect string '" + connectInfo.toString() + "' must contain either '" + "Jdbc" + "' or '" + "DataSource" + "'");
        }
        boolean poolNeeded = poolNeededString == null ? false : poolNeededString.equalsIgnoreCase("true");
        try {
            dataSource = (DataSource)new InitialContext().lookup(dataSourceName);
        }
        catch (NamingException e) {
            throw Util.newInternal(e, "Error while looking up data source (" + dataSourceName + ")");
        }
        if (!poolNeeded) {
            return dataSource;
        }
        DataSourceConnectionFactory connectionFactory = new DataSourceConnectionFactory(dataSource);
        try {
            return RolapConnectionPool.instance().getPoolingDataSource(dataSourceName, (ConnectionFactory)connectionFactory);
        }
        catch (Exception e) {
            throw Util.newInternal(e, "Error while creating connection pool (with URI " + dataSourceName + ")");
        }
    }

    private static Properties getJDBCProperties(Util.PropertyList connectInfo) {
        Properties jdbcProperties = new Properties();
        Iterator iterator = connectInfo.iterator();
        while (iterator.hasNext()) {
            String[] entry = (String[])iterator.next();
            if (!entry[0].startsWith("jdbc.")) continue;
            jdbcProperties.put(entry[0].substring("jdbc.".length()), entry[1]);
        }
        return jdbcProperties;
    }

    public Util.PropertyList getConnectInfo() {
        return this.connectInfo;
    }

    public void close() {
    }

    public Schema getSchema() {
        return this.schema;
    }

    public String getConnectString() {
        return this.connectInfo.toString();
    }

    public String getCatalogName() {
        return this.catalogName;
    }

    public Locale getLocale() {
        return this.locale;
    }

    public void setLocale(Locale locale) {
        this.locale = locale;
    }

    public SchemaReader getSchemaReader() {
        return this.schemaReader;
    }

    public Result execute(Query query) {
        try {
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug((Object)query.getQueryString());
            }
            ResultBase result = new RolapResult(query);
            for (int i = 0; i < query.axes.length; ++i) {
                QueryAxis axis = query.axes[i];
                if (!axis.nonEmpty) continue;
                result = new NonEmptyResult(result, query, i);
            }
            if (LOGGER.isDebugEnabled()) {
                StringWriter sw = new StringWriter();
                PrintWriter pw = new PrintWriter(sw);
                result.print(pw);
                pw.flush();
                LOGGER.debug((Object)sw.toString());
            }
            return result;
        }
        catch (Throwable e) {
            String queryString;
            try {
                queryString = query.getQueryString();
            }
            catch (Exception e1) {
                queryString = "?";
            }
            throw Util.newError(e, "Error while executing query [" + queryString + "]");
        }
    }

    public void setRole(Role role) {
        Util.assertPrecondition(role != null, "role != null");
        Util.assertPrecondition(!role.isMutable(), "!role.isMutable()");
        this.role = role;
        this.schemaReader = new RolapSchemaReader(role, this.schema){

            public Cube getCube() {
                throw new UnsupportedOperationException();
            }
        };
    }

    public Role getRole() {
        Util.assertPostcondition(this.role != null, "role != null");
        Util.assertPostcondition(!this.role.isMutable(), "!role.isMutable()");
        return this.role;
    }

    public DataSource getDataSource() {
        return this.dataSource;
    }

    class NonEmptyResult
    extends ResultBase {
        final Result underlying;
        private final int axis;
        private final Map map;
        private final int[] pos;

        NonEmptyResult(Result result, Query query, int axis) {
            super(query, (Axis[])result.getAxes().clone());
            this.underlying = result;
            this.axis = axis;
            this.map = new HashMap();
            int axisCount = this.underlying.getAxes().length;
            this.pos = new int[axisCount];
            this.slicerAxis = this.underlying.getSlicerAxis();
            Position[] positions = this.underlying.getAxes()[axis].positions;
            ArrayList<Position> positionsList = new ArrayList<Position>();
            int count = positions.length;
            for (int i = 0; i < count; ++i) {
                Position position = positions[i];
                if (this.isEmpty(i, axis)) continue;
                this.map.put(new Integer(positionsList.size()), new Integer(i));
                positionsList.add(position);
            }
            this.axes[axis] = new RolapAxis(positionsList.toArray(new Position[0]));
        }

        protected Logger getLogger() {
            return LOGGER;
        }

        private boolean isEmpty(int offset, int fixedAxis) {
            int axisCount = this.getAxes().length;
            this.pos[fixedAxis] = offset;
            return this.isEmptyRecurse(fixedAxis, axisCount - 1);
        }

        private boolean isEmptyRecurse(int fixedAxis, int axis) {
            if (axis < 0) {
                RolapCell cell = (RolapCell)this.underlying.getCell(this.pos);
                return cell.isNull();
            }
            if (axis == fixedAxis) {
                return this.isEmptyRecurse(fixedAxis, axis - 1);
            }
            Position[] positions = this.getAxes()[axis].positions;
            int i = 0;
            int count = positions.length;
            while (i < count) {
                this.pos[axis] = i++;
                if (this.isEmptyRecurse(fixedAxis, axis - 1)) continue;
                return false;
            }
            return true;
        }

        public synchronized Cell getCell(int[] externalPos) {
            int mappedOffset;
            System.arraycopy(externalPos, 0, this.pos, 0, externalPos.length);
            int offset = externalPos[this.axis];
            this.pos[this.axis] = mappedOffset = this.mapOffsetToUnderlying(offset);
            return this.underlying.getCell(this.pos);
        }

        private int mapOffsetToUnderlying(int offset) {
            return (Integer)this.map.get(new Integer(offset));
        }

        public void close() {
            this.underlying.close();
        }
    }

    private static class DriverManagerDataSource
    implements DataSource {
        private final String jdbcConnectString;
        private PrintWriter logWriter;
        private int loginTimeout;
        private Properties jdbcProperties;

        public DriverManagerDataSource(String jdbcConnectString, Properties properties) {
            this.jdbcConnectString = jdbcConnectString;
            this.jdbcProperties = properties;
        }

        public Connection getConnection() throws SQLException {
            return new DelegatingConnection(DriverManager.getConnection(this.jdbcConnectString, this.jdbcProperties));
        }

        public Connection getConnection(String username, String password) throws SQLException {
            if (this.jdbcProperties == null) {
                return DriverManager.getConnection(this.jdbcConnectString, username, password);
            }
            Properties temp = (Properties)this.jdbcProperties.clone();
            temp.put("user", username);
            temp.put("password", password);
            return DriverManager.getConnection(this.jdbcConnectString, temp);
        }

        public PrintWriter getLogWriter() throws SQLException {
            return this.logWriter;
        }

        public void setLogWriter(PrintWriter out) throws SQLException {
            this.logWriter = out;
        }

        public void setLoginTimeout(int seconds) throws SQLException {
            this.loginTimeout = seconds;
        }

        public int getLoginTimeout() throws SQLException {
            return this.loginTimeout;
        }
    }
}

