/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.hql.ast;

import antlr.SemanticException;
import antlr.collections.AST;
import java.lang.reflect.Constructor;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.hibernate.hql.ast.ASTAppender;
import org.hibernate.hql.ast.ASTIterator;
import org.hibernate.hql.ast.ASTPrinter;
import org.hibernate.hql.ast.ConstructorNode;
import org.hibernate.hql.ast.FromClause;
import org.hibernate.hql.ast.FromElement;
import org.hibernate.hql.ast.SelectExpression;
import org.hibernate.hql.ast.SelectExpressionImpl;
import org.hibernate.hql.ast.SelectExpressionList;
import org.hibernate.type.Type;

public class SelectClause
extends SelectExpressionList {
    private boolean prepared = false;
    private boolean scalarSelect;
    private List fromElementsForLoad = new ArrayList();
    private Type[] queryReturnTypes;
    private String[][] columnNames;
    private ConstructorNode constructorNode;
    private List collectionFromElements;
    private String[] aliases;
    public static boolean VERSION2_SQL = false;
    static /* synthetic */ Class class$org$hibernate$hql$antlr$SqlTokenTypes;

    public boolean isScalarSelect() {
        return this.scalarSelect;
    }

    public List getFromElementsForLoad() {
        return this.fromElementsForLoad;
    }

    public Type[] getQueryReturnTypes() {
        return this.queryReturnTypes;
    }

    public String[] getQueryReturnAliases() {
        return this.aliases;
    }

    public String[][] getColumnNames() {
        return this.columnNames;
    }

    public Constructor getConstructor() {
        return this.constructorNode == null ? null : this.constructorNode.getConstructor();
    }

    public boolean isMap() {
        return this.constructorNode == null ? false : this.constructorNode.isMap();
    }

    public boolean isList() {
        return this.constructorNode == null ? false : this.constructorNode.isList();
    }

    void initializeExplicitSelectClause(FromClause fromClause) throws SemanticException {
        if (this.prepared) {
            throw new IllegalStateException("SelectClause was already prepared!");
        }
        ArrayList<Type> queryReturnTypeList = new ArrayList<Type>();
        SelectExpression[] selectExpressions = this.collectSelectExpressions();
        for (int i = 0; i < selectExpressions.length; ++i) {
            SelectExpression expr = selectExpressions[i];
            if (expr.isConstructor()) {
                this.constructorNode = (ConstructorNode)expr;
                List constructorArgumentTypeList = this.constructorNode.getConstructorArgumentTypeList();
                queryReturnTypeList.addAll(constructorArgumentTypeList);
                this.scalarSelect = true;
                continue;
            }
            Type type = expr.getDataType();
            if (type == null) {
                throw new IllegalStateException("No data type for node: " + expr.getClass().getName() + " " + new ASTPrinter(class$org$hibernate$hql$antlr$SqlTokenTypes == null ? (class$org$hibernate$hql$antlr$SqlTokenTypes = SelectClause.class$("org.hibernate.hql.antlr.SqlTokenTypes")) : class$org$hibernate$hql$antlr$SqlTokenTypes).showAsString((AST)expr, ""));
            }
            if (expr.isScalar()) {
                this.scalarSelect = true;
            }
            if (this.isReturnableEntity(expr)) {
                this.fromElementsForLoad.add(expr.getFromElement());
            }
            queryReturnTypeList.add(type);
        }
        this.initAliases(selectExpressions);
        if (!this.getWalker().isShallowQuery()) {
            List fromElements = fromClause.getProjectionList();
            ASTAppender appender = new ASTAppender(this.getASTFactory(), (AST)this);
            int size = fromElements.size();
            Iterator iterator = fromElements.iterator();
            int k = 0;
            while (iterator.hasNext()) {
                FromElement fromElement = (FromElement)iterator.next();
                if (fromElement.isFetch()) {
                    boolean collectionOfElements;
                    Type type = fromElement.getSelectType();
                    this.addCollectionFromElement(fromElement);
                    if (type != null && !(collectionOfElements = fromElement.isCollectionOfValuesOrComponents())) {
                        fromElement.setIncludeSubclasses(true);
                        this.fromElementsForLoad.add(fromElement);
                        String text = fromElement.renderIdentifierSelect(size, k);
                        SelectExpressionImpl generatedExpr = (SelectExpressionImpl)appender.append(131, text, false);
                        if (generatedExpr != null) {
                            generatedExpr.setFromElement(fromElement);
                        }
                    }
                }
                ++k;
            }
            this.renderNonScalarSelects(this.collectSelectExpressions(), fromClause);
        }
        if (this.scalarSelect || this.getWalker().isShallowQuery()) {
            this.renderScalarSelects(selectExpressions, fromClause);
        }
        this.finishInitialization(queryReturnTypeList);
    }

    private void finishInitialization(ArrayList queryReturnTypeList) {
        this.queryReturnTypes = queryReturnTypeList.toArray(new Type[queryReturnTypeList.size()]);
        this.initializeColumnNames();
        this.prepared = true;
    }

    private void initializeColumnNames() {
        this.columnNames = this.getSessionFactoryHelper().generateColumnNames(this.queryReturnTypes);
    }

    void initializeDerivedSelectClause(FromClause fromClause) throws SemanticException {
        if (this.prepared) {
            throw new IllegalStateException("SelectClause was already prepared!");
        }
        List fromElements = fromClause.getProjectionList();
        ASTAppender appender = new ASTAppender(this.getASTFactory(), (AST)this);
        int size = fromElements.size();
        ArrayList<Type> sqlResultTypeList = new ArrayList<Type>(size);
        ArrayList<Type> queryReturnTypeList = new ArrayList<Type>(size);
        Iterator iterator = fromElements.iterator();
        int k = 0;
        while (iterator.hasNext()) {
            boolean collectionOfElements;
            FromElement fromElement = (FromElement)iterator.next();
            Type type = fromElement.getSelectType();
            this.addCollectionFromElement(fromElement);
            if (type != null && !(collectionOfElements = fromElement.isCollectionOfValuesOrComponents())) {
                if (!fromElement.isFetch()) {
                    queryReturnTypeList.add(type);
                }
                this.fromElementsForLoad.add(fromElement);
                sqlResultTypeList.add(type);
                String text = fromElement.renderIdentifierSelect(size, k);
                SelectExpressionImpl generatedExpr = (SelectExpressionImpl)appender.append(131, text, false);
                if (generatedExpr != null) {
                    generatedExpr.setFromElement(fromElement);
                }
            }
            ++k;
        }
        SelectExpression[] selectExpressions = this.collectSelectExpressions();
        if (this.getWalker().isShallowQuery()) {
            this.renderScalarSelects(selectExpressions, fromClause);
        } else {
            this.renderNonScalarSelects(selectExpressions, fromClause);
        }
        this.finishInitialization(queryReturnTypeList);
    }

    private void addCollectionFromElement(FromElement fromElement) {
        if (fromElement.isFetch() && (fromElement.isCollectionJoin() || fromElement.getQueryableCollection() != null)) {
            String suffix;
            if (this.collectionFromElements == null) {
                this.collectionFromElements = new ArrayList();
                suffix = VERSION2_SQL ? "__" : "0__";
            } else {
                suffix = Integer.toString(this.collectionFromElements.size()) + "__";
            }
            this.collectionFromElements.add(fromElement);
            fromElement.setCollectionSuffix(suffix);
        }
    }

    protected AST getFirstSelectExpression() {
        AST n;
        for (n = this.getFirstChild(); n != null && (n.getType() == 16 || n.getType() == 4); n = n.getNextSibling()) {
        }
        return n;
    }

    private boolean isReturnableEntity(SelectExpression selectExpression) throws SemanticException {
        boolean isFetchOrValueCollection;
        FromElement fromElement = selectExpression.getFromElement();
        boolean bl = isFetchOrValueCollection = fromElement != null && (fromElement.isFetch() || fromElement.isCollectionOfValuesOrComponents());
        if (isFetchOrValueCollection) {
            return false;
        }
        return selectExpression.isReturnableEntity();
    }

    private void renderScalarSelects(SelectExpression[] se, FromClause currentFromClause) throws SemanticException {
        if (!currentFromClause.isSubQuery()) {
            for (int i = 0; i < se.length; ++i) {
                SelectExpression expr = se[i];
                expr.setScalarColumnText(i);
            }
        }
    }

    private void initAliases(SelectExpression[] selectExpressions) {
        if (this.constructorNode == null) {
            this.aliases = new String[selectExpressions.length];
            for (int i = 0; i < selectExpressions.length; ++i) {
                String alias = selectExpressions[i].getAlias();
                this.aliases[i] = alias == null ? Integer.toString(i) : alias;
            }
        } else {
            this.aliases = this.constructorNode.getAliases();
        }
    }

    private void renderNonScalarSelects(SelectExpression[] selectExpressions, FromClause currentFromClause) throws SemanticException {
        FromElement fromElement;
        ASTAppender appender = new ASTAppender(this.getASTFactory(), (AST)this);
        int size = selectExpressions.length;
        int nonscalarSize = 0;
        for (int i = 0; i < size; ++i) {
            if (selectExpressions[i].isScalar()) continue;
            ++nonscalarSize;
        }
        int j = 0;
        for (int i = 0; i < size; ++i) {
            SelectExpression expr;
            if (selectExpressions[i].isScalar() || (fromElement = (expr = selectExpressions[i]).getFromElement()) == null) continue;
            this.renderNonScalarIdentifiers(fromElement, nonscalarSize, j, expr, appender);
            ++j;
        }
        if (!currentFromClause.isSubQuery()) {
            int k = 0;
            for (int i = 0; i < size; ++i) {
                if (selectExpressions[i].isScalar() || (fromElement = selectExpressions[i].getFromElement()) == null) continue;
                this.renderNonScalarProperties(appender, fromElement, nonscalarSize, k);
                ++k;
            }
        }
    }

    private void renderNonScalarIdentifiers(FromElement fromElement, int nonscalarSize, int j, SelectExpression expr, ASTAppender appender) {
        String text = fromElement.renderIdentifierSelect(nonscalarSize, j);
        if (!fromElement.getFromClause().isSubQuery()) {
            if (!this.scalarSelect && !this.getWalker().isShallowQuery()) {
                expr.setText(text);
            } else {
                appender.append(129, text, false);
            }
        }
    }

    private void renderNonScalarProperties(ASTAppender appender, FromElement fromElement, int nonscalarSize, int k) {
        String text = fromElement.renderPropertySelect(nonscalarSize, k);
        appender.append(129, text, false);
        if (fromElement.getQueryableCollection() != null && fromElement.isFetch()) {
            text = fromElement.renderCollectionSelectFragment(nonscalarSize, k);
            appender.append(129, text, false);
        }
        ASTIterator iter = new ASTIterator((AST)fromElement);
        while (iter.hasNext()) {
            FromElement child = (FromElement)iter.next();
            if (!child.isCollectionOfValuesOrComponents() || !child.isFetch()) continue;
            text = child.renderValueCollectionSelectFragment(nonscalarSize, nonscalarSize + k);
            appender.append(129, text, false);
        }
    }

    public List getCollectionFromElements() {
        return this.collectionFromElements;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

