/*
 * JListView.java
 *
 * Created on 8 ottobre 2004, 2.55
 */

package it.businesslogic.ireport.gui.listview;
import java.awt.*;
import javax.swing.*;
import javax.swing.event.*;

public class JListView extends JPanel
   implements ChangeListener
{
   protected JScrollPane scroll;
   private ScrollableList list;
   
   int listLayout = JList.HORIZONTAL_WRAP;
   
   public JListView()
   {
      setLayout(new BorderLayout());
      
      add(BorderLayout.CENTER, scroll = 
         new JScrollPane(
         list = new ScrollableList() ));
      scroll.getViewport().setBackground(
         getList().getBackground());
      stateChanged(new ChangeEvent(this));
   }
   
   public void stateChanged(ChangeEvent event)
   {
      getList().setLayoutOrientation(listLayout);
      if (listLayout == JList.VERTICAL)
      {
         scroll.setVerticalScrollBarPolicy(
            JScrollPane.VERTICAL_SCROLLBAR_AS_NEEDED);
         scroll.setHorizontalScrollBarPolicy(
            JScrollPane.HORIZONTAL_SCROLLBAR_NEVER);
      }
      if (listLayout == JList.VERTICAL_WRAP)
      {
         scroll.setVerticalScrollBarPolicy(
            JScrollPane.VERTICAL_SCROLLBAR_NEVER);
         scroll.setHorizontalScrollBarPolicy(
            JScrollPane.HORIZONTAL_SCROLLBAR_AS_NEEDED);
      }
      if (listLayout == JList.HORIZONTAL_WRAP)
      {
         scroll.setVerticalScrollBarPolicy(
            JScrollPane.VERTICAL_SCROLLBAR_AS_NEEDED);
         scroll.setHorizontalScrollBarPolicy(
            JScrollPane.HORIZONTAL_SCROLLBAR_NEVER);
      }
      scroll.revalidate();
   }

    public ScrollableList getList() {
        return list;
    }

    public void setList(ScrollableList list) {
        this.list = list;
    }
   

}
