/*
 * Decompiled with CFR 0.152.
 */
package it.businesslogic.ireport.gui;

import it.businesslogic.ireport.JRVariable;
import it.businesslogic.ireport.SubDataset;
import it.businesslogic.ireport.gui.JRParameterDialog;
import it.businesslogic.ireport.gui.JRTextExpressionArea;
import it.businesslogic.ireport.util.Misc;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTextField;

public class JRVariableDialog
extends JDialog {
    JRVariable tmpVariable = null;
    private SubDataset subDataset = null;
    private JButton jButtonCancel;
    private JButton jButtonOK;
    private JComboBox jComboBoxCalculationType;
    private JComboBox jComboBoxClassType;
    private JComboBox jComboBoxIncrementGroup;
    private JComboBox jComboBoxIncrementType;
    private JComboBox jComboBoxResetGroup;
    private JComboBox jComboBoxResetType;
    private JLabel jLabel1;
    private JLabel jLabel10;
    private JLabel jLabel2;
    private JLabel jLabel3;
    private JLabel jLabel4;
    private JLabel jLabel5;
    private JLabel jLabel6;
    private JLabel jLabel7;
    private JLabel jLabel8;
    private JLabel jLabel9;
    private JPanel jPanel1;
    private JRTextExpressionArea jRTextExpressionAreaExpression;
    private JRTextExpressionArea jRTextExpressionAreaInitialExpression;
    private JTextField jTextFieldName;
    private JTextField jTextFieldNameIncrementerFactoryClass;
    private int dialogResult;

    public JRVariableDialog(SubDataset report, Frame parent, boolean modal) {
        super(parent, modal);
        this.initComponents();
        this.setSubDataset(report);
        this.updateGroups();
        this.jRTextExpressionAreaExpression.setText("");
        this.jRTextExpressionAreaInitialExpression.setText("");
        this.setTypes();
        this.jComboBoxClassType.setSelectedItem("java.lang.String");
        this.jComboBoxCalculationType.setSelectedItem("Nothing");
        this.jComboBoxResetType.setSelectedItem("Report");
        this.updateGroups();
        this.pack();
    }

    public void setTypes() {
        this.jComboBoxClassType.addItem("java.lang.String");
        this.jComboBoxClassType.addItem("java.lang.Object");
        this.jComboBoxClassType.addItem("java.lang.Boolean");
        this.jComboBoxClassType.addItem("java.lang.Byte");
        this.jComboBoxClassType.addItem("java.util.Date");
        this.jComboBoxClassType.addItem("java.sql.Timestamp");
        this.jComboBoxClassType.addItem("java.sql.Time");
        this.jComboBoxClassType.addItem("java.lang.Double");
        this.jComboBoxClassType.addItem("java.lang.Float");
        this.jComboBoxClassType.addItem("java.lang.Integer");
        this.jComboBoxClassType.addItem("java.io.InputStream");
        this.jComboBoxClassType.addItem("java.lang.Long");
        this.jComboBoxClassType.addItem("java.lang.Short");
        this.jComboBoxClassType.addItem("java.math.BigDecimal");
        this.jComboBoxClassType.addItem("net.sf.jasperreports.engine.JREmptyDataSource");
        this.jComboBoxCalculationType.addItem("Nothing");
        this.jComboBoxCalculationType.addItem("Count");
        this.jComboBoxCalculationType.addItem("DistinctCount");
        this.jComboBoxCalculationType.addItem("Sum");
        this.jComboBoxCalculationType.addItem("Average");
        this.jComboBoxCalculationType.addItem("Lowest");
        this.jComboBoxCalculationType.addItem("Highest");
        this.jComboBoxCalculationType.addItem("StandardDeviation");
        this.jComboBoxCalculationType.addItem("Variance");
        this.jComboBoxCalculationType.addItem("System");
        this.jComboBoxCalculationType.addItem("First");
        this.jComboBoxResetType.addItem("None");
        this.jComboBoxResetType.addItem("Report");
        this.jComboBoxResetType.addItem("Page");
        this.jComboBoxResetType.addItem("Column");
        this.jComboBoxResetType.addItem("Group");
        this.jComboBoxIncrementType.addItem("None");
        this.jComboBoxIncrementType.addItem("Report");
        this.jComboBoxIncrementType.addItem("Page");
        this.jComboBoxIncrementType.addItem("Column");
        this.jComboBoxIncrementType.addItem("Group");
    }

    public void updateGroups() {
        if (this.getSubDataset() == null) {
            this.jComboBoxResetGroup.removeAllItems();
            this.jComboBoxResetGroup.addItem("");
        } else {
            Misc.updateStringComboBox(this.jComboBoxResetGroup, this.getSubDataset().getGroups(), false);
            Misc.updateStringComboBox(this.jComboBoxIncrementGroup, this.getSubDataset().getGroups(), false);
        }
    }

    private void initComponents() {
        this.jLabel1 = new JLabel();
        this.jTextFieldName = new JTextField();
        this.jLabel2 = new JLabel();
        this.jComboBoxResetGroup = new JComboBox();
        this.jLabel3 = new JLabel();
        this.jLabel4 = new JLabel();
        this.jLabel5 = new JLabel();
        this.jComboBoxResetType = new JComboBox();
        this.jComboBoxCalculationType = new JComboBox();
        this.jLabel6 = new JLabel();
        this.jComboBoxClassType = new JComboBox();
        this.jLabel7 = new JLabel();
        this.jRTextExpressionAreaExpression = new JRTextExpressionArea();
        this.jRTextExpressionAreaInitialExpression = new JRTextExpressionArea();
        this.jLabel8 = new JLabel();
        this.jTextFieldNameIncrementerFactoryClass = new JTextField();
        this.jPanel1 = new JPanel();
        this.jButtonOK = new JButton();
        this.jButtonCancel = new JButton();
        this.jLabel9 = new JLabel();
        this.jLabel10 = new JLabel();
        this.jComboBoxIncrementType = new JComboBox();
        this.jComboBoxIncrementGroup = new JComboBox();
        this.getContentPane().setLayout(new GridBagLayout());
        this.setTitle("Add/modify variable");
        this.setModal(true);
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent evt) {
                JRVariableDialog.this.closeDialog(evt);
            }
        });
        this.jLabel1.setText("Variable name");
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.getContentPane().add((Component)this.jLabel1, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 3;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.getContentPane().add((Component)this.jTextFieldName, gridBagConstraints);
        this.jLabel2.setText("Calculation type");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.getContentPane().add((Component)this.jLabel2, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.getContentPane().add((Component)this.jComboBoxResetGroup, gridBagConstraints);
        this.jLabel3.setText("Variable expression");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 10;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.getContentPane().add((Component)this.jLabel3, gridBagConstraints);
        this.jLabel4.setText("Initial value expression");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 12;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.getContentPane().add((Component)this.jLabel4, gridBagConstraints);
        this.jLabel5.setText("Variable class type");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.getContentPane().add((Component)this.jLabel5, gridBagConstraints);
        this.jComboBoxResetType.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                JRVariableDialog.this.jComboBoxResetTypeActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.getContentPane().add((Component)this.jComboBoxResetType, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.getContentPane().add((Component)this.jComboBoxCalculationType, gridBagConstraints);
        this.jLabel6.setText("Reset group");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.getContentPane().add((Component)this.jLabel6, gridBagConstraints);
        this.jComboBoxClassType.setEditable(true);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.getContentPane().add((Component)this.jComboBoxClassType, gridBagConstraints);
        this.jLabel7.setText("Reset type");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.getContentPane().add((Component)this.jLabel7, gridBagConstraints);
        this.jRTextExpressionAreaExpression.setBorder(BorderFactory.createEtchedBorder());
        this.jRTextExpressionAreaExpression.setCaretVisible(false);
        this.jRTextExpressionAreaExpression.setElectricScroll(0);
        this.jRTextExpressionAreaExpression.setMinimumSize(new Dimension(657, 100));
        this.jRTextExpressionAreaExpression.setNextFocusableComponent(this.jRTextExpressionAreaInitialExpression);
        this.jRTextExpressionAreaExpression.setPreferredSize(new Dimension(325, 70));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 11;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.getContentPane().add((Component)this.jRTextExpressionAreaExpression, gridBagConstraints);
        this.jRTextExpressionAreaInitialExpression.setBorder(BorderFactory.createEtchedBorder());
        this.jRTextExpressionAreaInitialExpression.setCaretVisible(false);
        this.jRTextExpressionAreaInitialExpression.setElectricScroll(0);
        this.jRTextExpressionAreaInitialExpression.setFont(new Font("Tahoma", 0, 12));
        this.jRTextExpressionAreaInitialExpression.setMinimumSize(new Dimension(657, 100));
        this.jRTextExpressionAreaInitialExpression.setPreferredSize(new Dimension(325, 70));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 13;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.getContentPane().add((Component)this.jRTextExpressionAreaInitialExpression, gridBagConstraints);
        this.jLabel8.setText("Custom Incrementer Factory Class");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 8;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.getContentPane().add((Component)this.jLabel8, gridBagConstraints);
        this.jTextFieldNameIncrementerFactoryClass.setNextFocusableComponent(this.jRTextExpressionAreaExpression);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 9;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.getContentPane().add((Component)this.jTextFieldNameIncrementerFactoryClass, gridBagConstraints);
        this.jPanel1.setLayout(new FlowLayout(2));
        this.jButtonOK.setMnemonic('o');
        this.jButtonOK.setText("OK");
        this.jButtonOK.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                JRVariableDialog.this.jButtonOKActionPerformed(evt);
            }
        });
        this.jPanel1.add(this.jButtonOK);
        this.jButtonCancel.setText("Cancel");
        this.jButtonCancel.setMnemonic('c');
        this.jButtonCancel.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                JRVariableDialog.this.jButtonCancelActionPerformed(evt);
            }
        });
        this.jPanel1.add(this.jButtonCancel);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 14;
        gridBagConstraints.gridwidth = 3;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.getContentPane().add((Component)this.jPanel1, gridBagConstraints);
        this.jLabel9.setText("Increment type");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 6;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.getContentPane().add((Component)this.jLabel9, gridBagConstraints);
        this.jLabel10.setText("Increment group");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 6;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.getContentPane().add((Component)this.jLabel10, gridBagConstraints);
        this.jComboBoxIncrementType.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                JRVariableDialog.this.jComboBoxIncrementTypeActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 7;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.getContentPane().add((Component)this.jComboBoxIncrementType, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 7;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.getContentPane().add((Component)this.jComboBoxIncrementGroup, gridBagConstraints);
        this.pack();
        Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();
        Dimension dialogSize = this.getSize();
        this.setLocation((screenSize.width - dialogSize.width) / 2, (screenSize.height - dialogSize.height) / 2);
    }

    private void jComboBoxIncrementTypeActionPerformed(ActionEvent evt) {
        String val = this.jComboBoxIncrementType.getSelectedItem() + "";
        this.jComboBoxIncrementGroup.setEnabled(val.equals("Group"));
        if (this.jComboBoxIncrementGroup.isEnabled() && this.jComboBoxIncrementGroup.getSelectedItem() == null && this.jComboBoxIncrementGroup.getItemCount() > 0) {
            this.jComboBoxIncrementGroup.setSelectedIndex(0);
        }
    }

    private void jComboBoxResetTypeActionPerformed(ActionEvent evt) {
        String val = this.jComboBoxResetType.getSelectedItem() + "";
        this.jComboBoxResetGroup.setEnabled(val.equals("Group"));
        if (this.jComboBoxResetGroup.isEnabled() && this.jComboBoxResetGroup.getSelectedItem() == null && this.jComboBoxResetGroup.getItemCount() > 0) {
            this.jComboBoxResetGroup.setSelectedIndex(0);
        }
    }

    private void jButtonCancelActionPerformed(ActionEvent evt) {
        this.setVisible(false);
        this.setDialogResult(2);
        this.dispose();
    }

    private void jButtonOKActionPerformed(ActionEvent evt) {
        if (this.jTextFieldName.getText().trim().length() <= 0) {
            JOptionPane.showMessageDialog(this, "Please insert a valid variable name!", "Invalid variable!", 2);
            return;
        }
        this.tmpVariable = new JRVariable(this.jTextFieldName.getText(), false);
        this.tmpVariable.setClassType(this.jComboBoxClassType.getSelectedItem() + "");
        this.tmpVariable.setCalculation(this.jComboBoxCalculationType.getSelectedItem() + "");
        this.tmpVariable.setResetType(this.jComboBoxResetType.getSelectedItem() + "");
        this.tmpVariable.setIncrementType(this.jComboBoxIncrementType.getSelectedItem() + "");
        this.tmpVariable.setIncrementerFactoryClass(this.jTextFieldNameIncrementerFactoryClass.getText());
        if (this.jComboBoxClassType.getSelectedItem().toString().trim().length() == 0) {
            this.tmpVariable.setClassType("java.lang.String");
        } else {
            this.tmpVariable.setClassType(this.jComboBoxClassType.getSelectedItem().toString().trim());
        }
        if (this.tmpVariable.getResetType().equals("Group")) {
            if (this.jComboBoxResetGroup.getSelectedItem() == null || this.jComboBoxResetGroup.getSelectedItem().equals("")) {
                JOptionPane.showMessageDialog(this, "Please choose a valid group for the reset type selected!", "Invalid group!", 2);
                return;
            }
            this.tmpVariable.setResetGroup(this.jComboBoxResetGroup.getSelectedItem() + "");
        }
        if (this.tmpVariable.getIncrementType().equals("Group")) {
            if (this.jComboBoxIncrementGroup.getSelectedItem() == null || this.jComboBoxIncrementGroup.getSelectedItem().equals("")) {
                JOptionPane.showMessageDialog(this, "Please choose a valid group for the increment type selected!", "Invalid group!", 2);
                return;
            }
            this.tmpVariable.setIncrementGroup(this.jComboBoxIncrementGroup.getSelectedItem() + "");
        }
        this.tmpVariable.setExpression(this.jRTextExpressionAreaExpression.getText());
        this.tmpVariable.setInitialValueExpression(this.jRTextExpressionAreaInitialExpression.getText());
        this.setVisible(false);
        this.setDialogResult(0);
        this.dispose();
    }

    private void closeDialog(WindowEvent evt) {
        this.setVisible(false);
        this.setDialogResult(-1);
        this.dispose();
    }

    public static void main(String[] args) {
        new JRParameterDialog((Frame)new JFrame(), true).setVisible(true);
    }

    public JRVariable getVariable() {
        return this.tmpVariable;
    }

    public void setVariable(JRVariable tmpVariable) {
        this.jTextFieldName.setText(new String(tmpVariable.getName()));
        this.jComboBoxClassType.setSelectedItem(new String(tmpVariable.getClassType()));
        this.jComboBoxResetType.setSelectedItem(new String(tmpVariable.getResetType()));
        this.jComboBoxIncrementType.setSelectedItem(new String(tmpVariable.getIncrementType()));
        this.jComboBoxCalculationType.setSelectedItem(new String(tmpVariable.getCalculation()));
        this.jComboBoxResetGroup.setSelectedItem(tmpVariable.getResetGroup());
        this.jComboBoxIncrementGroup.setSelectedItem(tmpVariable.getIncrementGroup());
        this.jRTextExpressionAreaExpression.setText(new String(tmpVariable.getExpression()));
        this.jRTextExpressionAreaInitialExpression.setText(new String(tmpVariable.getInitialValueExpression()));
        this.jTextFieldNameIncrementerFactoryClass.setText(new String(tmpVariable.getIncrementerFactoryClass()));
    }

    public int getDialogResult() {
        return this.dialogResult;
    }

    public void setDialogResult(int dialogResult) {
        this.dialogResult = dialogResult;
    }

    public SubDataset getSubDataset() {
        return this.subDataset;
    }

    public void setSubDataset(SubDataset subDataset) {
        this.subDataset = subDataset;
        this.jRTextExpressionAreaExpression.setSubDataset(subDataset);
        this.jRTextExpressionAreaInitialExpression.setSubDataset(subDataset);
        this.jRTextExpressionAreaExpression.getTokenMarker().setKeywordLookup(subDataset.getKeywordLookup());
        this.jRTextExpressionAreaInitialExpression.getTokenMarker().setKeywordLookup(subDataset.getKeywordLookup());
    }
}

