/*
 * Decompiled with CFR 0.152.
 */
package it.businesslogic.ireport.gui;

import it.businesslogic.ireport.JRField;
import it.businesslogic.ireport.JRParameter;
import it.businesslogic.ireport.JRVariable;
import it.businesslogic.ireport.ReportElement;
import it.businesslogic.ireport.Style;
import it.businesslogic.ireport.gui.JReportFrame;
import it.businesslogic.ireport.gui.MainFrame;
import it.businesslogic.ireport.gui.ReportPanelToolTip;
import it.businesslogic.ireport.gui.event.ReportElementChangedEvent;
import it.businesslogic.ireport.gui.library.AbstractLibraryObject;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.dnd.DropTarget;
import java.awt.dnd.DropTargetContext;
import java.awt.dnd.DropTargetDragEvent;
import java.awt.dnd.DropTargetDropEvent;
import java.awt.dnd.DropTargetEvent;
import java.awt.dnd.DropTargetListener;
import java.awt.event.MouseEvent;
import java.util.List;
import javax.swing.JPanel;
import javax.swing.JToolTip;

public class JReportPanel
extends JPanel
implements DropTargetListener {
    private JReportFrame jrf = null;
    private ReportPanelToolTip rptt = null;

    public JReportPanel() {
        this.setBackground(new Color(128, 128, 128));
        new DropTarget(this, 3, this);
        this.setIgnoreRepaint(true);
    }

    public void paint(Graphics g) {
        if (this.jrf != null) {
            this.jrf.paintReportPanel(g);
        } else {
            super.paint(g);
        }
    }

    public JReportFrame getJrf() {
        return this.jrf;
    }

    public void setJrf(JReportFrame jrf) {
        this.jrf = jrf;
        if (this.rptt != null) {
            this.rptt.setReportFrame(jrf);
        }
    }

    public Point getToolTipLocation(MouseEvent event) {
        return new Point(event.getX() + 30, event.getY() + 30);
    }

    public void dragEnter(DropTargetDragEvent dtde) {
        dtde.acceptDrag(dtde.getDropAction());
    }

    public void dragExit(DropTargetEvent dte) {
    }

    public void dragOver(DropTargetDragEvent dtde) {
        dtde.acceptDrag(dtde.getDropAction());
    }

    public void drop(DropTargetDropEvent dtde) {
        try {
            Class<?> c;
            DropTargetContext context = dtde.getDropTargetContext();
            Transferable tr = dtde.getTransferable();
            DataFlavor[] df = tr.getTransferDataFlavors();
            if (df[0].getHumanPresentableName().equals("it.businesslogic.ireport.JRField")) {
                DataFlavor myFlavor = new DataFlavor(JRField.class, JRField.class.getName());
                JRField field = (JRField)tr.getTransferData(myFlavor);
                this.jrf.dropNewTextField(dtde.getLocation(), "$F{" + field.getName() + "}", field.getClassType());
            } else if (df[0].getHumanPresentableName().equals("it.businesslogic.ireport.JRVariable")) {
                DataFlavor myFlavor = new DataFlavor(JRVariable.class, JRVariable.class.getName());
                JRVariable var = (JRVariable)tr.getTransferData(myFlavor);
                this.jrf.dropNewTextField(dtde.getLocation(), "$V{" + var.getName() + "}", var.getClassType());
            } else if (df[0].getHumanPresentableName().equals("it.businesslogic.ireport.JRParameter")) {
                DataFlavor myFlavor = new DataFlavor(JRParameter.class, JRParameter.class.getName());
                JRParameter var = (JRParameter)tr.getTransferData(myFlavor);
                this.jrf.dropNewTextField(dtde.getLocation(), "$P{" + var.getName() + "}", var.getClassType());
            } else if (tr.isDataFlavorSupported(DataFlavor.javaFileListFlavor)) {
                dtde.acceptDrop(3);
                List fileList = (List)tr.getTransferData(DataFlavor.javaFileListFlavor);
                MainFrame.getMainInstance().openFiles(fileList);
            } else if (df[0].getHumanPresentableName().equals("it.businesslogic.ireport.Style")) {
                DataFlavor myFlavor = new DataFlavor(Style.class, JRParameter.class.getName());
                Style var = (Style)tr.getTransferData(myFlavor);
                ReportElement re = this.jrf.getElementAt(dtde.getLocation());
                if (re != null) {
                    if (!this.jrf.getReport().getStyles().contains(var)) {
                        boolean found = false;
                        for (int i = 0; i < this.jrf.getReport().getStyles().size(); ++i) {
                            Style s = (Style)this.jrf.getReport().getStyles().elementAt(i);
                            if (s.getName() == null || !s.getName().equals(var.getName())) continue;
                            var = s;
                            found = true;
                            break;
                        }
                        if (!found) {
                            var = new Style(var);
                            this.jrf.getReport().addStyle(var);
                        }
                    }
                    re.setStyle(var);
                    this.jrf.fireReportListenerReportElementsChanged(new ReportElementChangedEvent(this.jrf, re, 3));
                    this.repaint();
                }
            } else if (AbstractLibraryObject.class.isAssignableFrom(c = Class.forName(df[0].getHumanPresentableName()))) {
                DataFlavor myFlavor = new DataFlavor(c, df[0].getHumanPresentableName());
                Object obj = tr.getTransferData(myFlavor);
                ((AbstractLibraryObject)obj).drop(dtde);
            } else {
                System.out.println("Dropped a " + df[0].getHumanPresentableName());
            }
            context.dropComplete(true);
        }
        catch (Exception ex) {
            System.out.println("Error in drop!");
            ex.printStackTrace();
        }
    }

    public void dropActionChanged(DropTargetDragEvent dtde) {
    }

    public JToolTip createToolTip() {
        if (this.rptt == null) {
            this.rptt = new ReportPanelToolTip(this.getJrf());
        }
        return this.rptt;
    }
}

